/*
 * Created on 2004/04/06
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.command.model;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableNodeRegister;
import netjfwatcher.engine.command.control.CommandMappingTableResource;
import netjfwatcher.engine.command.control.TemplateCommandImpl;
import netjfwatcher.engine.nodewatchinfo.BaseNodeWatchInfoList;
import netjfwatcher.engine.nodewatchinfo.NodeWatchInfo;
import netjfwatcher.engine.nodewatchinfo.StatisticsMibInfo;
import netjfwatcher.engine.server.protocol.control.ListQueueStatisticsMibControl;
import netjfwatcher.engine.snmpmanager.statistics.ThreadStatisticsMibGetControl;
import netjfwatcher.engine.socket.CommandInfo;
import netjfwatcher.engine.socket.info.NodeInformation;


/**
 * SNMPvMIb̎ZbgR}hNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class CommandStatisticsMibSet extends TemplateCommandImpl {
    /* MO */
    private static Logger logger;

    /* SNMPvMIb̎Zbg҂WaitJE^l */
    private static final int SET_LOOP_WAIT = 10000;

    /**
     * SNMPvMIb̎Zbg܂B
     *
     * @param com R}h
     * @param ois ̓Xg[
     * @param oos o̓Xg[
     */
    public void doInvoke(
        CommandInfo com, ObjectInputStream ois, ObjectOutputStream oos) {
        logger = Logger.getLogger(this.getClass().getName());

        // v̎OIDDB tableɃZbg
        logger.info("MIB set Oid : " + com.getMibInfo().getRequestMibOid());

        // e[u쐬
        ThreadStatisticsMibGetControl ifoctet =
            new ThreadStatisticsMibGetControl();
        ifoctet.setStatistics(
            com.getIpaddress(), com.getMibInfo().getVersion(),
            com.getMibInfo().getRoCommunity(), com.getMibInfo().getPeriod(),
            com.getMibInfo().getRequestMibOid(),
            com.getMibInfo().getThreshHold(),
            com.getMibInfo().getThreshHoldType());

        // ThreadXgL[ɓo^
        StatisticsMibInfo mibInfo =
            StatisticsMibInfo.getInstance(com.getIpaddress());

        /* vMIB̎m[hIP addressɑΉm[h擾 */
        DBTableNodeRegister nodeRegisterDBTable =
            DBTableNodeRegister.getInstance();
        ArrayList list = null;

        try {
            list = nodeRegisterDBTable.findTarget(com.getIpaddress());

            if (list != null) {
                mibInfo.setNodeName(
                    ((NodeInformation) list.get(0)).getNodename());
            }
        } catch (SQLException e1) {
            e1.printStackTrace();
        } catch (DatabaseConnectionException e1) {
            e1.printStackTrace();
        }

        mibInfo.setCommunity(com.getMibInfo().getRoCommunity());
        mibInfo.setVersion(com.getMibInfo().getVersion());
        mibInfo.setOidList(
            com.getMibInfo().getRequestMibOid(), com.getMibInfo().getPeriod(),
            com.getMibInfo().getThreshHold(),
            com.getMibInfo().getThreshHoldType());
        ListQueueStatisticsMibControl.getInstance().setStatisticsMibGetNode(
            com.getIpaddress(), mibInfo);

        NodeWatchInfo nodeInfo =
            BaseNodeWatchInfoList.getInstance().getNodeWatchInfo(
                com.getIpaddress());
        int checkcounter = 0;

        while (!nodeInfo.getStatisticsMIBStatus().equals("OK")) {
            if (checkcounter >= SET_LOOP_WAIT) {
                break;
            }
        }

        sendResponse(CommandMappingTableResource.ACK_RESPONSE, ois, oos);
    }
}
