/*
 * Created on 2004/12/16
 *
 *
 */
package netjfwatcher.engine.command.model;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.SQLException;
import java.util.logging.Logger;

import netjfwatcher.database.access.model.DBTableSystemMIB;
import netjfwatcher.engine.command.control.TemplateCommandImpl;
import netjfwatcher.engine.socket.CommandInfo;
import netjfwatcher.engine.socket.info.SystemMib;


/**
 * m[hSNMP System MIB̎悷郁\bhNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class CommandSystemMibGet extends TemplateCommandImpl {
    // MO
    private static Logger logger;

    /**
     * System MIBԂ܂B
     *
     * @param com R}h
     * @param ois ̓Xg[
     * @param oos o̓Xg[
     */
    public void doInvoke(
        CommandInfo com, ObjectInputStream ois, ObjectOutputStream oos) {
        logger = Logger.getLogger(this.getClass().getName());

        SystemMib systemMibInfo = null;

        /* System MIBe[uANZXCX^X */
        DBTableSystemMIB systemDBtable = DBTableSystemMIB.getInstance();

        try {
            systemMibInfo = systemDBtable.findSystemMIBTable(com.getIpaddress());
        } catch (SQLException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
        } catch (Exception e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
        } finally {
            systemDBtable = null;
        }

        sendResponse(systemMibInfo, ois, oos);
    }
}
