/*
 * Created on 2003/08/15
 *
 *
 * Copyright(c) 2003 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.nodecontrol;

import java.sql.SQLException;
import java.util.logging.Logger;

import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableInterfaceMIB;
import netjfwatcher.database.access.model.DBTableNodeRegister;
import netjfwatcher.database.access.model.DBTablePingResponse;
import netjfwatcher.database.access.model.DBTablePrintMIB;
import netjfwatcher.database.access.model.DBTableStatisticsMIBControl;
import netjfwatcher.database.access.model.DBTableSystemMIB;
import netjfwatcher.engine.alarm.AlarmRecovery;
import netjfwatcher.engine.noderegister.snmp.NodeSnmpRegisterInitializeThread;
import netjfwatcher.engine.nodewatchinfo.BaseNodeWatchInfoList;
import netjfwatcher.engine.nodewatchinfo.NodeWatchInfo;
import netjfwatcher.engine.nodewatchinfo.StatisticsMibInfo;
import netjfwatcher.engine.server.protocol.control.ListQueueDatabaseWatchControl;
import netjfwatcher.engine.server.protocol.control.ListQueueDefaultSnmpMibControl;
import netjfwatcher.engine.server.protocol.control.ListQueueHTTPControl;
import netjfwatcher.engine.server.protocol.control.ListQueuePingControl;
import netjfwatcher.engine.server.protocol.control.ListQueuePopControl;
import netjfwatcher.engine.server.protocol.control.ListQueueSmtpControl;
import netjfwatcher.engine.server.protocol.control.ListQueueStatisticsMibControl;
import netjfwatcher.engine.server.protocol.snmp.NetSnmpOid;
import netjfwatcher.engine.server.protocol.snmp.SnmpIfOctet;
import netjfwatcher.engine.snmpmanager.statistics.StatisticsMibDBRegister;
import netjfwatcher.engine.socket.CommandInfo;
import netjfwatcher.engine.socket.info.DatabaseWatcherInfo;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.snmp.preference.SnmpPreference;

/**
 * m[hǉ郁\bhNXłB
 * 
 * m[hǉɂȉ̏s܂B Ef[^x[Xe[u̐ EXbh̐
 * 
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class NodeAdd {
	// MO
	private static Logger logger = null;

	// m[hĎ
	private NodeWatchInfo nodewatchinfo;

	private NodeAdd() {
		logger = Logger.getLogger(this.getClass().getName());
	}

	/**
	 * m[hǉ܂B m[h̒ǉɂȉ̏s܂B Ef[^x[Xe[u̐ EXbh
	 * 
	 * @param com
	 *            R}h
	 */
	public void addNode(final CommandInfo com) {
		logger = Logger.getLogger(this.getClass().getName());

		// A[`FbNpm[hIPAhXi[
		AlarmRecovery alarmRecovery = AlarmRecovery.getInstance();
		alarmRecovery.setArarmrecoveryCheck(com.getIpaddress());

		// ǉm[hIPAhX
		String ipaddress = com.getIpaddress();

		// m[hǗe[uCX^X擾
		DBTableNodeRegister nodeRegister = DBTableNodeRegister.getInstance();

		// m[hPinge[u
		DBTablePingResponse pingRes = DBTablePingResponse.getInstance();

		// Snmp System MIBe[u
		DBTableSystemMIB systemMib = DBTableSystemMIB.getInstance();

		// Snmp C^tF[XMIBe[u
		DBTableInterfaceMIB interfaceMib = DBTableInterfaceMIB.getInstance();

		// Snmp Print MIBe[u
		DBTablePrintMIB printMib = DBTablePrintMIB.getInstance();

		// Snmp vMIBe[u
		DBTableStatisticsMIBControl statisticsMibTable = DBTableStatisticsMIBControl
				.getInstance();

		try {
			// m[hǗe[uɃm[ho^
			nodeRegister.registerNode(com.getNodeInformation());

			// Pinge[u
			pingRes.createTable(ipaddress);

			// Snmp SystemMIBe[u
			systemMib.createTable(ipaddress);

			// Snmp C^tF[XMIBe[u
			interfaceMib.createTable(ipaddress);

			// Snmp Print MIBe[u
			printMib.createTable(ipaddress);

			/* Snmpv̎\e[ui̎MIB OIDACX^XA̎A臒lj */
			statisticsMibTable.createStatisticsMibConfigTable(ipaddress);

			/* Snmpvi[e[uiCX^XA̎f[^iljj */
			statisticsMibTable.createStatisticsMibDataTable(ipaddress);

			/* SnmpvCX^Xe[uiOIDACX^Xj */
			statisticsMibTable.createMibInstanceTable(ipaddress);

		} catch (DatabaseConnectionException e1) {
			logger.warning(e1.getMessage());
			e1.printStackTrace();
		} catch (SQLException e1) {
			logger.warning(e1.getMessage());
			e1.printStackTrace();
		} finally {
			nodeRegister = null;
			pingRes = null;
			systemMib = null;
			interfaceMib = null;
			statisticsMibTable = null;
		}

		/* m[hĎ񐶐 */
		nodewatchinfo = new NodeWatchInfo();

		String snmpVersion = com.getNodeInformation().getSnmpVersion();

		if (snmpVersion.equals(SnmpPreference.SNMPV1_DESCRIPTION)) {
			nodewatchinfo.setSnmpVersion(SnmpPreference.SNMP_VERSION_1);
		} else if (snmpVersion.equals(SnmpPreference.SNMPV2_DESCRIPTION)) {
			nodewatchinfo.setSnmpVersion(SnmpPreference.SNMPV2C);
		} else if (snmpVersion.equals(SnmpPreference.SNMPV3_DESCRIPTION)) {
			nodewatchinfo.setSnmpVersion(SnmpPreference.SNMPV3);
		} else {
			logger.warning("Bad snmp version : " + snmpVersion);
		}

		/*
		 * m[h,IPAhXyPingĎZbg
		 */
		nodewatchinfo.setIpaddress(com.getNodeInformation().getIpaddress());
		nodewatchinfo.setNodename(com.getNodeInformation().getNodename());
		nodewatchinfo.setNodeKind(com.getNodeInformation().getNodeKind());
		nodewatchinfo.setPingPeriod(com.getNodeInformation().getPingPeriod());
		nodewatchinfo.setPingThreshold(com.getNodeInformation()
				.getPingThreshold());

		/*
		 * SNMPĎZbg
		 */
		nodewatchinfo.setSnmpPeriod(com.getNodeInformation().getSnmpPeriod());
		nodewatchinfo.setSnmpLevel(com.getNodeInformation().getSnmpLevel());
		nodewatchinfo.setSnmpROCommunity(com.getNodeInformation()
				.getRoCommunity());
		nodewatchinfo.setSnmpRWCommunity(com.getNodeInformation()
				.getRwCommunity());

		/*
		 * HTTPĎZbg
		 */
		nodewatchinfo.setHttpUrl(com.getNodeInformation().getHttpUrl());
		nodewatchinfo.setHttpPeriod(com.getNodeInformation().getHttpPeriod());
		nodewatchinfo.setHttpTimeout(com.getNodeInformation().getHttpTimeout());

		/*
		 * Pop3ĎZbg
		 */
		nodewatchinfo.setPopPeriod(com.getNodeInformation().getPopPeriod());
		nodewatchinfo.setPopUser(com.getNodeInformation().getPopUser());
		nodewatchinfo.setPopPassword(com.getNodeInformation().getPopPassword());
		nodewatchinfo.setPopPort(com.getNodeInformation().getPopPort());
		nodewatchinfo.setPopTimeout(com.getNodeInformation().getPopTimeout());

		/*
		 * SMTPĎZbg
		 */
		nodewatchinfo.setSmtpPeriod(com.getNodeInformation().getSmtpPeriod());
		nodewatchinfo.setSmtpPort(com.getNodeInformation().getSmtpPort());
		nodewatchinfo.setSmtpTimeout(com.getNodeInformation().getSmtpTimeout());
		nodewatchinfo.setSmtpTestAddress(com.getNodeInformation()
				.getSmtpSendAddress());
		nodewatchinfo.setSmtpCheckPop3Host(com.getNodeInformation()
				.getSmtpCheckHost());
		nodewatchinfo.setSmtpCheckPop3User(com.getNodeInformation()
				.getSmtpCheckUser());
		nodewatchinfo.setSmtpCheckPop3Password(com.getNodeInformation()
				.getSmtpCheckPassword());
		nodewatchinfo.setSmtpCheckPop3Port(com.getNodeInformation()
				.getSmtpCheckPort());
		nodewatchinfo.setSmtpCheckPop3Timeout(com.getNodeInformation()
				.getSmtpCheckTimeout());

		// m[hĎ擾ThreadXgɃm[hǉ
		this.setThreadList(nodewatchinfo, true);
	}

	/**
	 * Ďm[hǉ܂B
	 * 
	 * @param nodeInfomation
	 *            m[hĎ
	 * @param isInitDatabaseTable
	 *            Database tabel𐶐邩̃tO true : m[hDatabase
	 *            tabel𐶐(f[^x[Xe[u) false: m[hDatabase
	 *            tabel͉Ȃ(f[^x[Xe[ȕȂ)
	 */
	public void addNode(final NodeInformation nodeInfomation,
			boolean isInitDatabaseTable) {
		logger = Logger.getLogger(this.getClass().getName());

		// ǉm[hIPAhX
		String ipaddress = nodeInfomation.getIpaddress();

		// A[`FbNpm[hIPAhXZbg
		AlarmRecovery alarmRecovery = AlarmRecovery.getInstance();
		alarmRecovery.setArarmrecoveryCheck(ipaddress);

		if (isInitDatabaseTable) {
			// m[hǗe[uCX^X擾
			DBTableNodeRegister nodeRegister = DBTableNodeRegister
					.getInstance();

			// m[hPinge[u
			DBTablePingResponse pingRes = DBTablePingResponse.getInstance();

			// Snmp System MIBe[u
			DBTableSystemMIB systemMib = DBTableSystemMIB.getInstance();

			// Snmp C^tF[XMIBe[u
			DBTableInterfaceMIB interfaceMib = DBTableInterfaceMIB
					.getInstance();

			// Snmp vMIBe[u
			DBTableStatisticsMIBControl statisticsMibTable = DBTableStatisticsMIBControl
					.getInstance();

			// Snmp Print MIBe[u
			DBTablePrintMIB printMib = DBTablePrintMIB.getInstance();

			try {
				// m[hǗe[uɃm[ho^
				nodeRegister.registerNode(nodeInfomation);

				// Pinge[u
				pingRes.createTable(ipaddress);

				// Snmp SystemMIBe[u
				systemMib.createTable(ipaddress);

				// Snmp C^tF[XMIBe[u
				interfaceMib.createTable(ipaddress);

				// Snmp Print MIBe[u
				printMib.createTable(ipaddress);

				/* Snmpv̎\e[ui̎MIB OIDACX^XA̎A臒lj */
				statisticsMibTable.createStatisticsMibConfigTable(ipaddress);

				/* Snmpvi[e[uiCX^XA̎f[^iljj */
				statisticsMibTable.createStatisticsMibDataTable(ipaddress);

				/* SnmpvCX^Xe[uiOIDACX^Xj */
				statisticsMibTable.createMibInstanceTable(ipaddress);

			} catch (DatabaseConnectionException e1) {
				logger.warning(e1.getMessage());
				e1.printStackTrace();
			} catch (SQLException e1) {
				logger.warning(e1.getMessage());
				e1.printStackTrace();
			} finally {
				nodeRegister = null;
				pingRes = null;
				systemMib = null;
				interfaceMib = null;
				statisticsMibTable = null;
			}
		}

		/* m[hĎ񐶐 */
		nodewatchinfo = new NodeWatchInfo();

		String snmpVersion = nodeInfomation.getSnmpVersion();

		if (snmpVersion.equals(SnmpPreference.SNMPV1_DESCRIPTION)) {
			nodewatchinfo.setSnmpVersion(SnmpPreference.SNMP_VERSION_1);
		} else if (snmpVersion.equals(SnmpPreference.SNMPV2_DESCRIPTION)) {
			nodewatchinfo.setSnmpVersion(SnmpPreference.SNMPV2C);
		} else if (snmpVersion.equals(SnmpPreference.SNMPV3_DESCRIPTION)) {
			nodewatchinfo.setSnmpVersion(SnmpPreference.SNMPV3);
		} else {
			logger.warning("Bad snmp version : " + snmpVersion);
		}

		logger.info("Snmp version : " + snmpVersion);

		/*
		 * PingĎZbg
		 */
		nodewatchinfo.setIpaddress(nodeInfomation.getIpaddress());
		nodewatchinfo.setNodename(nodeInfomation.getNodename());
		nodewatchinfo.setNodeKind(nodeInfomation.getNodeKind());
		nodewatchinfo.setPingPeriod(nodeInfomation.getPingPeriod());
		nodewatchinfo.setPingThreshold(nodeInfomation.getPingThreshold());

		/*
		 * SNMPĎZbg
		 */
		nodewatchinfo.setSnmpPeriod(nodeInfomation.getSnmpPeriod());
		nodewatchinfo.setSnmpLevel(nodeInfomation.getSnmpLevel());
		nodewatchinfo.setSnmpROCommunity(nodeInfomation.getRoCommunity());
		nodewatchinfo.setSnmpRWCommunity(nodeInfomation.getRwCommunity());

		/*
		 * HTTPĎZbg
		 */
		nodewatchinfo.setHttpUrl(nodeInfomation.getHttpUrl());
		nodewatchinfo.setHttpPeriod(nodeInfomation.getHttpPeriod());
		nodewatchinfo.setHttpTimeout(nodeInfomation.getHttpTimeout());

		/*
		 * Pop3ĎZbg
		 */
		nodewatchinfo.setPopPeriod(nodeInfomation.getPopPeriod());
		nodewatchinfo.setPopUser(nodeInfomation.getPopUser());
		nodewatchinfo.setPopPassword(nodeInfomation.getPopPassword());
		nodewatchinfo.setPopPort(nodeInfomation.getPopPort());
		nodewatchinfo.setPopTimeout(nodeInfomation.getPopTimeout());

		/*
		 * SMTPĎZbg
		 */
		nodewatchinfo.setSmtpPeriod(nodeInfomation.getSmtpPeriod());
		nodewatchinfo.setSmtpPort(nodeInfomation.getSmtpPort());
		nodewatchinfo.setSmtpTimeout(nodeInfomation.getSmtpTimeout());
		nodewatchinfo.setSmtpTestAddress(nodeInfomation.getSmtpSendAddress());
		nodewatchinfo.setSmtpCheckPop3Host(nodeInfomation.getSmtpCheckHost());
		nodewatchinfo.setSmtpCheckPop3User(nodeInfomation.getSmtpCheckUser());
		nodewatchinfo.setSmtpCheckPop3Password(nodeInfomation
				.getSmtpCheckPassword());
		nodewatchinfo.setSmtpCheckPop3Port(nodeInfomation.getSmtpCheckPort());
		nodewatchinfo.setSmtpCheckPop3Timeout(nodeInfomation
				.getSmtpCheckTimeout());

		/*
		 * f[^x[XĎZbg
		 */
		nodewatchinfo.setDatabaseWatcherInfo(nodeInfomation
				.getDatabaseWatcherInfo());

		// m[hĎ擾ThreadXgɃm[hǉ
		this.setThreadList(nodewatchinfo, isInitDatabaseTable);
	}

	/**
	 * IThreads邽߂̃Xgɏݒ肵܂B
	 * 
	 * (0) ̎Ȃ (1) o^ɍ\(System MIBƃC^tF[XMIB)̂ݍ̎ (2)
	 * (1)̎AifInOctets:MINebgy ifOutOctets :MINebg̎
	 * 
	 * @param nodewatchinfo
	 *            m[hĎ
	 * @param isInitDatabaseTable
	 *            e[usۂtO
	 */
	private void setThreadList(NodeWatchInfo nodewatchinfo,
			boolean isInitDatabaseTable) {
		NodeWatchInfo nodeInfo = BaseNodeWatchInfoList.getInstance()
				.getNodeWatchInfo(nodewatchinfo.getIpaddress());

		if (nodeInfo == null) {
			BaseNodeWatchInfoList.getInstance().setNodeWatchInfo(nodewatchinfo);
			nodeInfo = BaseNodeWatchInfoList.getInstance().getNodeWatchInfo(
					nodewatchinfo.getIpaddress());
			nodeInfo.setSystemMIBStatus(NodeWatchInfo.SYSTEM_MIB_PENDING);
			nodeInfo.setInterfaceMIBStatus(NodeWatchInfo.INTERFACE_MIB_PENDING);
			nodeInfo
					.setStatisticsMIBStatus(NodeWatchInfo.STATISTICS_MIB_PENDING);
			nodeInfo.setPrintMIBStatus(NodeWatchInfo.PRINT_MIB_PENDING);
			nodeInfo.setIpaddress(nodewatchinfo.getIpaddress());

			BaseNodeWatchInfoList.getInstance().setNodeWatchInfo(nodeInfo);
		} else {
			nodewatchinfo.setSystemMIBStatus(NodeWatchInfo.SYSTEM_MIB_PENDING);
			nodewatchinfo
					.setInterfaceMIBStatus(NodeWatchInfo.INTERFACE_MIB_PENDING);
			nodewatchinfo
					.setStatisticsMIBStatus(NodeWatchInfo.STATISTICS_MIB_PENDING);
			nodewatchinfo.setPrintMIBStatus(NodeWatchInfo.PRINT_MIB_PENDING);
			nodewatchinfo.setIpaddress(nodewatchinfo.getIpaddress());

			BaseNodeWatchInfoList.getInstance().setNodeWatchInfo(nodewatchinfo);
		}

		String ipaddress = nodewatchinfo.getIpaddress();
		String nodeName = nodewatchinfo.getNodename();
		int version = nodewatchinfo.getSnmpVersion();
		String roCommunity = nodewatchinfo.getSnmpROCommunity();

		String pingPeriod = nodewatchinfo.getPingPeriod();
		String threshHold = nodewatchinfo.getPingThreshold();

		int pingPeriodData = 0;

		if (!pingPeriod.equals("--")) {
			try {
				pingPeriodData = Integer.parseInt(pingPeriod);
			} catch (NumberFormatException e3) {
				logger.warning("ping period : " + pingPeriod);
			}
		}

		// PingĎThreadAX^[g
		if (pingPeriodData > 0) {
			// PingsList Zbg
			NodeWatchInfo info = new NodeWatchInfo();
			info.setPingPeriod(pingPeriod);
			info.setSnmpROCommunity(roCommunity);
			info.setPingThreshold(threshHold);
			info.setIpaddress(ipaddress);
			info.setNodename(nodeName);
			ListQueuePingControl.getInstance().setPingNode(ipaddress, info);
		}

		/* SNMP ThreadZbg */
		setSNMPThread(isInitDatabaseTable, nodewatchinfo, ipaddress, nodeName,
				version, roCommunity);

		/*
		 * HTTPXgɃZbg
		 */
		int httpPeriod = 0;

		try {
			httpPeriod = Integer.parseInt(nodewatchinfo.getHttpPeriod());
		} catch (NumberFormatException e) {
			logger.warning("http period " + e.getMessage());
		}

		if (httpPeriod > 0) {
			// HTTPsList Zbg
			NodeWatchInfo info = new NodeWatchInfo();
			info.setIpaddress(ipaddress);
			info.setNodename(nodeName);
			info.setHttpPeriod(nodewatchinfo.getHttpPeriod());
			info.setHttpTimeout(nodewatchinfo.getHttpTimeout());
			info.setHttpUrl(nodewatchinfo.getHttpUrl());

			ListQueueHTTPControl.getInstance().setHTTPNode(ipaddress, info);
		}

		int popPeriod = 0;

		try {
			popPeriod = Integer.parseInt(nodewatchinfo.getPopPeriod());
		} catch (NumberFormatException e) {
			logger.warning("pop period " + e.getMessage());
		}

		if (popPeriod > 0) {
			// POP3sList Zbg
			NodeWatchInfo info = new NodeWatchInfo();
			info.setIpaddress(ipaddress);
			info.setNodename(nodeName);
			info.setPopPeriod(nodewatchinfo.getPopPeriod());
			info.setPopUser(nodewatchinfo.getPopUser());
			info.setPopPassword(nodewatchinfo.getPopPassword());
			info.setPopPort(nodewatchinfo.getPopPort());
			info.setPopTimeout(nodewatchinfo.getPopTimeout());
			ListQueuePopControl.getInstance().setPop3Node(ipaddress, info);
		}

		int smtpPeriod = 0;

		try {
			smtpPeriod = Integer.parseInt(nodewatchinfo.getSmtpPeriod());
		} catch (NumberFormatException e) {
			logger.warning("http period " + e.getMessage());
		}

		if (smtpPeriod > 0) {
			// SMTPsList Zbg
			NodeWatchInfo info = new NodeWatchInfo();
			info.setIpaddress(ipaddress);
			info.setNodename(nodeName);
			info.setSmtpPeriod(nodewatchinfo.getSmtpPeriod());
			info.setSmtpPort(nodewatchinfo.getSmtpPort());
			info.setSmtpTimeout(nodewatchinfo.getSmtpTimeout());
			info.setSmtpTestAddress(nodewatchinfo.getSmtpTestAddress());
			info.setSmtpCheckPop3Host(nodewatchinfo.getSmtpCheckPop3Host());
			info.setSmtpCheckPop3User(nodewatchinfo.getSmtpCheckPop3User());
			info.setSmtpCheckPop3Password(nodewatchinfo
					.getSmtpCheckPop3Password());
			info.setSmtpCheckPop3Port(nodewatchinfo.getSmtpCheckPop3Port());
			info.setSmtpCheckPop3Timeout(nodewatchinfo
					.getSmtpCheckPop3Timeout());
			ListQueueSmtpControl.getInstance().setSmtpNode(ipaddress, info);
		}

		DatabaseWatcherInfo databaseWatcherInfo = nodewatchinfo
				.getDatabaseWatcherInfo();
		if (databaseWatcherInfo != null) {
			String databaseInfoPeriod = databaseWatcherInfo.getWatcherPeriod();
			int databaseInfoPeriodData = 0;
			if (databaseInfoPeriod == null || !databaseInfoPeriod.equals("--")) {
				try {
					databaseInfoPeriodData = Integer
							.parseInt(databaseInfoPeriod);
				} catch (NumberFormatException e3) {
					logger.warning("database watch period : "
							+ databaseInfoPeriod);
				}
			}

			// DatabaseĎThreadAX^[g
			if (databaseInfoPeriodData > 0) {
				// DatabasesList Zbg
				NodeWatchInfo info = new NodeWatchInfo();
				info.setIpaddress(ipaddress);
				info.setNodename(nodeName);
				info.setDatabaseWatcherInfo(nodewatchinfo
						.getDatabaseWatcherInfo());
				ListQueueDatabaseWatchControl.getInstance().setDatabaseNode(
						ipaddress, info);
			}
		}
	}

	/*
	 * SNMP ThraedZbg܂B
	 * 
	 * @param isInitDatabaseTable f[^x[XtO @param nodewatchinfo m[hĎ
	 * @param ipaddress m[hIP Address @param nodeName m[h @param version
	 * SNMPo[W @param roCommunity SNMP ReadR~jeB
	 */
	private void setSNMPThread(boolean isInitDatabaseTable,
			NodeWatchInfo nodewatchinfo, String ipaddress, String nodeName,
			int version, String roCommunity) {
		int snmpLevel = 0;

		try {
			snmpLevel = Integer.parseInt(nodewatchinfo.getSnmpLevel());
		} catch (NumberFormatException e1) {
			logger.warning("SNMP level : " + snmpLevel);
		}

		int snmpPeriod = 0;

		if (!nodewatchinfo.getSnmpPeriod().equals("--")) {
			try {
				snmpPeriod = Integer.parseInt(nodewatchinfo.getSnmpPeriod());
			} catch (NumberFormatException e2) {
				logger
						.warning("SNMP period : "
								+ nodewatchinfo.getSnmpPeriod());
			}
		}

		if (snmpPeriod == 0) {
			return;
		}
		/*
		 * SNMPĎx`FbN
		 */
		if (snmpLevel > SnmpPreference.SNMP_LEVEL0) {
			nodewatchinfo.setSystemMIBStatus(NodeWatchInfo.SYSTEM_MIB_PENDING);
			nodewatchinfo
					.setInterfaceMIBStatus(NodeWatchInfo.INTERFACE_MIB_PENDING);
			nodewatchinfo.setPrintMIBStatus(NodeWatchInfo.PRINT_MIB_PENDING);
			BaseNodeWatchInfoList.getInstance().setNodeWatchInfo(nodewatchinfo);

			if (isInitDatabaseTable) {
				/*
				 * SNMP Thread(System MIByInterfaces MIB̎) AX^[g
				 * f[^x[XZbĝ߂Ƀe[u𐶐 (e[u܂Œ̎ThreadWait)
				 */
				Thread thread = new Thread(
						new NodeSnmpRegisterInitializeThread(ipaddress,
								version, snmpPeriod, roCommunity, snmpLevel,
								nodewatchinfo.getNodeKind()));
				thread.setDaemon(true);
				thread.setName("SNMP Init Thread : " + ipaddress);
				thread.start();
			} else {
				/*
				 * f[^x[XłȂꍇɂ͊Ƀe[u݂邽߂ ̎OKtOZbg
				 */
				nodewatchinfo.setSystemMIBStatus(NodeWatchInfo.SYSTEM_MIB_OK);
				nodewatchinfo
						.setInterfaceMIBStatus(NodeWatchInfo.INTERFACE_MIB_OK);
				nodewatchinfo
						.setStatisticsMIBStatus(NodeWatchInfo.STATISTICS_MIB_OK);
				nodewatchinfo.setPrintMIBStatus(NodeWatchInfo.PRINT_MIB_OK);
				BaseNodeWatchInfoList.getInstance().setNodeWatchInfo(
						nodewatchinfo);
			}

			/*
			 * SNMP̎惌x1ȏłSystem/Interface MIB̎
			 */
			NodeWatchInfo info2 = new NodeWatchInfo();
			info2.setSnmpVersion(version);
			info2.setSnmpPeriod(nodewatchinfo.getSnmpPeriod());
			info2.setSnmpROCommunity(roCommunity);
			info2.setIpaddress(ipaddress);
			info2.setNodename(nodeName);
			info2.setNodeKind(nodewatchinfo.getNodeKind());
			ListQueueDefaultSnmpMibControl.getInstance().setDefaultSnmpNode(
					ipaddress, info2);
		}

		if (snmpLevel == SnmpPreference.SNMP_LEVEL2) {
			/*
			 * EifInOctets 1.3.6.1.2.1.2.2.1.10 if:MINebg EifOutOctets
			 * 1.3.6.1.2.1.2.2.1.16 if:MINebg
			 */
			StatisticsMibInfo mibInfo = StatisticsMibInfo
					.getInstance(ipaddress);
			mibInfo.setNodeName(nodeName);
			mibInfo.setVersion(version);
			mibInfo.setCommunity(roCommunity);
			mibInfo.setOidList(SnmpIfOctet.IF_IN_OCTETS, nodewatchinfo
					.getSnmpPeriod(),
					StatisticsMibDBRegister.STATISTICS_MIB_NO_THRESHOLD,
					StatisticsMibDBRegister.STATISTICS_MIB_NO_TYPE);

			ListQueueStatisticsMibControl.getInstance()
					.setStatisticsMibGetNode(ipaddress, mibInfo);

			mibInfo = StatisticsMibInfo.getInstance(ipaddress);
			mibInfo.setNodeName(nodeName);
			mibInfo.setCommunity(roCommunity);
			mibInfo.setOidList(SnmpIfOctet.IF_OUT_OCTETS, nodewatchinfo
					.getSnmpPeriod(),
					StatisticsMibDBRegister.STATISTICS_MIB_NO_THRESHOLD,
					StatisticsMibDBRegister.STATISTICS_MIB_NO_TYPE);

			ListQueueStatisticsMibControl.getInstance()
					.setStatisticsMibGetNode(ipaddress, mibInfo);
		}

		if (snmpLevel == SnmpPreference.SNMP_LEVEL3) {
			// net-snmp CPU MIB̎Threado^
			StatisticsMibInfo mibInfo = StatisticsMibInfo
					.getInstance(ipaddress);
			mibInfo.setNodeName(nodeName);
			mibInfo.setVersion(version);
			mibInfo.setCommunity(roCommunity);

			mibInfo.setOidList(NetSnmpOid.LALOAD,
					nodewatchinfo.getSnmpPeriod(),
					StatisticsMibDBRegister.STATISTICS_MIB_NO_THRESHOLD,
					StatisticsMibDBRegister.STATISTICS_MIB_NO_TYPE);

			ListQueueStatisticsMibControl.getInstance()
					.setStatisticsMibGetNode(ipaddress, mibInfo);
		}

		if (snmpLevel == SnmpPreference.SNMP_LEVEL4) {
			// net-snmp Disk MIB̎Threado^
			StatisticsMibInfo mibInfo = StatisticsMibInfo
					.getInstance(ipaddress);
			mibInfo.setNodeName(nodeName);
			mibInfo.setVersion(version);

			mibInfo.setCommunity(roCommunity);
			mibInfo.setOidList(NetSnmpOid.DSK_TOTAL, nodewatchinfo
					.getSnmpPeriod(),
					StatisticsMibDBRegister.STATISTICS_MIB_NO_THRESHOLD,
					StatisticsMibDBRegister.STATISTICS_MIB_NO_TYPE);
			ListQueueStatisticsMibControl.getInstance()
					.setStatisticsMibGetNode(ipaddress, mibInfo);
			mibInfo = StatisticsMibInfo.getInstance(ipaddress);
			mibInfo.setCommunity(roCommunity);
			mibInfo.setOidList(NetSnmpOid.DSK_AVAIL, nodewatchinfo
					.getSnmpPeriod(),
					StatisticsMibDBRegister.STATISTICS_MIB_NO_THRESHOLD,
					StatisticsMibDBRegister.STATISTICS_MIB_NO_TYPE);
			ListQueueStatisticsMibControl.getInstance()
					.setStatisticsMibGetNode(ipaddress, mibInfo);
			mibInfo = StatisticsMibInfo.getInstance(ipaddress);
			mibInfo.setCommunity(roCommunity);
			mibInfo.setOidList(NetSnmpOid.DSK_USED, nodewatchinfo
					.getSnmpPeriod(),
					StatisticsMibDBRegister.STATISTICS_MIB_NO_THRESHOLD,
					StatisticsMibDBRegister.STATISTICS_MIB_NO_TYPE);
			ListQueueStatisticsMibControl.getInstance()
					.setStatisticsMibGetNode(ipaddress, mibInfo);
		}
	}

	/**
	 * ̃NX̃CX^XԂ܂B<BR>
	 * iNXێĂVOgEIuWFNg Ԃ܂j<BR>
	 * 
	 * @return VOgEIuWFNgƂĂ̂̃NX CX^X
	 */
	public static NodeAdd getInstance() {
		return SingletonResource.RESOURCE;
	}

	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonResource {
		static final NodeAdd RESOURCE = new NodeAdd();
	}
}
