/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.nodemaneger.map;

import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.view.editorpart.common.AbstractEditorNodeChart;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeChart;
import netjfwatcher.engine.view.editorpart.snmp.EditorNodeSnmpStatisticsChart;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;



/**
 * m[hMapł̃m[hIconIj[ŁASnmpvOt\I
 * ꍇ s郁\bhSelectionAdapterNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodeMapMenuNodeSnmpStatisticsChart extends SelectionAdapter {
    /* MO */
    private static Logger logger;

    /* m[hĎ */
    private NodeInformation nodeInfo;

    /**
     * SocketɂăT[of[^擾邩f[^x[X
     * 擾邩tO
     */
    protected boolean isSocket;

    /* OID */
    private String oid;

    /* SNMPv̎OIDXg */
    private ArrayList snmpStatisticsNameList;

    /**
     * m[hMapł̃m[hIconIj[łSelectionAdapterNX
     * CX^X𐶐܂B
     *
     * @param nodeInfo m[hĎ
     * @param isSocket lbg[NoRŏ擾邩ۂtO
     * @param oid OID
     * @param snmpStatisticsNameList SNMPv̎OIDXg
     */
    public NodeMapMenuNodeSnmpStatisticsChart(
        NodeInformation nodeInfo, boolean isSocket, String oid,
        ArrayList snmpStatisticsNameList) {
        logger = Logger.getLogger(this.getClass().getName());
        this.nodeInfo = nodeInfo;
        this.isSocket = isSocket;
        this.oid = oid;
        this.snmpStatisticsNameList = snmpStatisticsNameList;
    }

    /**
     * j[IłB
     *
     * @param event SelectionEvent
     */
    public void widgetSelected(SelectionEvent event) {
        String title =
            nodeInfo.getNodename() + "(" + nodeInfo.getIpaddress() + ") "
            + " OID=" + oid + AbstractEditorNodeChart.TITLE_SUFFIX;

        IWorkbenchPage activePage =
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();

        try {
            /*
            * IꂽGg̃m[hURLEditorɃuEU
            * I[v
            * EditorID̓uEŨNX
            */
            activePage.openEditor(
                new EditorInputNodeChart(
                    title, nodeInfo, isSocket, snmpStatisticsNameList, oid),
                EditorNodeSnmpStatisticsChart.class.getName());

            /* editorNodeConfigView =
                activePage.openEditor(
                    new EditorInputNodeChart(
                        title, nodeInfo, dataList, dateList, nameList,
                        maxData, minData, oid),
                    EditorNodeSnmpStatisticsChart.class.getName());
            */
        } catch (PartInitException e3) {
            logger.warning(e3.getMessage());
            e3.printStackTrace();
        }
    }
}
