/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.nodemaneger.map;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;

import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.socket.info.NodeMapLinkInformation;
import netjfwatcher.engine.top.TopViewPreference;
import netjfwatcher.engine.view.canvas.CanvasViewConfig;
import netjfwatcher.engine.view.editorpart.common.AbstractEditorNodeChart;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;

/**
 * m[hMap ViewɃm[hMap`悷NXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodeMapViewDraw {
	/* zFColor` */
	private static Color WHITE_COLOR;

	private static Color BLACK_COLOR;

	private static Color RED_COLOR;

	private static Color TEST_COLOR;

	private static final int NODE_NAME_Y_OFFSET = 40;

	private static final int NODE_IPADDRESS_Y_OFFSET = 60;

	private static final int NODE_OVAL_VIEW_OFFSET = 3;
	
	/* m[hIconN`悷IconItZbgl */
	private static final int NODE_ICON_LINK_OFFSET = 10;

	private Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();
	
	private Display display;
	
	/* m[hMap Canvas */
	private Canvas canvas;

	/* GC */
	private GC gc;

	// private Rectangle mapViewRectangle;
	private ScrolledComposite scrollComposite;

	private Point mapScrollCompositePoint;

	private int overviewPointX;

	private int overviewPointY;

	private int canvaAbsPointX;

	private int canvaAbsPointY;
	private int nodeMapViewWidth;
	private int nodeMapViewHeight;

	/* TvXP[ */
	private static final int OVERVIEW_POINT_SCALL = 20;

	/**
	 * m[hMap View`NXCX^X𐶐܂B
	 * 
	 * @param canvas
	 *            Canvas
	 * @param gc
	 *            GC
	 */
	public NodeMapViewDraw(Display display, ScrolledComposite scrollComposite, Canvas canvas,
			GC gc) {
		this.display = display;
		this.scrollComposite = scrollComposite;
		this.canvas = canvas;
		this.gc = gc;

	
		nodeMapViewWidth = CanvasViewConfig.getInstance().getCanvasSizeInfo().getNodeMapWidth();
		nodeMapViewHeight = CanvasViewConfig.getInstance().getCanvasSizeInfo().getNodeMapHeight();
		
		WHITE_COLOR = new Color(null, 255, 255, 255);
		BLACK_COLOR = new Color(null, 0, 0, 0);
		RED_COLOR = new Color(null, 255, 0, 0);
		TEST_COLOR = new Color(null, 127, 127, 127);
	}

	/**
	 * m[hLinkyуm[hĕ`悵܂B
	 * 
	 * @param nodeMapNodeInfoList
	 *            m[hIcon񃊃Xg
	 * @param nodMapLinkInformationList
	 *            m[hN
	 */
	public void redraw(ArrayList nodeMapNodeInfoList,
			NodeMapLinkInformation nodMapLinkInformationList) {

		
		
		gc.fillRectangle(canvas.getClientArea());

		int height = canvas.getClientArea().height - 1;
		int width = canvas.getClientArea().width - 1;
		gc.setForeground(TEST_COLOR);
		gc.drawLine(0, 0, width, 0);
		gc.drawLine(0, 0, 0, height);
		gc.setForeground(WHITE_COLOR);
		gc.drawLine(width, 0, width, height);
		gc.drawLine(0, height, width, height);
		gc.setBackground(WHITE_COLOR);
		gc.setForeground(BLACK_COLOR);

		createOverviewPoint();
		setMapOverviewNode();

		/* m[hLink` */
		drawNodeLink(nodeMapNodeInfoList, nodMapLinkInformationList);

		/* m[h` */
		drawNode(nodeMapNodeInfoList);

	}


	
	/**
	 * Map Overview̕`ʒuZbg܂B
	 * 
	 */
	protected void createOverviewPoint() {
		/* SCanvasɂVieẅʒu */
		Point canvaPoint = canvas.getLocation();
		canvaAbsPointX = Math.abs(canvaPoint.x);
		canvaAbsPointY = Math.abs(canvaPoint.y);
		/* \ĂMapr[TCY */
		// mapViewRectangle = gc.getClipping();
		mapScrollCompositePoint = scrollComposite.getSize();
		overviewPointX = canvaAbsPointX;
		overviewPointY = canvaAbsPointY
				+ (mapScrollCompositePoint.y - (AbstractEditorNodeChart.OFFSET))
				- (nodeMapViewHeight/ OVERVIEW_POINT_SCALL);

	}

	/**
	 * Map Overview`悵܂B
	 * 
	 */
	protected void setMapOverviewNode() {

		gc.setForeground(BLACK_COLOR);
		/* Map OverviewOg */
		gc.setLineStyle(SWT.LINE_DOT);
		gc.drawRectangle(overviewPointX, overviewPointY,
				nodeMapViewWidth / OVERVIEW_POINT_SCALL,
				nodeMapViewHeight / OVERVIEW_POINT_SCALL);
		/* Map view̑S̃LoẌʒu */
		gc.setLineWidth(2);
		gc.setLineStyle(SWT.LINE_SOLID);
		gc.drawRectangle(overviewPointX + canvaAbsPointX / OVERVIEW_POINT_SCALL,
				overviewPointY + canvaAbsPointY / OVERVIEW_POINT_SCALL,
				mapScrollCompositePoint.x / OVERVIEW_POINT_SCALL,
				mapScrollCompositePoint.y / OVERVIEW_POINT_SCALL);

		gc.setLineWidth(1);
	}

	/**
	 * Map OverviewɃm[hDraw܂B
	 * 
	 * @param nodex
	 *            m[hXW
	 * @param nodey
	 *            m[hYW
	 */
	protected void setMapOverviewNode(int nodex, int nodey) {

		gc.drawRectangle((overviewPointX + (nodex / OVERVIEW_POINT_SCALL)),
				(overviewPointY + (nodey / OVERVIEW_POINT_SCALL)), NODE_OVAL_VIEW_OFFSET, NODE_OVAL_VIEW_OFFSET);
	}

	/**
	 * m[h`悵܂B
	 * 
	 * @param nodeMapNodeInfoList
	 *            m[hIcon񃊃Xg
	 */
	protected void drawNode(ArrayList nodeMapNodeInfoList) {
		setColor();

		for (int i = 0; i < nodeMapNodeInfoList.size(); i++) {
			/* m[hIcon imagedraw */
			NodeMapInfo nodeMapInfo = (NodeMapInfo) nodeMapNodeInfoList.get(i);
			int pointX = nodeMapInfo.getX();
			int pointY = nodeMapInfo.getY();
			gc.setForeground(BLACK_COLOR);

			if (!nodeMapInfo.isSelected()) {
				gc.drawImage(nodeMapInfo.getNodeIconImage(), pointX, pointY);

			} else {
				gc.drawImage(nodeMapInfo.getNodeIconImage(), pointX, pointY);
				gc.drawOval(pointX, pointY, nodeMapInfo.getWidth(), nodeMapInfo
						.getHeight());
			}
			setMapOverviewNode(pointX, pointY);
			/*
			 * m[h,IPAhXIcon imagẻɃZbg
			 */
			gc.drawString(nodeMapInfo.getNodeInfo().getNodename(), pointX,
					pointY + NODE_NAME_Y_OFFSET);
			gc.drawString(nodeMapInfo.getNodeInfo().getIpaddress(), pointX,
					pointY + NODE_IPADDRESS_Y_OFFSET);

			/*
			 * A[Zbg
			 */
			NodeInformation nodeInfo = nodeMapInfo.getNodeInfo();

			if ((nodeInfo.getAlarmMessage() != null)
					&& !nodeInfo.getAlarmMessage().equals("")) {
				gc.setForeground(RED_COLOR);

				gc.drawString(nodeMapInfo.getNodeInfo().getAlarmDate() + " : "
						+ nodeMapInfo.getNodeInfo().getAlarmMessage(), pointX,
						pointY + 80);

				gc.drawLine(pointX, pointY, pointX + nodeMapInfo.getWidth(),
						pointY + nodeMapInfo.getHeight());
				gc.drawLine(pointX + nodeMapInfo.getWidth(), pointY, pointX,
						pointY + nodeMapInfo.getHeight());

				gc.setForeground(BLACK_COLOR);
			}
		}
	}

	/**
	 * m[hLink`悵܂B
	 * 
	 * @param nodeMapNodeInfoList
	 *            m[hIcon񃊃Xg
	 * @param nodMapLinkInformationList
	 *            m[hN
	 */
	protected void drawNodeLink(ArrayList nodeMapNodeInfoList,
			NodeMapLinkInformation nodMapLinkInformationList) {
		if (nodMapLinkInformationList == null) {
			return;
		}

		ArrayList nodeLinkList0 = nodMapLinkInformationList.getNode0address();
		ArrayList nodeLinkList1 = nodMapLinkInformationList.getNode1address();

		/*
		 * m[hLinkoăm[hԂLink`
		 */
		for (int i = 0; i < nodeLinkList0.size(); i++) {
			String nodeX = (String) nodeLinkList0.get(i);
			String nodeY = (String) nodeLinkList1.get(i);
			for (int j = 0; j < nodeMapNodeInfoList.size(); j++) {
				NodeMapInfo nodeMapInfo = (NodeMapInfo) nodeMapNodeInfoList
						.get(j);
				NodeInformation nodeInfo = nodeMapInfo.getNodeInfo();
				if (nodeX.equals(nodeInfo.getIpaddress())) {
					for (int k = 0; k < nodeMapNodeInfoList.size(); k++) {
						NodeMapInfo nodeMapInfo2 = (NodeMapInfo) nodeMapNodeInfoList
								.get(k);
						NodeInformation nodeInfo2 = nodeMapInfo2.getNodeInfo();

						if (nodeY.equals(nodeInfo2.getIpaddress())) {
							int x0;
							int y0;
							int x1;
							int y1;

							x0 = (int) Float.parseFloat(nodeInfo.getNodeX())
									+ NODE_ICON_LINK_OFFSET;
							y0 = (int) Float.parseFloat(nodeInfo.getNodeY())
									+ NODE_ICON_LINK_OFFSET;
							x1 = (int) Float.parseFloat(nodeInfo2.getNodeX())
									+ NODE_ICON_LINK_OFFSET;
							y1 = (int) Float.parseFloat(nodeInfo2.getNodeY())
									+ NODE_ICON_LINK_OFFSET;
							gc.setForeground(BLACK_COLOR);
							gc.drawLine(x0, y0, x1, y1);
						}
					}
				}
			}
		}
	}

	/*
	 * ColorIuWFNgZbg܂B
	 * 
	 */
	private void setColor() {
		/*
		 * ColorIuWFNgjĂ΍ăZbg
		 */
		if ((WHITE_COLOR == null) || WHITE_COLOR.isDisposed()) {
			WHITE_COLOR = new Color(null, 255, 255, 255);
		}

		if ((BLACK_COLOR == null) || BLACK_COLOR.isDisposed()) {
			BLACK_COLOR = new Color(null, 0, 0, 0);
		}

		if ((RED_COLOR == null) || RED_COLOR.isDisposed()) {
			RED_COLOR = new Color(null, 255, 0, 0);
		}

		if ((TEST_COLOR == null) || TEST_COLOR.isDisposed()) {
			TEST_COLOR = new Color(null, 127, 127, 127);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#finalize()
	 */
	protected void finalize() throws Throwable {
		super.finalize();

		if (WHITE_COLOR != null && !WHITE_COLOR.isDisposed()) {
			WHITE_COLOR.dispose();
		}

		if (BLACK_COLOR != null && !BLACK_COLOR.isDisposed()) {
			BLACK_COLOR.dispose();
		}

		if (RED_COLOR != null && !RED_COLOR.isDisposed()) {
			RED_COLOR.dispose();
		}

		if (TEST_COLOR != null && !TEST_COLOR.isDisposed()) {
			TEST_COLOR.dispose();
		}

		if (gc != null && !gc.isDisposed()) {
			gc.dispose();
		}
		if (canvas != null && !canvas.isDisposed()) {
			canvas.dispose();
		}
	}
}
