/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.preferance;

import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.engine.resource.DatabasePropertyResource;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.socket.info.DatabasePropertyInfo;
import netjfwatcher.engine.socket.info.ResourceInfo;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;



/**
 * DatabasevpeBPreferencePageNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class DatabasePreferencePage extends AbstractEnginePreferancePage
    implements IWorkbenchPreferencePage {
    /** f[^x[XeLXg */
    public static final int DATABASE_NAME_TEXT_WIDTH = 200;

    /** eLXg */
    public static final int TEXT_WIDTH = 300;

    /* MO */
    private static Logger logger;

    /* \[X */
    private ResourceInfo resourceInfo;

    /* f[^x[XvpeBXg */
    private ArrayList databasePropList;

    /* f[^x[XvpeB */
    private DatabasePropertyInfo databaseProp;

    /* f[^x[XIR{ */
    private Combo databaseNameCombo;

    /* f[^x[X\Text */
    private Text databaseNameText;

    /* f[^x[XhCo\Text */
    private Text databaseDriverText;

    /* f[^x[XURL\Text */
    private Text databaseUrlText;

    /* f[^x[X[U\Text */
    private Text databaseUserText;

    /* f[^x[XpX[h\Text */
    private Text databasePasswordText;

    /* [Nf[^x[XhCo\Text */
    private Text workDatabaseDriverText;

    /* [Nf[^x[XURL\Text */
    private Text workDatabaseUrlText;

    /* [Nf[^x[X[U\Text */
    private Text workDatabaseUserText;

    /* [Nf[^x[XpX[h\Text */
    private Text workDatabasePasswordText;

    /* Rs[{^ */
    private Button copyButton;

    /*
     * (non-Javadoc)
     * @see org.eclipse.jface.preference.PreferencePage#init(IWorkbench)
     */
    public void init(IWorkbench workbench) {
        logger = Logger.getLogger(this.getClass().getName());

        // Initialize the preference store we wish to use
        setPreferenceStore(NetJFWatcherPlugin.getInstance().getPreferenceStore());
    }

    /*
     * (non-Javadoc)
     * @see org.eclipse.jface.preference.PreferencePage#createContents(Composite)
     */
    protected Control createContents(Composite parent) {
        resourceInfo =
            SystemResourceConfig.getInstance().getResourceFileParse()
                                .getResourceInfo();

        databasePropList =
            DatabasePropertyResource.getInstance().getdatabasePropList()
                                    .getDatabasePropList();
        databaseProp = (DatabasePropertyInfo) databasePropList.get(0);

        /*
         * eCompositezueLayout
         * ieCompositec1ɔzuj
         */
        GridLayout layout = new GridLayout(1, false);
        parent.setLayout(layout);

        GridData gridData = null;

        /*
         * Snmp V3 AgentAhXAOIDȂǂzuComposite
         */
        GridLayout gridLayout = new GridLayout(2, false);
        Composite composite = new Composite(parent, SWT.NULL);

        composite.setLayout(gridLayout);
        composite.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
        gridData = new GridData();

        Label label = new Label(composite, SWT.NONE);
        label.setText("Database Name");
        label.setLayoutData(new GridData());
        databaseNameText = new Text(composite, SWT.BORDER);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = DATABASE_NAME_TEXT_WIDTH;
        databaseNameText.setLayoutData(gridData);

        label = new Label(composite, SWT.NONE);
        label.setText("Database Driver");
        gridData = new GridData();
        label.setLayoutData(gridData);

        databaseDriverText = new Text(composite, SWT.BORDER);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        databaseDriverText.setLayoutData(gridData);

        label = new Label(composite, SWT.NONE);
        label.setText("Database URL");
        gridData = new GridData();
        label.setLayoutData(gridData);

        databaseUrlText = new Text(composite, SWT.BORDER);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        databaseUrlText.setLayoutData(gridData);

        label = new Label(composite, SWT.NONE);
        label.setText("Database User");
        label.setLayoutData(new GridData());
        databaseUserText = new Text(composite, SWT.BORDER);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        databaseUserText.setLayoutData(gridData);

        label = new Label(composite, SWT.NONE);
        label.setText("Database Password");
        label.setLayoutData(new GridData());
        databasePasswordText = new Text(composite, SWT.BORDER);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        databasePasswordText.setLayoutData(gridData);

        /* Dummy column */
        label = new Label(composite, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        /* Dummy column */
        label = new Label(composite, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        /* Dummy column */
        label = new Label(composite, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        copyButton = new Button(composite, SWT.NONE);
        copyButton.setText("Copy");
        copyButton.setLayoutData(new GridData());

        label = new Label(composite, SWT.NONE);
        label.setText("Database Name");
        label.setLayoutData(new GridData());
        databaseNameCombo = new Combo(composite, SWT.DROP_DOWN | SWT.READ_ONLY);

        for (int i = 0; i < databasePropList.size(); i++) {
            databaseNameCombo.add(
                ((DatabasePropertyInfo) databasePropList.get(i))
                .getDatabaseName());
        }

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = DATABASE_NAME_TEXT_WIDTH;
        databaseNameCombo.setLayoutData(gridData);
        databaseNameCombo.select(0);

        label = new Label(composite, SWT.NONE);
        label.setText("Database Driver");
        label.setLayoutData(new GridData());
        workDatabaseDriverText = new Text(composite, SWT.BORDER);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        workDatabaseDriverText.setLayoutData(gridData);

        label = new Label(composite, SWT.NONE);
        label.setText("Database URL");
        label.setLayoutData(new GridData());
        workDatabaseUrlText = new Text(composite, SWT.BORDER);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        workDatabaseUrlText.setLayoutData(gridData);

        label = new Label(composite, SWT.NONE);
        label.setText("Database User");
        label.setLayoutData(new GridData());
        workDatabaseUserText = new Text(composite, SWT.BORDER);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        workDatabaseUserText.setLayoutData(gridData);

        label = new Label(composite, SWT.NONE);
        label.setText("Database Password");
        label.setLayoutData(new GridData());
        workDatabasePasswordText = new Text(composite, SWT.BORDER);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        workDatabasePasswordText.setLayoutData(gridData);

        /* Dummy column */
        label = new Label(composite, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        showDatabaseProp();
        setSelectDatabase();

        /* Database CombBoxI */
        databaseNameCombo.addSelectionListener(
            new SelectionAdapter() {
                public void widgetSelected(SelectionEvent event) {
                    int smtpHostSelectIndex =
                        databaseNameCombo.getSelectionIndex();

                    databaseProp =
                        (DatabasePropertyInfo) databasePropList.get(
                            smtpHostSelectIndex);
                    setSelectDatabase();
                }
            });

        /* DatabaseCopy{^ */
        copyButton.addSelectionListener(
            new SelectionListener() {

                public void widgetSelected(SelectionEvent event) {
                    resourceInfo.setDatabaseName(databaseNameCombo.getText());
                    resourceInfo.setDatabaseDriver(
                        workDatabaseDriverText.getText());
                    resourceInfo.setDatabaseUrl(workDatabaseUrlText.getText());
                    resourceInfo.setDatabaseUser(
                        workDatabaseUserText.getText());
                    resourceInfo.setDatabasePassword(
                        workDatabasePasswordText.getText());

                    showDatabaseProp();
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                }
            });

        return composite;
    }

    /*
     * DatabasevpeBeLXg\܂B
     *
     */
    private void showDatabaseProp() {
        databaseNameText.setText(resourceInfo.getDatabaseName());
        databaseDriverText.setText(resourceInfo.getDatabaseDriver());
        databaseUrlText.setText(resourceInfo.getDatabaseUrl());
        databaseUserText.setText(resourceInfo.getDatabaseUser());
        databasePasswordText.setText(resourceInfo.getDatabasePassword());
    }

    /*
     * DatabaseIComboBoxőIꂽvpeB\܂B
     *
     */
    private void setSelectDatabase() {
        workDatabaseDriverText.setText(databaseProp.getDatabaseDriver());
        workDatabaseUrlText.setText(databaseProp.getDatabaseUrl());
        workDatabaseUserText.setText(databaseProp.getDatabaseUser());
        workDatabasePasswordText.setText(databaseProp.getDatabasePassword());
    }

    /* (non-Javadoc)
     * @see org.eclipse.jface.preference.PreferencePage#performDefaults()
     */
    protected void performDefaults() {
        resourceInfo =
            SystemResourceConfig.getInstance().getResourceFileParse()
                                .getResourceInfo();
        showDatabaseProp();
    }

    /*
     * (non-Javadoc)
     * @see org.eclipse.jface.preference.PreferencePage#performOk()
     */
    public boolean performOk() {
        resourceInfo.setDatabaseName(databaseNameText.getText());
        resourceInfo.setDatabaseDriver(databaseDriverText.getText());
        resourceInfo.setDatabaseUrl(databaseUrlText.getText());
        resourceInfo.setDatabaseUser(databaseUserText.getText());
        resourceInfo.setDatabasePassword(databasePasswordText.getText());

        saveResourceXMLInfo(resourceInfo);

        return super.performOk();
    }
}
