/*
 * Created on 2004/05/01
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.server.protocol.control;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import netjfwatcher.engine.nodewatchinfo.NodeWatchInfo;



/**
 * SMTPĎCxgL[ƂĊǗNXłB
 * SMTPĎCxg̃L[ɓo^ASMTPĎThraed
 * ̂̈ThreadL[̃CxgǂݏoĎs܂B
 *
 *            ThreadListReadQ
 *           iĎJEgAĎŃL[Pushj
 *        Read         Push
 * |  | ---------+   +---------------+   Queue
 * |--|                            |  |
 * |--|                            |   |
 * |--|                            |   |
 * |--|                            |   |    ThreadQueueCheck
 * +--+                            |   |   iL[Ƀf[^
 *                                 |   |      `FbNsj
 * ListQueue                                    
 * im[ho^/폜                    +----------+  +----- Exec
 *  ŃXgZbgj
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class QueueForSmtp extends AbstractQueueForProtocolCheck {
    /*
     * SMTPĎCxgL[Ƃĕێ郊Xg
     */
    private List<NodeWatchInfo> list;

    /*
     * SMTPĎCxgL[ƂĊǗNXCX^X𐶐܂B
     *
     */
    private QueueForSmtp() {
        list = Collections.synchronizedList(new LinkedList<NodeWatchInfo>());
    }

    /**
     * m[hĎZbg܂B
     *
     * @param info m[hĎ
     */
    public synchronized void pushQue(NodeWatchInfo info) {
        if (!isPause) {
            checkQueueSize(list, info.getIpaddress());
            list.add(list.size(), info);
        }
    }

    /**
     * L[m[hĎPop܂B
     *
     * @return m[hĎ
     */
    public synchronized NodeWatchInfo popQueue() {
        NodeWatchInfo info = null;

        if (list.size() > 0) {
            if (!isPause) {
                info = (NodeWatchInfo) list.get(0);
            }

            list.remove(0);
        }

        return info;
    }

    /**
     * SMTPĎCxgL[Ԃ܂B
     *
     * @return list SMTPĎCxgL[
     */
    public List getSmtpQueueList() {
        return list;
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static QueueForSmtp getInstance() {
        return SingletonAboutMessage.INSTANCE;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonAboutMessage {
        static final QueueForSmtp INSTANCE = new QueueForSmtp();
    }
}
