/*
 * Created on 2004/05/01
 *
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.server.protocol.control;

import java.util.logging.Logger;

import netjfwatcher.engine.nodewatchinfo.BaseNodeWatchInfoList;
import netjfwatcher.engine.nodewatchinfo.NodeWatchInfo;
import netjfwatcher.engine.server.protocol.pop.ExecutePopCheck;



/**
 * IɃL[`FbNAL[Ƀf[^Pop3Ďs
 * ThreadNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ThreadQueueCheckPop3 implements Runnable {
    /* Thread sleep */
    private static final int WAIT_SLEEP_TIME = 1000;

    /* MO */
    private static Logger logger = null;

    /**
     * Pop3ĎsThreadNXCX^X𐶐܂B
     *
     */
    public ThreadQueueCheckPop3() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * IɃL[`FbNAL[Ƀf[^Pop3Ď
     * s܂B
     */
    public void run() {
        ExecutePopCheck checkPop3 = new ExecutePopCheck();

        //IɃL[`FbN[v
        while (!Thread.interrupted()) {
            // L[Pop
            NodeWatchInfo info = QueueForPop3.getInstance().popQueue();
            NodeWatchInfo checkIPAddress = null;

            if (info != null) {
                checkIPAddress =
                    BaseNodeWatchInfoList.getInstance().getNodeWatchInfo(
                        info.getIpaddress());
            }

            // L[Ƀf[^URL `FbNs
            if ((info != null) && (checkIPAddress != null)) {
                if (
                    BusyCheckForPop3.getInstance().getArbitrationExec(
                            info.getIpaddress())) {
                    checkPop3.checkPop(info);
                    BusyCheckForPop3.getInstance().release(info.getIpaddress());
                } else {
                    logger.warning("Busy Pop3 IP = " + info.getIpaddress());
                }
            }

            try {
                Thread.sleep(WAIT_SLEEP_TIME);
            } catch (InterruptedException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }
}
