/*
 * Created on 2004/09/28
 *
 *
 *@Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.snmpmanager.process;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.SocketTimeoutException;
import java.security.GeneralSecurityException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Logger;

import netjfwatcher.engine.alarm.AlarmMessageMake;
import netjfwatcher.engine.alarm.AlarmMessageResource;
import netjfwatcher.engine.alarm.AlarmRecovery;
import netjfwatcher.engine.resource.SnmpV3ManagerConfig;
import netjfwatcher.engine.resource.SnmpV3ManagerConfigInfo;
import netjfwatcher.engine.resource.SnmpV3ManagerUserConfigInfo;
import netjfwatcher.snmp.messageformat.SNMPTLV;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.messageformat.SnmpConfigurationException;
import netjfwatcher.snmp.messageformat.SnmpErrorStatusException;
import netjfwatcher.snmp.messageformat.SnmpMIBGetException;
import netjfwatcher.snmp.messageformat.SnmpSetException;
import netjfwatcher.snmp.messageformat.SnmpUnmuchRequestIDException;
import netjfwatcher.snmp.messageformat.SnmpUnmuchRequestMsgIDException;
import netjfwatcher.snmp.messageformat.SnmpVarBindList;
import netjfwatcher.snmp.messageformat.SnmpVariablePair;
import netjfwatcher.snmp.preference.SnmpBERCodec;
import netjfwatcher.snmp.preference.SnmpPreference;
import netjfwatcher.snmp.preference.SnmpV3Preference;
import netjfwatcher.snmp.snmpobject.integer.SnmpInteger;
import netjfwatcher.snmp.snmpobject.message.AbstractSnmpObject;
import netjfwatcher.snmp.snmpobject.message.SnmpNull;
import netjfwatcher.snmp.snmpobject.message.SnmpObjectIdentifier;
import netjfwatcher.snmp.snmpobject.message.SnmpPDU;
import netjfwatcher.snmp.snmpobject.message.SnmpSequence;
import netjfwatcher.snmp.snmpobject.octetstring.SnmpOctetString;
import netjfwatcher.snmp.snmpv3.SnmpEngineID;
import netjfwatcher.snmp.snmpv3.SnmpV3AuthAbortException;
import netjfwatcher.snmp.snmpv3.SnmpV3ConfigurationException;
import netjfwatcher.snmp.snmpv3.SnmpV3DecryptAbortException;
import netjfwatcher.snmp.snmpv3.UsmSecuritySubsystem;
import netjfwatcher.snmp.snmpv3.UsmUserEntry;
import netjfwatcher.snmp.snmpv3.UsmUserManager;
import netjfwatcher.snmpmanager.SnmpManagerQueue;


/**
 *  SNMP}l[WɂSNMP V3̐ݒsNXłB
 *  SNMP V3bZ[Wt@[}bg͈ȉłB
 *
 * +-----------+-----------+----------------------------+
 * | Header    |           | msgVersion                 |
 * |           |           +----------------------------+
 * |           |           | msgID                      |
 * |           |           +----------------------------+
 * |           |           | msgMaxSize                 |
 * |           |           +----------------------------+
 * |           |           | msgFlags                   |
 * |           |           +----------------------------+
 * |           |           | msgSecurityModel           |
 * +-----------+-----------+----------------------------+
 * | Security  |           | msgAuthoritativeEngineID   |
 * | Params    |           +----------------------------+
 * |           |           | msgAuthoritativeBoots      |
 * |           |           +----------------------------+
 * |           |           | msgAuthoritativeEngineTime |
 * |           |           +----------------------------+
 * |           |           | msgUserName                |
 * |           |           +----------------------------+
 * |           |           | msgAuthenticationParameters|
 * |           |           +----------------------------+
 * |           |           | msgPrivacyParameters       |
 * +-----------+-----------+----------------------------+
 * | Scoped    |           | contextEngineID            |
 * | PDU Data  |           +----------------------------+
 * |           |           | contextName                |
 * |           |           +----------------------------+
 * |           |           | PDU Data                   |
 * +-----------+-----------+----------------------------+
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ManagerV3MP extends AbstractManagerMessageProcessingSubsystem {
    /* MO */
    private static Logger logger;

    //
    private boolean authFlag = false;

    //
    private boolean privFlag = false;

    /*  */
    private DateFormat simpleDateformat = new SimpleDateFormat("HH:mm:ss");

    /**
     *
     */
    public ManagerV3MP() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     *
     *
     * @param dSocket DatagramSocket
     * @param hostAddress AgnetAhX
     * @param community R~jeB
     * @throws SnmpConfigurationException SNMP\`񂪈ُȏꍇ
     * @throws SnmpV3ConfigurationException SNMP V3\`񂪈ُȏꍇ
     */
    public ManagerV3MP(
        DatagramSocket dSocket, InetAddress hostAddress, String community)
        throws SnmpConfigurationException, SnmpV3ConfigurationException {
        logger = Logger.getLogger(this.getClass().getName());

        /* SNMP Ver.3Zbg */
        this.version = SnmpPreference.SNMPV3;
        this.dSocket = dSocket;
        this.targetAddress = hostAddress;
        this.community = community;

        this.setConfig(dSocket, hostAddress);
    }

    /**
     * SNMP V3}l[Wł̃vpeBZbg܂B
     *
     * @param dSocket DatagramSocket
     * @param hostAddress AgnetAhX
     * @param community R~jeB
     * @throws SnmpConfigurationException SNMP\`񂪈ُȏꍇ
     * @throws SnmpV3ConfigurationException SNMP V3\`񂪈ُȏꍇ
     */
    public void setManagerMP(
        DatagramSocket dSocket, InetAddress hostAddress, String community)
        throws SnmpConfigurationException, SnmpV3ConfigurationException {
        /* SNMP Ver.3Zbg */
        this.version = SnmpPreference.SNMPV3;
        this.dSocket = dSocket;
        this.targetAddress = hostAddress;
        this.community = community;

        this.setConfig(dSocket, hostAddress);
    }

    /**
     * SNMP V3}l[ŴAGetRequestyGetnextRequestR}hN܂B
     *
     * @param code R}hR[h
     * @param requestOID OID
     * @throws SnmpUnmuchRequestIDException NGXgIDҒlƈvȂꍇ
     * @throws SnmpUnmuchRequestMsgIDException msgIDҒlƈvȂꍇ
     * @throws GeneralSecurityException ZLeB֘Aňُ킪ꍇ
     * @throws SnmpErrorStatusException G[Xe[^XłȂꍇ
     * @throws SnmpBadValueException f[^܂͉͂ňُ킪ꍇ
     * @throws SnmpV3DecryptAbortException f[^ňُ킪ꍇ
     * @throws SnmpV3AuthAbortException F؂ňُ킪ꍇ
     * @throws SnmpMIBGetException MIB̎ňُ킪ꍇ
     * @throws SnmpSetException Set Requestňُ킪ꍇ
     * @throws SnmpV3ConfigurationException SNMP V3\ňُ킪ꍇ
     * @throws IOException f[^Mňُ킪ꍇ
     * @return SnmpVarBindList Agent SNMP VarBindList
     */
    public SnmpVarBindList getProcess(byte code, String requestOID)
        throws SnmpUnmuchRequestIDException, SnmpUnmuchRequestMsgIDException, 
            GeneralSecurityException, SnmpErrorStatusException, 
            SnmpBadValueException, SnmpV3DecryptAbortException, 
            SnmpV3AuthAbortException, SnmpMIBGetException, SnmpSetException, 
            SnmpV3ConfigurationException, IOException {
        /*  */
        SnmpVarBindList returnVarBindList = null;

        try {
            this.learnedSnmpV3Agent();
        } catch (GeneralSecurityException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
            throw e;
        }

        switch (code) {
        case SnmpBERCodec.SNMPGETREQUEST:
            returnVarBindList = getMIBEntry(requestOID);

            break;

        case SnmpBERCodec.SNMPGETNEXTREQUEST:
            returnVarBindList = getNextMIBEntry(requestOID);

            break;

        default:
            logger.warning("Unknown code : " + hexByte(code));
        }

        return returnVarBindList;
    }

    /**
     * SNMP V3}l[ŴASetRequestR}hN܂B
     *
     * @param code R}hR[h
     * @param requestOID OID
     * @param newValue SNMPIuWFNg
     * @throws SnmpUnmuchRequestIDException NGXgIDҒlƈvȂꍇ
     * @throws SnmpUnmuchRequestMsgIDException msgIDҒlƈvȂꍇ
     * @throws GeneralSecurityException ZLeB֘Aňُ킪ꍇ
     * @throws SnmpV3DecryptAbortException f[^ňُ킪ꍇ
     * @throws SnmpErrorStatusException G[Xe[^XłȂꍇ
     * @throws SnmpMIBGetException MIB̎ňُ킪ꍇ
     * @throws SnmpV3AuthAbortException F؂ňُ킪ꍇ
     * @throws SnmpSetException SetNGXgsꍇ
     * @throws SnmpV3ConfigurationException SNMP V3\ňُ킪ꍇ
     * @throws SnmpBadValueException f[^܂͉͂ňُ킪ꍇ
     * @throws IOException f[^Msꍇ
     * @return Agent SNMP varBind List
     */
    public SnmpVarBindList setProcess(
        byte code, String requestOID, AbstractSnmpObject newValue)
        throws SnmpUnmuchRequestIDException, SnmpUnmuchRequestMsgIDException, 
            GeneralSecurityException, SnmpV3DecryptAbortException, 
            SnmpErrorStatusException, SnmpMIBGetException, 
            SnmpV3AuthAbortException, SnmpSetException, 
            SnmpV3ConfigurationException, SnmpBadValueException, IOException {
        SnmpVarBindList returnVarBindList = null;

        try {
            this.learnedSnmpV3Agent();
        } catch (GeneralSecurityException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
            throw e;
        }

        switch (code) {
        case SnmpBERCodec.SNMPSETREQUEST:
            returnVarBindList = setMIBEntry(requestOID, newValue);

            break;

        default:
            logger.warning("Undefined command code : " + hexByte(code));
        }

        return returnVarBindList;
    }

    /**
     * SnmpV3}l[W̃R}hɂāAOɃ^[QbgSnmpV3G[WFg
     * fBXJo[s܂B
     * fBXJo[ƂĈȉ̏oAG[WFg\Ƃĕێ܂B
     * EsnmpEngineID
     * EsnmpBoots
     * EsnmpEngineTime
     *
     * @throws SnmpUnmuchRequestIDException NGXgIDҒlƈvȂꍇ
     * @throws SnmpUnmuchRequestMsgIDException msgIDҒlƈvȂꍇ
     * @throws GeneralSecurityException ZLeB֘Aňُ킪ꍇ
     * @throws SnmpErrorStatusException G[Xe[^XłȂꍇ
     * @throws SnmpBadValueException f[^܂͉͂ňُ킪ꍇ
     * @throws SnmpV3DecryptAbortException f[^ňُ킪ꍇ
     * @throws SnmpV3AuthAbortException F؂ňُ킪ꍇ
     * @throws SnmpV3ConfigurationException G[WFgAddress
     * ΉG[WFg񂪌Ȃꍇ
     * @throws IOException f[^Mňُ킪ꍇ
     */
    private void learnedSnmpV3Agent()
        throws SnmpUnmuchRequestIDException, SnmpUnmuchRequestMsgIDException, 
            GeneralSecurityException, SnmpErrorStatusException, 
            SnmpBadValueException, SnmpV3DecryptAbortException, 
            SnmpV3AuthAbortException, SnmpV3ConfigurationException, IOException {
        ManagerV3MessageInfo receiveMessageInfo = null;
        int engineBoots = 0;
        long engineTime = 0;
        long agentStartTime = 0;
        Date agentDate = null;

        if (snmpV3ManagerConfInfo == null) {
            throw new SnmpV3ConfigurationException(
                "Not Found SNMPV3 Config IP=" + targetAddress.toString());
        }

        /* G[WFgDiscoverys`FbN */
        if (!snmpV3ManagerConfInfo.isLearned()) {
            /*
             * G[WFgsnmpv3ƂĂ̈ȉ𖢊wK̏ꍇɂ́ADiscoveryV[PX
             * ƂăG[WFgWB
             *
             * (1)snmpEngineID
             * (2)snmpEngineBootsysnmpEngineTime
             */
            logger.info(
                "Learned TargetIP=" + targetAddress.toString() + " EngineID="
                + snmpV3ManagerConfInfo.getSnmpEngineID());

            ManagerV3MPDiscoveryAgent managerDiscoveryAgent =
                new ManagerV3MPDiscoveryAgent(
                    dSocket, targetAddress, community);

            try {
                receiveMessageInfo = managerDiscoveryAgent.discoveryAgent();
            } catch (GeneralSecurityException e) {
                logger.warning(e.getMessage());
                throw e;
            } catch (SnmpBadValueException e) {
                logger.warning(e.getMessage());
                throw e;
            } catch (IOException e) {
                logger.warning(e.getMessage());
                throw e;
            }

            if (receiveMessageInfo != null) {
                /* Learned snmpEngineBoots, snmpEngineTime */

                // EngineBootsZbg
                engineBoots = receiveMessageInfo.getMsgAuthoritativeBoots();
                snmpV3ManagerConfInfo.setSnmpEngineBoots(
                    Integer.toString(engineBoots));

                // EngineTimeZbg
                engineTime = receiveMessageInfo.getMsgAuthoritativeEngineTime();
                agentStartTime =
                    System.currentTimeMillis() - (engineTime * 1000);
                snmpV3ManagerConfInfo.setSnmpEngineTime(
                    Long.toString(agentStartTime));

                /* Agent DiscoveryiwKς݁jZbg */
                snmpV3ManagerConfInfo.setLearned(true);

                agentDate = Calendar.getInstance().getTime();
                agentDate.setTime(agentStartTime);
                logger.info("Agent EngineTime : " + engineTime);
                logger.info("Agent Start date : " + agentDate.toString());

                /*
                 * Snmp V3 AgentXgEngineID,BootsySysupTime
                 * ȂǂAgentZbg
                 */
                SnmpV3ManagerConfig.getInstance().getResourceFileParse()
                                   .updateSnmpV3ManagerConfigInfo(
                    targetAddress.getHostAddress(), snmpV3ManagerConfInfo);

                HashMap snmpV3ConfigEngineIDList =
                    SnmpV3ManagerConfig.getInstance().getResourceFileParse()
                                       .getSnmpV3ConfigEngineIDMapList();
                snmpV3ConfigEngineIDList.put(
                    snmpV3ManagerConfInfo.getSnmpEngineID(),
                    snmpV3ManagerConfInfo);
            }
        } else {
            /* G[WFgDiscoveryłȂʏ̃R}h */
            logger.info(
                "Already Learned TargetIP=" + targetAddress.toString()
                + " EngineID=" + snmpV3ManagerConfInfo.getSnmpEngineID());
        }
    }

    /**
     * wOIDMIB̎悵varBindListƂĕԂ܂B
     *
     * @param requestOID OID
     * @return SnmpVarBindList
    * @throws SnmpUnmuchRequestIDException NGXgIDҒlƈvȂꍇ
    * @throws SnmpUnmuchRequestMsgIDException msgIDҒlƈvȂꍇ
    * @throws GeneralSecurityException ZLeB֘Aňُ킪ꍇ
    * @throws SnmpErrorStatusException G[Xe[^XłȂꍇ
    * @throws SnmpBadValueException f[^܂͉͂ňُ킪ꍇ
    * @throws SnmpSetException SetNGXgňُ킪ꍇ
    * @throws SnmpMIBGetException MIB̎ňُ킪ꍇ
    * @throws SnmpV3DecryptAbortException f[^ňُ킪ꍇ
    * @throws SnmpV3AuthAbortException F؂ňُ킪ꍇ
    * @throws SnmpV3ConfigurationException SNMP V3\`ňُ킪ꍇ
    * @throws IOException f[^Mňُ킪ꍇ
     */
    public SnmpVarBindList getMIBEntry(String requestOID)
        throws SnmpUnmuchRequestIDException, SnmpUnmuchRequestMsgIDException, 
            GeneralSecurityException, SnmpBadValueException, 
            SnmpMIBGetException, SnmpV3DecryptAbortException, 
            SnmpV3AuthAbortException, SnmpV3ConfigurationException, 
            SnmpErrorStatusException, IOException {
        // f[^i[varBindList
        SnmpVarBindList retrievedVars = null;

        // Mf[^i[SNMPV[PX
        SnmpSequence sequenceData = null;

        int requestID =
            SnmpRequestIDManager.getInstance().getRequestID(
                Thread.currentThread().getName(), requestOID);
        int msgID =
            SnmpV3MsgIDManager.getInstance().getMsgID(
                Thread.currentThread().getName(), requestOID);

        try {
            // SNMP GetNextRequestbZ[W쐬
            sequenceData =
                this.createSNMPV3Message(
                    msgID, snmpV3ManagerConfInfo, snmpV3UserName, requestID,
                    requestOID, SnmpBERCodec.SNMPGETNEXTREQUEST, new SnmpNull());
        } catch (SnmpV3ConfigurationException e2) {
            e2.printStackTrace();
            throw new SnmpV3DecryptAbortException(e2.getMessage());
        }

        retrievedVars = sendData(requestID, msgID, requestOID, sequenceData);

        return retrievedVars;
    }

    /**
     * GetNextR}hMbZ[W쐬EMAf[^͂ĕԂ܂B
     *
     * @param requestOID OID
     * @return SnmpVarBindList
    * @throws SnmpUnmuchRequestIDException NGXgIDҒlƈvȂꍇ
    * @throws SnmpUnmuchRequestMsgIDException msgIDҒlƈvȂꍇ
    * @throws GeneralSecurityException ZLeB֘Aňُ킪ꍇ
    * @throws SnmpErrorStatusException G[Xe[^XłȂꍇ
    * @throws SnmpBadValueException f[^܂͉͂ňُ킪ꍇ
    * @throws SnmpMIBGetException MIB̎ňُ킪ꍇ
    * @throws SnmpV3DecryptAbortException f[^ňُ킪ꍇ
    * @throws SnmpV3AuthAbortException F؂ňُ킪ꍇ
    * @throws SnmpV3ConfigurationException SNMP V3\`ňُ킪ꍇ
    * @throws IOException f[^Mňُ킪ꍇ
     */
    public SnmpVarBindList getNextMIBEntry(String requestOID)
        throws SnmpUnmuchRequestIDException, SnmpUnmuchRequestMsgIDException, 
            GeneralSecurityException, SnmpV3DecryptAbortException, 
            SnmpV3AuthAbortException, SnmpErrorStatusException, 
            SnmpMIBGetException, SnmpBadValueException, 
            SnmpV3ConfigurationException, IOException {
        // f[^i[verBind
        SnmpVarBindList retrievedVars = null;

        // Mf[^i[SNMPV[PX
        SnmpSequence sequenceData = null;

        int requestID =
            SnmpRequestIDManager.getInstance().getRequestID(
                Thread.currentThread().getName(), requestOID);
        int msgID =
            SnmpV3MsgIDManager.getInstance().getMsgID(
                Thread.currentThread().getName(), requestOID);

        try {
            // SNMP GetNextRequestbZ[W쐬
            sequenceData =
                this.createSNMPV3Message(
                    msgID, snmpV3ManagerConfInfo, snmpV3UserName, requestID,
                    requestOID, SnmpBERCodec.SNMPGETNEXTREQUEST, new SnmpNull());

            retrievedVars =
                sendData(requestID, msgID, requestOID, sequenceData);
        } catch (SnmpV3ConfigurationException e) {
            throw e;
        }

        return retrievedVars;
    }

    /**
     * SetR}hMbZ[W쐬EMAf[^͂ĕԂ܂B
     *
     * @param requestOID OID
     * @param newValue SNMPIuWFNg Value
     * @return SnmpVarBindList
    * @throws SnmpUnmuchRequestIDException NGXgIDҒlƈvȂꍇ
    * @throws SnmpUnmuchRequestMsgIDException msgIDҒlƈvȂꍇ
    * @throws GeneralSecurityException ZLeB֘Aňُ킪ꍇ
    * @throws SnmpErrorStatusException G[Xe[^XłȂꍇ
    * @throws SnmpBadValueException f[^܂͉͂ňُ킪ꍇ
    * @throws SnmpSetException SetNGXgňُ킪ꍇ
    * @throws SnmpMIBGetException MIB̎ňُ킪ꍇ
    * @throws SnmpV3DecryptAbortException f[^ňُ킪ꍇ
    * @throws SnmpV3AuthAbortException F؂ňُ킪ꍇ
    * @throws SnmpV3ConfigurationException SNMP V3\`ňُ킪ꍇ
    * @throws IOException f[^Mňُ킪ꍇ
    */
    public SnmpVarBindList setMIBEntry(
        String requestOID, AbstractSnmpObject newValue)
        throws SnmpUnmuchRequestIDException, SnmpUnmuchRequestMsgIDException, 
            GeneralSecurityException, SnmpErrorStatusException, 
            SnmpBadValueException, SnmpSetException, SnmpMIBGetException, 
            SnmpV3DecryptAbortException, SnmpV3AuthAbortException, 
            SnmpV3ConfigurationException, IOException {
        /*  */
        SnmpVarBindList retrievedVars = null;

        /*  */
        SnmpSequence sequenceData = null;

        int requestID =
            SnmpRequestIDManager.getInstance().getRequestID(
                Thread.currentThread().getName(), requestOID);
        int msgID =
            SnmpV3MsgIDManager.getInstance().getMsgID(
                Thread.currentThread().getName(), requestOID);

        try {
            // MbZ[W쐬
            sequenceData =
                this.createSNMPV3Message(
                    msgID, snmpV3ManagerConfInfo, snmpV3UserName, requestID,
                    requestOID, SnmpBERCodec.SNMPSETREQUEST, newValue);
        } catch (SnmpV3ConfigurationException e2) {
            logger.warning(e2.getMessage());
            e2.printStackTrace();
            throw e2;
        }

        retrievedVars = sendData(requestID, msgID, requestOID, sequenceData);

        return retrievedVars;
    }

    /**
     * SNMP V3 NGXg(Get/Get Next/SetRequest)f[^𑗐MA
     * f[^`FbN܂B
     *
     * @param requestID NGXgID
     * @param msgID msgID
     * @param requestOID OID
     * @param sequenceData SNMP SequenceIuWFNg
     * @return SnmpVarBindList
     * @throws SnmpUnmuchRequestIDException NGXgIDҒlƈvȂꍇ
     * @throws SnmpUnmuchRequestMsgIDException msgIDҒlƈvȂꍇ
     * @throws GeneralSecurityException ZLeB֘Aňُ킪ꍇ
     * @throws SNMPBadValueException f[^܂͉͂ňُ킪ꍇ
     * @throws SnmpV3DecryptAbortException f[^ňُ킪ꍇ
     * @throws SnmpV3AuthAbortException F؂ňُ킪ꍇ
     * @throws SnmpErrorStatusException G[Xe[^XłȂꍇ
     * @throws NoRouteToHostException NoRouteToHostꍇ
     * @throws SocketTimeoutException Socket^CAEgꍇ
     * @throws IOException Msꍇ
     */
    private SnmpVarBindList sendData(
        int requestID, int msgID, String requestOID, SnmpSequence sequenceData)
        throws SnmpUnmuchRequestIDException, SnmpUnmuchRequestMsgIDException, 
            GeneralSecurityException, SnmpBadValueException, 
            SnmpV3DecryptAbortException, SnmpV3AuthAbortException, 
            SnmpErrorStatusException, NoRouteToHostException, 
            SocketTimeoutException, IOException {
        SnmpVarBindList retrievedVars = null;
        DatagramPacket inPacket = null;

        try {
            byte[] sendByteData = sequenceData.getBEREncoding();
            dSocket.connect(targetAddress, snmpPort);

            while (true) {
                // bZ[WM
                try {
                    /* MPacket */
                    inPacket = new DatagramPacket(new byte[MAXSIZE], MAXSIZE);

                    this.sendByteDataToAgent(sendByteData, requestOID, dSocket);

                    // f[^M
                    dSocket.receive(inPacket);

                    int socketTimeout = dSocket.getSoTimeout();

                    if (
                        AlarmRecovery.getInstance().isOccurredAlarmId(
                                targetAddress.getHostAddress(),
                                AlarmMessageResource.SNMP_GET_TIMEOUT)) {
                        /* SNMP^CAEgZbg */
                        AlarmMessageMake message =
                            AlarmMessageMake.getInstance();
                        message.setRecoverySNMPTimeout(
                            targetAddress.getHostAddress(), requestOID,
                            socketTimeout);
                    }

                    if (
                        AlarmRecovery.getInstance().isOccurredAlarmId(
                                targetAddress.getHostAddress(),
                                AlarmMessageResource.SNMP_NO_ROUTE_TOHOST)) {
                        /* No Route toHostZbg */
                        AlarmMessageMake message =
                            AlarmMessageMake.getInstance();
                        message.setRecoverySNMPNoRouteToHost(
                            targetAddress.getHostAddress(), requestOID);
                    }

                    if (
                        AlarmRecovery.getInstance().isOccurredAlarmId(
                                targetAddress.getHostAddress(),
                                AlarmMessageResource.SNMP_IOEXCEPTION)) {
                        /* IOExceptionZbg */
                        AlarmMessageMake message =
                            AlarmMessageMake.getInstance();
                        message.setRecoverySNMPIOException(
                            targetAddress.getHostAddress(), requestOID);
                    }

                    /*
                     * Mf[^
                     */
                    byte[] receiveDataByte = inPacket.getData();
                    logger.finer(
                        "Receive data : "
                        + hexBytetoString(
                            receiveDataByte, inPacket.getLength()));

                    /*
                     * Mf[^̓j^[\Zbg
                     */
                    Date date = Calendar.getInstance().getTime();
                    SnmpManagerQueue.getInstance().pushSnmpManagerQueue(
                        "Receive data : " + simpleDateformat.format(date)
                        + " : ");
                    SnmpManagerQueue.getInstance().pushSnmpManagerQueue(
                        hexBytetoString(receiveDataByte, inPacket.getLength()));

                    ManagerV3MessageInfo receiveMessageInfo =
                        this.parseSnmpV3ReceiveData(
                            receiveDataByte, requestID, msgID, requestOID);

                    retrievedVars = receiveMessageInfo.getRetrievedVars();

                    break;
                } catch (SnmpUnmuchRequestIDException e1) {
                    retryCounter--;
                    logger.info(
                        "SnmpUnmuchRequestIDException Retry : " + retryCounter);

                    if (retryCounter <= 0) {
                        AlarmMessageMake message =
                            AlarmMessageMake.getInstance();

                        message.setErrorSNMPUnmuchRequestID(
                            targetAddress.getHostAddress(), e1.getMessage());

                        throw e1;
                    }

                    try {
                        Thread.sleep(
                            AbstractManagerMessageProcessingSubsystem.UNMUCH_REQUEST_ID_RETRY_WAIT_TIME);
                    } catch (InterruptedException e) {
                        logger.warning(e.getMessage());
                        e.printStackTrace();
                    }
                } catch (NoRouteToHostException e1) {
                    /*
                    * SNMP TimeoutꍇɃA[
                    * bZ[WA[L[Put
                    */
                    AlarmMessageMake message = AlarmMessageMake.getInstance();
                    message.setErrorSNMPNoRouteToHost(
                        targetAddress.getHostAddress(), requestOID);
                    logger.warning(
                        "GetNext Request send data : " + e1.getMessage());
                    e1.printStackTrace();
                    throw e1;
                } catch (SocketTimeoutException e) {
                    SnmpStatisticsManager.getInstance().addSnmpSocketTimeout(
                        targetAddress.getHostAddress());

                    if (retryCounter <= 0) {
                        /*
                         * SNMP TimeoutꍇɃA[
                         * bZ[WA[L[Put
                         */
                        int socketTimeout = dSocket.getSoTimeout();
                        AlarmMessageMake message =
                            AlarmMessageMake.getInstance();
                        message.setErrorSNMPTimeout(
                            targetAddress.getHostAddress(), requestOID,
                            socketTimeout);

                        logger.warning(
                            e.getMessage() + " : "
                            + targetAddress.getHostAddress() + " : "
                            + requestOID);

                        throw new SocketTimeoutException(
                            "Target IP=" + targetAddress.getHostAddress()
                            + " OID=" + requestOID + " : " + e.getMessage());
                    }

                    logger.warning("Socket timeout retry=" + retryCounter);
                } catch (IOException e) {
                    AlarmMessageMake message = AlarmMessageMake.getInstance();
                    message.setErrorSNMPIOException(
                        targetAddress.getHostAddress(), requestOID,
                        e.getMessage());
                    logger.warning(
                        e.getMessage() + " : " + targetAddress.getHostAddress()
                        + " : " + requestOID);

                    throw new IOException(
                        "Target IP=" + targetAddress.getHostAddress() + " OID="
                        + requestOID + " : " + e.getMessage());
                }

                retryCounter--;
            }
        } finally {
            dSocket.disconnect();
        }

        return retrievedVars;
    }

    /**
     * SnmpV3G[WFg̉f[^͂āAsnmpV3vpeBƂĕԂ܂B
     *
     * ͂ɂauthPrivɏ]Ĉȉ̃`FbNs܂B
     * EF؂̃`FbN
     * EÍ̕
     *
     * @param receiveData MoCgf[^
     * @param requestID NGXgID
     * @param requestMsgID msgID
     * @param requestOID OID
     * @return ManagerV3MessageInfo
     * @throws SnmpUnmuchRequestIDException NGXgIDҒlƃA}b`ȏꍇ
     * @throws SnmpUnmuchRequestMsgIDException msgIDҒlƃA}b`ȏꍇ
     * @throws GeneralSecurityException ZLeB֘Aňُ킪ꍇ
     * @throws SnmpErrorStatusException G[Xe[^XłȂꍇ
     * @throws SnmpBadValueException f[^͂ňُ킪ꍇ
     * @throws SnmpV3DecryptAbortException f[^ňُ킪ꍇ
     * @throws SnmpV3AuthAbortException F؂ňُ킪ꍇ
     */
    public ManagerV3MessageInfo parseSnmpV3ReceiveData(
        byte[] receiveData, int requestID, int requestMsgID, String requestOID)
        throws SnmpUnmuchRequestIDException, SnmpUnmuchRequestMsgIDException, 
            GeneralSecurityException, SnmpErrorStatusException, 
            SnmpBadValueException, SnmpV3DecryptAbortException, 
            SnmpV3AuthAbortException {
        //
        ManagerV3MessageInfo receiveMessageInfo = new ManagerV3MessageInfo();

        SnmpV3ManagerConfigInfo snmpV3ConfigInformation = null;
        SnmpV3ManagerUserConfigInfo userConfigInfo = null;
        AbstractSnmpObject msgVersion = null;
        AbstractSnmpObject msgID = null;
        AbstractSnmpObject msgMaxSize = null;
        AbstractSnmpObject msgFlags = null;
        int receiveMsgFlags = 0;
        AbstractSnmpObject msgSecurityModel = null;
        AbstractSnmpObject msgAuthoritativeEngineID = null;
        AbstractSnmpObject msgAuthoritativeBoots = null;
        AbstractSnmpObject msgAuthoritativeEngineTime = null;
        AbstractSnmpObject msgUserName = null;

        SnmpSequence request = new SnmpSequence();
        SNMPTLV nextTLV = request.extractNextTLV(receiveData, 0);

        // pPbg̃fR[h
        try {
            request.setTLV(nextTLV);
        } catch (SnmpBadValueException e) {
            logger.warning("Snmp V3 receive data parse : " + e.getMessage());
            e.printStackTrace();
            throw e;
        }

        // SNMP ̃o[W
        msgVersion =
            request.getSNMPObjectAt(
                SnmpV3Preference.POS_MSG_VERSION_OF_MESSAGE);

        if (!(msgVersion instanceof SnmpInteger)) {
            logger.warning("Version is not INTEGER : " + msgVersion);
            throw new SnmpBadValueException(
                "Version is not INTEGER : " + msgVersion);
        }

        /* SNMP V3 Header */
        SnmpSequence header =
            (SnmpSequence) request.getSNMPObjectAt(
                SnmpV3Preference.POS_HEADER_OF_MESSAGE);
        msgID = header.getSNMPObjectAt(SnmpV3Preference.HEADER_MSG_ID);
        msgMaxSize =
            header.getSNMPObjectAt(SnmpV3Preference.HEADER_MSG_MAXSIZE);
        msgFlags = header.getSNMPObjectAt(SnmpV3Preference.HEADER_MSG_FLAGS);
        msgSecurityModel =
            header.getSNMPObjectAt(SnmpV3Preference.HEADER_MSG_SEC_MODEL);

        /* SNMP V3 msgID`FbN */
        if (requestMsgID != Integer.parseInt(msgID.getValue().toString())) {
            SnmpV3MsgID requestIDIns =
                SnmpV3MsgIDManager.getInstance().getMsgIDInstance(
                    Integer.toString(requestMsgID));
            SnmpV3MsgID receiveIDIns =
                SnmpV3MsgIDManager.getInstance().getMsgIDInstance(
                    msgID.getValue().toString());

            String requestMsg =
                " Request Thread Name=" + requestIDIns.getThreadName() + "("
                + Thread.currentThread().getName() + ")" + " OID="
                + requestIDIns.getOid();
            String receiveMsg =
                " Receive Thread Name=" + receiveIDIns.getThreadName()
                + " OID=" + receiveIDIns.getOid();

            /*  */
            AlarmMessageMake message = AlarmMessageMake.getInstance();
            message.setErrorSNMPV3UnmuchRequestMsgID(
                targetAddress.getHostAddress(), requestMsgID,
                msgID.getValue().toString(),
                " Get OID=" + requestOID + requestMsg + receiveMsg);

            /* vJEg */
            SnmpStatisticsManager.getInstance().addSnmpV3UnmuchMsgID(
                targetAddress.getHostAddress());
            logger.warning(
                "Unmuch msgID, requestMsgID=" + requestMsgID
                + " receive msgID=" + msgID.getValue());
            throw new SnmpUnmuchRequestMsgIDException(
                "Unmuch msgID, requestMsgID=" + requestMsgID
                + " receive msgID=" + msgID.getValue());
        }

        try {
            receiveMsgFlags = Integer.parseInt(msgFlags.toString());
        } catch (NumberFormatException e3) {
            logger.warning("Illegal msgFlags : " + receiveMsgFlags);
        }

        /* Security Params */
        SnmpOctetString securityParaOctet =
            (SnmpOctetString) request.getSNMPObjectAt(
                SnmpV3Preference.POS_SECURITY_PARA_MESSAGE);

        SnmpSequence securityPara = null;

        try {
            securityPara =
                new SnmpSequence((byte[]) securityParaOctet.getValue());
        } catch (SnmpBadValueException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
            throw e1;
        }

        /*
         * securityParasSequence
         */
        SnmpSequence securityParasSequence =
            (SnmpSequence) securityPara.getSNMPObjectAt(0);

        msgAuthoritativeEngineID =
            securityParasSequence.getSNMPObjectAt(
                SnmpV3Preference.SECURITY_PARAMS_MSG_AUTH_ENGINEID);
        msgAuthoritativeBoots =
            securityParasSequence.getSNMPObjectAt(
                SnmpV3Preference.SECURITY_PARAMS_MSG_AUTH_ENGINEBOOTS);
        msgAuthoritativeEngineTime =
            securityParasSequence.getSNMPObjectAt(
                SnmpV3Preference.SECURITY_PARAMS_MSG_AUTH_ENGINETIME);
        msgUserName =
            securityParasSequence.getSNMPObjectAt(
                SnmpV3Preference.SECURITY_PARAMS_MSG_USERNAME);

        logger.info("Receive version : " + msgVersion.getValue());
        logger.info("Receive msgID : " + msgID.getValue());
        logger.info("Receive msgMaxSize : " + msgMaxSize.getValue());
        logger.info("Receive msgFlags : " + msgFlags);
        logger.info(
            "Receive msgSecurityModel : " + msgSecurityModel.getValue());
        logger.info(
            "Receive msgAuthoritativeEngineID : " + msgAuthoritativeEngineID);
        logger.info(
            "Receive msgAuthoritativeBoots : "
            + msgAuthoritativeBoots.getValue());
        logger.info(
            "Receive msgAuthoritativeEngineTime : "
            + msgAuthoritativeEngineTime.getValue());
        logger.info("Receive msgUserName : " + msgUserName);

        SnmpManagerQueue.getInstance().pushSnmpManagerQueue(
            "Receive version : " + msgVersion.getValue());
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue(
            "Receive msgID : " + msgID.getValue());
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue(
            "Receive msgMaxSize : " + msgMaxSize.getValue());
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue(
            "Receive msgFlags : " + msgFlags);
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue(
            "Receive msgSecurityModel : " + msgSecurityModel.getValue());
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue(
            "Receive msgAuthoritativeEngineID : " + msgAuthoritativeEngineID);
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue(
            "Receive msgAuthoritativeBoots : "
            + msgAuthoritativeBoots.getValue());
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue(
            "Receive msgAuthoritativeEngineTime : "
            + msgAuthoritativeEngineTime.getValue());
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue(
            "Receive msgUserName : " + msgUserName);

        AbstractSnmpObject msgAuthenticationParameters =
            securityParasSequence.getSNMPObjectAt(
                SnmpV3Preference.SECURITY_PARAMS_MSG_AUTH_PARAMS);

        AbstractSnmpObject msgPrivacyParameters =
            securityParasSequence.getSNMPObjectAt(
                SnmpV3Preference.SECURITY_PARAMS_MSG_PRIV_PARAMS);

        /*
         *
         */
        UsmUserEntry usmUserEntry = null;

        snmpV3ConfigInformation =
            SnmpV3ManagerConfig.getInstance().getResourceFileParse()
                               .getSnmpV3AgentInfo(
                targetAddress.getHostAddress());

        /*
         * Agent Dicoveryς݂̃`FbN
         */
        if (snmpV3ConfigInformation.isLearned()) {
            /*
             * Agent Discoveryς݂̏ꍇɂ͎Mf[^ȉ
             * `FbN
            * (1) snmpEngineIDo^Ă̂ƍv邩̃`FbN
            * (2) F/Íx̃`FbN
            *
            */
            HashMap snmpV3EngineIDList =
                SnmpV3ManagerConfig.getInstance().getResourceFileParse()
                                   .getSnmpV3ConfigEngineIDMapList();

            // MsnmpEngineID"0x"č\
            String checkSnmpEngineID =
                msgAuthoritativeEngineID.toString().substring(2);

            if (snmpV3EngineIDList.size() > 0) {
                snmpV3ConfigInformation =
                    (SnmpV3ManagerConfigInfo) snmpV3EngineIDList.get(
                        checkSnmpEngineID);
            }

            userConfigInfo = ((SnmpV3ManagerUserConfigInfo) snmpV3ConfigInformation.getUserList()
                                                                                   .get(
                    0));

            if (snmpV3ConfigInformation != null) {
                logger.info(
                    "EngineID much config Agent IP Address = "
                    + snmpV3ConfigInformation.getIpAddress());
                logger.info(
                    "EngineID much config User Name = "
                    + userConfigInfo.getUsername());
            } else {
                // MsnmpEngineIDo^񂩂猩Ȃ
                SnmpManagerQueue.getInstance().pushSnmpManagerQueue(
                    "Not found engineID = " + checkSnmpEngineID);
                throw new SnmpV3AuthAbortException(
                    "Not found engineID = " + checkSnmpEngineID);
            }

            // userNameo^ς݂
            String userName = userConfigInfo.getUsername();

            if (!(userName.equals(msgUserName.toString()))) {
                logger.warning(
                    "Unmuch userName at receive data=" + msgUserName
                    + " config userName=" + userName);
                SnmpManagerQueue.getInstance().pushSnmpManagerQueue(
                    "Unmuch userName at receive data=" + msgUserName
                    + " config userName=" + userName);
                throw new SnmpV3AuthAbortException(
                    "Unmuch userName=" + msgUserName);
            }

            usmUserEntry =
                UsmUserManager.getInstance().getUsmUserEntry(
                    new SnmpEngineID(checkSnmpEngineID), userName);

            if (usmUserEntry == null) {
                logger.warning(
                    "Not found USMUser Entry at " + "snmpEngineID : "
                    + checkSnmpEngineID + " and " + "userName : " + userName);
                SnmpManagerQueue.getInstance().pushSnmpManagerQueue(
                    "Not found USMUser Entry at " + "snmpEngineID : "
                    + checkSnmpEngineID + " and " + "userName : " + userName);
                throw new SnmpV3AuthAbortException(
                    "Not found USMUser Entry at " + "snmpEngineID : "
                    + checkSnmpEngineID + " and " + "userName : " + userName);
            }

            // NOAUTH/AUTH/PRIV
            String authPriv = userConfigInfo.getAuthPriv();

            if (authPriv.equals(SnmpV3Preference.NOAUTH)) {
                if (
                    (receiveMsgFlags
                        & (SnmpV3Preference.SNMPV3_MSG_FLAGS_AUTH
                        | SnmpV3Preference.SNMPV3_MSG_FLAGS_PRIV)) != 0x00) {
                    logger.warning("Unmuch msgFlags : " + receiveMsgFlags);
                }
            } else if (authPriv.equals(SnmpV3Preference.AUTH)) {
                if (
                    (receiveMsgFlags & SnmpV3Preference.SNMPV3_MSG_FLAGS_AUTH) != SnmpV3Preference.SNMPV3_MSG_FLAGS_AUTH) {
                    logger.warning("Unmuch msgFlags : " + receiveMsgFlags);
                }
            } else if (authPriv.equals(SnmpV3Preference.PRIV)) {
                if (
                    (receiveMsgFlags & SnmpV3Preference.SNMPV3_MSG_FLAGS_PRIV) != SnmpV3Preference.SNMPV3_MSG_FLAGS_PRIV) {
                    logger.warning("Unmuch msgFlags : " + receiveMsgFlags);
                }
            }
        } else {
            /*
             * Agent Discovery(EngineID Discovery܂́A
             * Discovery engineBoots and time)̏ꍇ
             * UsmUserEntrýAEngineID Discovery̏ꍇ́A
             * UsmUserEntry͎擾łȂADiscovery engineBoots
             * and timȅꍇɂUsmUserEntry擾
             */
            String checkSnmpEngineID =
                msgAuthoritativeEngineID.toString().substring(2);
            logger.info(
                "usmUserEntry1 : SnmpEngineID : " + checkSnmpEngineID
                + " userName :" + msgUserName.toString());

            usmUserEntry =
                UsmUserManager.getInstance().getUsmUserEntry(
                    new SnmpEngineID(checkSnmpEngineID), msgUserName.toString());
        }

        // F؃`FbN
        boolean isCheckAuth = false;

        /*
         * USM msgFlagF؂
         */
        if (
            (receiveMsgFlags & SnmpV3Preference.SNMPV3_MSG_FLAGS_AUTH) == SnmpV3Preference.SNMPV3_MSG_FLAGS_AUTH) {
            /*
             * F؃`FbN
             */
            try {
                isCheckAuth =
                    UsmSecuritySubsystem.getInstance().checkAuth(
                        request, securityParasSequence,
                        usmUserEntry.getUsmUserAuthKey());
            } catch (GeneralSecurityException e4) {
                /* F؃G[ */
                logger.warning(e4.getMessage());
                logger.warning(
                    "Auth error Target IP=" + targetAddress.getHostAddress()
                    + " OID=" + requestOID);
                SnmpManagerQueue.getInstance().pushSnmpManagerQueue(
                    "Auth error Target IP=" + targetAddress.getHostAddress()
                    + " OID=" + requestOID);
                e4.printStackTrace();
                throw e4;
            }

            /*
             * F؃G[`FbN
             */
            if (!isCheckAuth) {
                /* F؃G[ */
                logger.warning(
                    "Auth error Target IP=" + targetAddress.getHostAddress()
                    + " OID=" + requestOID);
                SnmpManagerQueue.getInstance().pushSnmpManagerQueue(
                    "Auth error Target IP=" + targetAddress.getHostAddress()
                    + " OID=" + requestOID);
                throw new SnmpV3AuthAbortException();
            }
        }

        /* ꂽ܂́AÍĂȂScoped PDU */
        SnmpSequence scopedPDUData = null;

        /* (Íꂽ)Ώۃf[^i[ */
        SnmpOctetString descyptOctetData = null;

        /*
         * USM msgFlagÍ`FbN
         */
        if (
            (receiveMsgFlags & SnmpV3Preference.SNMPV3_MSG_FLAGS_PRIV) == SnmpV3Preference.SNMPV3_MSG_FLAGS_PRIV) {
            /*
             * 
             */
            try {
                /* AAR}hScopedPDU|[gPDU
                 * `FbNB
                 * |[gPDUłscopedPDU͈ÍȂ
                 */
                if (!(request.getSNMPObjectAt(3) instanceof SnmpOctetString)) {
                    if (request.getSNMPObjectAt(3) instanceof SnmpSequence) {
                        SnmpSequence testDescyptOctetData =
                            (SnmpSequence) request.getSNMPObjectAt(3);

                        if (
                            (testDescyptOctetData.getSNMPObjectAt(2) instanceof SnmpSequence)) {
                            /* |[gPDÛ߂ɈÍĂȂ
                                 * |[gPDUScoped PDUƂ
                                 */
                            scopedPDUData =
                                (SnmpSequence) request.getSNMPObjectAt(3);
                        } else {
                            /*
                             * |[gPDUł͂Ȃ̂ŕΏۃf[^Zbg
                             */
                            descyptOctetData =
                                (SnmpOctetString) testDescyptOctetData
                                .getSNMPObjectAt(0);
                            logger.warning("Not report PDU");
                            descyptOctetData =
                                (SnmpOctetString) testDescyptOctetData
                                .getSNMPObjectAt(1);
                        }
                    }
                } else {
                    /*
                     * R}hiȉŁA|[gPDUłȂꍇj
                     * Ȃ̂ŕΏۃf[^Zbg
                     */
                    descyptOctetData =
                        (SnmpOctetString) request.getSNMPObjectAt(3);
                }

                /*
                 * SNMP Report PDUH(parameterÍ
                 * 邩)
                 * (Ώۃf[^i[Ă邩)
                 */
                if (
                    (descyptOctetData == null)
                        || (descyptOctetData.getValue() == null)) {
                } else {
                    /*
                     * msgPrivacyParameters(DES random salt)`FbN
                     */
                    if (
                        (msgPrivacyParameters == null)
                            || (msgPrivacyParameters.getValue() == null)) {
                        logger.warning("msgPrivacyParameters null");
                    }

                    /* Scoped PDU */
                    SnmpSequence scopedPDUDataWork = null;

                    scopedPDUDataWork =
                        UsmSecuritySubsystem.getInstance().decrypt(
                            (byte[]) descyptOctetData.getValue(),
                            (byte[]) msgPrivacyParameters.getValue(),
                            usmUserEntry.getUsmUserPrivKey());

                    if (scopedPDUDataWork != null) {
                        try {
                            scopedPDUData =
                                (SnmpSequence) scopedPDUDataWork
                                .getSNMPObjectAt(0);
                        } catch (Exception e) {
                            logger.warning(
                                "Asemble SNMPSequence error by scopedPDU decrypt error");
                            SnmpManagerQueue.getInstance().pushSnmpManagerQueue(
                                "Asemble SNMPSequence error by scopedPDU decrypt error");
                            throw new SnmpV3DecryptAbortException(
                                "Asemble SNMPSequence error by scopedPDU decrypt error");
                        }
                    } else {
                        /* PDUG[ */
                        logger.warning("scopedPDU decrypt error");
                    }

                    if (scopedPDUData == null) {
                        /* PDUG[ */
                        logger.warning("ScopedPDU decrypt error");
                        logger.warning("usmStatsDecryptionErrors");
                        SnmpManagerQueue.getInstance().pushSnmpManagerQueue(
                            "ScopedPDU decrypt error");
                        throw new SnmpV3DecryptAbortException(
                            "Asemble SNMPSequence error by scopedPDU decrypt error");
                    }
                }
            } catch (GeneralSecurityException e3) {
                logger.warning(e3.getMessage());
                SnmpManagerQueue.getInstance().pushSnmpManagerQueue(
                    e3.getMessage());
                e3.printStackTrace();
            }
        } else {
            /* PDUÍ̏ꍇ */
            scopedPDUData = (SnmpSequence) request.getSNMPObjectAt(3);
        }

        if (scopedPDUData == null) {
            logger.warning("Scoped PDU Data null");
            SnmpManagerQueue.getInstance().pushSnmpManagerQueue(
                "Scoped PDU Data null");
            throw new SnmpV3DecryptAbortException("Decrypt error");
        }

        /*
         * scopedPDU
         */
        /* contextEngineID */
        AbstractSnmpObject contextEngineID = scopedPDUData.getSNMPObjectAt(0);

        /* contextName */
        AbstractSnmpObject contextName = scopedPDUData.getSNMPObjectAt(1);

        /* PDU Data */
        AbstractSnmpObject pduData = scopedPDUData.getSNMPObjectAt(2);

        logger.info("Receive contextEngineID : " + contextEngineID);
        logger.info("Receive contextName : " + contextName);
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue(
            "Receive contextEngineID : " + contextEngineID);
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue(
            "Receive contextName : " + contextName);

        SnmpPDU pduTLV = null;
        SnmpSequence pduTLVSequence = null;

        try {
            pduTLVSequence = new SnmpSequence(pduData.getBEREncoding());
        } catch (SnmpBadValueException e2) {
            logger.warning(e2.getMessage());
            e2.printStackTrace();
            throw e2;
        }

        // Report PDU܂́AResponce PDU
        pduTLV = (SnmpPDU) pduTLVSequence.getSNMPObjectAt(0);

        /*
         * Scoped PDUf[^j^[\Zbg
         */
        Date date = Calendar.getInstance().getTime();
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue(
            "Scoped PDU Receive Date : " + simpleDateformat.format(date)
            + " : ");
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue(
            hexBytetoString(
                pduTLV.getBEREncoding(), pduTLV.getBEREncoding().length));

        /*
         * Scoped PDU
         *
         */
        messageReceiveInstance.setSnmpReceiveSocket(targetAddress, dSocket);

        SnmpVarBindList retrievedVars;
        retrievedVars =
            messageReceiveInstance.parsePDU(pduTLV, requestID, requestOID);

        /*
         * SNMP V3̓f[^Mi[CX^XɃZbg
         */
        receiveMessageInfo.setMsgVersion(
            Integer.parseInt(msgVersion.toString()));
        receiveMessageInfo.setMsgID(Integer.parseInt(msgID.toString()));
        receiveMessageInfo.setMsgMaxSize(
            Integer.parseInt(msgMaxSize.toString()));
        receiveMessageInfo.setMsgFlags(msgFlags.toString());
        receiveMessageInfo.setMsgSecurityModel(
            Integer.parseInt(msgSecurityModel.toString()));
        receiveMessageInfo.setMsgAuthoritativeEngineID(
            msgAuthoritativeEngineID.toString());
        receiveMessageInfo.setMsgAuthoritativeBoots(
            Integer.parseInt(msgAuthoritativeBoots.toString()));
        receiveMessageInfo.setMsgAuthoritativeEngineTime(
            Integer.parseInt(msgAuthoritativeEngineTime.toString()));
        receiveMessageInfo.setMsgUserName(msgUserName.toString());

        receiveMessageInfo.setRetrievedVars(retrievedVars);

        return receiveMessageInfo;
    }

    /**
      * fBXJo[̂ČosnmpEngineID}l[W
      * ƂĕێĂG[WFg𒊏oāAG[WF
      * gf[^̑Ó؂܂B
      * G[WFg̉f[^Ół΁Af[^Snmp
      * V[PXf[^ƂĕԂ܂B
      *
      * @param msgID SNMP V3 msgID
      * @param info SNMP V3\
      * @param userName [U
      * @param requestID NGXgID
      * @param requestOID OID
      * @param code R}hR[h
      * @param newVar SNMPIuWFNg
      * @return SnmpSequence
      *
      * @throws GeneralSecurityException ZLeB֘Aňُ킪ꍇ
      * @throws SnmpV3ConfigurationException SNMP V3\ňُ킪ꍇ
      */
    public SnmpSequence createSNMPV3Message(
        int msgID, SnmpV3ManagerConfigInfo info, String userName, int requestID,
        String requestOID, byte code, AbstractSnmpObject newVar)
        throws GeneralSecurityException, SnmpV3ConfigurationException {
        int snmpVersion = SnmpPreference.SNMPV3;
        int securityModel = SnmpV3Preference.SECURITY_MODEL_USM;

        /*engineIDo  */
        SnmpEngineID snmpEngineID = new SnmpEngineID(info.getSnmpEngineID());

        /* engineBootso */
        int snmpEngineBoots = Integer.parseInt(info.getSnmpEngineBoots());

        /* engine StartTimeZbg */
        long agentStartTime = Long.parseLong(info.getSnmpEngineTime());
        String contextName = info.getContextName();

        SnmpSequence sendSNMPSequence = new SnmpSequence();

        try {
            /*
             * [UEngineID}l[WƂĕێĂG[WFg𒊏o
             */
            // System.out.println("Create snmpEngineID : " + snmpEngineID);
            // System.out.println("Create userName : " + userName);

            UsmUserEntry usmUserEntry =
                UsmUserManager.getInstance().getUsmUserEntry(
                    snmpEngineID, userName);

            if (usmUserEntry == null) {
                /* G[WFg񂪌Ȃ */
                logger.warning("Not user entry");
                logger.warning("snmpEngineID : " + snmpEngineID);
                logger.warning("userName : " + userName);
                throw new SnmpV3ConfigurationException(
                    userName + "@" + snmpEngineID + " Not user entry");
            }

            /*
             * G[WFg񂩂F؋yшÍxo
             */
            if (
                usmUserEntry.getUsmUserAuthProtocol() == UsmUserEntry.USM_NO_AUTH_PROTOCOL) {
                authFlag = false;
            } else {
                authFlag = true;
            }

            if (
                usmUserEntry.getUsmUserPrivProtocol() == UsmUserEntry.USM_NO_PRIV_PROTOCOL) {
                privFlag = false;
            } else {
                privFlag = true;
            }

            // Header
            // msgVersion
            sendSNMPSequence.addSNMPObject(new SnmpInteger(snmpVersion));

            // msgGlobalData
            SnmpSequence msgGlobalData = new SnmpSequence();

            // msgID
            msgGlobalData.addSNMPObject(new SnmpInteger(msgID));

            // msgMaxSize
            msgGlobalData.addSNMPObject(
                new SnmpInteger(SnmpV3Preference.SNMP_V3_MAX_PDU_SIZE));

            /* msgFlagsReport FlagZbg */
            byte msgFlag = SnmpV3Preference.SNMPV3_MSG_FLAGS_REPORT;

            if (authFlag) {
                /* msgFlagsɔFFlagZbg */
                msgFlag |= SnmpV3Preference.SNMPV3_MSG_FLAGS_AUTH;
            }

            if (privFlag) {
                /* msgFlagsɈÍFlagZbg */
                msgFlag |= SnmpV3Preference.SNMPV3_MSG_FLAGS_PRIV;
            }

            msgGlobalData.addSNMPObject(
                new SnmpOctetString(new byte[] { msgFlag }));

            // msgSecurityModel
            msgGlobalData.addSNMPObject(new SnmpInteger(securityModel));
            sendSNMPSequence.addSNMPObject(msgGlobalData);

            // msgSecurityParameters
            SnmpSequence msgSecurityParameters = new SnmpSequence();

            // msgAuthoritativeEngineID
            msgSecurityParameters.addSNMPObject(
                new SnmpOctetString(snmpEngineID.getId()));

            // msgAuthoritativeBoots
            msgSecurityParameters.addSNMPObject(
                new SnmpInteger(snmpEngineBoots));

            // msgAuthoritativeEngineTime
            int snmpEngineTime =
                (int) ((System.currentTimeMillis() - agentStartTime) / 1000);
            msgSecurityParameters.addSNMPObject(
                new SnmpInteger(snmpEngineTime));

            // msgUserName
            msgSecurityParameters.addSNMPObject(
                new SnmpOctetString(usmUserEntry.getUsmUserName()));

            // msgAuthenticationParameters
            if (authFlag) {
                msgSecurityParameters.addSNMPObject(
                    new SnmpOctetString(
                        new byte[SnmpV3Preference.MSG_AUTHENTICATION_PARAM_MSG_DIGEST_LEN]));
            } else {
                msgSecurityParameters.addSNMPObject(
                    new SnmpOctetString(new byte[0]));
            }

            /*  */
            byte[] iv = null;

            // msgPrivacyParameters
            if (privFlag) {
                logger.info("Priv");
                iv = UsmSecuritySubsystem.getInstance().getIV(snmpEngineBoots);
                msgSecurityParameters.addSNMPObject(
                    new SnmpOctetString(
                        UsmSecuritySubsystem.getInstance().getSalt(
                            usmUserEntry.getUsmUserPrivKey(), iv)));
            } else {
                logger.info("NoPriv");
                msgSecurityParameters.addSNMPObject(
                    new SnmpOctetString(new byte[0]));
            }

            sendSNMPSequence.addSNMPObject(
                new SnmpOctetString(msgSecurityParameters.getBEREncoding()));

            // msgData
            SnmpSequence msgData = new SnmpSequence();

            // contextEngineID
            msgData.addSNMPObject(new SnmpOctetString(snmpEngineID.getId()));

            // contextName
            msgData.addSNMPObject(new SnmpOctetString(contextName));

            // PDU Data
            SnmpPDU sendPDU = null;

            try {
                switch (code) {
                case SnmpBERCodec.SNMPGETNEXTREQUEST:
                    sendPDU =
                        createSNMPPDU(requestID, requestOID, code, newVar);
                    /* System.out.println(
                        "SNMP V3 GetNext : req ID= " + requestID + " OID="
                        + requestOID + " code=" + Byte.toString(code) + " var="
                        + newVar.toString());
                    */

                    break;

                case SnmpBERCodec.SNMPSETREQUEST:
                    sendPDU =
                        createSNMPPDU(requestID, requestOID, code, newVar);
                    /* System.out.println(
                        "SNMP V3 Set Req : req ID= " + requestID + " OID="
                        + requestOID + " code=" + Byte.toString(code) + " var="
                        + newVar.toString());
                    */

                    break;

                default:
                    logger.warning("Illegal code=" + Byte.toString(code));
                }
            } catch (SnmpBadValueException e3) {
                logger.warning("create snmp V3 message : " + e3.getMessage());
                e3.printStackTrace();
                throw e3;
            }

            msgData.addSNMPObject(sendPDU);

            // Í
            if (privFlag) {
                logger.info("Priv");

                try {
                    sendSNMPSequence.addSNMPObject(
                        new SnmpOctetString(
                            UsmSecuritySubsystem.encrypt(
                                msgData, iv, usmUserEntry.getUsmUserPrivKey())));
                } catch (GeneralSecurityException e2) {
                    logger.warning(e2.getMessage());
                    e2.printStackTrace();
                    throw e2;
                }
            } else {
                logger.info("No Priv");
                sendSNMPSequence.addSNMPObject(msgData);
            }

            /*
             * bZ[WF؃R[h(MAC)̃bZ[Wւ̖ߍ
             */
            if (authFlag) {
                logger.info("Auth");

                try {
                    SnmpOctetString msgAuthenticationParametersOctet = null;

                    /*
                     * F؃R[h
                     */
                    msgAuthenticationParametersOctet =
                        UsmSecuritySubsystem.getInstance().setAuth(
                            sendSNMPSequence, msgSecurityParameters,
                            usmUserEntry.getUsmUserAuthKey());
                    logger.info("usmUserName : " + usmUserEntry.getUsmUserName());
                    logger.info(
                        "usmUserAuthProtocol : "
                        + usmUserEntry.getUsmUserAuthProtocol());
                    logger.info(
                        "usmUserAuthKey : "
                        + hexBytetoString(
                            usmUserEntry.getUsmUserAuthKey().getEncoded(),
                            usmUserEntry.getUsmUserAuthKey().getEncoded().length));

                    /*
                     * F؃R[hߍ
                     */
                    msgSecurityParameters.addSNMPObject(
                        msgAuthenticationParametersOctet, 4);
                } catch (GeneralSecurityException e2) {
                    logger.warning(e2.getMessage());
                    e2.printStackTrace();
                    throw e2;
                }

                sendSNMPSequence.addSNMPObject(
                    new SnmpOctetString(msgSecurityParameters.getBEREncoding()),
                    2);
            } else {
                logger.info("No Auth");
            }
        } catch (SnmpBadValueException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
        }

        return sendSNMPSequence;
    }

    /**
     * wOIDsnmpObjectSnmp PDU𐶐܂B
     *
     * @param requestID NGXgʎq
     * @param requestOID OID
     * @param code SNMPR}hR[h
     * @param newVar SNMPIuWFNgValue
     *
     * @return pud SNMP PDU
     * @throws SnmpBadValueException SNMP PDUɎsꍇ
     */
    private SnmpPDU createSNMPPDU(
        int requestID, String requestOID, byte code, AbstractSnmpObject newVar)
        throws SnmpBadValueException {
        // Error Status
        int errorStatus = SnmpPreference.ERROR_STATUS_CORRECT;

        // Error Index
        int errorIndex = SnmpPreference.ERROR_INDEX_CORRECT;

        // PDU-Type
        byte pduType = code;

        SnmpPDU pdu = null;

        // SNMP PDU
        try {
            SnmpObjectIdentifier requestedObjectIdentifier =
                new SnmpObjectIdentifier(requestOID);
            SnmpSequence varList;

            // SNMP pair(OIDValue)
            SnmpVariablePair nextPair =
                new SnmpVariablePair(requestedObjectIdentifier, newVar);

            //@SNMP varList
            varList = new SnmpSequence();
            varList.addSNMPObject(nextPair);

            //@SNMP PDU
            pdu = new SnmpPDU(
                    pduType, requestID, errorStatus, errorIndex, varList);
        } catch (SnmpBadValueException e) {
            e.printStackTrace();
            throw new SnmpBadValueException(
                requestOID + " : " + e.getMessage());
        }

        return pdu;
    }
}
