/*
 * Created on 2004/10/21
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.snmpmanager.process;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;

import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;

import netjfwatcher.engine.resource.SnmpV3ManagerConfig;
import netjfwatcher.engine.resource.SnmpV3ManagerConfigInfo;
import netjfwatcher.engine.resource.SnmpV3ManagerUserConfigInfo;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.messageformat.SnmpErrorStatusException;
import netjfwatcher.snmp.messageformat.SnmpUnmuchRequestIDException;
import netjfwatcher.snmp.messageformat.SnmpUnmuchRequestMsgIDException;
import netjfwatcher.snmp.preference.SnmpBERCodec;
import netjfwatcher.snmp.preference.SnmpPreference;
import netjfwatcher.snmp.preference.SnmpV3Preference;
import netjfwatcher.snmp.snmpobject.integer.SnmpInteger;
import netjfwatcher.snmp.snmpobject.message.SnmpPDU;
import netjfwatcher.snmp.snmpobject.message.SnmpSequence;
import netjfwatcher.snmp.snmpobject.octetstring.SnmpOctetString;
import netjfwatcher.snmp.snmpv3.SnmpEngineID;
import netjfwatcher.snmp.snmpv3.SnmpV3AuthAbortException;
import netjfwatcher.snmp.snmpv3.SnmpV3ConfigurationException;
import netjfwatcher.snmp.snmpv3.SnmpV3DecryptAbortException;
import netjfwatcher.snmp.snmpv3.UsmSecuritySubsystem;
import netjfwatcher.snmp.snmpv3.UsmUserEntry;
import netjfwatcher.snmp.snmpv3.UsmUserManager;
import netjfwatcher.snmpmanager.SnmpManagerQueue;



/**
 * G[WFgsnmpEngineIDAsnmpEngineBootsysnmpEngineTimeo郁\bh
 * NXłB
 *
 * G[WFgfBXJo[V[PXƂāA
 *
 * EsnmpEngineIDfBXJo[p̑MbZ[W쐬
 * Ef[^M
 * EMf[^
 * EsnmpEngineBoots/snmpEngineTimefBXJo[p̑MbZ[W쐬
 * Ef[^M
 * EMf[^
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ManagerV3MPDiscoveryAgent extends ManagerV3MP {

    /* MO */
    private static Logger logger;

    /* SNMP V3\ */
    private SnmpV3ManagerConfigInfo snmpConfigInformation;

    /* SNMP V3[U */
    private SnmpV3ManagerUserConfigInfo userConfigInfo;

    /* j^tH[}bg */
    private DateFormat dateformat = new SimpleDateFormat("HH:mm:ss");

    /**
     * SNMP V3 DiscoveryCX^X𐶐܂B
     *
     * @param dSocket DatagramSocket
     * @param hostAddress AgentAhX
     * @param community R~jeB
     */
    public ManagerV3MPDiscoveryAgent(
        DatagramSocket dSocket, InetAddress hostAddress, String community) {
        //
        logger = Logger.getLogger(this.getClass().getName());
        this.version = SnmpPreference.SNMPV3;
        this.dSocket = dSocket;
        this.targetAddress = hostAddress;
        this.community = community;
    }

    /**
     * G[WFg̈ȉ̏oiDiscoveryjAXgɓo^ƂƂ
     * USM[U}l[WXgɂo^܂B
     *
     * (1) snmpEngineID
     * (2) snmpEngineBoots
     * (3) snmpEngineTime
     *
     * ^[QbgIP Addresssnmp V3񃊃Xgɓo^Ăsnmp V3
     * oĕێ܂B
     * ̏Ń[UAF/Íx̃`FbNs܂B
     *
     * @return ManagerV3MessageInfo
     * @throws SnmpUnmuchRequestIDException NGXgIDҒlƈvȂꍇ
     * @throws SnmpUnmuchRequestMsgIDException msgIDҒlƈvȂꍇ
     * @throws GeneralSecurityException ZLeB֘Aňُ킪ꍇ
     * @throws SnmpErrorStatusException G[Xe[^XłȂꍇ
     * @throws SnmpBadValueException f[^܂͉͂ňُ킪ꍇ
     * @throws SnmpV3DecryptAbortException Mf[^͂ɂĕɎsꍇ
     * @throws SnmpV3AuthAbortException Mf[^͂ɂĔF؂Ɏsꍇ
     * @throws SnmpV3ConfigurationException SNMP V3\ňُ킪ꍇ
     * @throws IOException f[^Mňُ킪ꍇ
     */
    public ManagerV3MessageInfo discoveryAgent()
        throws SnmpUnmuchRequestIDException, SnmpUnmuchRequestMsgIDException, 
            GeneralSecurityException, SnmpErrorStatusException, 
            SnmpBadValueException, SnmpV3DecryptAbortException, 
            SnmpV3AuthAbortException, SnmpV3ConfigurationException, IOException {
        /*
         * snmp V3𒊏o
         */
        snmpConfigInformation =
            SnmpV3ManagerConfig.getInstance().getResourceFileParse()
                               .getSnmpV3AgentInfo(
                targetAddress.getHostAddress());
        userConfigInfo =
            (SnmpV3ManagerUserConfigInfo) snmpConfigInformation.getUserList()
                                                               .get(0);

        int requestID =
            SnmpRequestIDManager.getInstance().getRequestID(
                Thread.currentThread().getName(), "discoveryAgent");
        int msgID =
            SnmpV3MsgIDManager.getInstance().getMsgID(
                Thread.currentThread().getName(), "discoveryAgent");

        /*
         * snmpV3 EngineIDoiDiscoveryj
         */
        SnmpSequence sequenceData = null;

        try {
            /* SnmpEngineID DiscoverybZ[W쐬 */
            sequenceData =
                this.createDiscoverySnmpEngineIDMessage(requestID, msgID);
        } catch (SnmpBadValueException e) {
            logger.warning(
                "create message for engineID discovery : " + e.getMessage());
            throw e;
        }

        DatagramPacket inPacket = null;
        ManagerV3MessageInfo receiveMessageInfo = null;

        try {
            byte[] sendData = sequenceData.getBEREncoding();
            dSocket.connect(targetAddress, snmpPort);

            while (true) {
                try {
                    // SnmpEngineID DiscoverybZ[WM
                    this.sendByteDataToAgent(
                        sendData, "discoveryAgent", dSocket);
                } catch (IOException e3) {
                    logger.warning(e3.getMessage());
                    e3.printStackTrace();
                    throw e3;
                }

                // SnmpEngineID Discovery f[^M
                inPacket =
                    new DatagramPacket(
                        new byte[AbstractManagerMessageProcessingSubsystem.MAXSIZE],
                        AbstractManagerMessageProcessingSubsystem.MAXSIZE);

                try {
                    dSocket.receive(inPacket);
                } catch (SocketTimeoutException e) {
                    try {
                        logger.warning(
                            "SnmpEngineID Discovery socket timeout : "
                            + dSocket.getSoTimeout());
                    } catch (SocketException e1) {
                        logger.warning(e1.getMessage());
                        e1.printStackTrace();

                        throw e1;
                    }

                    e.printStackTrace();
                    throw e;
                } catch (IOException e) {
                    logger.warning(
                        "SnmpEngineID Discovery : " + e.getMessage());
                    e.printStackTrace();
                    throw e;
                }

                break;
            }

            /*
             * EngineID Discoveryɑ΂鉞bZ[W
             */
            byte[] receiveDataByte = inPacket.getData();
            logger.fine(
                "EngineID Discovery receive data : "
                + hexBytetoString(receiveDataByte, inPacket.getLength()));

            /*
             * EngineID DiscoveryMf[^j^[\Zbg
             */
            Date date = Calendar.getInstance().getTime();
            SnmpManagerQueue.getInstance().pushSnmpManagerQueue(
                "EngineID Discovery receive data : " + dateformat.format(date)
                + " : Data length : " + inPacket.getLength() + "Byte");
            SnmpManagerQueue.getInstance().pushSnmpManagerQueue(
                hexBytetoString(receiveDataByte, inPacket.getLength()));
            receiveMessageInfo =
                this.parseSnmpV3ReceiveData(
                    receiveDataByte, requestID, msgID, "discoveryAgent");

            System.out.println(
                "Discovery engineID : "
                + receiveMessageInfo.getMsgAuthoritativeEngineID());

            String msgAuthoritativeEngineID =
                receiveMessageInfo.getMsgAuthoritativeEngineID();

            String snmpEngineID = "";
            String msgAuthoritativeUserName =
                receiveMessageInfo.getMsgUserName();

            // MsnmpEngineID"0x"č\ɃZbg
            snmpEngineID = msgAuthoritativeEngineID.substring(2);
            snmpConfigInformation.setSnmpEngineID(snmpEngineID);

            logger.info(
                "Discovery Agent : " + snmpConfigInformation.getIpAddress());
            logger.info(
                "Discovery Agent AuthPassPhrase : "
                + ((SnmpV3ManagerUserConfigInfo) snmpConfigInformation.getUserList()
                                                                      .get(0))
                .getAuthPassPhrase());
            SnmpV3ManagerConfig.getInstance().getResourceFileParse()
                               .updateSnmpV3ManagerConfigInfo(
                targetAddress.getHostAddress(), snmpConfigInformation);

            // USMXgɓo^
            try {
                // Agent Discoveryɂ茟o񂩂USM񃊃Xgɓo^
                this.setSnmpV3USMUserManagerList(snmpConfigInformation);
            } catch (SnmpV3ConfigurationException e) {
                logger.warning(
                    "SnmpV3USMUserManagerList abort : " + e.getMessage());
                throw e;
            }

            // Client̃p[^`FbN
            // UserNameo^ς݂
            if (snmpConfigInformation != null) {
                System.out.println(
                    "IP Address : " + snmpConfigInformation.getIpAddress());
                System.out.println(
                    "User Name : " + userConfigInfo.getUsername());
            } else {
                // MAgent Addresso^񂩂猩Ȃ
                logger.warning(
                    "Not found Agent Address : " + targetAddress.toString());
            }

            // userNameo^ς݂
            String userName = userConfigInfo.getUsername();

            requestID =
                SnmpRequestIDManager.getInstance().getRequestID(
                    Thread.currentThread().getName(),
                    "DiscoverySnmpBootsAndTimeMessage");
            msgID =
                SnmpV3MsgIDManager.getInstance().getMsgID(
                    Thread.currentThread().getName(),
                    "DiscoverySnmpBootsAndTimeMessage");

            if (!(userName.equals(msgAuthoritativeUserName))) {
                logger.warning(
                    "Not found UserName : " + msgAuthoritativeUserName);
            }

            try {
                // SNMPEngineBoots and engineTime discoverytbZ[W쐬
                sequenceData =
                    this.createDiscoverySnmpBootsAndTimeMessage(
                        requestID, msgID, snmpEngineID, userName);
            } catch (GeneralSecurityException e) {
                logger.warning(e.getMessage());
                throw e;
            } catch (SnmpV3ConfigurationException e) {
                logger.warning(e.getMessage());
                throw e;
            } catch (SnmpBadValueException e) {
                logger.warning(e.getMessage());
                throw new SnmpBadValueException(e.getMessage());
            }

            sendData = sequenceData.getBEREncoding();

            while (true) {
                // bZ[WM
                try {
                    this.sendByteDataToAgent(
                        sendData, "discoveryAgent", dSocket);
                } catch (IOException e1) {
                    logger.warning(
                        "Send to discovery agent : " + e1.getMessage());
                    e1.printStackTrace();
                    throw e1;
                }

                // f[^M
                inPacket = new DatagramPacket(new byte[MAXSIZE], MAXSIZE);

                try {
                    dSocket.receive(inPacket);
                } catch (SocketTimeoutException e) {
                    logger.warning(
                        "Receive socket timeout from discovery Agent : "
                        + e.getMessage());
                    e.printStackTrace();
                    throw e;
                } catch (IOException e) {
                    logger.warning(
                        "Receive from discovery Agent : " + e.getMessage());
                    e.printStackTrace();
                    throw e;
                }

                break;
            }

            receiveDataByte = inPacket.getData();

            logger.fine(
                "EngineBoots/Time Discovery receive data : "
                + hexBytetoString(receiveDataByte, inPacket.getLength()));

            /*
             * EngineBoots/Time DiscoveryMf[^j^[\Zbg
             */
            date = Calendar.getInstance().getTime();
            SnmpManagerQueue.getInstance().pushSnmpManagerQueue(
                "EngineBoots/Time Discovery receive data : "
                + dateformat.format(date) + " : Data length : "
                + inPacket.getLength() + "Byte");
            SnmpManagerQueue.getInstance().pushSnmpManagerQueue(
                hexBytetoString(receiveDataByte, inPacket.getLength()));
            receiveMessageInfo =
                this.parseSnmpV3ReceiveData(
                    receiveDataByte, requestID, msgID, "discoveryAgent");
            System.out.println(
                "Discovery engineBoots and time : "
                + receiveMessageInfo.getMsgAuthoritativeEngineID());
            System.out.println(
                "Discovery engineBoots and time : "
                + receiveMessageInfo.getMsgAuthoritativeBoots());
            System.out.println(
                "Discovery engineBoots and time : "
                + receiveMessageInfo.getMsgAuthoritativeBoots());
        } finally {
            dSocket.disconnect();
        }

        return receiveMessageInfo;
    }

    /**
     * Agent Discoveryɂ茟o񂩂USM񃊃Xgɓo^܂B
     *
     * @param info SNMP V3Ǘ
     * @throws SnmpV3ConfigurationException SNMP V3\ňُ킪ꍇ
     */
    private void setSnmpV3USMUserManagerList(SnmpV3ManagerConfigInfo info)
        throws SnmpV3ConfigurationException {
        // snmpEngineID
        SnmpEngineID snmpEngineID = new SnmpEngineID(info.getSnmpEngineID());
        System.out.println("SnmpEngineID : " + snmpEngineID);

        // USM[U}l[Wɓo^
        UsmUserManager.getInstance().registList(snmpEngineID, info);

        try {
            MessageDigest.getInstance(SnmpV3Preference.AUTH_PROTOCOL_MD5);
        } catch (NoSuchAlgorithmException e) {
            logger.warning("MessageDigest MD5 : " + e.getMessage());
            throw new SnmpV3ConfigurationException(
                "MessageDigest MD5 : " + e.getMessage());
        }

        try {
            MessageDigest.getInstance(SnmpV3Preference.AUTH_PROTOCOL_SHA1);
        } catch (NoSuchAlgorithmException e) {
            logger.warning("MessageDigest SHA-1 : " + e.getMessage());
            throw new SnmpV3ConfigurationException(
                "MessageDigest SHA-1 : " + e.getMessage());
        }

        try {
            Mac.getInstance(SnmpV3Preference.HMAC_MD5);
        } catch (NoSuchAlgorithmException e) {
            logger.warning("Mac HmacMD5 : " + e.getMessage());
            throw new SnmpV3ConfigurationException(
                "Mac HmacMD5 : " + e.getMessage());
        }

        try {
            Mac.getInstance(SnmpV3Preference.HMAC_SHA1);
        } catch (NoSuchAlgorithmException e) {
            logger.warning("Mac HmacSHA1 : " + e.getMessage());
            throw new SnmpV3ConfigurationException(
                "Mac HmacSHA1 : " + e.getMessage());
        }

        try {
            Cipher.getInstance(SnmpV3Preference.PRIV_PROTOCOL_DES);
        } catch (NoSuchPaddingException e) {
            logger.warning("Cipher DES : " + e.getMessage());
            throw new SnmpV3ConfigurationException(
                "Cipher DES : " + e.getMessage());
        } catch (NoSuchAlgorithmException e) {
            logger.warning("Cipher DES : " + e.getMessage());
            throw new SnmpV3ConfigurationException(
                "Cipher DES : " + e.getMessage());
        }

        try {
            SecretKeyFactory.getInstance(SnmpV3Preference.PRIV_PROTOCOL_DES);
        } catch (NoSuchAlgorithmException e) {
            logger.warning("SecretKeyFactory DES : " + e.getMessage());
            throw new SnmpV3ConfigurationException(
                "SecretKeyFactory DES : " + e.getMessage());
        } catch (Throwable e) {
            logger.warning("MessageDigest MD5 : " + e.getMessage());
            throw new SnmpV3ConfigurationException(e.toString());
        }
    }

    /**
     * G[WFgEngineIDo邽߂̃bZ[W쐬郁\bhłB
     *
     * @param requestID NGXgID
     * @param requestMsgID msgID
     * @return SnmpSequence
     * @throws SnmpBadValueException Snmp EngineID Discovery Mf[^쐬ňُ
     */
    public SnmpSequence createDiscoverySnmpEngineIDMessage(
        int requestID, int requestMsgID) throws SnmpBadValueException {
        int snmpVersion = SnmpPreference.SNMPV3;
        int securityModel = SnmpV3Preference.SECURITY_MODEL_USM;

        // String userName = null;
        SnmpEngineID snmpEngineID = null;
        int snmpEngineBoots = 0;

        // String contextName = null;
        SnmpSequence sendSNMPSequence = new SnmpSequence();

        try {
            System.out.println("snmpEngineID : " + snmpEngineID);

            // Header
            // msgVersion	
            sendSNMPSequence.addSNMPObject(new SnmpInteger(snmpVersion));

            // msgGlobalData
            SnmpSequence msgGlobalData = new SnmpSequence();

            // msgID
            msgGlobalData.addSNMPObject(new SnmpInteger(requestMsgID));

            // msgMaxSize
            msgGlobalData.addSNMPObject(new SnmpInteger(0x200));

            // msgFlagsreport flagZbg
            byte msgFlag = (byte) SnmpV3Preference.SNMPV3_MSG_FLAGS_REPORT;

            msgGlobalData.addSNMPObject(
                new SnmpOctetString(new byte[] { msgFlag }));

            // msgSecurityModel
            msgGlobalData.addSNMPObject(new SnmpInteger(securityModel));
            sendSNMPSequence.addSNMPObject(msgGlobalData);

            // msgSecurityParameters
            SnmpSequence msgSecurityParameters = new SnmpSequence();

            // msgAuthoritativeEngineID
            msgSecurityParameters.addSNMPObject(new SnmpOctetString());

            // msgAuthoritativeBoots
            msgSecurityParameters.addSNMPObject(
                new SnmpInteger(snmpEngineBoots));

            // msgAuthoritativeEngineTime
            int snmpEngineTime = 0;
            msgSecurityParameters.addSNMPObject(
                new SnmpInteger(snmpEngineTime));

            // msgUserName
            msgSecurityParameters.addSNMPObject(new SnmpOctetString());

            // msgAuthenticationParameters
            msgSecurityParameters.addSNMPObject(
                new SnmpOctetString(new byte[0]));

            // msgPrivacyParameters
            msgSecurityParameters.addSNMPObject(
                new SnmpOctetString(new byte[0]));

            sendSNMPSequence.addSNMPObject(
                new SnmpOctetString(msgSecurityParameters.getBEREncoding()));

            // msgData
            SnmpSequence msgData = new SnmpSequence();

            // contextEngineID
            msgData.addSNMPObject(new SnmpOctetString());

            // contextName
            msgData.addSNMPObject(new SnmpOctetString());

            // PDU Data
            SnmpPDU sendPDU = null;

            try {
                int errorStatus = 0;
                int errorIndex = 0;

                // SNMP PDU
                try {
                    SnmpSequence varList;
                    varList = new SnmpSequence();

                    //@SNMP PDU
                    sendPDU =
                        new SnmpPDU(
                            SnmpBERCodec.SNMPGETREQUEST, requestID, errorStatus,
                            errorIndex, varList);
                } catch (SnmpBadValueException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                    throw e;
                }
            } catch (SnmpBadValueException e3) {
                throw e3;
            }

            msgData.addSNMPObject(sendPDU);

            sendSNMPSequence.addSNMPObject(msgData);
        } catch (SnmpBadValueException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
            throw e1;
        }

        return sendSNMPSequence;
    }

    /**
     * G[WFgEngineBootsyEngineTimeo邽߂̃bZ[W쐬
     * \bhłB
     *
     * @param requestID NGXgID
     * @param requestMsgID msgID
     * @param snmpEngineIDString SNMP engineID
     * @param userNameString [U
     * @return sendSNMPSequence SNMP SequenceIuWFNg
     * @throws GeneralSecurityException ZLeB֘Aňُ킪ꍇ
     * @throws SnmpV3ConfigurationException engineIDUserɑΉG[WFg񂪌Ȃꍇ
     * @throws SnmpBadValueException SnmpbZ[W쐬Ɏsꍇ
     */
    public SnmpSequence createDiscoverySnmpBootsAndTimeMessage(
        int requestID, int requestMsgID, String snmpEngineIDString,
        String userNameString)
        throws GeneralSecurityException, SnmpBadValueException,
            SnmpV3ConfigurationException {
        int snmpVersion = SnmpPreference.SNMPV3;
        int securityModel = SnmpV3Preference.SECURITY_MODEL_USM;


        String userName = userNameString;
        SnmpEngineID snmpEngineID = new SnmpEngineID(snmpEngineIDString);
        int snmpEngineBoots = 0;

        String contextName = snmpConfigInformation.getContextName();
        SnmpSequence sendSNMPSequence = new SnmpSequence();

        /*
         * EngineIDƃ[UUSM[UGg[𒊏o
         */
        UsmUserEntry usmUserEntry =
            UsmUserManager.getInstance().getUsmUserEntry(
                snmpEngineID, userName);

        if (usmUserEntry == null) {
            System.out.println("Not user entry");
            System.out.println("snmpEngineID : " + snmpEngineID);
            System.out.println("userName : " + userName);
            throw new SnmpV3ConfigurationException(
                "Agent discovery EngineBoots/Time : ");
        }

        try {
            System.out.println("SnmpEngineID : " + snmpEngineID);
            System.out.println("UserName : " + userName);

            // Header
            // msgVersion	
            sendSNMPSequence.addSNMPObject(new SnmpInteger(snmpVersion));

            // msgGlobalData
            SnmpSequence msgGlobalData = new SnmpSequence();

            // msgID
            msgGlobalData.addSNMPObject(new SnmpInteger(requestMsgID));

            // msgMaxSize
            msgGlobalData.addSNMPObject(
                new SnmpInteger(SnmpV3Preference.SNMP_V3_MAX_PDU_SIZE));

            // msgFlagsreport flagZbg
            byte msgFlag = (byte) SnmpV3Preference.SNMPV3_MSG_FLAGS_REPORT;
            String authPriv = userConfigInfo.getAuthPriv();

            if (
                authPriv.equals(SnmpV3Preference.AUTH)
                    || authPriv.equals(SnmpV3Preference.PRIV)) {
                msgFlag |= (byte) 0x1;
            }

            msgGlobalData.addSNMPObject(
                new SnmpOctetString(new byte[] { msgFlag }));

            // msgSecurityModel
            msgGlobalData.addSNMPObject(new SnmpInteger(securityModel));
            sendSNMPSequence.addSNMPObject(msgGlobalData);

            // msgSecurityParameters
            SnmpSequence msgSecurityParameters = new SnmpSequence();

            // msgAuthoritativeEngineID
            msgSecurityParameters.addSNMPObject(
                new SnmpOctetString(snmpEngineID.getId()));

            // msgAuthoritativeBoots
            msgSecurityParameters.addSNMPObject(
                new SnmpInteger(snmpEngineBoots));

            // msgAuthoritativeEngineTime
            int snmpEngineTime = 0;
            msgSecurityParameters.addSNMPObject(
                new SnmpInteger(snmpEngineTime));

            // msgUserName
            msgSecurityParameters.addSNMPObject(new SnmpOctetString(userName));

            // msgAuthenticationParameters
            if (
                authPriv.equals(UsmUserManager.AUTHPRIV_AUTH)
                    || authPriv.equals(UsmUserManager.AUTHPRIV_PRIV)) {
                msgSecurityParameters.addSNMPObject(
                    new SnmpOctetString(new byte[12]));
            } else {
                msgSecurityParameters.addSNMPObject(
                    new SnmpOctetString(new byte[0]));
            }

            // msgPrivacyPara
            msgSecurityParameters.addSNMPObject(
                new SnmpOctetString(new byte[0]));
            sendSNMPSequence.addSNMPObject(
                new SnmpOctetString(msgSecurityParameters.getBEREncoding()));

            // msgData
            SnmpSequence msgData = new SnmpSequence();

            // contextEngineID
            msgData.addSNMPObject(new SnmpOctetString(snmpEngineID.getId()));

            // contextName
            msgData.addSNMPObject(new SnmpOctetString(contextName));

            // PDU Data
            SnmpPDU sendPDU = null;

            try {
                int errorStatus = 0;
                int errorIndex = 0;

                // SNMP PDU
                try {
                    SnmpSequence varList;

                    //
                    varList = new SnmpSequence();

                    //@SNMP PDU
                    sendPDU =
                        new SnmpPDU(
                            SnmpBERCodec.SNMPGETREQUEST, requestID, errorStatus,
                            errorIndex, varList);
                } catch (SnmpBadValueException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                    throw new SnmpBadValueException(e.getMessage());
                }
            } catch (SnmpBadValueException e) {
                throw e;
            }

            msgData.addSNMPObject(sendPDU);

            sendSNMPSequence.addSNMPObject(msgData);

            // MAC(FdigestZbgFߍ)
            if (
                authPriv.equals(UsmUserManager.AUTHPRIV_AUTH)
                    || authPriv.equals(UsmUserManager.AUTHPRIV_PRIV)) {
                try {
                    SnmpOctetString msgAuthenticationParametersOctet = null;

                    msgAuthenticationParametersOctet =
                        UsmSecuritySubsystem.getInstance().setAuth(
                            sendSNMPSequence, msgSecurityParameters,
                            usmUserEntry.getUsmUserAuthKey());

                    msgSecurityParameters.addSNMPObject(
                        msgAuthenticationParametersOctet, 4);
                } catch (GeneralSecurityException e2) {
                    logger.warning(e2.getMessage());
                    e2.printStackTrace();
                    throw e2;
                }

                sendSNMPSequence.addSNMPObject(
                    new SnmpOctetString(msgSecurityParameters.getBEREncoding()),
                    2);
            }
        } catch (SnmpBadValueException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
            throw e1;
        }

        return sendSNMPSequence;
    }
}
