/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.snmpmanager.process;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;


/**
 * SNMPv(USM v)AgentAhXɊǗNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class SnmpStatisticsManager {
    /* SNMP AgentAhXKeyƂSNMPvi[Map */
    private static Map addressMap = Collections.synchronizedMap(new HashMap());

    /*
     * SNMPv(USM v)AgentAhXɊǗNX
     * CX^X𐶐܂B
     */
    private SnmpStatisticsManager() {
    }

    /**
     * AgentAhXɑΉSNMPvCX^XԂ܂B
     *
     * @param addressKey SNMP AgentAhX
     * @return SnmpStatisticsInfo
     */
    public synchronized SnmpStatisticsInfo getSnmpStatisticsInfo(
        String addressKey) {
        /* */
        SnmpStatisticsInfo info = null;

        if (addressMap.containsKey(addressKey)) {
            info = (SnmpStatisticsInfo) addressMap.get(addressKey);
        } else {
            info = new SnmpStatisticsInfo();
        }

        return info;
    }

    /**
     *
     *
     * @param addressKey SNMP AgentAhX
     */
    public synchronized void addSnmpSocketTimeout(String addressKey) {
        /*  */
        SnmpStatisticsInfo info = null;

        if (addressMap.containsKey(addressKey)) {
            info = (SnmpStatisticsInfo) addressMap.get(addressKey);
        } else {
            info = new SnmpStatisticsInfo();
        }

        info.addSnmpSocketTimeout();
        addressMap.put(addressKey, info);
    }

    /**
     *
     *
     * @param addressKey SNMP AgentAhX
     */
    public synchronized void addSnmpUnmuchRequestID(String addressKey) {
        /*  */
        SnmpStatisticsInfo info = null;

        if (addressMap.containsKey(addressKey)) {
            info = (SnmpStatisticsInfo) addressMap.get(addressKey);
        } else {
            info = new SnmpStatisticsInfo();
        }

        info.addSnmpUnmuchRequestID();
        addressMap.put(addressKey, info);
    }

    /**
     *
     * @param addressKey SNMP AgentAhX
     */
    public synchronized void addSnmpErrorStatus(String addressKey) {
        /*  */
        SnmpStatisticsInfo info = null;

        if (addressMap.containsKey(addressKey)) {
            info = (SnmpStatisticsInfo) addressMap.get(addressKey);
        } else {
            info = new SnmpStatisticsInfo();
        }

        info.addSnmpErrorStatus();
        addressMap.put(addressKey, info);
    }

    /**
     *
     * @param addressKey SNMP AgentAhX
     */
    public synchronized void addSnmpV3UnmuchMsgID(String addressKey) {
        /*  */
        SnmpStatisticsInfo info = null;

        if (addressMap.containsKey(addressKey)) {
            info = (SnmpStatisticsInfo) addressMap.get(addressKey);
        } else {
            info = new SnmpStatisticsInfo();
        }

        info.addSnmpV3UnmuchmsgID();
        addressMap.put(addressKey, info);
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static SnmpStatisticsManager getInstance() {
        return SingletonResource.RESOURCE;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final SnmpStatisticsManager RESOURCE =
            new SnmpStatisticsManager();
    }
}
