/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.view.editorpart.common;

import java.util.ArrayList;

import netjfwatcher.engine.socket.info.NodeInformation;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;


/**
 * Ot`Editor View̓͒lێNXłB
 * Viewɕ̃Ot`s߂ɁAf[^ێ܂B
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class EditorInputNodeChart implements IEditorInput {
    /* View^Cg */
    private final String title;

    /* m[hĎ */
    private NodeInformation nodeInfo;

    /* lbg[NoRtO */
    private boolean isSocket;

    /* OID */
    private String oid;

    /* ef[^̍őli[z */
    private String[] maxData;

    /* ef[^̍ŏli[z */
    private String[] minData;

    /* f[^i[Xg */
    private ArrayList dataList;

    /* f[^̎i[Xg */
    private ArrayList dateList;

    /* Otf[^i[Xg */
    private ArrayList itemNameList;

    /**
     * Ot`Editor View̓͒lێNXCX^X
     * ܂B
     *
     * @param title View^Cg
     * @param nodeInfo m[hĎ
     * @param isSocket lbg[NoR̎tO
     * @param itemNameList ItemXg
     */
    public EditorInputNodeChart(
        String title, NodeInformation nodeInfo, boolean isSocket,
        ArrayList itemNameList) {
        this.title = title;
        this.nodeInfo = nodeInfo;
        this.isSocket = isSocket;
        this.itemNameList = itemNameList;
    }

    /**
     * Ot`Editor View̓͒lێNXCX^X
     * ܂B
     *
     * @param title View^Cg
     * @param nodeInfo m[hĎ
     * @param isSocket lbg[NoR̎tO
     * @param itemNameList ItemXg
     * @param oid OID
     */
    public EditorInputNodeChart(
        String title, NodeInformation nodeInfo, boolean isSocket,
        ArrayList itemNameList, String oid) {
        this.title = title;
        this.nodeInfo = nodeInfo;
        this.isSocket = isSocket;
        this.itemNameList = itemNameList;
        this.oid = oid;
    }

    /**
     * Ot`Editor View̓͒lێNXCX^X
     * ܂B
     *
     * @param title View^Cg
     * @param nodeInfo m[hĎ
     * @param isSocket lbg[NoR̎tO
     * @param dataList f[^Xg
     * @param dateList Xg
     * @param itemNameList eOt
     * @param maxData eOtőli[z
     * @param minData eOtŏli[z
     */
    public EditorInputNodeChart(
        String title, NodeInformation nodeInfo, boolean isSocket,
        ArrayList dataList, ArrayList dateList, ArrayList itemNameList,
        String[] maxData, String[] minData) {
        this.title = title;
        this.nodeInfo = nodeInfo;
        this.isSocket = isSocket;
        this.dataList = dataList;
        this.dateList = dateList;
        this.itemNameList = itemNameList;
        this.maxData = maxData;
        this.minData = minData;
    }

    /**
     * Ot`Editor View̓͒lێNXCX^X
     * ܂B
     *
     * @param title ^Cg
     * @param nodeInfo m[hĎ
     * @param isSocket lbg[NoR̎tO
     * @param dataList f[^Xg
     * @param dateList Xg
     * @param itemNameList OtItemXg
     * @param maxData Otőlz
     * @param minData Otŏlz
     * @param oid OID
     */
    public EditorInputNodeChart(
        String title, NodeInformation nodeInfo, boolean isSocket,
        ArrayList dataList, ArrayList dateList, ArrayList itemNameList,
        String[] maxData, String[] minData, String oid) {
        this(
            title, nodeInfo, isSocket, dataList, dateList, itemNameList, maxData,
            minData);
        this.oid = oid;
    }

    /*
     *  (non-Javadoc)
     * @see org.eclipse.core.runtime.IAdaptable#getAdapter(java.lang.Class)
     */
    public Object getAdapter(Class adapter) {
        return null;
    }

    /**
     * ImageDescriptorԂ܂B
     *
     * @return ImageDescriptor
     */
    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    /**
     * ^CgԂ܂B
     *
     * @return title ^Cg
     */
    public String getName() {
        return title;
    }

    /*
     *  (non-Javadoc)
     * @see org.eclipse.ui.IEditorInput#getPersistable()
     */
    public IPersistableElement getPersistable() {
        return null;
    }

    /**
     * ToolTipTextƂURLԂ܂B
     *
     * @return url URL
     */
    public String getToolTipText() {
        return title;
    }

    /**
     * w肳ꂽObjectEditor͒lNXCX^X`FbNA
     * ă^Cg`FbNČʂԂ܂B
     *
     * @param obj Object
     * @return `FbN
     */
    public boolean equals(Object obj) {

        if (!(obj instanceof EditorInputNodeChart)) {
            return false;
        }

        EditorInputNodeChart that = (EditorInputNodeChart) obj;

        return this.title.equals(that.title);
    }

    /*
     *  (non-Javadoc)
     * @see org.eclipse.ui.IEditorInput#exists()
     */
    public boolean exists() {
        return false;
    }

    /*
     *  (non-Javadoc)
     * @see java.lang.Object#hashCode()
     */
    public int hashCode() {
        return title.hashCode();
    }

    /**
     *
     *
     * @return nodeInfo ߂܂B
     */
    public NodeInformation getNodeInfo() {
        return nodeInfo;
    }

    /**
     * @return dataList ߂܂B
     */
    public ArrayList getDataList() {
        return dataList;
    }

    /**
     * @return dateList ߂܂B
     */
    public ArrayList getDateList() {
        return dateList;
    }

    /**
     * @return maxData ߂܂B
     */
    public String[] getMaxData() {
        return maxData;
    }

    /**
     * @return minData ߂܂B
     */
    public String[] getMinData() {
        return minData;
    }

    /**
     * @return itemNameList ߂܂B
     */
    public ArrayList getItemNameList() {
        return itemNameList;
    }

    /**
     * @return oid ߂܂B
     */
    public String getOid() {
        return oid;
    }

    /**
     * @return isSocket ߂܂B
     */
    public boolean isSocket() {
        return isSocket;
    }
}
