/*
 * Created on 2006/06/28
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.view.editorpart.nodedetect;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;

import netjfwatcher.engine.model.action.MediaResource;
import netjfwatcher.engine.view.editorpart.common.AbstractEditorNodeView;
import netjfwatcher.engine.view.editorpart.node.EditorNodeOperationInitialData;
import netjfwatcher.snmp.preference.SnmpPreference;
import netjfwatcher.snmpmanager.model.ActionBuilderTrapReceiveTable;

import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorSite;


/**
 * m[h̎o邽߂ViewNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class EditorAutoNodeDetect extends AbstractEditorNodeView {
    /** View^CgSuffix */
    public static final String TITLE_SUFFIX = "Node Discovery";

    /** f[^\eLXg */
    public static final int DATE_TEXT_WIDTH = 250;

    /** eLXg\ */
    public static final int TEXT_WIDTH1 = 120;

    /* Scroll CompositeTCY */
    private static final int[] SCROLL_COMPOSITE_SIZE = { 800, 500 };
    private static final int IPADDRESS_LENGTH = 4;

    /* Horizontal Span 4 */
    private static final int HORIZONTAL_SPAN4 = 4;

    /* Nodeo\^C}[ */
    private static final int NODE_DISCOVERY_PROCESSOR_TIMER = 1000;
    private static final String INITIAL_NODE_KIND = "Router";
    private static final String INITIAL_PERIOD_TIME = "120";
    private static final int INITIAL_PERIOD_TIME_DATA = 60;

    /* Logging */
    private static Logger logger;

    /* SNMPĎReadR~jeB\Text */
    private Text snmpROCommunityText;

    /* m[hJnIPAhX\Text */
    private Text startIPAddressText;

    /* m[hEnd IPAhX\Text */
    private Text endIPAddressText;

    /* m[hIPo^C}[\Text */
    private Text pingTimeoutText;

    /* SNMP Version\ComboBox */
    private Combo snmpVersionCombo;

    /* `FbNm[h\Text */
    private Text chekNodeCountText;

    /* IP OKm[h\Text */
    private Text ipNodeCountText;

    /* SNMP OKm[h\Text */
    private Text snmpNodeCountText;

    /* m[hoJn{^ */
    private Button startButton;

    /* m[hoLZ{^ */
    private Button cancelButton;

    /* m[hʕ\eLXg */
    private Combo nodeKindCombo;
    private Text nodeGroupText;
    private Text pingPeriodText;
    private Text snmpPeriodText;

    /* m[heLXg\BackGroundFi[ */
    private Color textBackColor;

    /* m[hoIPAhXXg */
    private ArrayList nodeDiscoveryIPAddressList = new ArrayList();

    /* Display */
    private Display display;

    /* m[hoTimer */
    private NodeDetectTimerProcessor timerProcessor;

    /**
     * EditorEBhEɃuEU\邽߂̃CX^X
     * 𐶐܂B
     *
     */
    public EditorAutoNodeDetect() {
        logger = Logger.getLogger(this.getClass().getName());

        textBackColor = WHITE_COLOR;
    }

    /*
     *  (non-Javadoc)
     * @see org.eclipse.ui.ISaveablePart#isSaveAsAllowed()
     */
    public boolean isSaveAsAllowed() {
        return false;
    }

    /**
     * EditorEBhE𐶐܂B
     *
     * @param parent Composite
     */
    public void createPartControl(Composite parent) {
        display = parent.getDisplay();

        /*
         * ViewCAEg
         */
        ScrolledComposite scrollComposite =
            new ScrolledComposite(parent, SWT.H_SCROLL | SWT.V_SCROLL);

        GridLayout layout = new GridLayout(1, false);
        scrollComposite.setLayout(layout);

        GridData gridData = null;

        GridLayout gridLayout0 = new GridLayout(1, true);
        Composite composite0 = new Composite(scrollComposite, SWT.NONE);
        composite0.setLayout(gridLayout0);
        composite0.setLayoutData(
            new GridData(
                GridData.HORIZONTAL_ALIGN_FILL | GridData.VERTICAL_ALIGN_FILL));

        GridLayout gridLayout = new GridLayout(HORIZONTAL_SPAN4, false);
        Composite composite1 = new Composite(composite0, SWT.NULL);
        composite1.setLayout(gridLayout);
        composite1.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
        gridData = new GridData();

        GridLayout gridLayout2 = new GridLayout(HORIZONTAL_SPAN4, false);
        Composite composite2 = new Composite(composite0, SWT.NONE);
        composite2.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
        composite2.setLayout(gridLayout2);

        Group composite3 = new Group(composite0, SWT.NONE);
        composite3.setText("Node Discovery Status");
        composite3.setLayout(new GridLayout(HORIZONTAL_SPAN4, false));
        composite3.setLayoutData(new GridData());

        Group composite4 = new Group(composite0, SWT.NONE);
        composite4.setText("Node Register Information");
        composite4.setLayout(new GridLayout(HORIZONTAL_SPAN4, false));
        composite4.setLayoutData(new GridData());

        startButton = new Button(composite1, SWT.NONE);
        startButton.setText("Start");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        startButton.setLayoutData(gridData);

        cancelButton = new Button(composite1, SWT.NONE);
        cancelButton.setText("Cancel");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        cancelButton.setLayoutData(gridData);

        Label label = new Label(composite2, SWT.NONE);
        label.setText("Start IP Address");
        gridData = new GridData();
        label.setLayoutData(gridData);

        startIPAddressText = new Text(composite2, SWT.BORDER);
        startIPAddressText.setBackground(textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH1;
        startIPAddressText.setLayoutData(gridData);

        label = new Label(composite2, SWT.NONE);
        label.setText("End IP Address");
        gridData = new GridData();
        label.setLayoutData(gridData);
        endIPAddressText = new Text(composite2, SWT.BORDER);
        endIPAddressText.setBackground(textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH1;
        endIPAddressText.setLayoutData(gridData);

        label = new Label(composite2, SWT.NONE);
        label.setText("IP Node Check Timeout(sec)");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        pingTimeoutText = new Text(composite2, SWT.BORDER | SWT.RIGHT);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH1;
        pingTimeoutText.setLayoutData(gridData);

        /* Dummy column */
        label = new Label(composite2, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite2, SWT.NONE);
        label.setText("SNMP RO Community");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        snmpROCommunityText = new Text(composite2, SWT.BORDER);
        snmpROCommunityText.setBackground(textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH1;
        snmpROCommunityText.setLayoutData(gridData);

        /* Dummy column */
        label = new Label(composite2, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite2, SWT.NONE);
        label.setText("SNMP Version");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        snmpVersionCombo = new Combo(composite2, SWT.DROP_DOWN | SWT.READ_ONLY);

        snmpVersionCombo.add(SnmpPreference.SNMPV1_DESCRIPTION);
        snmpVersionCombo.add(SnmpPreference.SNMPV2_DESCRIPTION);

        // snmpVersionCombo.add(SnmpPreference.SNMPV3_DESCRIPTION);
        snmpVersionCombo.select(0);

        /* Dummy column */
        label = new Label(composite2, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        /* Dummy column */
        label = new Label(composite2, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = HORIZONTAL_SPAN4;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite3, SWT.NONE);
        label.setText("Check Node Count");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        chekNodeCountText =
            new Text(composite3, SWT.BORDER | SWT.READ_ONLY | SWT.RIGHT);
        chekNodeCountText.setBackground(textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH1;
        chekNodeCountText.setLayoutData(gridData);

        /* Dummy column */
        label = new Label(composite3, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite3, SWT.NONE);
        label.setText("IP Node Count");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);
        ipNodeCountText =
            new Text(composite3, SWT.BORDER | SWT.READ_ONLY | SWT.RIGHT);
        ipNodeCountText.setBackground(textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH1;
        ipNodeCountText.setLayoutData(gridData);

        /* Dummy column */
        label = new Label(composite3, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite3, SWT.NONE);
        label.setText("SNMP Node Count");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        snmpNodeCountText =
            new Text(composite3, SWT.BORDER | SWT.READ_ONLY | SWT.RIGHT);
        snmpNodeCountText.setBackground(textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH1;
        snmpNodeCountText.setLayoutData(gridData);

        /* Dummy column */
        label = new Label(composite3, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        /* Dummy column */
        label = new Label(composite3, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = HORIZONTAL_SPAN4;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        /* m[hComboBoxZbg */
        setNodeKind(composite4);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH1;
        nodeKindCombo.setLayoutData(gridData);

        /* Dummy column */
        label = new Label(composite4, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite4, SWT.NONE);
        label.setText("Node Group");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        nodeGroupText = new Text(composite4, SWT.BORDER);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH1;
        nodeGroupText.setLayoutData(gridData);

        /* Dummy column */
        label = new Label(composite4, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite4, SWT.NONE);
        label.setText("Ping Period(sec)");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        pingPeriodText = new Text(composite4, SWT.BORDER | SWT.RIGHT);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH1;
        pingPeriodText.setLayoutData(gridData);

        /* Dummy column */
        label = new Label(composite4, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite4, SWT.NONE);
        label.setText("SNMP Period(sec)");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        snmpPeriodText = new Text(composite4, SWT.BORDER | SWT.RIGHT);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH1;
        snmpPeriodText.setLayoutData(gridData);

        /* Dummy column */
        label = new Label(composite4, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        /* Dummy column */
        label = new Label(composite4, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = HORIZONTAL_SPAN4;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        scrollComposite.setContent(composite0);
        scrollComposite.setMinSize(
            SCROLL_COMPOSITE_SIZE[0], SCROLL_COMPOSITE_SIZE[1]);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.setExpandVertical(true);

        setTexInitial();

        startButton.setEnabled(true);
        cancelButton.setEnabled(false);

        startIPAddressText.addKeyListener(
            new KeyListener() {
                public void keyPressed(KeyEvent event) {
                }

                public void keyReleased(KeyEvent event) {
                    setIPAddress(startIPAddressText.getText());
                }
            });

        /*
         * XV{^Xi[
         */
        startButton.addSelectionListener(
            new SelectionListener() {
                public void widgetSelected(SelectionEvent event) {
                    startButton.setEnabled(false);
                    cancelButton.setEnabled(true);
                    chekNodeCountText.setText("");
                    ipNodeCountText.setText("");
                    snmpNodeCountText.setText("");

                    getIPAddressList();

                    chekNodeCountText.setText(
                        "0/"
                        + Integer.toString(nodeDiscoveryIPAddressList.size()));

                    String ipTimeout = pingTimeoutText.getText();
                    int timeout = 1;

                    try {
                        timeout = Integer.parseInt(ipTimeout);
                    } catch (NumberFormatException e) {
                        MessageDialog.openError(
                            getEditorSite().getShell(), "Error",
                            "Error IP Node Check Timeout : " + pingTimeoutText);
                        pingTimeoutText.setFocus();

                        startButton.setEnabled(true);
                        cancelButton.setEnabled(false);

                        return;
                    }

                    if (timeout < 1) {
                        MessageDialog.openError(
                            getEditorSite().getShell(), "Error",
                            "Error IP Node Check Timeout >= 1(Sec) : "
                            + pingTimeoutText);
                        pingTimeoutText.setFocus();
                        startButton.setEnabled(true);
                        cancelButton.setEnabled(false);

                        return;
                    }

                    String pingPeriodTime = pingPeriodText.getText();
                    int pingPeriod = INITIAL_PERIOD_TIME_DATA;

                    try {
                        pingPeriod = Integer.parseInt(pingPeriodTime);
                    } catch (NumberFormatException e) {
                        MessageDialog.openError(
                            getEditorSite().getShell(), "Error",
                            "Error Ping Period : " + pingPeriodText);
                        pingPeriodText.setFocus();

                        startButton.setEnabled(true);
                        cancelButton.setEnabled(false);

                        return;
                    }

                    if (pingPeriod < INITIAL_PERIOD_TIME_DATA) {
                        MessageDialog.openError(
                            getEditorSite().getShell(), "Error",
                            "Error Ping Period >= " + INITIAL_PERIOD_TIME_DATA
                            + "(Sec) : " + pingPeriod);
                        pingPeriodText.setFocus();
                        startButton.setEnabled(true);
                        cancelButton.setEnabled(false);

                        return;
                    }

                    String snmpPeriodTime = snmpPeriodText.getText();
                    int snmpPeriod = INITIAL_PERIOD_TIME_DATA;

                    try {
                        snmpPeriod = Integer.parseInt(snmpPeriodTime);
                    } catch (NumberFormatException e) {
                        MessageDialog.openError(
                            getEditorSite().getShell(), "Error",
                            "Error SNMP Period : " + snmpPeriodText);
                        snmpPeriodText.setFocus();

                        startButton.setEnabled(true);
                        cancelButton.setEnabled(false);

                        return;
                    }

                    if (snmpPeriod < INITIAL_PERIOD_TIME_DATA) {
                        MessageDialog.openError(
                            getEditorSite().getShell(), "Error",
                            "Error SNMP Period >= " + INITIAL_PERIOD_TIME_DATA
                            + "(Sec) : " + snmpPeriod);
                        snmpPeriodText.setFocus();
                        startButton.setEnabled(true);
                        cancelButton.setEnabled(false);

                        return;
                    }

                    int snmpVersion = snmpVersionCombo.getSelectionIndex();
                    String ipNodeCheckTimeout =
                        Integer.toString(timeout * 1000);
                    String snmpROCommunity = snmpROCommunityText.getText();
                    String nodeKind = nodeKindCombo.getText();
                    String nodeGroup = nodeGroupText.getText();
                    ThreadAutoNodeDetect.getInstance().setNodeCheckParam(
                        ipNodeCheckTimeout, snmpVersion, snmpROCommunity);

                    ThreadAutoNodeDetect.getInstance().startThread(
                        nodeDiscoveryIPAddressList);
                    startNodeDicoveryTimer(
                        nodeKind, nodeGroup, pingPeriodTime, snmpPeriodTime,
                        snmpROCommunity, snmpVersion);
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                }
            });

        cancelButton.addSelectionListener(
            new SelectionListener() {
                public void widgetSelected(SelectionEvent event) {
                    startButton.setEnabled(true);
                    cancelButton.setEnabled(false);

                    /* m[h\^C}[~ */
                    display.timerExec(
                        ActionBuilderTrapReceiveTable.TIMER_STOP, timerProcessor);
                    ThreadAutoNodeDetect.getInstance().stopThread();
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                }
            });
    }

    /*
     * m[h\^C}[̐Ass܂B
     *
     */
    private void startNodeDicoveryTimer(
        String nodeKind, String nodeGroup, String pingPeriod, String snmpPeriod,
        String snmpROCommunity, int snmpVersion) {
        IEditorSite editorSite = getEditorSite();

        /* \^C}[̐As */
        NodeDetectTimerProcessor.getInstance().setDisplay(display);
        NodeDetectTimerProcessor.getInstance().setText(
            editorSite, chekNodeCountText, ipNodeCountText, snmpNodeCountText,
            startButton, cancelButton);
        NodeDetectTimerProcessor.getInstance().setNodeAddParam(
            nodeKind, nodeGroup, pingPeriod, snmpPeriod, snmpROCommunity,
            snmpVersion);
        timerProcessor = NodeDetectTimerProcessor.getInstance();
        display.timerExec(NODE_DISCOVERY_PROCESSOR_TIMER, timerProcessor);
    }

    /*
     * Text̏Zbgs܂B
     */
    private void setTexInitial() {
        snmpROCommunityText.setText(
            EditorNodeOperationInitialData.INITIAL_NODE_SNMP_ROCOMMUNITY);
        pingTimeoutText.setText("1");

        nodeGroupText.setText(
            EditorNodeOperationInitialData.INITIAL_NODE_GROUP);
        pingPeriodText.setText(INITIAL_PERIOD_TIME);
        snmpPeriodText.setText(INITIAL_PERIOD_TIME);

        String localIPAddress = "";

        try {
            localIPAddress = InetAddress.getLocalHost().getHostAddress();
        } catch (UnknownHostException e4) {
            logger.warning("UnknownHostException : " + e4.getMessage());
        }

        setInitialIPAddress(localIPAddress);
    }

    /*
     * m[h𔭌AhX͈͂Zbg܂B
     *
     * @param ipAddress m[hoJnAhX
     */
    private void setInitialIPAddress(String ipAddress) {
        String[] ipArray = ipAddress.split("[.]");

        if (ipArray.length == IPADDRESS_LENGTH) {
            String setIPAddress =
                ipArray[0] + "." + ipArray[1] + "." + ipArray[2] + ".";
            startIPAddressText.setText(setIPAddress + "1");

            if (ipAddress.equals("127.0.0.1")) {
                endIPAddressText.setText(setIPAddress + "1");
            } else {
                endIPAddressText.setText(setIPAddress + "254");
            }
        }
    }

    /*
     * m[hJnIPAhX͂EndAhXZbg܂B
     *
     * @param ipAddress m[hJnIPAhX
     */
    private void setIPAddress(String ipAddress) {
        String[] ipArray = ipAddress.split("[.]");

        if (ipArray.length == IPADDRESS_LENGTH) {
            String setIPAddress =
                ipArray[0] + "." + ipArray[1] + "." + ipArray[2] + ".";

            if (ipAddress.equals("127.0.0.1")) {
                endIPAddressText.setText(setIPAddress + "1");
            } else {
                endIPAddressText.setText(setIPAddress + "254");
            }
        }
    }

    /*
     * m[hIPAhX͈͂AhXListZbg܂B
     *
     */
    private void getIPAddressList() {
        nodeDiscoveryIPAddressList.clear();

        String[] startIPArray = startIPAddressText.getText().split("[.]");

        if (startIPArray.length != IPADDRESS_LENGTH) {
            return;
        }

        String[] endIPArray = endIPAddressText.getText().split("[.]");

        if (endIPArray.length != IPADDRESS_LENGTH) {
            return;
        }

        int startCount = 0;
        int endCount = 0;

        try {
            startCount = Integer.parseInt(startIPArray[3]);
            endCount = Integer.parseInt(endIPArray[3]);
        } catch (NumberFormatException e) {
            return;
        }

        while (startCount <= endCount) {
            String ipAddress =
                startIPArray[0] + "." + startIPArray[1] + "." + startIPArray[2]
                + "." + Integer.toString(startCount);

            nodeDiscoveryIPAddressList.add(ipAddress);
            startCount++;
        }
    }

    /*
     * m[hComboBoxZbg܂B
     *
     * @param composite2 Composite
     */
    private void setNodeKind(Composite composite2) {
        Label label = new Label(composite2, SWT.NONE);
        label.setText("Default Node Kind");

        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        nodeKindCombo = new Combo(composite2, SWT.DROP_DOWN | SWT.READ_ONLY);

        HashMap nodeIconMap = MediaResource.getInstance().getIconDataList();
        Iterator it;

        for (it = nodeIconMap.keySet().iterator(); it.hasNext();) {
            String key = (String) it.next();
            nodeKindCombo.add(key);
        }

        nodeKindCombo.setText(INITIAL_NODE_KIND);
    }

    /**
     * Xe[^XC\Zbg܂B
     */
    protected void setStatusLine() {
        /* Xe[^XC\L */
        statusLineManager =
            (SubStatusLineManager) (getEditorSite().getActionBars()
                                        .getStatusLineManager());
        statusLineManager.setVisible(true);
    }

    /* ( Javadoc)
     * @see java.lang.Object#finalize()
     */
    protected void finalize() throws Throwable {
        super.finalize();

        /* TrapMf[^\^C}[~ */
        display.timerExec(
            ActionBuilderTrapReceiveTable.TIMER_STOP, timerProcessor);
    }
}
