/*
 * Created on 2004/04/01
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.snmp.messageformat;

import java.util.List;

import netjfwatcher.snmp.snmpobject.message.AbstractSnmpObject;
import netjfwatcher.snmp.snmpobject.message.SnmpSequence;


/**
 *
 * The SNMPVarBindList class is a specialization of SNMPSequence that contains a list of
 * SNMPVariablePair objects.
 *
 * @see netjfwatcher.snmp.messageformat.SnmpVariablePair
 *
 *          -- variable bindings
 *
 *          VarBind ::=
 *                  SEQUENCE {
 *                      name
 *                          ObjectName,
 *
 *                     value
 *                         ObjectSyntax
 *                 }
 *
 *         VarBindList ::=
 *                  SEQUENCE OF
 *                     VarBind
 *
 *         END
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class SnmpVarBindList extends SnmpSequence {
    /**
     * Create a new empty variable binding list.
     */
    public SnmpVarBindList() {
        super();
    }

    /**
     *@Return the variable pairs in the list, separated by newlines.
     *
     * @return valueString
     */
    public String toString() {
        List sequence = (List) (this.getValue());

        String valueString = "";

        for (int i = 0; i < sequence.size(); ++i) {
            valueString += (((AbstractSnmpObject) sequence.get(i)).toString()
            + "\n");
        }

        return valueString;
    }
}
