/*
 * Created on 2004/04/01
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.snmp.snmpobject.integer;

import java.math.BigInteger;

import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.preference.SnmpBERCodec;



/**
 * ASN.1 Type(^O)ɂGAUGE32(^O 0x42)ɑΉ32-bitJE^
 * SNMPIuWFNg𑀍삷郁\bhNXłB
 *
 * @see netjfwatcher.snmp.snmpobject.integer.SnmpCounter32
 * @see netjfwatcher.snmp.snmpobject.integer.SnmpCounter64
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class SnmpGauge32 extends SnmpInteger {
    // maximum value is 2^32 - 1 (hack w/ 4*107...)
    private static BigInteger maxValue = new BigInteger("4294967295");

    /**
     * l0SNMP GAUGE32IuWFNg𐶐܂B
     */
    public SnmpGauge32() {
        this(0); // initialize value to 0
        tag = SnmpBERCodec.SNMPGAUGE32_TAG;
        tagDescription = SnmpBERCodec.SNMPGAUGE32;
    }

    /**
     * w̒lSNMP GAUGE32IuWFNg𐶐܂B
     *
     * @param newValue JE^[l
     */
    public SnmpGauge32(long newValue) {
        integerValue = new BigInteger(Long.toString(newValue));

        // peg if value > maxValue
        integerValue = integerValue.min(maxValue);
        tag = SnmpBERCodec.SNMPGAUGE32_TAG;
        tagDescription = SnmpBERCodec.SNMPGAUGE32;
    }

    /**
     * ASN.1 BER encodingf[^ɂSNMP GAUGE32IuWFNg𐶐܂B
     *
     * @param enc ASN.1 BER encodingf[^
     * @throws SnmpBadValueException SNMP GAUGE32IuWFNgɎsꍇ
     */
    public SnmpGauge32(byte[] enc) throws SnmpBadValueException {
        extractValueFromBEREncoding(enc);

        // peg if value > maxValue
        integerValue = integerValue.min(maxValue);
        tag = SnmpBERCodec.SNMPGAUGE32_TAG;
        tagDescription = SnmpBERCodec.SNMPGAUGE32;
    }

    /**
     * SNMP GAUGE32IuWFNgɃf[^Zbg܂B
     *
     * @param newValue ZbgIuWFNgl
     * @throws SnmpBadValueException f[^ZbgɎsꍇ
     */
    public void setValue(Object newValue) throws SnmpBadValueException {
        // plateau when value hits maxValue
        if (newValue instanceof BigInteger) {
            integerValue = (BigInteger) newValue;
            integerValue = integerValue.min(maxValue);
        } else if (newValue instanceof Integer) {
            integerValue = new BigInteger(newValue.toString());
            integerValue = integerValue.min(maxValue);
        } else if (newValue instanceof String) {
            try {
                integerValue = new BigInteger((String) newValue);
                integerValue = integerValue.min(maxValue);
            } catch (NumberFormatException e) {
                throw new SnmpBadValueException(
                    " Gauge32: bad object supplied to set value ");
            }
        } else {
            throw new SnmpBadValueException(
                " Gauge32: bad object supplied to set value ");
        }
    }
}
