/*
 * Created on 2004/10/11
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.snmpagent;

import java.io.FileNotFoundException;
import java.net.SocketException;

import netjfwatcher.application.NetJFWatcherApplication;
import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.engine.filepreference.FilePreference;
import netjfwatcher.snmp.mibtree.AgentMibTree;
import netjfwatcher.snmpagent.AgentCommunicationMonitorView.TimerProcessorThread;
import netjfwatcher.snmpagent.model.AgentDataImport;
import netjfwatcher.snmpagent.model.AgentDataImportException;
import netjfwatcher.snmpagent.process.ThreadAgent;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.osgi.framework.Bundle;


/**
 * SNMP Agente[uɂANVNXłB
 *
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ActionBuilderAgentTable {
    /* Snmp Agentf[^\e[u */
    private Table agentTable;

    /* Xe[^XC}l[W */
    private SubStatusLineManager statusLineManager;

    /* 摜肷邽߂PluginResource bundle */
    private final Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();

    /* Snmp AgentJnANV */
    private IAction startAgentAction = new ActionAgentStart();

    /* Snmp Agent~ANV */
    private IAction stopAgentAction = new ActionStopAgent();

    /* Snmp Agent RestartANV */
    private IAction restartAgentAction = new ActionRestartAgent();

    /* Snmp Agent MIB`t@CC|[gANV */
    private IAction importAgentFileAction = new ActionAgentImportFile();

    /* Snmp Agentj^X^[gANV */
    private IAction monitorStartAction = new ActionAgentMonitorStart();

    /* Snmp Agentj^~ANV */
    private IAction monitorStopAction = new ActionAgentMonitorStop();

    /* Snmp Agentj^샊X^[gANV */
    private IAction monitorRestartAction = new ActionAgentMonitorRestart();

    /**
     * Snmp Agente[uɂANVNX
     * CX^X𐶐܂B
     *
     * @param agentTable Table
     * @param statusLineManager Xe[^XC}l[W
     */
    public ActionBuilderAgentTable(
        final Table agentTable, final SubStatusLineManager statusLineManager) {
        this.agentTable = agentTable;
        this.statusLineManager = statusLineManager;
    }

    /**
     * AgentJnANVԂ܂B
     *
     * @return startAgentAction AgentJnANV
     */
    public IAction actionStartAgent() {
        return startAgentAction;
    }

    /**
     * Agent~ANVԂ܂B
     *
     * @return stopAgentAction Agent~ANV
     */
    public IAction actionStopAgent() {
        return stopAgentAction;
    }

    /**
     * Agent RestartANVԂ܂B
     *
     * @return restartAgentAction Agent RestartANV
     */
    public IAction actionRestartAgent() {
        return restartAgentAction;
    }

    /**
     * Agentt@CImportANVԂ܂B
     *
     * @return importAgentFileAction  Agentt@CImportANV
     */
    public IAction actionImportAgentFile() {
        return importAgentFileAction;
    }

    /**
     *
     *
     * @return monitorStartAction
     */
    public IAction actionMonitorStart() {
        return monitorStartAction;
    }

    /**
     * j^[StopANVԂ܂B
     *
     * @return monitorStopAction j^[StopANV
     */
    public IAction actionMonitorStop() {
        return monitorStopAction;
    }

    /**
     * j^[RestartANVԂ܂B
     *
     * @return monitorRestartAction j^[RestartANV
     */
    public IAction actionMonitorRestart() {
        return monitorRestartAction;
    }

    /**
     * G[WFge[uɊւANV̒ۊNXłB
     *
     * @author Yoshimasa Matsumoto
     * @version 1.0
     */
    private abstract class AbstractNodeAction extends Action {
        /**
         * eANVŎsׂ\bh
         * Ăяo܂B
         */
        public final void run() {
            doTask();
        }

        /**
         * eANVŎsׂ\bhłB
         *
         */
        protected abstract void doTask();
    }

    /**
     * Agent̊JnsANVB
     */
    private final class ActionAgentStart extends AbstractNodeAction {
        /**
         * ImageDescriptorԂ܂B
         *
         * @return ImageDescriptor
         */
        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL(
                bundle.getEntry("icons/agent.gif"));
        }

        /**
         * TextԂ܂B
         *
         * @return Text
         */
        public String getText() {
            return "Agent Start";
        }

        /**
         * ToolTipTextԂ܂B
         *
         * @return ToolTipText
         */
        public String getToolTipText() {
            return "AgentJn܂";
        }

        /**
         * SNMP AgentN܂B
         */
        protected void doTask() {
            Shell shell = new Shell();
            MessageBox alertMessageVox =
                new MessageBox(shell, SWT.YES | SWT.ICON_WARNING);

            if (ThreadAgent.getInstance().checkThread()) {
                alertMessageVox.setMessage("Already agent thraed alive");
                alertMessageVox.open();
                statusLineManager.setMessage(
                    AgentTableView.AGENT_THREAD_ALIVE_MESSAGE);
                shell.dispose();

                return;
            }

            try {
                if (!ThreadAgent.getInstance().startThread(true)) {
                    alertMessageVox.setMessage("Abort agnet thread start");
                    alertMessageVox.open();

                    return;
                }
            } catch (SocketException e) {
                alertMessageVox.setMessage(e.getMessage());
                alertMessageVox.open();
                statusLineManager.setMessage(
                    AgentTableView.AGENT_THREAD_ALIVE_MESSAGE);

                return;
            } finally {
                if (shell != null) {
                    shell.dispose();
                }
            }

            statusLineManager.setMessage(
                AgentTableView.AGENT_THREAD_ALIVE_MESSAGE);

            /* SNMP Agentr[XV */
            if (NetJFWatcherApplication.getAgentOperationView() != null) {
                NetJFWatcherApplication.getAgentOperationView().setText();
                NetJFWatcherApplication.getAgentOperationView().setSysupTime();
            }
        }
    }

    /**
     * Agent~ANVNXłB
     */
    private final class ActionStopAgent extends AbstractNodeAction {
        /**
             * Stop AgentANVImageDescriptorԂ܂B
             *
             * @return Stop AgentANVImageDescriptor
             */
        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL(
                bundle.getEntry("icons/agentstop.gif"));
        }

        /**
         * Stop AgentANVTextԂ܂B
         *
         * @return Stop AgentANVText
         */
        public String getText() {
            return "Stop Agent";
        }

        /**
         * Stop AgentANVToolTipTextԂ܂B
         *
         * @return Stop AgentANVToolTipText
         */
        public String getToolTipText() {
            return "Agent~܂";
        }

        /**
         * SNMP Agnet~܂B
         */
        protected void doTask() {
            ThreadAgent.getInstance().stopReceiving();
            statusLineManager.setMessage(
                AgentTableView.AGENT_THREAD_DEAD_MESSAGE);
        }
    }

    /**
     * AgentċNANVɊւ郁\bhNXłB
     *
     * @author Yoshimasa Matsumoto
     * @version 1.0
     */
    private final class ActionRestartAgent extends AbstractNodeAction {
        /**
        * SnmpG[WFgċNANVImageDescriptorԂ܂B
        *
        * @return ImageDescriptor
        */
        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL(
                bundle.getEntry("icons/agentrestart.gif"));
        }

        /**
         * SnmpG[WFgċNANṼeLXgԂ܂B
         *
         * @return Text
         */
        public String getText() {
            return "AgentċN";
        }

        /**
         * SnmpG[WFgċNANVToolTipTextԂ܂B
         *
         * @return ToolTipText
         */
        public String getToolTipText() {
            return "AgentċN܂";
        }

        /**
         * SnmpG[WFgċN܂B
         *
         */
        protected void doTask() {
            ThreadAgent.getInstance().stopReceiving();

            try {
                if (ThreadAgent.getInstance().startThread(true)) {
                    statusLineManager.setMessage(
                        AgentTableView.AGENT_THREAD_ALIVE_MESSAGE);
                } else {
                    Shell shell = new Shell();
                    MessageBox alertMessageVox =
                        new MessageBox(shell, SWT.YES | SWT.ICON_WARNING);

                    alertMessageVox.setMessage("Abort agnet thread restart");
                    alertMessageVox.open();
                    shell.dispose();

                    return;
                }
            } catch (SocketException e) {
                Shell shell = new Shell();
                MessageBox alertMessageVox =
                    new MessageBox(shell, SWT.YES | SWT.ICON_WARNING);

                alertMessageVox.setMessage(e.getMessage());
                alertMessageVox.open();
                shell.dispose();

                return;
            }
        }
    }

    /**
     * Agent fileC|[gANVNXłB
     */
    private final class ActionAgentImportFile extends AbstractNodeAction {
        /**
         * ImageDescriptorԂ܂B
         *
         * @return ImageDescriptor
         */
        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL(
                bundle.getEntry("icons/import_wiz.gif"));
        }

        /**
         * Import Agent fileANVTextԂ܂B
         *
         * @return Import Agent fileANVText
         */
        public String getText() {
            return "Import Agent file";
        }

        /**
         * Import Agent fileANVToolTipTextԂ܂B
         *
         * @return Import Agent fileANVToolTipText
         */
        public String getToolTipText() {
            return "Agent fileC|[g܂B";
        }

        /**
         * SnmpG[WFgCX^Xf[^C|[g
         * ^XN\bhłB
         * G[WFgCX^Xf[^Zbgɂ
         * āA쒆̃G[WFgMThread~AC
         * X^Xf[^ZbgɃG[WFgMThread
         * N܂A
         */
        protected void doTask() {
            // ǂݍݗp_CAOJ
            Shell shell = new Shell();
            FileDialog openDialog = new FileDialog(shell, SWT.OPEN);
            String openFileName = openDialog.open();

            if (openFileName != null) {
                /* Agent`t@CImportāAAgentċN */
                ThreadAgent.getInstance().stopReceiving();

                agentTable.removeAll();

                TableViewer view =
                    NetJFWatcherApplication.getAgentTableView().getViewer();
                view.refresh();

                AgentMibTree.getInstance().reloadOidTree(
                    FilePreference.AGENT_MIB_DEFINE_FILE);

                AgentDataImport importData = new AgentDataImport();
                String resultSetAgentDataMessage = "";

                try {
                    resultSetAgentDataMessage =
                        importData.setAgentData(openFileName);

                    if (!resultSetAgentDataMessage.equals("")) {
                        MessageBox infoMessageBox =
                            new MessageBox(
                                shell, SWT.YES | SWT.ICON_INFORMATION);

                        infoMessageBox.setMessage(resultSetAgentDataMessage);
                        infoMessageBox.open();
                    }
                } catch (FileNotFoundException e) {
                    MessageBox alertMessageBox =
                        new MessageBox(shell, SWT.YES | SWT.ICON_WARNING);

                    alertMessageBox.setMessage(e.getMessage());
                    alertMessageBox.open();
                    e.printStackTrace();

                    return;
                } catch (AgentDataImportException e) {
                    MessageBox alertMessageBox =
                        new MessageBox(shell, SWT.YES | SWT.ICON_WARNING);

                    alertMessageBox.setMessage(e.getMessage());
                    alertMessageBox.open();
                    e.printStackTrace();

                    return;
                } finally {
                    shell.dispose();
                }

                try {
                    shell = new Shell();
                    ThreadAgent.getInstance().startThread(true);
                } catch (SocketException e) {
                    MessageBox alertMessageBox =
                        new MessageBox(shell, SWT.YES | SWT.ICON_WARNING);

                    alertMessageBox.setMessage(e.getMessage());
                    alertMessageBox.open();
                    e.printStackTrace();

                    return;
                } finally {
                    shell.dispose();
                }
            }
        }
    }

    /**
     * SNMPG[WFg̑Mf[^̃j^[NANV
     * ւ郁\bhNXłB
     *
     * @author Yoshimasa Matsumoto
     * @version 1.0
     */
    private final class ActionAgentMonitorStart extends AbstractNodeAction {
        /**
         * ImageDescriptorԂ܂B
         *
         * @return ImageDescriptor
         */
        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL(
                bundle.getEntry("icons/monitor.gif"));
        }

        /**
         * j^[JnANVTextԂ܂B
         *
         * @return j^[JnANVText
         */
        public String getText() {
            return "MonitorStart";
        }

        /**
         * j^[JnANVToolTipTextԂ܂B
         *
         * @return j^[JnANVToolTipText
         */
        public String getToolTipText() {
            return "MonitorStart܂B";
        }

        /**
         * j^[Jn܂B
         */
        protected void doTask() {
            TimerProcessorThread timerProcessor =
                NetJFWatcherApplication.getAgentCommunicationMonitorView()
                                       .getTimerProcessor();
            NetJFWatcherApplication.getAgentCommunicationMonitorView()
                                   .getDisplay().timerExec(
                AgentCommunicationMonitorView.AGENT_MONITOR_TIMER,
                timerProcessor);
        }
    }

    /**
     * SnmpG[WFg̑Mf[^̃j^[~ANV
     * ւ郁\bhNXłB
     *
     *
     * @author Yoshimasa Matsumoto
     * @version 1.0
     */
    private final class ActionAgentMonitorStop extends AbstractNodeAction {
        /**
         * ImageDescriptorԂ܂B
         *
         * @return ImageDescriptor
         */
        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL(
                bundle.getEntry("icons/monitorstop.gif"));
        }

        /**
         * TextԂ܂B
         *
         * @return Text
         */
        public String getText() {
            return "MonitorStop";
        }

        /**
         * ToolTipTextԂ܂B
         *
         * @return ToolTipText
         */
        public String getToolTipText() {
            return "MonitorStop܂B";
        }

        /**
         * j^[~܂B
         */
        protected void doTask() {
            TimerProcessorThread timerProcessor =
                NetJFWatcherApplication.getAgentCommunicationMonitorView()
                                       .getTimerProcessor();

            /* j^~ */
            NetJFWatcherApplication.getAgentCommunicationMonitorView()
                                   .getDisplay().timerExec(-1, timerProcessor);
        }
    }

    /**
     * SNMPG[WFg̑Mf[^̃j^[ċNANV
     * ւ郁\bhNXłB
     *
     *
     * @author Yoshimasa Matsumoto
     * @version 1.0
     */
    private final class ActionAgentMonitorRestart extends AbstractNodeAction {
        /**
         * ImageDescriptorԂ܂B
         *
         * @return ImageDescriptor
         */
        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL(
                bundle.getEntry("icons/monitorrestart.gif"));
        }

        /**
         * eLXgԂ܂B
         *
         * @return eLXg
         */
        public String getText() {
            return "MonitorRestart";
        }

        /**
         * ToolTipTextԂ܂B
         *
         * @return ToolTipText
         */
        public String getToolTipText() {
            return "MonitorRestart܂B";
        }

        /**
         * SnmpG[WFg̑Mf[^̃j^[ċN
         * 郁\bhłB
         */
        protected void doTask() {
            TimerProcessorThread timerProcessor =
                NetJFWatcherApplication.getAgentCommunicationMonitorView()
                                       .getTimerProcessor();

            /* j^~ */
            NetJFWatcherApplication.getAgentCommunicationMonitorView()
                                   .getDisplay().timerExec(-1, timerProcessor);

            /* j^N */
            NetJFWatcherApplication.getAgentCommunicationMonitorView()
                                   .getDisplay().timerExec(
                AgentCommunicationMonitorView.AGENT_MONITOR_TIMER,
                timerProcessor);
        }
    }
}
