/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.snmpagent;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;

import netjfwatcher.engine.resource.SnmpAgentConfigInfo;
import netjfwatcher.engine.resource.SnmpV3AgentConfig;
import netjfwatcher.engine.resource.SnmpV3AgentConfigInfo;
import netjfwatcher.snmp.mibtree.MibInfo;
import netjfwatcher.snmp.preference.SnmpPreference;
import netjfwatcher.snmpagent.model.AgentInstanceDataRefreshQueue;
import netjfwatcher.snmpagent.process.AgentSysupTime;
import netjfwatcher.snmpagent.process.ThreadAgent;
import netjfwatcher.snmptest.SnmpErrorTest;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;



/**
 * SNMPG[WFgƂĂ̑View\NXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class AgentOperationView extends AbstractAgentView {
    /** EngineIDyEngineSysUpTime\eLXg */
    public static final int TEXT_WIDTH = 120;

    /** eLXg\ */
    public static final int SNMPV3_TEXT_WIDTH = 250;

    /* ^eXgComboBox */
    private static final int COMBO_BOX_WIDTH = 150;

    /* Scroll CompositeTCY */
    private static final int[] SCROLL_COMPOSITE_SIZE = { 950, 400 };

    /* MO */
    private static Logger logger;

    /* EngineID */
    private Text engineIDText;

    /* EngineBoots */
    private Text engineBootText;

    /* Engine N */
    private Text engineStartTimeText;

    /* Engine SysupTime(oߕb) */
    private Text engineSysUpTimeText;

    /* Engine SysupTime(oߔN) */
    private Text engineSysUpTimeDataText;

    /* Sysup TimeXV{^ */
    private Button engineSysUpTimeUpdateButton;

    /* ViewXV{^ */
    private Button refreshButton;

    /* User Name */
    private Text userNameText;

    /* Auth Priv */
    private Text authPrivText;

    /* Auth Protocol */
    private Text authProtocolText;

    /* Auth PassPhrasa */
    private Text authPassPhrasaText;

    /* Priv Protocol */
    private Text privProtocolText;

    /* Priv PassPhrasa */
    private Text privPassPhrasaText;

    /* ^G[eXgICombo Box */
    private Combo snmpErrorTestCombo;

    /* ^G[|[gICombo Box */
    private Combo snmpErrorReportCombo;

    /* ^G[Zbg{^ */
    private Button errorTestSetButton;

    /* ڑzXg\ */
    private Text allowHostText;

    /* Read Community */
    private Text roCommunityText;

    /* Write Community */
    private Text rwCommunityText;

    /* eLXg\BackGroundFi[ */
    private Color textBackColor;

    /* Engine StartTime\tH[}bg */
    private DateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    /**
     * PartControl𐶐܂B
     *
     * @param parent Composite
     */
    public void createPartControl(Composite parent) {
        logger = Logger.getLogger(this.getClass().getName());

        /* TextwiFZbg */
        textBackColor = whiteColor;

        /*
         * eCompositezueLayout
         * ieCompositec1ɔzuj
         */
        ScrolledComposite scrollComposite =
            new ScrolledComposite(parent, SWT.H_SCROLL | SWT.V_SCROLL);

        GridLayout layout = new GridLayout(1, false);
        scrollComposite.setLayout(layout);

        GridLayout gridLayout0 = new GridLayout(1, true);
        Composite baseComposite = new Composite(scrollComposite, SWT.NONE);
        baseComposite.setLayout(gridLayout0);
        baseComposite.setLayoutData(new GridData());

        /*
         * Snmp V3 AgentAhXAOIDȂǂzuComposite
         */
        GridLayout gridLayout = new GridLayout(7, false);
        Composite composite = new Composite(baseComposite, SWT.NULL);

        composite.setLayout(gridLayout);
        composite.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));

        GridData gridData = null;
        gridData = new GridData();

        Label label = new Label(composite, SWT.NONE);
        label.setText("Allow-Host");
        label.setLayoutData(new GridData());
        allowHostText = new Text(composite, SWT.BORDER | SWT.READ_ONLY);

        allowHostText.setEnabled(false);
        allowHostText.setBackground(textBackColor);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        allowHostText.setLayoutData(gridData);

        label = new Label(composite, SWT.NONE);
        label.setText("EngineID");
        label.setLayoutData(new GridData());
        engineIDText = new Text(composite, SWT.BORDER | SWT.READ_ONLY);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = SNMPV3_TEXT_WIDTH;
        engineIDText.setEnabled(false);
        engineIDText.setBackground(textBackColor);
        engineIDText.setLayoutData(gridData);

        label = new Label(composite, SWT.NONE);
        label.setText("Error Test");
        gridData = new GridData();
        label.setLayoutData(gridData);

        snmpErrorTestCombo =
            new Combo(composite, SWT.DROP_DOWN | SWT.READ_ONLY);
        snmpErrorTestCombo.add(SnmpPreference.CORRECT_DESCRIPTION);
        snmpErrorTestCombo.add(SnmpPreference.WRONG_DIGEST_DESCRIPTION);
        snmpErrorTestCombo.add(SnmpPreference.DECRYPTION_ERROR_DESCRIPTION);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = COMBO_BOX_WIDTH;
        snmpErrorTestCombo.setLayoutData(gridData);
        snmpErrorTestCombo.select(0);

        errorTestSetButton = new Button(composite, SWT.NONE);
        errorTestSetButton.setText("Error Set");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;

        // gridData.widthHint = 120;
        errorTestSetButton.setLayoutData(gridData);

        label = new Label(composite, SWT.NONE);
        label.setText("Read Community");
        gridData = new GridData();
        label.setLayoutData(gridData);

        roCommunityText = new Text(composite, SWT.BORDER | SWT.READ_ONLY);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        roCommunityText.setEnabled(false);
        roCommunityText.setBackground(textBackColor);
        roCommunityText.setLayoutData(gridData);

        label = new Label(composite, SWT.NONE);
        label.setText("EngineBoots");
        label.setLayoutData(new GridData());
        engineBootText = new Text(composite, SWT.BORDER | SWT.READ_ONLY);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        engineBootText.setEnabled(false);
        engineBootText.setBackground(textBackColor);
        engineBootText.setLayoutData(gridData);

        /* G[|[gComboBoxZbg */
        setSnmpErrorReportCombo(composite);

        /* Dummy column */
        label = new Label(composite, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite, SWT.NONE);
        label.setText("Write Community");
        gridData = new GridData();
        label.setLayoutData(gridData);

        rwCommunityText = new Text(composite, SWT.BORDER | SWT.READ_ONLY);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        rwCommunityText.setEnabled(false);
        rwCommunityText.setBackground(textBackColor);
        rwCommunityText.setLayoutData(gridData);

        label = new Label(composite, SWT.NONE);
        label.setText("Engine Start Time");
        label.setLayoutData(new GridData());
        engineStartTimeText = new Text(composite, SWT.BORDER | SWT.READ_ONLY);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        engineStartTimeText.setEnabled(false);
        engineStartTimeText.setBackground(textBackColor);
        engineStartTimeText.setLayoutData(gridData);

        /* Dummy column */
        setDummyColumnHorizontalSpan3(composite);

        /* Dummy column */
        setDummyColumnHorizontalSpan2(composite);

        label = new Label(composite, SWT.NONE);
        label.setText("EngineSysUpTime");
        label.setLayoutData(new GridData());
        engineSysUpTimeText = new Text(composite, SWT.BORDER | SWT.READ_ONLY);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = SNMPV3_TEXT_WIDTH;
        engineSysUpTimeText.setEnabled(false);
        engineSysUpTimeText.setBackground(textBackColor);
        engineSysUpTimeText.setLayoutData(gridData);

        /* Dummy column */
        setDummyColumnHorizontalSpan3(composite);

        /* Dummy column */
        setDummyColumnHorizontalSpan2(composite);

        label = new Label(composite, SWT.NONE);
        label.setText("EngineSysUpTime Value (Sec)");
        label.setLayoutData(new GridData());
        engineSysUpTimeDataText = new Text(composite, SWT.BORDER);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        engineSysUpTimeDataText.setLayoutData(gridData);

        engineSysUpTimeUpdateButton = new Button(composite, SWT.NONE);
        engineSysUpTimeUpdateButton.setText("Update");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;

        refreshButton = new Button(composite, SWT.NONE);
        refreshButton.setText("Refresh");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;

        /* Dummy column */
        setDummyColumnHorizontalSpan1(composite);

        /* Dummy column */
        setDummyColumnHorizontalSpan2(composite);

        label = new Label(composite, SWT.NONE);
        label.setText("User Name");
        label.setLayoutData(new GridData());
        userNameText = new Text(composite, SWT.BORDER | SWT.READ_ONLY);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        userNameText.setEnabled(false);
        userNameText.setBackground(textBackColor);
        userNameText.setLayoutData(gridData);

        /* Dummy column */
        setDummyColumnHorizontalSpan3(composite);

        /* Dummy column */
        setDummyColumnHorizontalSpan2(composite);

        label = new Label(composite, SWT.NONE);
        label.setText("AuthPriv");
        label.setLayoutData(new GridData());
        authPrivText = new Text(composite, SWT.BORDER | SWT.READ_ONLY);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        authPrivText.setEnabled(false);
        authPrivText.setBackground(textBackColor);
        authPrivText.setLayoutData(gridData);

        /* Dummy column */
        setDummyColumnHorizontalSpan3(composite);

        /* Dummy column */
        setDummyColumnHorizontalSpan2(composite);

        label = new Label(composite, SWT.NONE);
        label.setText("AuthProtocol");
        label.setLayoutData(new GridData());
        authProtocolText = new Text(composite, SWT.BORDER | SWT.READ_ONLY);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        authProtocolText.setEnabled(false);
        authProtocolText.setBackground(textBackColor);
        authProtocolText.setLayoutData(gridData);

        /* Dummy column */
        setDummyColumnHorizontalSpan3(composite);

        /* Dummy column */
        setDummyColumnHorizontalSpan2(composite);

        label = new Label(composite, SWT.NONE);
        label.setText("AuthPassPhrase");
        label.setLayoutData(new GridData());
        authPassPhrasaText = new Text(composite, SWT.BORDER | SWT.READ_ONLY);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        authPassPhrasaText.setEnabled(false);
        authPassPhrasaText.setBackground(textBackColor);
        authPassPhrasaText.setLayoutData(gridData);

        /* Dummy column */
        setDummyColumnHorizontalSpan3(composite);

        /* Dummy column */
        setDummyColumnHorizontalSpan2(composite);

        label = new Label(composite, SWT.NONE);
        label.setText("PrivProtocol");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        privProtocolText = new Text(composite, SWT.BORDER | SWT.READ_ONLY);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        privProtocolText.setEnabled(false);
        privProtocolText.setBackground(textBackColor);
        privProtocolText.setLayoutData(gridData);

        /* Dummy column */
        setDummyColumnHorizontalSpan3(composite);

        /* Dummy column */
        setDummyColumnHorizontalSpan2(composite);

        label = new Label(composite, SWT.NONE);
        label.setText("PrivPassPhrase");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);
        privPassPhrasaText = new Text(composite, SWT.BORDER | SWT.READ_ONLY);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        privPassPhrasaText.setEnabled(false);
        privPassPhrasaText.setBackground(textBackColor);
        privPassPhrasaText.setLayoutData(gridData);

        /* Dummy column */
        setDummyColumnHorizontalSpan3(composite);

        scrollComposite.setContent(baseComposite);
        scrollComposite.setMinSize(
            SCROLL_COMPOSITE_SIZE[0], SCROLL_COMPOSITE_SIZE[1]);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.setExpandVertical(true);

        /* ^G[Zbg */
        SnmpErrorTest.getInstance().setAgentErrorControlCode(
            SnmpPreference.CORRECT_DESCRIPTION);
        SnmpErrorTest.getInstance().setAgentErrorReportCode(
            SnmpPreference.CORRECT_DESCRIPTION);

        setText();
        setListener();

        setSysupTime();
    }

    /**
     * TextZbg܂B
     *
     */
    public void setText() {
        /* Allow HostAR~jeB̍\`ǂݍ */
        SnmpAgentConfigInfo snmpCommonInfo =
            SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo()
                             .getSnmpAgentResourceInfo();

        /* Snmp V3G[WFgǂݍ */
        SnmpV3AgentConfigInfo snmpV3info =
            SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo()
                             .getSnmpV3AgentResourceInfo();

        allowHostText.setText(snmpCommonInfo.getAllowHost());
        roCommunityText.setText(snmpCommonInfo.getReadCommunity());
        rwCommunityText.setText(snmpCommonInfo.getWriteCommunity());
        engineIDText.setText(snmpV3info.getSnmpEngineID());
        engineBootText.setText(snmpV3info.getSnmpEngineBoots());
        engineStartTimeText.setText("");
        engineSysUpTimeText.setText("");
        engineSysUpTimeDataText.setText("");

        userNameText.setText(snmpV3info.getUserName());
        authPrivText.setText(snmpV3info.getAuthPriv());
        authProtocolText.setText(snmpV3info.getAuthProtocol());
        authPassPhrasaText.setText(snmpV3info.getAuthPassPhrase());
        privProtocolText.setText(snmpV3info.getPrivProtocol());
        privPassPhrasaText.setText(snmpV3info.getPrivPassPhrase());
    }

    /*
     * ListenerZbg܂B
     *
     */
    private void setListener() {
        refreshButton.addSelectionListener(
            new SelectionListener() {
                public void widgetSelected(SelectionEvent event) {
                    /*
                         * ViewXV
                         */
                    setText();
                    setSysupTime();
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                }
            });

        engineSysUpTimeUpdateButton.addSelectionListener(
            new SelectionListener() {
                public void widgetSelected(SelectionEvent event) {
                    if (
                        MessageDialog.openQuestion(
                                getSite().getShell(),
                                "Confirm Engine SysUp Time",
                                "Engine SysUp Time update ?,"
                                + " Progress time = "
                                + engineSysUpTimeText.getText())) {
                        /*
                         * Engine SysUpTime Textɕ\Ă
                         * f[^SNMP Agent SysUpTimeXV
                         */
                        updateEngineSysUpTime();
                    }
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                }
            });

        /*
         * Engine SysupTimef[^Zbg
         */
        engineSysUpTimeDataText.addKeyListener(
            new KeyListener() {
                /*
                 *  (non-Javadoc)
                 * @see org.eclipse.swt.events
                 * .KeyListener#keyPressed(org.eclipse.swt.events.KeyEvent)
                 */
                public void keyPressed(KeyEvent event) {
                }

                /**
                 * Engine SysUpTimef[^\eLXgKey ReleaseCxg
                 * ɂSysUpTime\f[^eLXg\܂B
                 *
                 */
                public void keyReleased(KeyEvent event) {
                    /*
                         * Engine SysUpTimef[^񂩂SysUpTime\f[^
                         * eLXg\
                         */
                    String engineSysUpTimeDataString =
                        engineSysUpTimeDataText.getText();

                    try {
                        long sysupTimeMills =
                            (Long.parseLong(engineSysUpTimeDataString) * 1000);

                        engineSysUpTimeText.setText(
                            convertTime(sysupTimeMills));
                    } catch (NumberFormatException e1) {
                        logger.warning(
                            "NumberFormatException "
                            + engineSysUpTimeDataString);
                    }
                }
            });

        /*
         * ^G[eXgݒR{BoxXi[
         */
        errorTestSetButton.addSelectionListener(
            new SelectionListener() {
                /**
                     *
                     */
                public void widgetSelected(SelectionEvent e) {
                    logger.info(
                        "Set Error : error code="
                        + snmpErrorTestCombo.getText()
                        + " , report error code="
                        + snmpErrorReportCombo.getText());

                    /* Test Error set */
                    SnmpErrorTest.getInstance().setAgentErrorControlCode(
                        snmpErrorTestCombo.getText());

                    /* Test Report error set */
                    SnmpErrorTest.getInstance().setAgentErrorReportCode(
                        snmpErrorReportCombo.getText());
                }

                /*
                 *  (non-Javadoc)
                 * @see org.eclipse.swt.events
                 * .SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
                 */
                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
    }

    /*
     * G[|[gComboBoxZbg܂B
     *
     * @param composite Composite
     */
    private void setSnmpErrorReportCombo(Composite composite) {
        Label label = new Label(composite, SWT.NONE);
        label.setText("Error Report");

        GridData gridData = new GridData();
        label.setLayoutData(gridData);
        snmpErrorReportCombo =
            new Combo(composite, SWT.DROP_DOWN | SWT.READ_ONLY);
        snmpErrorReportCombo.add(SnmpPreference.CORRECT_DESCRIPTION);
        snmpErrorReportCombo.add(
            SnmpPreference.UNSUPPORTED_SECURITY_LEVEL_DESCRIPTION);
        snmpErrorReportCombo.add(SnmpPreference.NOT_IN_TIME_PACKET_DESCRIPTION);
        snmpErrorReportCombo.add(SnmpPreference.UNKNOWN_USER_NAME_DESCRIPTION);
        snmpErrorReportCombo.add(SnmpPreference.UNKNOWN_ENGINE_ID_DESCRIPTION);
        snmpErrorReportCombo.add(SnmpPreference.WRONG_DIGEST_DESCRIPTION);
        snmpErrorReportCombo.add(SnmpPreference.DECRYPTION_ERROR_DESCRIPTION);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = COMBO_BOX_WIDTH;
        snmpErrorReportCombo.setLayoutData(gridData);
        snmpErrorReportCombo.select(0);
    }

    /**
     * Dummy Column HorizontalSpan 1Zbg܂B
     *
     * @param composite Composite
     */
    private void setDummyColumnHorizontalSpan1(Composite composite) {
        /* Dummy column */
        Label label = new Label(composite, SWT.NONE);
        label.setText("");

        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);
    }

    /**
     * Dummy Column HorizontalSpan 2Zbg܂B
     *
     * @param composite Composite
     */
    private void setDummyColumnHorizontalSpan2(Composite composite) {
        /* Dummy column */
        Label label = new Label(composite, SWT.NONE);
        label.setText("");

        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);
    }

    /**
     * Dummy Column HorizontalSpan 3Zbg܂B
     *
     * @param composite Composite
     */
    private void setDummyColumnHorizontalSpan3(Composite composite) {
        /* Dummy column */
        Label label = new Label(composite, SWT.NONE);
        label.setText("");

        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);
    }

    /**
     * SnmpG[WFg\XV܂B
     * SnmpG[WFgvtFXݒEXVꂽ
     * ɌĂ΂܂B
     *
     */
    public void updateSnmpAgentInfo() {
        /* Allow HostAR~jeB̍\`ǂݍ */
        SnmpAgentConfigInfo snmpCommonInfo =
            SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo()
                             .getSnmpAgentResourceInfo();

        /* Snmp V3G[WFgǂݍ */
        SnmpV3AgentConfigInfo snmpV3info =
            SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo()
                             .getSnmpV3AgentResourceInfo();

        /* G[WFg\eLXgXV */
        allowHostText.setText(snmpCommonInfo.getAllowHost());
        roCommunityText.setText(snmpCommonInfo.getReadCommunity());
        rwCommunityText.setText(snmpCommonInfo.getWriteCommunity());
        engineIDText.setText(snmpV3info.getSnmpEngineID());
        engineBootText.setText(snmpV3info.getSnmpEngineBoots());
        userNameText.setText(snmpV3info.getUserName());
        authPrivText.setText(snmpV3info.getAuthPriv());
        authProtocolText.setText(snmpV3info.getAuthProtocol());
        authPassPhrasaText.setText(snmpV3info.getAuthPassPhrase());
        privProtocolText.setText(snmpV3info.getPrivProtocol());
        privPassPhrasaText.setText(snmpV3info.getPrivPassPhrase());
    }

    /**
     * bNf[^ɕϊ܂B
     *
     * @param time bf[^
     * @return timeData N
     */
    public String convertTime(final long time) {
        int ms; // ms
        int second; // b
        int minute; // 
        int hour; // 
        int day; // 

        /*
         * 10ms(1/100sec)PʂUA1msPʂƂāASecZoł1000Ŋ
         */
        int baseUnit = 1000;

        ms = (int) (time % baseUnit);
        second = (int) ((time / baseUnit) % 60);
        minute = (int) ((time / baseUnit / 60) % 60);
        hour = (int) ((time / baseUnit / 60 / 60) % 24);
        day = (int) (time / baseUnit / 60 / 60 / 24);

        String timeData =
            day + "day  " + hour + "hour  " + minute + "min  " + second
            + "sec  " + ms + "msec";

        return timeData;
    }

    /**
     * Sysup TimeeLXg\܂B
     *
     */
    public void setSysupTime() {
        /* ێĂSNMP Agnet Start Timeǂݏo */
        long agentStartTime = ThreadAgent.getInstance().getStartEngineTime();
        Date agentDate = Calendar.getInstance().getTime();
        agentDate.setTime(agentStartTime);
        engineStartTimeText.setText(dateformat.format(agentDate));

        /* Sysup Time(ғ)Zo */
        long sysupTimeMills = (System.currentTimeMillis() - agentStartTime);

        /* Sysup Time(oߔN)eLXg\ */
        engineSysUpTimeText.setText(convertTime(sysupTimeMills));

        /* Sysup Time(oߕb)eLXg\ */
        engineSysUpTimeDataText.setText(Long.toString(sysupTimeMills / 1000));
    }

    /**
     * Engine SysUpTime Textɕ\Ăf[^SNMP Agent SysUpTime
     * XV܂B
     */
    private void updateEngineSysUpTime() {
        String data = engineSysUpTimeDataText.getText();

        try {
            long sysupTimeMills =
                System.currentTimeMillis() - (Long.parseLong(data) * 1000);

            ThreadAgent.getInstance().setStartEngineTime(sysupTimeMills);

            MibInfo miboid = AgentSysupTime.getInstance().updateSysupTime();
            setSysupTime();

            /* Agente[u\XV */
            AgentInstanceDataRefreshQueue.getInstance().pushQueue(miboid);
        } catch (NumberFormatException e1) {
            MessageBox alertMessageBox =
                new MessageBox(
                    getSite().getShell(), SWT.YES | SWT.ICON_WARNING);

            alertMessageBox.setMessage("Illegal SysupTime data");
            alertMessageBox.open();
            engineSysUpTimeDataText.setFocus();
        }
    }
}
