/*
 * Created on 2004/10/16
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.snmpagent.process;

import java.util.logging.Logger;

import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.messageformat.SnmpMappingTableController;
import netjfwatcher.snmp.messageformat.SnmpTrap2PDU;
import netjfwatcher.snmp.messageformat.SnmpTrapPDU;
import netjfwatcher.snmp.messageformat.SnmpVarBindList;
import netjfwatcher.snmp.messageformat.SnmpVariablePair;
import netjfwatcher.snmp.snmpobject.integer.SnmpTimeTicks;
import netjfwatcher.snmp.snmpobject.message.AbstractSnmpObject;
import netjfwatcher.snmp.snmpobject.message.SnmpObjectIdentifier;
import netjfwatcher.snmp.snmpobject.octetstring.SnmpIPAddress;



/**
 * SNMP AgentłTrapMPDU𐶐郁\bhNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class AgentTrapPDU {
    /* MO */
    private static Logger logger;

    /*
     * SNMP AgentłTrapMPDU𐶐郁\bhNX
     * CX^X𐶐܂B
     */
    private AgentTrapPDU() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * SNMP V1 Agent TrapMPDU𐶐܂B
     * PDUtH[}bg͈ȉłB
     * +--------------------------
     * |Enterprise OID : ID(@x_[̃IuWFNgID)
     * +--------------------------
     * |Agent Address
     * +--------------------------
     * |Generic No. : Trapԍ
     * +--------------------------
     * |Specific No. : gTrapԍ(enterpriseSpecific Trap
     * |               Ɍ肷ԍ)
     * +--------------------------
     * |Timestamp
     * +--------------------------
     * |VarBindList
     * |           ---------------
     * |             Data | OID
     * |                  +-------
     * |                  | Value
     *
     *
     * @param agentIPAddressString AgentAhX
     * @param enterpriseOIDString Enterprise OID
     * @param genericTrap Generic Trap No.
     * @param specificTrap Specific Trap No.
     * @param additionalVariableOID AdditionalVariable OID
     * @param valueString Value
     * @param valueTypeString ValueType
     * @return PDU SnmpTrapPDU
     * @throws SnmpBadValueException Trap PDUňُ킪ꍇ
     */
    public SnmpTrapPDU createV1TrapPDU(
        final String agentIPAddressString, final String enterpriseOIDString,
        final int genericTrap, final int specificTrap,
        final String additionalVariableOID, final String valueString,
        final String valueTypeString) throws SnmpBadValueException {
        // create trap pdu
        SnmpTrapPDU pdu = null;
        SnmpObjectIdentifier enterpriseOID;

        try {
            enterpriseOID = new SnmpObjectIdentifier(enterpriseOIDString);
        } catch (SnmpBadValueException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
            throw e1;
        }

        SnmpIPAddress agentAddress;

        try {
            agentAddress = new SnmpIPAddress(agentIPAddressString);
        } catch (SnmpBadValueException e2) {
            logger.warning(e2.getMessage());
            e2.printStackTrace();
            throw e2;
        }

        long agentStartTime =
            (System.currentTimeMillis()
            - ThreadAgent.getInstance().getStartEngineTime()) / 10;

        SnmpTimeTicks timestamp = new SnmpTimeTicks(agentStartTime);

        // see if have any additional variable pairs to send, and add them to
        // the VarBindList if so
        SnmpVarBindList varBindList = new SnmpVarBindList();

        if (!additionalVariableOID.equals("")) {
            try {
                SnmpObjectIdentifier itemID =
                    new SnmpObjectIdentifier(additionalVariableOID);

                AbstractSnmpObject itemValue =
                    SnmpMappingTableController.getInstance()
                                              .getSnmpObjectInstance(
                        valueTypeString);
                itemValue.setValue(valueString);

                varBindList.addSNMPObject(
                    new SnmpVariablePair(itemID, itemValue));

                // logger.info("VariableOID : " + itemID);
                // logger.info("VariableOID value : " + valueString);
            } catch (SnmpBadValueException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }

        /*
        logger.info("enterpriseOID : " + enterpriseOID);
        logger.info("agentAddress  : " + agentAddress);
        logger.info("genericTrap   : " + genericTrap);
        logger.info("specificTrap  : " + specificTrap);
        logger.info("timestamp     : " + timestamp);
        */
        try {
            pdu = new SnmpTrapPDU(
                    enterpriseOID, agentAddress, genericTrap, specificTrap,
                    timestamp, varBindList);
        } catch (SnmpBadValueException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }

        return pdu;
    }

    /**
     * Snmp V2 Trap PDU𐶐ĕԂ܂B
     *
     * +---------------------------------------
     * | sysUpTime   // {1.3.6.1.2.1.1.3.0}
     * +---------------------------------------
     * | snmpTrapOID // {1.3.6.1.6.3.1.1.4.1.0}
     * +---------------------------------------
     * | varList
     * +---------------------------------------
     *
     * @param snmpTrapOidValue Trap OID
     * @param additionalVariableOID AdditionalVariable OID
     * @param valueString Value
     * @param valueTypeString Value Type
     * @return pdu Snmp V2 Trap PDU
     * @throws SnmpBadValueException Trap PDUňُ킪ꍇ
     */
    public SnmpTrap2PDU createV2Trap2PDU(
        final String snmpTrapOidValue, final String additionalVariableOID,
        final String valueString, final String valueTypeString)
        throws SnmpBadValueException {
        long agentStartTime =
            (System.currentTimeMillis()
            - ThreadAgent.getInstance().getStartEngineTime()) / 10;

        /*
         * snmpTrapOidValueƂ
         * interfaces.ifTable.ifEntry.ifIndex.1
         */

        // String snmpTrapOidValue = "1.3.6.1.2.1.2.2.1.1.1";

        /* SNMPVariablePair */
        SnmpObjectIdentifier varBindOid =
            new SnmpObjectIdentifier(additionalVariableOID);

        AbstractSnmpObject itemValue =
            SnmpMappingTableController.getInstance().getSnmpObjectInstance(
                valueTypeString);
        itemValue.setValue(valueString);

        SnmpVariablePair variablePair =
            new SnmpVariablePair(varBindOid, itemValue);

        SnmpTrap2PDU pdu = null;
        pdu = new SnmpTrap2PDU(agentStartTime, snmpTrapOidValue, variablePair);

        return pdu;
    }

    /**
     * Snmp V3 Trap PDU𐶐ĕԂ܂B
     *
     * +---------------------------------------
     * | sysUpTime   // {1.3.6.1.2.1.1.3.0}
     * +---------------------------------------
     * | snmpTrapOID // {1.3.6.1.6.3.1.1.4.1.0}
     * +---------------------------------------
     * | varList
     * +---------------------------------------
     *
     * @param snmpTrapOidValue Trap OID
     * @param additionalVariableOID AdditionalVariable OID
     * @param valueString Value
     * @param valueTypeString Value Type
     * @return pdu Snmp V3 Trap PDU
     * @throws SnmpBadValueException Trap PDUňُ킪ꍇ
     */
    public SnmpTrap2PDU createV3Trap2PDU(
        final String snmpTrapOidValue, final String additionalVariableOID,
        final String valueString, final String valueTypeString)
        throws SnmpBadValueException {
        long agentStartTime =
            (System.currentTimeMillis()
            - ThreadAgent.getInstance().getStartEngineTime()) / 10;

        /*
         * snmpTrapOidValueƂ
         * interfaces.ifTable.ifEntry.ifIndex.1
         */

        // String snmpTrapOidValue = "1.3.6.1.2.1.2.2.1.1.1";

        /*
         * Trap2 PDU
         */
        /* SNMPVariablePair */
        SnmpObjectIdentifier varBindOid =
            new SnmpObjectIdentifier(additionalVariableOID);
        AbstractSnmpObject itemValue =
            SnmpMappingTableController.getInstance().getSnmpObjectInstance(
                valueTypeString);
        itemValue.setValue(valueString);

        SnmpVariablePair variablePair =
            new SnmpVariablePair(varBindOid, itemValue);
        SnmpTrap2PDU pdu;
        pdu = new SnmpTrap2PDU(agentStartTime, snmpTrapOidValue, variablePair);

        return pdu;
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static AgentTrapPDU getInstance() {
        return SingletonResource.TRAP_PDU_INSTANCE;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final AgentTrapPDU TRAP_PDU_INSTANCE = new AgentTrapPDU();
    }
}
