/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.snmpmanager;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;


/**
 * Snmp}l[WɂG[WFg̃f[^MThreadSNMP}l[W
 * e[u\ThreadԂ̃f[^̂߂̃L[\NXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class SnmpManagerQueue {
    /* L[Xg */
    private static List<String> snmpManagerQueueList;

    /* L[l */
    private static final int QUEUE_LIMIT = 1000;

    /* L[Ɋi[邩ۂtO */
    private boolean isMonitor = false;

    /**
     * Snmp}l[WɂG[WFg̃f[^MThread
     * SNMP}l[We[u\ThreadԂ̃f[^̂߂
     * L[\NXCX^X𐶐܂B
     *
     */
    private SnmpManagerQueue() {
        snmpManagerQueueList = Collections.synchronizedList(new LinkedList<String>());
    }

    /**
     * L[ɃbZ[Wi[܂B
     *
     * @param obj L[Ɋi[郁bZ[W
     */
    public synchronized void pushSnmpManagerQueue(String obj) {
        if (isMonitor) {
            if (snmpManagerQueueList.size() > QUEUE_LIMIT) {
                snmpManagerQueueList.remove(0);
                snmpManagerQueueList.add(obj);
            } else {
                snmpManagerQueueList.add(obj);
            }
        }
    }

    /**
     * L[烁bZ[WPop܂B
     *
     * @return snmpManagerData bZ[WObject
     */
    public synchronized String popSnmpManagerQueue() {
    	String snmpManagerData = null;

        if (snmpManagerQueueList.size() > 0) {
            snmpManagerData = (String)snmpManagerQueueList.get(0);
            snmpManagerQueueList.remove(0);
        }

        return snmpManagerData;
    }

    /**
     * L[Objecti[邩ۂtOZbg܂B
     *
     * @param isMonitor L[Objecti[邩ۂtO
     */
    public void setMonitor(boolean isMonitor) {
        snmpManagerQueueList.clear();
        this.isMonitor = isMonitor;
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static SnmpManagerQueue getInstance() {
        return SingletonResource.RESOURCE;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final SnmpManagerQueue RESOURCE = new SnmpManagerQueue();
    }
}
