/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.snmpmanager;

import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.logging.Logger;

import netjfwatcher.snmp.mibtree.ManagerMibTree;
import netjfwatcher.snmp.preference.SnmpBERCodec;

import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;



/**
 * Tablef[^CSVt@Cɏo͂邽߂̃NXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class TableDataCsvFileOutput {
    /* MO */
    private static Logger logger = null;

    /**
     * Tablef[^CSVt@Cɏo͂邽߂̃NXCX^X
     * ܂B
     */
    private TableDataCsvFileOutput() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * CSVt@CɃf[^write܂B<BR>
     *
     * @param csvFile writeCSVt@C
     * @param table Table
     * @throws FileNotFoundException t@CȂꍇ
     * @throws IOException t@Co͂Ɏsꍇ
     */
    public void writeCSVFile(final String csvFile, Table table)
        throws FileNotFoundException, IOException {
        FileOutputStream fo = null;
        OutputStreamWriter osw = null;
        BufferedWriter bw = null;

        try {
            fo = new FileOutputStream(csvFile);
            osw = new OutputStreamWriter(fo);
            bw = new BufferedWriter(osw);

            TableItem[] items = table.getItems();

            /* e[uRow̃f[^i[z񐶐 */
            Object[] array = new Object[items.length];

            /* Ae[uRowColumnf[^擾 */
            for (int i = 0; i < items.length; i++) {
                array[i] = (String[]) (items[i].getData());
            }

            /* Ae[uRowColumnf[^擾 */
            for (int j = 0; j < items.length; j++) {
                String[] work0 = (String[]) array[j];

                if (
                    work0[OidTableViewLabelProvider.TYPE].equals(SnmpBERCodec.SNMPTIMETICKS)
                        || work0[OidTableViewLabelProvider.TYPE].equals(ManagerMibTree.TIMETICKS)) {
                    /* TimeTicksf[^̓\Jbg */
                    String[] work = work0[OidTableViewLabelProvider.VALUE].split(" ");
                    if (work.length > 0) {
                        work0[OidTableViewLabelProvider.VALUE] = work[0];
                    }
                }
                bw.write(work0[OidTableViewLabelProvider.OID_DESC] + "=" + work0[OidTableViewLabelProvider.VALUE]);
                bw.newLine();
                bw.flush();
            }
        } catch (FileNotFoundException e) {
            /* t@CȂ */
            logger.warning(e.getMessage());
            throw e;
        } catch (IOException e) {
            /* t@Co͂Ɏs */
            logger.warning(e.getMessage());
            throw e;
        } finally {
            // CSVGNX|[gš㏈
            if (bw != null) {
                try {
                    bw.close();
                } catch (IOException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();

                    return;
                }
            }

            if (osw != null) {
                try {
                    osw.close();
                } catch (IOException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();

                    return;
                }
            }

            if (fo != null) {
                try {
                    fo.close();
                } catch (IOException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();

                    return;
                }
            }
        }
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static TableDataCsvFileOutput getInstance() {
        return SingletonResource.RESOURCE;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final TableDataCsvFileOutput RESOURCE = new TableDataCsvFileOutput();
    }
}
