/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.snmpmanager.preferences;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.logging.Logger;

import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.socket.info.ResourceInfo;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.jdom.Document;



/**
 * SNMPvtFXy[WNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class SnmpPreferencePage extends AbstractSnmpPreferencePage {
    /* eLXg\ */
    private static final int TEXT_WIDTH = 120;

    /* MO */
    private static Logger logger;

    /* Snmp}l[WĎPort */
    private Text snmpPortText;

    /* Snmp TrapMPort */
    private Text snmpTrapPortText;

    /* Snmp V1 Timeoutl */
    private Text snmpV1TimeoutText;

    /* Snmp V1 gC */
    private Text snmpV1RetryText;

    /* Snmp V2 Timeoutl */
    private Text snmpV2TimeoutText;

    /* Snmp V2 gC */
    private Text snmpV2RetryText;

    /* Snmp V3 Timeoutl */
    private Text snmpV3TimeoutText;

    /* Snmp V3 gC */
    private Text snmpV3RetryText;

    /* (non-Javadoc)
     * @see org.eclipse.jface.preference.PreferencePage#init(IWorkbench)
     */
    public void init(IWorkbench workbench) {
        logger = Logger.getLogger(this.getClass().getName());

        // Initialize the preference store we wish to use
        setPreferenceStore(NetJFWatcherPlugin.getInstance().getPreferenceStore());
    }

    /* (non-Javadoc)
     * @see org.eclipse.jface.preference.
     * PreferencePage#createContents(Composite)
     */
    protected Control createContents(final Composite parent) {
        Composite entryTable = new Composite(parent, SWT.NULL);
        entryTable.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

        GridLayout gridLayout = new GridLayout(2, false);

        // gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        entryTable.setLayout(gridLayout);

        Label label = new Label(entryTable, SWT.NONE);
        label.setText("Snmp Port");
        label.setLayoutData(new GridData());
        snmpPortText = new Text(entryTable, SWT.BORDER | SWT.RIGHT);

        int snmpPort =
            SystemResourceConfig.getInstance().getResourceFileParse()
                                .getResourceInfo().getSnmpPort();
        snmpPortText.setText(Integer.toString(snmpPort));

        GridData gridData = new GridData();
        gridData.widthHint = TEXT_WIDTH;
        snmpPortText.setLayoutData(gridData);

        label = new Label(entryTable, SWT.NONE);
        label.setText("Snmp Trap Port");
        label.setLayoutData(new GridData());
        snmpTrapPortText = new Text(entryTable, SWT.BORDER | SWT.RIGHT);

        int snmpTrapPort =
            SystemResourceConfig.getInstance().getResourceFileParse()
                                .getResourceInfo().getSnmpTrapPort();
        snmpTrapPortText.setText(Integer.toString(snmpTrapPort));
        gridData = new GridData();
        gridData.widthHint = TEXT_WIDTH;
        snmpTrapPortText.setLayoutData(gridData);

        Group snmpV1Group = new Group(entryTable, SWT.NONE);
        snmpV1Group.setText("Snmp V1");
        snmpV1Group.setLayout(new GridLayout(2, false));
        gridData = new GridData(GridData.FILL_HORIZONTAL);
        gridData.horizontalSpan = 2;
        snmpV1Group.setLayoutData(gridData);

        label = new Label(snmpV1Group, SWT.NONE);
        label.setText("Timeout (ms)");
        label.setLayoutData(new GridData());
        snmpV1TimeoutText = new Text(snmpV1Group, SWT.BORDER | SWT.RIGHT);
        snmpV1TimeoutText.setText(
            SystemResourceConfig.getInstance().getResourceFileParse()
                                .getResourceInfo().getSnmpV1Timeout());
        gridData = new GridData();
        gridData.widthHint = TEXT_WIDTH;
        snmpV1TimeoutText.setLayoutData(gridData);

        label = new Label(snmpV1Group, SWT.NONE);
        label.setText("Retry");
        label.setLayoutData(new GridData());
        snmpV1RetryText = new Text(snmpV1Group, SWT.BORDER | SWT.RIGHT);
        snmpV1RetryText.setText(
            SystemResourceConfig.getInstance().getResourceFileParse()
                                .getResourceInfo().getSnmpV1Retry());
        gridData = new GridData();
        gridData.widthHint = TEXT_WIDTH;
        snmpV1RetryText.setLayoutData(gridData);

        Group snmpV2Group = new Group(entryTable, SWT.NONE);
        snmpV2Group.setText("Snmp V2");
        snmpV2Group.setLayout(new GridLayout(2, false));
        gridData = new GridData(GridData.FILL_HORIZONTAL);
        gridData.horizontalSpan = 2;
        snmpV2Group.setLayoutData(gridData);

        label = new Label(snmpV2Group, SWT.NONE);
        label.setText("Timeout (ms)");
        label.setLayoutData(new GridData());
        snmpV2TimeoutText = new Text(snmpV2Group, SWT.BORDER | SWT.RIGHT);

        snmpV2TimeoutText.setText(
            SystemResourceConfig.getInstance().getResourceFileParse()
                                .getResourceInfo().getSnmpV2Timeout());
        gridData = new GridData();
        gridData.widthHint = TEXT_WIDTH;
        snmpV2TimeoutText.setLayoutData(gridData);
        label = new Label(snmpV2Group, SWT.NONE);
        label.setText("Retry");
        label.setLayoutData(new GridData());
        snmpV2RetryText = new Text(snmpV2Group, SWT.BORDER | SWT.RIGHT);

        // snmpV2RetryText.setEchoChar('*');
        snmpV2RetryText.setText(
            SystemResourceConfig.getInstance().getResourceFileParse()
                                .getResourceInfo().getSnmpV2Retry());
        gridData = new GridData();
        gridData.widthHint = TEXT_WIDTH;
        snmpV2RetryText.setLayoutData(gridData);

        Group snmpV3Group = new Group(entryTable, SWT.NONE);
        snmpV3Group.setText("Snmp V3");
        snmpV3Group.setLayout(new GridLayout(2, false));
        gridData = new GridData(GridData.FILL_HORIZONTAL);
        gridData.horizontalSpan = 2;
        snmpV3Group.setLayoutData(gridData);

        label = new Label(snmpV3Group, SWT.NONE);
        label.setText("Timeout (ms)");
        label.setLayoutData(new GridData());
        snmpV3TimeoutText = new Text(snmpV3Group, SWT.BORDER | SWT.RIGHT);
        snmpV3TimeoutText.setText(
            SystemResourceConfig.getInstance().getResourceFileParse()
                                .getResourceInfo().getSnmpV3Timeout());
        gridData = new GridData();
        gridData.widthHint = TEXT_WIDTH;
        snmpV3TimeoutText.setLayoutData(gridData);
        label = new Label(snmpV3Group, SWT.NONE);
        label.setText("Retry");
        label.setLayoutData(new GridData());
        snmpV3RetryText = new Text(snmpV3Group, SWT.BORDER | SWT.RIGHT);

        // snmpV3RetryText.setEchoChar('*');
        snmpV3RetryText.setText(
            SystemResourceConfig.getInstance().getResourceFileParse()
                                .getResourceInfo().getSnmpV3Retry());
        gridData = new GridData();
        gridData.widthHint = TEXT_WIDTH;
        snmpV3RetryText.setLayoutData(gridData);

        return entryTable;
    }

    /* (non-Javadoc)
     * @see org.eclipse.jface.preference.PreferencePage#performDefaults()
     */
    protected void performDefaults() {
        ResourceInfo info =
            SystemResourceConfig.getInstance().getResourceFileParse()
                                .getResourceInfo();

        snmpPortText.setText(Integer.toString(info.getSnmpPort()));
        snmpTrapPortText.setText(Integer.toString(info.getSnmpTrapPort()));
        snmpV1TimeoutText.setText(info.getSnmpV1Timeout());
        snmpV1RetryText.setText(info.getSnmpV1Retry());
        snmpV2TimeoutText.setText(info.getSnmpV2Timeout());
        snmpV2RetryText.setText(info.getSnmpV2Retry());
        snmpV3TimeoutText.setText(info.getSnmpV3Timeout());
        snmpV3RetryText.setText(info.getSnmpV3Retry());
    }

    /* (non-Javadoc)
     * @see org.eclipse.jface.preference.PreferencePage#performOk()
     */
    public boolean performOk() {
        ResourceInfo info =
            SystemResourceConfig.getInstance().getResourceFileParse()
                                .getResourceInfo();
        String snmpPort = snmpPortText.getText();
        String snmpTrapPort = snmpTrapPortText.getText();
        info.setSnmpPort(Integer.parseInt(snmpPort));
        info.setSnmpTrapPort(Integer.parseInt(snmpTrapPort));

        info.setSnmpV1Timeout(snmpV1TimeoutText.getText());
        info.setSnmpV1Retry(snmpV1RetryText.getText());
        info.setSnmpV2Timeout(snmpV2TimeoutText.getText());
        info.setSnmpV2Retry(snmpV2RetryText.getText());
        info.setSnmpV3Timeout(snmpV3TimeoutText.getText());
        info.setSnmpV3Retry(snmpV3RetryText.getText());

        /* \`XMLt@CXV */
        saveSnmpXMLInfo(info);

        return super.performOk();
    }

    /**
    * SNMP V1/V2C/V3̒`t@Cɏ݂܂B
    *
    * @param resourceInfo \[X
    */
    private void saveSnmpXMLInfo(final ResourceInfo resourceInfo) {
        // Document
        Document dom = null;

        // t@Co̓obt@
        BufferedWriter bufWriter = null;

        /* SNMP\`XVjdom Documet擾 */
        dom = this.updateSNMPResource(resourceInfo);
        /* \[XFileXVobt@[C^[擾 */
        bufWriter =
            SystemResourceConfig.getInstance().getResourceFileParse()
                                .getResourceFileWriter();

        /* XMLt@CXVo */
        this.outputXMLFile(bufWriter, dom);

        if (bufWriter != null) {
            try {
                bufWriter.close();
            } catch (IOException e) {
                logger.warning(
                    "Abort close BufferedWriter for snmp resource : "
                    + e.getMessage());
                e.printStackTrace();
            }
        }

        // XMLt@CɃCgɃCX^XXV
        SystemResourceConfig.getInstance().updateResourceset();
    }

    /**
     * \[XXV邽߂jdom DocumentԂ܂B
     *
     * @param resourceInfo \[X
     * @return dom jdom Document
     */
    public Document updateSNMPResource(final ResourceInfo resourceInfo) {
        Document dom =
            SystemResourceConfig.getInstance().getResourceFileParse()
                                .updateDocument(resourceInfo);

        return dom;
    }
}
