/*
 * Created on 2004/10/20
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.snmpmanager.trap;

import java.util.logging.Logger;

import netjfwatcher.engine.common.model.DataStringDisplay;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.messageformat.SnmpTrap2PDU;
import netjfwatcher.snmp.snmpobject.message.AbstractSnmpObject;
import netjfwatcher.snmp.snmpobject.message.SnmpSequence;



/**
 * TrapM钊ۃNXŁASnmp V1/V2C/V3̊eo[W
 * ɑΉNXɌp܂B
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
abstract class AbstractTrapMessageProcessing extends DataStringDisplay {


    /* MO */
    private static Logger logger;

    /**
     * SNMP V2܂V3TrapMPDUf[^͂ASnmp TrapCX
     * ^X𐶐ĕԂ܂B
     *
     *
     * @param pduData Trap PDUf[^
     *
     * @return trap2PDU SNMPTrap2PDU
     * @throws SnmpBadValueException Trap PDUf[^ُ̏ꍇ
     */
    public SnmpTrap2PDU parseSNMPTrap2PDU(final AbstractSnmpObject pduData)
        throws SnmpBadValueException {
        logger = Logger.getLogger(this.getClass().getName());

        /* MTrapf[^́Ai[GA */
        SnmpSequence trapPDUSequence = null;
        try {
            /* MPDUf[^Trap PDU */
            trapPDUSequence = new SnmpSequence(pduData.getBEREncoding());
        } catch (SnmpBadValueException e2) {
            logger.warning(e2.getMessage());
            e2.printStackTrace();

            throw new SnmpBadValueException(
                "Received SNMP Trap V2/V3 Bad Value : " + e2.getMessage());
        }
        /* SNMPTrap2PDUi[ */
        SnmpTrap2PDU trap2PDU = null;
        if (trapPDUSequence.getSNMPObjectAt(0) instanceof SnmpTrap2PDU) {
            trap2PDU = (SnmpTrap2PDU) trapPDUSequence.getSNMPObjectAt(0);
        }
        return trap2PDU;
    }

}
