/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.socketclient;

import netjfwatcher.application.NetJFWatcherPlugin;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.osgi.framework.Bundle;

/**
 * NCAg[hɂEngine Tree View\ɊւANVNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ActionEngineTreeRefresh extends Action {

	/* TreeView */
	private EngineListView engineListTreeView;

	private Bundle bundle;

	public ActionEngineTreeRefresh() {
		bundle = NetJFWatcherPlugin.getInstance().getBundle();
	}

	/**
	 * ANVs܂B
	 */
	public final void run() {

		doTask();
	}

	/**
	 * ANVs^XNłB
	 * 
	 */
	public void doTask() {
		engineListTreeView.setTreeViewer();
	}

	/**
	 * ImageDescriptorԂ܂B
	 * 
	 * @return ImageDescriptor
	 */
	public ImageDescriptor getImageDescriptor() {
		return ImageDescriptor.createFromURL(bundle
				.getEntry("icons/reload.gif"));
	}

	/**
	 * TextԂ܂B
	 * 
	 * @return Text
	 */
	public String getText() {
		return "Engine list reload";
	}

	/**
	 * ToolTipTextԂ܂B
	 * 
	 * @return ToolTipText
	 */
	public String getToolTipText() {
		return "Engine list reload";
	}

	public void setEngineListTreeViewer(EngineListView engineListTreeView) {
		this.engineListTreeView = engineListTreeView;
	}
}
