/*
 * Created on 2006/08/17
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 *
 */
package netjfwatcher.socketclient;

import java.io.IOException;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.resourceconfig.EngineResourceInfo;

/**
 *  XML SocketڑԂ𐧌䂷ThreadNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class XMLSocketConnectThread implements Runnable {
	/* Thread sleep */
	private static final int WAIT_SLEEP_TIME = 1000;

	public static final String UNCONNECT_MSG = " Unconnect";

	public static final String CONNECT_MSG = " Connect";

	private static Logger logger;

	/* GWڑԃXg */
	private ArrayList engineList;
    private Map engineConnectStateMap;
    
	/* XML SocketڑThreadi[List */
	private List connectThreadList;

	/* XML SocketڑThread */
	private Thread xmlSocketConnectThread;

	/* GWAhXXg */
	private List engineConnectList;

	/* LsitXVɂList擾\tO */
	private boolean isAccess = false;

	private XMLSocketConnectThread() {
		logger = Logger.getLogger(this.getClass().getName());
		engineConnectList = Collections.synchronizedList(new LinkedList());
		connectThreadList = Collections.synchronizedList(new LinkedList());
		engineConnectStateMap = Collections.synchronizedMap(new HashMap());
	}

	public boolean checkThread() {
		if ((xmlSocketConnectThread == null)
				|| !xmlSocketConnectThread.isAlive()) {
			return false;
		}

		return true;
	}

	public boolean startXMLSocketConnectThread(ArrayList engineList) {
		isAccess = false;
		this.engineList = engineList;
		if ((xmlSocketConnectThread == null)
				|| !xmlSocketConnectThread.isAlive()) {
			xmlSocketConnectThread = new Thread(this);

			if (xmlSocketConnectThread != null) {

				xmlSocketConnectThread.start();
			}

			return true;
		}

		return false;
	}

	public void stopXMLSocketConnectThread() {
		isAccess = false;
		if (xmlSocketConnectThread == null) {
			return;
		}
		for (int i = 0; i < connectThreadList.size(); i++) {
			ConnectionEngineThread connectEngine = (ConnectionEngineThread) connectThreadList
					.get(i);
			connectEngine.setThreadRun(false);
		}
		engineConnectList.clear();
		engineConnectStateMap.clear();
		for (int j = 0; j < engineList.size(); j++) {
			String engineAddress = ((EngineResourceInfo) engineList.get(j))
					.getEngineIPaddress();
			engineConnectList.add(engineAddress + UNCONNECT_MSG);
			engineConnectStateMap.put(engineAddress, UNCONNECT_MSG);
		}
		// interrupt receive thread so it will die a natural death
		xmlSocketConnectThread.interrupt();

		/* Thread~܂Loop */
		while ((xmlSocketConnectThread != null)
				&& xmlSocketConnectThread.isAlive()) {
			try {
				Thread.sleep(WAIT_SLEEP_TIME);
			} catch (InterruptedException e) {
				logger.warning(e.getMessage());
				break;
			}
		}
		isAccess = true;

		xmlSocketConnectThread = null;
	}

	/**
	 * TrapM҂XbhłB ۂTrapMSNMP VersioñfBXpb`[ōs܂
	 * 
	 */
	public void run() {
		connectThreadList.clear();
		engineConnectList.clear();
		engineConnectStateMap.clear();
		String engineAddress = "";
		String enginePortString = "";
		for (int i = 0; i < engineList.size(); i++) {

			engineAddress = ((EngineResourceInfo) engineList.get(i))
					.getEngineIPaddress();
			enginePortString = SystemResourceConfig.getInstance()
					.getResourceFileParse().getResourceInfo()
					.getXmlSocketPort();
			String timeoutString = ((EngineResourceInfo) engineList.get(i))
					.getEngineTimeout();
			try {

				ConnectionEngineThread connectEngine = new ConnectionEngineThread(engineConnectStateMap);
				connectEngine.setXMLSocket(engineAddress, Integer
						.parseInt(enginePortString), Integer
						.parseInt(timeoutString));

				Thread connectEngineThread = new Thread(connectEngine);
				connectEngineThread.start();

				connectThreadList.add(connectEngine);

				engineConnectList.add(engineAddress + CONNECT_MSG);
				engineConnectStateMap.put(engineAddress, CONNECT_MSG);

			} catch (ConnectException e) {
				logger.warning("ConnectException : " + e.getMessage()
						+ " EngineAddress=" + engineAddress + " Port="
						+ enginePortString);
				engineConnectList.add(engineAddress + UNCONNECT_MSG);
				engineConnectStateMap.put(engineAddress, UNCONNECT_MSG);
				// e.printStackTrace();
			} catch (NumberFormatException e) {
				logger.warning("NumberFormatException : " + e.getMessage()
						+ " EngineAddress=" + engineAddress + " Port="
						+ enginePortString);
				engineConnectList.add(engineAddress + UNCONNECT_MSG);
				engineConnectStateMap.put(engineAddress, UNCONNECT_MSG);
				// e.printStackTrace();
			} catch (IOException e) {
				logger.warning("IOException : " + e.getMessage()
						+ " EngineAddress=" + engineAddress + " Port="
						+ enginePortString);
				engineConnectList.add(engineAddress + UNCONNECT_MSG);
				engineConnectStateMap.put(engineAddress, UNCONNECT_MSG);
				// e.printStackTrace();
			}

		}
		isAccess = true;
		while ((xmlSocketConnectThread != null)
				&& !xmlSocketConnectThread.isInterrupted()) {

			try {
				Thread.sleep(WAIT_SLEEP_TIME);
			} catch (InterruptedException e) {
				logger.warning(e.getMessage());
				break;
			}
		}

	}

	/**
	 * ̃NX̃CX^XԂ܂B<BR>
	 * iNXێĂVOgEIuWFNg Ԃ܂j<BR>
	 * 
	 * @return VOgEIuWFNgƂĂ̂̃NX CX^X
	 */
	public static XMLSocketConnectThread getInstance() {
		return SingletonResource.RESOURCE;
	}

	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonResource {
		static final XMLSocketConnectThread RESOURCE = new XMLSocketConnectThread();
	}

	/**
	 * GWڑԃXgԂ܂B
	 * 
	 * @return engineConnectList GWڑԃXg
	 */
	public List getEngineConnectList() {
		return engineConnectList;
	}

	/**
	 * XML SocketڑThreadi[ListԂ܂B
	 * 
	 * @return connectThreadList XML SocketڑThreadi[List
	 */
	public List getConnectThreadList() {
		return connectThreadList;
	}

	/**
	 * LsitXVɂList擾Ԃ܂B
	 * 
	 * @return isAccess ANZXtO
	 */
	public boolean isAccess() {
		return isAccess;
	}

	public Map getEngineConnectStateMap() {
		return engineConnectStateMap;
	}

}
