/*
 * Created on 2006/12/02
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netwatcher.database.view;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.database.access.control.AbstractDataAccessObject;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableDatabaseWatcher;
import netjfwatcher.engine.command.control.CommandMappingTableResource;
import netjfwatcher.engine.nodecontrol.NodeEdit;
import netjfwatcher.engine.nodewatchinfo.NodeWatchInfo;
import netjfwatcher.engine.resource.DatabasePropertyResource;
import netjfwatcher.engine.resourceconfig.ClientEngineInfo;
import netjfwatcher.engine.server.protocol.control.ListQueueDatabaseWatchControl;
import netjfwatcher.engine.server.protocol.database.DatabaseCheck;
import netjfwatcher.engine.socket.ConnectionNodeControl;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.DatabasePropertyInfo;
import netjfwatcher.engine.socket.info.DatabaseWatcherInfo;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.view.editorpart.common.AbstractEditorNodeView;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeView;

import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class EditorDatabaseWatcherConfigView extends AbstractEditorNodeView {
	/** View^CgSuffix */
	public static final String TITLE_SUFFIX = " Database Watcher Config";

	private static final String INITIAL_PERIOD = "300";

	/* f[^x[XeLXg */
	private static final int DATABASE_NAME_TEXT_WIDTH = 200;

	private static final int DATABASE_TEST_LIST_WIDTHHINT = 400;

	private static final int DATABASE_TEST_LIST_ITEM_HEIGHT = 7;

	/* Horizontal Span 6 */
	private static final int HORIZONTAL_SPAN6 = 6;

	private static final int COUNT_TEXT_WIDTH1 = 80;

	private static final int TEXT_WIDTH1 = 200;

	private static final int WIDTH_TEXT_WIDTH1 = 300; // 600;

	protected static Color WHITE_COLOR = new Color(null, 255, 255, 255);

	/* Scroll CompositeTCY */
	private static final int[] SCROLL_COMPOSITE_SIZE = { 800, 600 };

	/* f[^x[Xғ󋵃`FbNPhase1\ */
	private static final String PHASE1 = "Phase 1 : JDBC Driver ";

	/* f[^x[Xғ󋵃`FbNPhase2\ */
	private static final String PHASE2 = "Phase 2 : DriverManager getConnection ";

	/* f[^x[Xғ󋵃`FbNPhase3\ */
	private static final String PHASE3 = "Phase 3 : Database SQL execute ";

	/* f[^x[Xғ󋵃`FbNPhase\z */
	private static final String[] PHASE = { PHASE1, PHASE2, PHASE3 };

	private Color textBackColor;

	/* f[^x[XIR{ */
	private Combo databaseNameCombo;

	private Text watcherPeriodText;

	private Text userNameText;

	private Text passwordText;

	private Text jdbcDriverText;

	private Text connectURLText;

	private Text sqlText;

	/* f[^x[XғeXgʃXg */
	private List resultDatabaseTestList;

	private Button testButton;

	private Button sqlQueryButton;

	private Button startButton;

	private Button stopButton;

	private Button loadButton;

	private Button saveButton;

	private NodeInformation nodeInfo;

	/* f[^x[XvpeB */
	private DatabasePropertyInfo databaseProp;

	/* f[^x[XIXg(Apache dervyȂǂ܂܂ȂĎpf[^x[XXg) */
	private ArrayList databaseSelectList;

	/* Logging */
	private static Logger logger;

	public EditorDatabaseWatcherConfigView() {
		logger = Logger.getLogger(this.getClass().getName());

		textBackColor = WHITE_COLOR;

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.ISaveablePart#isSaveAsAllowed()
	 */
	public boolean isSaveAsAllowed() {
		return false;
	}

	/**
	 * EditorEBhE𐶐܂B
	 * 
	 * @param parent
	 *            Composite
	 */
	public void createPartControl(Composite parent) {

		/* ͐ݒlm[hĎ擾 */
		EditorInputNodeView nodeViewEditorInput = (EditorInputNodeView) getEditorInput();
		nodeInfo = nodeViewEditorInput.getNodeInfo();

		/* f[^x[XvpeBXg(Apache dervyȂǂ܂) */
		ArrayList databasePropList;
		databasePropList = DatabasePropertyResource.getInstance()
				.getdatabasePropList().getDatabasePropList();

		/*
		 * ViewCAEg
		 */
		ScrolledComposite scrollComposite = new ScrolledComposite(parent,
				SWT.H_SCROLL | SWT.V_SCROLL);

		GridLayout layout = new GridLayout(1, false);
		scrollComposite.setLayout(layout);

		GridData gridData = null;

		GridLayout gridLayoutBase = new GridLayout(1, true);
		Composite compositeBase = new Composite(scrollComposite, SWT.NONE);
		compositeBase.setLayout(gridLayoutBase);
		compositeBase
				.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));

		GridLayout gridLayoutURL = new GridLayout(2, false);
		Composite compositeURL = new Composite(compositeBase, SWT.NULL);
		compositeURL.setLayout(gridLayoutURL);
		compositeURL
				.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
		gridData = new GridData();

		GridLayout gridLayout = new GridLayout(2, false);
		Composite composite1 = new Composite(compositeBase, SWT.NULL);
		composite1.setLayout(gridLayout);
		composite1.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
		gridData = new GridData();

		GridLayout gridLayoutButton = new GridLayout(HORIZONTAL_SPAN6, true);
		Composite compositeButton = new Composite(compositeBase, SWT.NONE);
		compositeButton.setLayoutData(new GridData(
				GridData.HORIZONTAL_ALIGN_FILL));
		compositeButton.setLayout(gridLayoutButton);

		GridLayout gridLayouttest = new GridLayout(2, true);
		Composite compositeTest = new Composite(compositeBase, SWT.NONE);
		compositeTest
				.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
		compositeTest.setLayout(gridLayouttest);

		Label label = new Label(composite1, SWT.NONE);
		label.setText("Period(Sec)");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);
		watcherPeriodText = new Text(composite1, SWT.BORDER | SWT.RIGHT);
		watcherPeriodText.setBackground(textBackColor);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = COUNT_TEXT_WIDTH1;
		watcherPeriodText.setLayoutData(gridData);
		watcherPeriodText.setText(INITIAL_PERIOD);

		label = new Label(composite1, SWT.NONE);
		label.setText("Database Name");
		label.setLayoutData(new GridData());
		databaseNameCombo = new Combo(composite1, SWT.DROP_DOWN);
		databaseSelectList = new ArrayList<DatabasePropertyInfo>();
		for (int i = 0; i < databasePropList.size(); i++) {
			String databaseName = ((DatabasePropertyInfo) databasePropList
					.get(i)).getDatabaseName();
			if (!databaseName.equals(AbstractDataAccessObject.DERBY)
					&& !databaseName
							.equals(AbstractDataAccessObject.EMBEDDED_DERBY)
					&& !databaseName.equals(AbstractDataAccessObject.HSQLDB)) {
				/* f[^x[Xt */
				databaseNameCombo.add(databaseName);
				databaseSelectList.add((DatabasePropertyInfo) databasePropList
						.get(i));
			}
		}
		if (databaseSelectList.size() > 0) {
			databaseProp = (DatabasePropertyInfo) databaseSelectList.get(0);
		}
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = DATABASE_NAME_TEXT_WIDTH;
		databaseNameCombo.setLayoutData(gridData);
		databaseNameCombo.setVisibleItemCount(15);
		databaseNameCombo.select(0);

		label = new Label(composite1, SWT.NONE);
		label.setText("JDBC Driver");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);
		jdbcDriverText = new Text(composite1, SWT.BORDER);
		jdbcDriverText.setBackground(textBackColor);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = WIDTH_TEXT_WIDTH1;
		jdbcDriverText.setLayoutData(gridData);

		label = new Label(composite1, SWT.NONE);
		label.setText("Connect URL");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);
		connectURLText = new Text(composite1, SWT.BORDER);
		connectURLText.setBackground(textBackColor);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = WIDTH_TEXT_WIDTH1;
		connectURLText.setLayoutData(gridData);

		label = new Label(composite1, SWT.NONE);
		label.setText("User Name");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);
		userNameText = new Text(composite1, SWT.BORDER);
		userNameText.setBackground(textBackColor);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH1;
		userNameText.setLayoutData(gridData);

		label = new Label(composite1, SWT.NONE);
		label.setText("Password");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);
		passwordText = new Text(composite1, SWT.BORDER | SWT.PASSWORD);
		passwordText.setBackground(textBackColor);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH1;
		passwordText.setLayoutData(gridData);

		label = new Label(composite1, SWT.NONE);
		label.setText("SQL");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);
		sqlText = new Text(composite1, SWT.BORDER);
		sqlText.setBackground(textBackColor);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = WIDTH_TEXT_WIDTH1;
		sqlText.setLayoutData(gridData);

		/* Dummy column */
		label = new Label(compositeURL, SWT.NONE);
		label.setText("");
		GridData gridData2 = new GridData();
		gridData2.horizontalSpan = 1;
		gridData2.verticalSpan = 1;
		label.setLayoutData(gridData2);

		testButton = new Button(compositeTest, SWT.NULL);
		testButton.setText("Test");
		GridData gd = new GridData();
		gd.horizontalSpan = 1;
		testButton.setLayoutData(gd);

		sqlQueryButton = new Button(compositeTest, SWT.CHECK);
		sqlQueryButton
				.setText("Query (selection on/off=executeQuery/executeUpdate)");
		gd = new GridData();
		gd.horizontalSpan = 1;
		sqlQueryButton.setLayoutData(gd);
		sqlQueryButton.setSelection(true);

		resultDatabaseTestList = new List(compositeTest, SWT.SINGLE
				| SWT.BORDER | SWT.H_SCROLL | SWT.V_SCROLL);

		GridData data = new GridData(GridData.FILL_BOTH);
		data.horizontalSpan = 2;
		data.verticalSpan = 1;
		data.widthHint = DATABASE_TEST_LIST_WIDTHHINT;
		data.heightHint = resultDatabaseTestList.getItemHeight()
				* DATABASE_TEST_LIST_ITEM_HEIGHT;

		resultDatabaseTestList.select(0);
		resultDatabaseTestList.setLayoutData(data);

		startButton = new Button(compositeButton, SWT.NULL);
		startButton.setText("Start");
		gd = new GridData();
		gd.horizontalSpan = 1;
		startButton.setLayoutData(gd);

		stopButton = new Button(compositeButton, SWT.NULL);
		stopButton.setText("Stop");
		gd = new GridData();
		gd.horizontalSpan = 1;
		stopButton.setLayoutData(gd);

		loadButton = new Button(compositeButton, SWT.NULL);
		loadButton.setText("Load");
		gd = new GridData();
		gd.horizontalSpan = 1;
		loadButton.setLayoutData(gd);

		saveButton = new Button(compositeButton, SWT.NULL);
		saveButton.setText("Save");
		gd = new GridData();
		gd.horizontalSpan = 1;
		saveButton.setLayoutData(gd);

		scrollComposite.setContent(compositeBase);
		scrollComposite.setMinSize(SCROLL_COMPOSITE_SIZE[0],
				SCROLL_COMPOSITE_SIZE[1]);
		scrollComposite.setExpandHorizontal(true);
		scrollComposite.setExpandVertical(true);

		setSelectionListener();
		setText();
	}

	private void setSelectionListener() {
		testButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				testButton.setEnabled(false);
				BusyIndicator.showWhile(PlatformUI.getWorkbench().getDisplay(),
						new Runnable() {
							public void run() {
								/* Database Test */
								testDatabaseProp();
							}
						});

				testButton.setEnabled(true);

			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		startButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				startButton.setEnabled(false);
				if (checkDatabaseProp()) {
					/* DatabaseĎX^[g */
					startDatabaseWatch(nodeInfo.getIpaddress());
					setText();
				} else {
					startButton.setEnabled(true);
				}
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		stopButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				stopButton.setEnabled(false);
				/* DatabaseĎ~ */
				ListQueueDatabaseWatchControl.getInstance().removeDatabaseNode(
						nodeInfo.getIpaddress());
				setText();

			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		/* Database CombBoxI */
		databaseNameCombo.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent event) {
				int smtpHostSelectIndex = databaseNameCombo.getSelectionIndex();

				databaseProp = (DatabasePropertyInfo) databaseSelectList
						.get(smtpHostSelectIndex);
				setSelectDatabase();
			}
		});
		loadButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {

				loadButton.setEnabled(false);
				setText();
				loadButton.setEnabled(true);

			}
		});
		saveButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				saveButton.setEnabled(false);
				/* DatabaseĎDatabaseɊi[ */
				saveDatabaseInfo();
				setText();
				saveButton.setEnabled(true);
			}
		});
		userNameText.addKeyListener(new KeyListener() {
			public void keyPressed(KeyEvent event) {
			}

			public void keyReleased(KeyEvent event) {
				saveButton.setEnabled(true);
			}
		});
		connectURLText.addKeyListener(new KeyListener() {
			public void keyPressed(KeyEvent event) {
			}

			public void keyReleased(KeyEvent event) {
				saveButton.setEnabled(true);
			}
		});
		sqlText.addKeyListener(new KeyListener() {
			public void keyPressed(KeyEvent event) {
			}

			public void keyReleased(KeyEvent event) {
				saveButton.setEnabled(true);
			}
		});

	}

	private void setSelectDatabase() {
		jdbcDriverText.setText(databaseProp.getDatabaseDriver());
		connectURLText.setText(databaseProp.getDatabaseUrl()
				+ "<database name>");
		userNameText.setText(databaseProp.getDatabaseUser());
		passwordText.setText(databaseProp.getDatabasePassword());
		sqlText.setText("Exp. select * from <table>");
	}

	private void saveDatabaseInfo() {
		if (checkText()) {
			return;
		}

		DatabaseWatcherInfo databaseInfo = new DatabaseWatcherInfo();

		databaseInfo.setWatcherPeriod(watcherPeriodText.getText());
		databaseInfo.setDatabaseName(databaseNameCombo.getText());
		databaseInfo.setDatabaseUser(userNameText.getText());
		databaseInfo.setDatabasePassword(passwordText.getText());
		databaseInfo.setDatabaseDriver(jdbcDriverText.getText());

		databaseInfo.setDatabaseUrl(connectURLText.getText());
		databaseInfo.setDatabaseSQL(sqlText.getText());
		databaseInfo.setDatabaseExpect("");
		databaseInfo.setQuery(sqlQueryButton.getSelection());
		try {
			DatabaseWatcherInfo workDatabaseInfo = loadNetworkCameraInfo();
			if (workDatabaseInfo != null) {
				DBTableDatabaseWatcher.getInstance().updateDatabaseWatcher(
						nodeInfo.getIpaddress(), databaseInfo);
			} else {
				DBTableDatabaseWatcher.getInstance().putDatabaseWatcher(
						nodeInfo.getIpaddress(), databaseInfo);
			}
		} catch (SQLException e1) {
			Shell shell = new Shell();
			MessageDialog.openError(shell, "Abort Node information get", e1
					.getMessage());
			logger.warning("Abort Node information get" + e1.getMessage());
			shell.dispose();
		} catch (Exception e1) {
			Shell shell = new Shell();
			MessageDialog.openError(shell, "Abort Node information get", e1
					.getMessage());
			logger.warning("Abort Node information get" + e1.getMessage());
			shell.dispose();
		}
	}

	/*
	 * Text͏`FbN܂B
	 * 
	 * @return ͏񐳏/ُtO:true=ُ/false:
	 */
	private boolean checkText() {
		boolean isError = true;
		int checkPeriod = 0;
		try {
			checkPeriod = Integer.parseInt(watcherPeriodText.getText());
		} catch (NumberFormatException e) {
			MessageDialog.openError(getEditorSite().getShell(), "Input error",
					"Input error");
			watcherPeriodText.setFocus();
			return isError;
		}
		if (checkPeriod < 60) {
			MessageDialog.openError(getEditorSite().getShell(), "Input error",
					"Please over 60sec.");
			watcherPeriodText.setFocus();
			return isError;
		}
		if (jdbcDriverText.getText().equals("")) {
			MessageDialog.openError(getEditorSite().getShell(), "Input error",
					"Input error");
			jdbcDriverText.setFocus();
			return isError;
		}
		if (connectURLText.getText().equals("")) {
			MessageDialog.openError(getEditorSite().getShell(), "Input error",
					"Input error");
			connectURLText.setFocus();
			return isError;
		}
		if (sqlText.getText().equals("")) {
			MessageDialog.openError(getEditorSite().getShell(), "Input error",
					"Input error");
			sqlText.setFocus();
			return isError;
		}
		return false;
	}

	private void setText() {

		NodeWatchInfo nodeWatchInfo = ListQueueDatabaseWatchControl
				.getInstance().getDatabaseNode(nodeInfo.getIpaddress());
		if (nodeWatchInfo == null) {
			startButton.setEnabled(true);
			stopButton.setEnabled(false);
			loadButton.setEnabled(true);
		} else {
			startButton.setEnabled(false);
			stopButton.setEnabled(true);
			saveButton.setEnabled(false);
			loadButton.setEnabled(false);
		}
		DatabaseWatcherInfo databaseInfo = loadNetworkCameraInfo();

		if (databaseInfo != null) {
			saveButton.setEnabled(true);

			databaseNameCombo.setText(databaseInfo.getDatabaseName());
			jdbcDriverText.setText(databaseInfo.getDatabaseDriver());
			userNameText.setText(databaseInfo.getDatabaseUser());
			passwordText.setText(databaseInfo.getDatabasePassword());
			connectURLText.setText(databaseInfo.getDatabaseUrl());
			watcherPeriodText.setText(databaseInfo.getWatcherPeriod());
			sqlText.setText(databaseInfo.getDatabaseSQL());
			sqlQueryButton.setSelection(databaseInfo.isQuery());

		} else {
			startButton.setEnabled(false);
			saveButton.setEnabled(false);
			loadButton.setEnabled(true);

			if (databaseSelectList.size() > 0) {
				databaseProp = (DatabasePropertyInfo) databaseSelectList.get(0);
				setSelectDatabase();
			} else {
				jdbcDriverText.setText("");
				userNameText.setText("");
				passwordText.setText("");
				connectURLText.setText("");
				sqlText.setText("");
			}
			sqlQueryButton.setSelection(true);
			watcherPeriodText.setText(INITIAL_PERIOD);

		}

	}

	private DatabaseWatcherInfo loadNetworkCameraInfo() {
		DatabaseWatcherInfo databaseInfo = null;
		try {
			databaseInfo = DBTableDatabaseWatcher.getInstance()
					.findDatabaseWatcher(nodeInfo.getIpaddress());

			nodeInfo.setDatabaseWatcherInfo(databaseInfo);

		} catch (SQLException e1) {
			Shell shell = new Shell();
			MessageDialog.openError(shell, "Abort Node information get", e1
					.getMessage());
			logger.warning("Abort Node information get" + e1.getMessage());
			shell.dispose();
		} catch (Exception e1) {
			Shell shell = new Shell();
			MessageDialog.openError(shell, "Abort Node information get", e1
					.getMessage());
			logger.warning("Abort Node information get" + e1.getMessage());
			shell.dispose();
		}
		return databaseInfo;
	}

	private boolean testDatabaseProp() {

		boolean isTestOK = true;
		resultDatabaseTestList.removeAll();

		DatabaseCheck checkDatabase = new DatabaseCheck(
				nodeInfo.getIpaddress(), databaseNameCombo.getText());
		String[] testResult = null;
		try {
			testResult = checkDatabase.checkDatabase(jdbcDriverText.getText(),
					connectURLText.getText(), userNameText.getText(),
					passwordText.getText(), sqlText.getText(), sqlQueryButton
							.getSelection(), true, true);
			testResult = checkDatabase.checkDatabase(jdbcDriverText.getText(),
					connectURLText.getText(), userNameText.getText(),
					passwordText.getText(), sqlText.getText(), sqlQueryButton
							.getSelection(), false, true);
		} catch (Exception e) {
			MessageDialog.openError(getEditorSite().getShell(),
					"Error Database Test", e.getMessage());
			logger.warning("Error Database Test " + e.getMessage());
			isTestOK = false;
		}
		if (testResult != null) {
			/* f[^x[XғeXgʂXgɕ\ */
			for (int i = 0; i < testResult.length; i++) {
				resultDatabaseTestList.add(PHASE[i] + " : " + testResult[i]);

			}
		}
		return isTestOK;
	}

	private void startDatabaseWatch(String ipAddress) {

		if (!isSocket) {

			NodeEdit editNodeInstance = NodeEdit.getInstance();

			try {
				editNodeInstance.editNodeInfo(nodeInfo);
			} catch (DatabaseConnectionException e1) {
				MessageDialog.openError(getEditorSite().getShell(),
						"Abort Database Node", e1.getMessage());
				logger.warning("Abort Node " + e1.getMessage());

				return;
			} catch (SQLException e1) {
				MessageDialog.openError(getEditorSite().getShell(),
						"Abort Database Node", e1.getMessage());
				logger.warning("Abort Database Node " + e1.getMessage());

				return;
			}
		} else {
			String engineAddress = ClientEngineInfo
					.getClientEngineInfoInstance().getEngineAddress();
			ConnectionNodeControl threadstop = new ConnectionNodeControl(
					engineAddress);

			try {
				threadstop.requestThread(ipAddress,
						CommandMappingTableResource.THREAD_RESTART_COMMAND_ID,
						nodeInfo);
			} catch (EngineConnectException e1) {
				Shell shell = new Shell();
				MessageDialog.openError(shell, "Error", "Engine connect error "
						+ e1.getMessage() + " Engine=" + engineAddress);
				shell.dispose();

				return;
			} catch (IOException e1) {
				Shell shell = new Shell();
				MessageDialog.openError(shell, "Error", "Engine connect error "
						+ e1.getMessage() + " Engine=" + engineAddress);
				shell.dispose();

				return;
			}
		}
	}
	private boolean checkDatabaseProp() {

		boolean isTestOK = true;
		DatabaseWatcherInfo databaseInfo = nodeInfo.getDatabaseWatcherInfo();
		DatabaseCheck checkDatabase = new DatabaseCheck(
				nodeInfo.getIpaddress(), databaseNameCombo.getText());
		try {
			checkDatabase.checkDatabase(databaseInfo.getDatabaseDriver(),
					databaseInfo.getDatabaseUrl(), databaseInfo.getDatabaseUser(),
					databaseInfo.getDatabasePassword(), databaseInfo.getDatabasePassword(), databaseInfo.isQuery(), true, true);
			checkDatabase.checkDatabase(databaseInfo.getDatabaseDriver(),
					databaseInfo.getDatabaseUrl(), databaseInfo.getDatabaseUser(),
					databaseInfo.getDatabasePassword(), databaseInfo.getDatabasePassword(), databaseInfo.isQuery(), false, true);
		} catch (Exception e) {
			MessageDialog.openError(getEditorSite().getShell(),
					"Error Database Test", e.getMessage());
			logger.warning("Error Database Test " + e.getMessage());
			isTestOK = false;
		}

		return isTestOK;
	}
	/**
	 * Xe[^XC\Zbg܂B
	 */
	protected void setStatusLine() {
		/* Xe[^XC\L */
		statusLineManager = (SubStatusLineManager) (getEditorSite()
				.getActionBars().getStatusLineManager());
		statusLineManager.setVisible(true);
	}

}
