/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tomcat.internal;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import org.apache.catalina.Connector;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Logger;
import org.apache.catalina.Realm;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.logger.FileLogger;
import org.apache.catalina.net.ServerSocketFactory;
import org.apache.catalina.realm.MemoryRealm;
import org.apache.catalina.startup.Embedded;
import org.apache.coyote.tomcat4.CoyoteConnector;
import org.apache.coyote.tomcat4.CoyoteServerSocketFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.help.internal.appserver.IWebappServer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tomcat.internal.SocketUtil;
import org.eclipse.tomcat.internal.TomcatPlugin;
import org.eclipse.tomcat.internal.TomcatResources;
import org.eclipse.tomcat.internal.WebAppClassLoader;
import org.eclipse.tomcat.internal.extensions.IRealmFactory;

public class TomcatAppServer
implements IWebappServer {
    public static final int SSL_DISABLED = -1;
    private String hostAddress;
    private int port;
    private int sslPort = -1;
    private boolean isStarted = false;
    private boolean running = false;
    private Embedded embedded = null;
    private Engine engine = null;
    private Host host = null;
    private Connector httpConnector = null;
    private Connector sslConnector = null;
    private ArrayList contexts = new ArrayList();

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void start(int port, String hostAddress) throws CoreException {
        this.hostAddress = hostAddress;
        this.port = port;
        if (this.isStarted) {
            return;
        }
        this.isStarted = true;
        try {
            Object var13_16;
            Connector connector;
            FileLogger logger = new FileLogger();
            logger.setDirectory(TomcatPlugin.getDefault().getStateLocation().toOSString());
            this.embedded = new Embedded((Logger)logger, (Realm)new MemoryRealm());
            this.embedded.setDebug(0);
            this.embedded.setLogger((Logger)logger);
            URL installURL = TomcatPlugin.getDefault().getBundle().getEntry("/");
            URL resolvedURL = FileLocator.resolve((URL)installURL);
            String home = FileLocator.toFileURL((URL)resolvedURL).getFile();
            System.setProperty("catalina.home", home);
            String base = home;
            System.setProperty("catalina.base", base);
            if (TomcatPlugin.getDefault().getPluginPreferences().getInt("sslPort") >= 0) {
                Realm realm = this.getRealm();
                this.embedded.setRealm(realm);
            }
            this.embedded.start();
            this.engine = this.embedded.createEngine();
            this.host = this.embedded.createHost("localhost", String.valueOf(home) + "/webapps");
            this.engine.setDefaultHost(this.host.getName());
            if (this.host instanceof StandardHost) {
                ((StandardHost)this.host).setErrorReportValveClass("org.eclipse.tomcat.internal.EclipseErrorReportValve");
            }
            this.engine.addChild((Container)this.host);
            PrintStream sysOut = System.out;
            System.setOut(new PrintStream(new ByteArrayOutputStream()));
            try {
                this.embedded.addEngine(this.engine);
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                System.setOut(sysOut);
                throw throwable;
            }
            {
                Object var9_13 = null;
            }
            System.setOut(sysOut);
            Context root = this.embedded.createContext("", String.valueOf(home) + "/webapps/ROOT");
            if (root instanceof StandardContext) {
                ((StandardContext)root).setWorkDir(this.getWorkingDirectory("ROOT"));
            }
            root.setLoader(this.embedded.createLoader(this.getClass().getClassLoader()));
            this.contexts.add(root);
            this.host.addChild((Container)root);
            InetAddress iAddress = null;
            if (this.hostAddress != null) {
                try {
                    iAddress = InetAddress.getByName(this.hostAddress);
                }
                catch (UnknownHostException unknownHostException) {}
            }
            this.updateSslPort(iAddress);
            if (this.port == 0) {
                this.port = SocketUtil.findUnusedLocalPort(iAddress);
                if (this.port == -1) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.tomcat", 0, TomcatResources.TomcatAppServer_start_CannotObtainPort, null));
                }
            }
            if ((connector = this.embedded.createConnector(null, this.port, false)) instanceof CoyoteConnector) {
                int minProcessors;
                int maxProcessors;
                Preferences pref;
                int acceptCount;
                CoyoteConnector connectorImpl = (CoyoteConnector)connector;
                if (iAddress != null) {
                    connectorImpl.setAddress(iAddress.getHostAddress());
                }
                if ((acceptCount = (pref = TomcatPlugin.getDefault().getPluginPreferences()).getInt("acceptCount")) > 0) {
                    connectorImpl.setAcceptCount(acceptCount);
                }
                if ((maxProcessors = pref.getInt("maxProcessors")) > 0) {
                    connectorImpl.setMaxProcessors(maxProcessors);
                }
                if ((minProcessors = pref.getInt("minProcessors")) > 0) {
                    connectorImpl.setMinProcessors(minProcessors);
                }
                if (this.sslPort > 0) {
                    connectorImpl.setRedirectPort(this.sslPort);
                    connectorImpl.setEnableLookups(true);
                    connectorImpl.setConnectionTimeout(20000);
                    connectorImpl.setUseURIValidationHack(false);
                    connectorImpl.setDisableUploadTimeout(true);
                }
                connectorImpl.addLifecycleListener(new LifecycleListener(){

                    public void lifecycleEvent(LifecycleEvent event) {
                        if ("start".equals(event.getType())) {
                            TomcatAppServer.this.running = true;
                        }
                    }
                });
            }
            PrintStream sysErr = System.err;
            System.setErr(new PrintStream(new ByteArrayOutputStream()));
            try {
                this.embedded.addConnector(connector);
                this.httpConnector = connector;
            }
            catch (Throwable throwable) {
                var13_16 = null;
                System.setErr(sysErr);
                throw throwable;
            }
            {
                var13_16 = null;
            }
            System.setErr(sysErr);
            if (this.sslPort > 0) {
                this.createSSLConnector(iAddress, this.sslPort);
            }
            if (this.hostAddress == null) {
                this.hostAddress = "127.0.0.1";
            }
            TomcatPlugin.getDefault().setAppserver(this);
        }
        catch (Exception exc) {
            TomcatPlugin.logError("Exception occurred starting the embedded application server.", exc);
            if (exc instanceof CoreException) {
                throw (CoreException)exc;
            }
            throw new CoreException((IStatus)new Status(4, "org.eclipse.tomcat", 0, TomcatResources.TomcatAppServer_start, (Throwable)exc));
        }
        if (!this.running) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.tomcat", 0, TomcatResources.TomcatAppServer_start, null));
        }
    }

    private int updateSslPort(InetAddress iAddress) throws CoreException {
        this.sslPort = TomcatPlugin.getDefault().getPluginPreferences().getInt("sslPort");
        if (this.sslPort == 0) {
            this.sslPort = SocketUtil.findUnusedLocalPort(iAddress);
            if (this.sslPort == -1) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.tomcat", 0, TomcatResources.TomcatAppServer_start_CannotObtainPort, null));
            }
        }
        return this.sslPort;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createSSLConnector(InetAddress iAddress, int sslport) throws CoreException {
        Object var4_4;
        this.sslConnector = this.embedded.createConnector(null, sslport, false);
        if (this.sslConnector instanceof CoyoteConnector) {
            String keyStorePassword;
            String keyStoreFile;
            String algorithm;
            int minProcessors;
            int maxProcessors;
            Preferences pref;
            int acceptCount;
            CoyoteConnector connectorImpl = (CoyoteConnector)this.sslConnector;
            if (iAddress != null) {
                connectorImpl.setAddress(iAddress.getHostAddress());
            }
            if ((acceptCount = (pref = TomcatPlugin.getDefault().getPluginPreferences()).getInt("acceptCount")) > 0) {
                connectorImpl.setAcceptCount(acceptCount);
            }
            if ((maxProcessors = pref.getInt("maxProcessors")) > 0) {
                connectorImpl.setMaxProcessors(maxProcessors);
            }
            if ((minProcessors = pref.getInt("minProcessors")) > 0) {
                connectorImpl.setMinProcessors(minProcessors);
            }
            connectorImpl.setUseURIValidationHack(false);
            connectorImpl.setDisableUploadTimeout(true);
            connectorImpl.setSecure(true);
            String scheme = pref.getString("sslScheme");
            if (scheme != null && !"".equals(scheme.trim())) {
                connectorImpl.setScheme(scheme);
            }
            connectorImpl.setEnableLookups(true);
            CoyoteServerSocketFactory factory = new CoyoteServerSocketFactory();
            factory.setClientAuth(false);
            String protocol = pref.getString("sslProtocol");
            if (protocol != null && !"".equals(protocol.trim())) {
                factory.setProtocol(protocol);
            }
            if ((algorithm = pref.getString("sslAlgorithm")) != null && !"".equals(algorithm.trim())) {
                factory.setAlgorithm(algorithm);
            }
            if ((keyStoreFile = pref.getString("keyStoreFile")) != null && !"".equals(keyStoreFile.trim())) {
                factory.setKeystoreFile(keyStoreFile);
            }
            if ((keyStorePassword = pref.getString("keyStorePassword")) != null && !"".equals(keyStorePassword.trim())) {
                factory.setKeystorePass(keyStorePassword);
            }
            connectorImpl.setFactory((ServerSocketFactory)factory);
            connectorImpl.setDebug(0);
            connectorImpl.addLifecycleListener(new LifecycleListener(){

                public void lifecycleEvent(LifecycleEvent event) {
                    if ("start".equals(event.getType())) {
                        TomcatAppServer.this.running = true;
                    }
                }
            });
        }
        PrintStream sysErr = System.err;
        System.setErr(new PrintStream(new ByteArrayOutputStream()));
        try {
            this.embedded.addConnector(this.sslConnector);
        }
        catch (Throwable throwable) {
            var4_4 = null;
            System.setErr(sysErr);
            throw throwable;
        }
        {
            var4_4 = null;
        }
        System.setErr(sysErr);
    }

    private Realm getRealm() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.tomcat", "realmfactory");
        Realm realm = null;
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            if (extensions != null && extensions.length == 1) {
                IConfigurationElement[] factoryElements = extensions[0].getConfigurationElements();
                if (factoryElements != null && factoryElements.length == 1) {
                    try {
                        IRealmFactory realmFactory = (IRealmFactory)factoryElements[0].createExecutableExtension("class");
                        realm = realmFactory.createRealm();
                    }
                    catch (CoreException e) {
                        this.logError(TomcatResources.TomcatAppServer_getRealmFactoryFailed, e);
                    }
                } else if (factoryElements == null || factoryElements.length == 0) {
                    this.logError(TomcatResources.TomcatAppServer_missingFactoryElement);
                } else {
                    this.logError(TomcatResources.TomcatAppServer_multipleFactoryElements);
                }
            } else if (extensions == null || extensions.length == 0) {
                this.logError(TomcatResources.TomcatAppServer_missingRealmExtension);
            } else {
                this.logError(TomcatResources.TomcatAppServer_multipleRealmExtensions);
            }
        } else {
            this.logError(TomcatResources.TomcatAppServer_missingRealmExtensionPoint);
        }
        return realm;
    }

    private void logError(String msg) {
        this.logError(msg, null);
    }

    private void logError(String msg, Throwable cause) {
        TomcatPlugin.logError(msg, cause);
    }

    public synchronized void start(String webappName, IPath path, ClassLoader customLoader) throws CoreException {
        if (!this.isStarted) {
            this.start(this.port, this.hostAddress);
        }
        if (!this.running) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.tomcat", 0, NLS.bind((String)TomcatResources.TomcatAppServer_addingWebapp, (Object)webappName, (Object)path.toOSString()), null));
        }
        String contextPath = webappName;
        if (!contextPath.startsWith("/")) {
            contextPath = "/" + contextPath;
        }
        try {
            Context context = this.embedded.createContext(contextPath, path.toOSString());
            if (context instanceof StandardContext) {
                ((StandardContext)context).setWorkDir(this.getWorkingDirectory(webappName));
            }
            WebAppClassLoader webappLoader = new WebAppClassLoader(customLoader);
            context.setLoader(this.embedded.createLoader((ClassLoader)webappLoader));
            this.host.addChild((Container)context);
            this.contexts.add(context);
        }
        catch (Exception exc) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.tomcat", 0, NLS.bind((String)"TomcatAppServer.addingWebapp", (Object)webappName, (Object)path.toOSString()), (Throwable)exc));
        }
    }

    public synchronized void stop(String webappName) throws CoreException {
        if (!this.running) {
            return;
        }
        Context context = (Context)this.host.findChild("/" + webappName);
        if (context != null) {
            this.contexts.remove(context);
            this.embedded.removeContext(context);
        }
    }

    public String getHost() {
        if (!this.running) {
            return null;
        }
        return this.hostAddress;
    }

    public int getPort() {
        if (!this.running) {
            return 0;
        }
        return this.port;
    }

    public boolean isRunning() {
        return this.running;
    }

    public synchronized void stop() throws CoreException {
        if (!this.running) {
            return;
        }
        this.running = false;
        int i = 0;
        while (i < this.contexts.size()) {
            this.embedded.removeContext((Context)this.contexts.get(i));
            this.contexts.remove(this.contexts.get(i));
            ++i;
        }
        try {
            if (this.sslConnector != null) {
                this.embedded.removeConnector(this.sslConnector);
            }
        }
        catch (Exception exc) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.tomcat", 0, TomcatResources.TomcatAppServer_sslConnectorRemove, (Throwable)exc));
        }
        try {
            if (this.httpConnector != null) {
                this.embedded.removeConnector(this.httpConnector);
            }
        }
        catch (Exception exc) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.tomcat", 0, TomcatResources.TomcatAppServer_httpConnectorRemove, (Throwable)exc));
        }
        try {
            this.embedded.removeEngine(this.engine);
        }
        catch (Exception exc) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.tomcat", 0, TomcatResources.TomcatAppServer_engineRemove, (Throwable)exc));
        }
        try {
            this.embedded.stop();
        }
        catch (LifecycleException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.tomcat", 0, TomcatResources.TomcatAppServer_embeddedStop, (Throwable)e));
        }
        this.isStarted = false;
    }

    private String getWorkingDirectory(String webApp) {
        return TomcatPlugin.getDefault().getStateLocation().append(webApp).toOSString();
    }
}

