/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.verifier;

import java.io.File;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Security;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.internal.verifier.SignedBundleHook;

public class KeyStores {
    private static final String JAVA_POLICY_URL = "policy.url.";
    private static final String DEFAULT_KEYSTORE_TYPE = "keystore.type";
    private List keyStores;

    public KeyStores() {
        this.initializeDefaultKeyStores();
    }

    /*
     * Exception decompiling
     */
    private void processKeyStore(String urlSpec, String type, URL rootURL) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [4 : 123->127)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void initializeDefaultKeyStores() {
        this.keyStores = new ArrayList(5);
        String defaultType = Security.getProperty(DEFAULT_KEYSTORE_TYPE);
        String urlSpec = "file:" + FrameworkProperties.getProperty("java.home") + File.separator + "lib" + File.separator + "security" + File.separator + "cacerts";
        this.processKeyStore(urlSpec, defaultType, null);
        urlSpec = "file:" + FrameworkProperties.getProperty("user.home") + File.separator + ".keystore";
        this.processKeyStore(urlSpec, defaultType, null);
        urlSpec = FrameworkProperties.getProperty("osgi.framework.keystore");
        if (urlSpec != null) {
            this.processKeyStore(urlSpec, defaultType, null);
        }
        int index = 1;
        String java_policy = Security.getProperty(JAVA_POLICY_URL + index);
        while (java_policy != null) {
            this.processKeystoreFromLocation(java_policy);
            java_policy = Security.getProperty(JAVA_POLICY_URL + ++index);
        }
    }

    /*
     * Exception decompiling
     */
    private void processKeystoreFromLocation(String location) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [6 : 299->303)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void processKeystoreFromString(String content, URL rootURL) {
        String keyStoreType = null;
        int indexOfSpace = content.indexOf(32);
        if (indexOfSpace == -1) {
            return;
        }
        int secondSpace = content.lastIndexOf(44);
        if (secondSpace == -1) {
            secondSpace = content.length();
        } else {
            keyStoreType = content.substring(secondSpace + 1, content.length()).trim();
        }
        this.processKeyStore(content.substring(indexOfSpace, secondSpace), keyStoreType, rootURL);
    }

    public boolean isTrusted(Certificate cert) {
        Iterator it = this.keyStores.iterator();
        while (it.hasNext()) {
            KeyStore ks = (KeyStore)it.next();
            try {
                if (ks.getCertificateAlias(cert) == null) continue;
                return true;
            }
            catch (KeyStoreException e) {
                SignedBundleHook.log(e.getMessage(), 2, e);
            }
        }
        return false;
    }
}

