/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.application;

import java.sql.SQLException;
import java.util.logging.Logger;
import netjfwatcher.application.ActionBuilderPerspective;
import netjfwatcher.application.Messages;
import netjfwatcher.database.access.model.hsqldb.HsqldbControl;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.application.IActionBarConfigurer;

public final class NetJFWatcherMenuManager {
    private ActionBuilderPerspective perspectiveAction = new ActionBuilderPerspective();
    private static Logger logger;

    private NetJFWatcherMenuManager() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public void fillMenuBar(IWorkbenchWindow window, IActionBarConfigurer configurer) {
        IMenuManager menuBar = configurer.getMenuManager();
        menuBar.add((IContributionItem)this.createFileMenu(window));
        menuBar.add((IContributionItem)this.createWindowMenu(window));
        menuBar.add((IContributionItem)this.createAlarmMenu(window));
        menuBar.add((IContributionItem)this.createPortMenu(window));
        menuBar.add((IContributionItem)this.createMacAddressMenu(window));
        menuBar.add((IContributionItem)this.createSyslogNGMenu(window));
        menuBar.add((IContributionItem)this.createJettyMenu(window));
        menuBar.add((IContributionItem)this.createSSH2Menu(window));
        menuBar.add((IContributionItem)this.createProvisionMenu(window));
        menuBar.add((IContributionItem)this.createHelpMenu(window));
    }

    private MenuManager createFileMenu(IWorkbenchWindow window) {
        MenuManager menu = new MenuManager(Messages.getString("NetJFWatcherMenuManager.0"), "file");
        menu.add((IContributionItem)new GroupMarker("additions"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)ActionFactory.QUIT.create(window));
        return menu;
    }

    private MenuManager createWindowMenu(IWorkbenchWindow window) {
        MenuManager menuManager = new MenuManager(Messages.getString("NetJFWatcherMenuManager.1"), "window");
        MenuManager perspectiveMenu = new MenuManager(Messages.getString("NetJFWatcherMenuManager.2"), Messages.getString("NetJFWatcherMenuManager.3"));
        perspectiveMenu.add(this.perspectiveAction.getActionSnmpBrowser());
        perspectiveMenu.add(this.perspectiveAction.getActionSnmpAgent());
        perspectiveMenu.add(this.perspectiveAction.getActionNetworkWatch());
        perspectiveMenu.add(this.perspectiveAction.getActionNodeManager());
        perspectiveMenu.add(this.perspectiveAction.getActionSocketClient());
        IContributionItem perspectiveList = ContributionItemFactory.PERSPECTIVES_SHORTLIST.create(window);
        perspectiveMenu.add(perspectiveList);
        menuManager.add((IContributionItem)perspectiveMenu);
        menuManager.add((IContributionItem)new Separator("additions"));
        MenuManager showViewMenu = new MenuManager(Messages.getString("NetJFWatcherMenuManager.4"));
        IContributionItem viewList = ContributionItemFactory.VIEWS_SHORTLIST.create(window);
        showViewMenu.add(viewList);
        menuManager.add((IContributionItem)showViewMenu);
        menuManager.add((IContributionItem)new Separator("additions"));
        menuManager.add((IAction)ActionFactory.PREFERENCES.create(window));
        menuManager.add(ContributionItemFactory.OPEN_WINDOWS.create(window));
        return menuManager;
    }

    private MenuManager createAlarmMenu(IWorkbenchWindow window) {
        MenuManager menuManager = new MenuManager("Alarm", "alarmMenu");
        return menuManager;
    }

    private MenuManager createPortMenu(IWorkbenchWindow window) {
        MenuManager menuManager = new MenuManager("Port", "portMenu");
        return menuManager;
    }

    private MenuManager createMacAddressMenu(IWorkbenchWindow window) {
        MenuManager menuManager = new MenuManager("MAC Address", "ifMacMenu");
        return menuManager;
    }

    private MenuManager createSyslogNGMenu(IWorkbenchWindow window) {
        MenuManager menuManager = new MenuManager("Syslog-NG", "syslogMenu");
        return menuManager;
    }

    private MenuManager createJettyMenu(IWorkbenchWindow window) {
        MenuManager menuManager = new MenuManager("Jetty", "jettyMenu");
        return menuManager;
    }

    private MenuManager createSSH2Menu(IWorkbenchWindow window) {
        MenuManager menuManager = new MenuManager("SSH2", "ssh2Menu");
        return menuManager;
    }

    private MenuManager createProvisionMenu(IWorkbenchWindow window) {
        MenuManager menuManager = new MenuManager("Provision", "provisionMenu");
        return menuManager;
    }

    private MenuManager createHelpMenu(IWorkbenchWindow window) {
        MenuManager menu = new MenuManager("Help", "help");
        menu.add((IAction)ActionFactory.HELP_CONTENTS.create(window));
        menu.add((IContributionItem)new GroupMarker("helpStart"));
        menu.add((IContributionItem)new GroupMarker("helpEnd"));
        menu.add((IContributionItem)new GroupMarker("additions"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)ActionFactory.ABOUT.create(window));
        return menu;
    }

    public void stopHsqlDB() {
        try {
            HsqldbControl.getInstance().stopHsqlDBManager();
            HsqldbControl.getInstance().stopHsqlDB();
        }
        catch (ClassNotFoundException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }
        catch (SQLException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }
    }

    public static NetJFWatcherMenuManager getInstance() {
        return SingletonResource.RESOURCE;
    }

    /* synthetic */ NetJFWatcherMenuManager(NetJFWatcherMenuManager netJFWatcherMenuManager) {
        this();
    }

    private static class SingletonResource {
        static final NetJFWatcherMenuManager RESOURCE = new NetJFWatcherMenuManager(null);

        private SingletonResource() {
        }
    }
}

