/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.database.access.model;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;
import netjfwatcher.database.access.control.AbstractDataAccessObject;
import netjfwatcher.database.access.control.DatabaseAccessControlKind;

public final class PostgreSQLDatabaseInit {
    public static final String CREATE = "CREATE DATABASE nodewatch";
    public static final String DROP = "DROP DATABASE nodewatch";
    private static Logger logger = null;

    private PostgreSQLDatabaseInit() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public static PostgreSQLDatabaseInit getInstance() {
        return SingletonResource.RESOURCE;
    }

    public void createDatabase() throws SQLException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        AbstractDataAccessObject databaseProp = DatabaseAccessControlKind.getInstance().getDataAccessObject();
        String databaseName = DatabaseAccessControlKind.getInstance().getDatabaseName();
        String jdbcdriver = databaseProp.getDriver();
        String url = String.valueOf(databaseProp.getDatabaseurl()) + "nodewatch/";
        String username = databaseProp.getUser();
        String password = databaseProp.getPassword();
        Statement stmt = null;
        Connection con = null;
        try {
            try {
                Class.forName(jdbcdriver).newInstance();
                con = DriverManager.getConnection(url, username, password);
                stmt = con.createStatement();
                logger.info("Database Kind : " + databaseName);
                try {
                    stmt.executeUpdate(DROP);
                }
                catch (SQLException e1) {
                    logger.info("DROP DATABASE nodewatch : " + e1.getMessage());
                }
                stmt.executeUpdate(CREATE);
            }
            catch (SQLException e) {
                logger.warning(String.valueOf(databaseName) + " : " + "URL = " + url + " : User = " + username + " : Password = " + password);
                logger.warning(String.valueOf(databaseName) + " : " + e.getMessage());
                throw e;
            }
            catch (IllegalAccessException e) {
                logger.severe("IllegalAccessException " + jdbcdriver + " " + e.getMessage());
                throw e;
            }
            catch (InstantiationException e) {
                logger.severe("InstantiationException " + jdbcdriver + " " + e.getMessage());
                throw e;
            }
            catch (ClassNotFoundException e) {
                logger.severe("ClassNotFoundException " + jdbcdriver + " " + e.getMessage());
                throw e;
            }
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e1) {
                    logger.severe(e1.getMessage());
                    e1.printStackTrace();
                }
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e1) {
                    logger.severe(e1.getMessage());
                    e1.printStackTrace();
                }
            }
        }
    }

    /* synthetic */ PostgreSQLDatabaseInit(PostgreSQLDatabaseInit postgreSQLDatabaseInit) {
        this();
    }

    private static class SingletonResource {
        static final PostgreSQLDatabaseInit RESOURCE = new PostgreSQLDatabaseInit(null);

        private SingletonResource() {
        }
    }
}

