/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.alarm.trap;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.logging.Logger;
import netjfwatcher.application.NetJFWatcherPlugin;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.osgi.framework.Bundle;

public class AlarmTrapResourceFileParse {
    private static final String XML_FILE_VALUE = "value";
    private static final String ROOT = "root";
    private static final String ALARM_TRAP_FLAG = "alarm_trap_flag";
    private static final String TRAP_SEND_ADDRESS = "alarm_trap_send_address";
    private static final String ALARM_TRAP_LEVEL = "alarm_trap_level";
    private String alarmTrapFlag;
    private String serverAddress;
    private String alarmTrapLevel;
    private static Logger logger = null;

    public AlarmTrapResourceFileParse() {
        logger = Logger.getLogger(this.getClass().getName());
        this.setTrapForwardInfo();
    }

    public void setTrapForwardInfo() {
        Document doc = null;
        doc = this.getResourceFileDocumentPath("resources/alarm_trap.xml");
        if (doc == null) {
            logger.severe("Resource File Doc null ");
            return;
        }
        try {
            Element root = doc.getRootElement();
            Element alarmTrapFlagEl = root.getChild(ALARM_TRAP_FLAG);
            Element alarmSendAddressEl = root.getChild(TRAP_SEND_ADDRESS);
            Element alarmTrapLevelEl = root.getChild(ALARM_TRAP_LEVEL);
            this.alarmTrapFlag = alarmTrapFlagEl.getAttributeValue(XML_FILE_VALUE);
            this.serverAddress = alarmSendAddressEl.getAttributeValue(XML_FILE_VALUE);
            this.alarmTrapLevel = alarmTrapLevelEl.getAttributeValue(XML_FILE_VALUE);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    public BufferedWriter getResourceFileWriter() {
        File f = new File("resources/alarm_trap.xml");
        if (f == null) {
            return null;
        }
        BufferedWriter bufferedWriter = null;
        try {
            FileWriter fi = new FileWriter("resources/alarm_trap.xml");
            bufferedWriter = new BufferedWriter(fi);
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return null;
        }
        return bufferedWriter;
    }

    public Document getResourceFileDocumentPath(String file) {
        Document doc = null;
        File f = new File(file);
        if (f == null) {
            logger.warning("Abort create File : " + f.getAbsolutePath());
            return null;
        }
        BufferedReader d = null;
        try {
            FileReader fi = new FileReader(file);
            d = new BufferedReader(fi);
        }
        catch (FileNotFoundException e1) {
            logger.warning("FileNotFoundException : " + f.getPath() + " : " + e1.getMessage());
            logger.warning("FileNotFoundException : " + f.getAbsolutePath() + " : " + e1.getMessage());
            e1.printStackTrace();
            return null;
        }
        try {
            SAXBuilder builder = new SAXBuilder();
            doc = builder.build((Reader)d);
        }
        catch (JDOMException e) {
            logger.warning("JDOMException : " + e.getMessage());
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            logger.warning("NullPointerException : " + e.getMessage());
            e.printStackTrace();
        }
        catch (IOException e) {
            logger.warning("IOException : " + e.getMessage());
            e.printStackTrace();
        }
        return doc;
    }

    protected Document getDocument(String file) {
        URL url;
        Document doc;
        block5: {
            doc = null;
            url = null;
            Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();
            url = bundle.getEntry(file);
            if (url != null) break block5;
            logger.severe("Resource XML file url : " + url);
            return null;
        }
        try {
            SAXBuilder builder = new SAXBuilder();
            doc = builder.build(url.openStream());
        }
        catch (JDOMException e) {
            logger.severe("JDOMException URL= " + url + " " + e.getMessage());
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            logger.severe("NullPointerException URL= " + url + " " + e.getMessage());
            e.printStackTrace();
        }
        catch (IOException e) {
            logger.severe("IOException URL= " + url + " " + e.getMessage());
            e.printStackTrace();
        }
        return doc;
    }

    public Document updateDocument(String trapFlag, String trapAddress, String trapLevel) {
        logger = Logger.getLogger(this.getClass().getName());
        Element rootElement = new Element(ROOT);
        Document doc = new Document(rootElement);
        Element alarmTrapFlagEl = new Element(ALARM_TRAP_FLAG);
        Element alarmTrapAddressEl = new Element(TRAP_SEND_ADDRESS);
        Element alarmTrapLevelEl = new Element(ALARM_TRAP_LEVEL);
        rootElement.addContent((Content)alarmTrapFlagEl);
        rootElement.addContent((Content)alarmTrapAddressEl);
        rootElement.addContent((Content)alarmTrapLevelEl);
        alarmTrapFlagEl.setAttribute(new Attribute(XML_FILE_VALUE, trapFlag));
        alarmTrapAddressEl.setAttribute(new Attribute(XML_FILE_VALUE, trapAddress));
        alarmTrapLevelEl.setAttribute(new Attribute(XML_FILE_VALUE, trapLevel));
        return doc;
    }

    public static AlarmTrapResourceFileParse getInstance() {
        return SingletonResource.TRAP_FORWARD_DEFINE;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public String getAlarmTrapFlag() {
        return this.alarmTrapFlag;
    }

    public String getAlarmTrapLevel() {
        return this.alarmTrapLevel;
    }

    private static class SingletonResource {
        static final AlarmTrapResourceFileParse TRAP_FORWARD_DEFINE = new AlarmTrapResourceFileParse();

        private SingletonResource() {
        }
    }
}

