/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.mail;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Properties;
import java.util.logging.Logger;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import netjfwatcher.engine.alarm.AlarmMessageMake;
import netjfwatcher.engine.mail.MailSendException;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.resource.SystemResourceFileParse;
import netjfwatcher.engine.socket.info.MailProperty;

public final class MailSend {
    private static Logger logger = null;
    private static final String MAIL_SMTP_HOST = "mail.smtp.host";
    private static final String MAIL_FROM = "mail.from";
    private static final String ENC = "ISO-2022-JP";
    private Session session;
    private Properties prop = new Properties();

    private MailSend() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public void checkMailSend(String mailSubject, String mailMessageBody) {
        SystemResourceFileParse resourceset = SystemResourceConfig.getInstance().getResourceFileParse();
        MailProperty[] mailProp = resourceset.getResourceInfo().getMailPropertyList();
        int i = 0;
        while (i < mailProp.length) {
            if (mailProp[i].getMailSendFlag().equals("on")) {
                String from = mailProp[i].getFrom();
                String smtpHost = mailProp[i].getSmtpHost();
                String subject = mailSubject;
                String messageBody = mailMessageBody;
                ArrayList toList = mailProp[i].getToList();
                try {
                    int j = 0;
                    while (j < toList.size()) {
                        this.sendMail(smtpHost, from, (String)toList.get(j), subject, messageBody);
                        ++j;
                    }
                }
                catch (MailSendException e) {
                    logger.warning(e.getMessage());
                    AlarmMessageMake alarmMessage = AlarmMessageMake.getInstance();
                    alarmMessage.setMailSendError(e.getMessage());
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    public void sendMail(String smtpHost, String from, String to, String subject, String content) throws MailSendException {
        try {
            try {
                if (this.session == null || !this.session.getProperties().getProperty(MAIL_SMTP_HOST).equals(smtpHost) || !this.session.getProperties().getProperty(MAIL_FROM).equals(from)) {
                    this.prop.setProperty(MAIL_FROM, from);
                    this.prop.setProperty(MAIL_SMTP_HOST, smtpHost);
                    logger.info("Create session smtp_host : " + smtpHost);
                    logger.info("Create session from : " + from);
                    this.session = Session.getInstance((Properties)this.prop, null);
                }
            }
            catch (NoClassDefFoundError e) {
                logger.warning(e.getMessage());
                throw new MailSendException(e.getMessage());
            }
            if (this.session == null) {
                logger.warning("Session is null at Mail send");
                throw new MailSendException("Session is null at Mail send");
            }
            MimeMessage message = new MimeMessage(this.session);
            message.setFrom((Address)new InternetAddress(from));
            message.setSentDate(Calendar.getInstance().getTime());
            InternetAddress[] dests = new InternetAddress[]{new InternetAddress(to)};
            message.setRecipients(Message.RecipientType.TO, (Address[])dests);
            logger.info("Mail Send to : " + to + " from : " + from);
            logger.info("Mail Send subject : " + subject);
            logger.info("Mail Send content : " + content);
            message.setSubject(subject, ENC);
            message.setText(content, ENC);
            Transport.send((Message)message);
        }
        catch (AddressException e) {
            logger.warning(e.getMessage());
            throw new MailSendException(e.getMessage());
        }
        catch (MessagingException e) {
            logger.warning(e.getMessage());
            throw new MailSendException(e.getMessage());
        }
    }

    public static MailSend getInstance() {
        return SingletonResource.RESOURCE;
    }

    /* synthetic */ MailSend(MailSend mailSend) {
        this();
    }

    private static class SingletonResource {
        static final MailSend RESOURCE = new MailSend(null);

        private SingletonResource() {
        }
    }
}

