/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.mail;

import java.util.logging.Logger;
import netjfwatcher.engine.mail.MailSend;
import netjfwatcher.engine.mail.MailSendInfo;
import netjfwatcher.engine.mail.MailSendInfoList;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.resource.SystemResourceFileParse;

public final class ThreadMailSendGuard
implements Runnable {
    private static Logger logger = null;
    private static final int WAIT_COUNT = 5;
    private static final int MAIL_CONTROL_THREAD_TIMER = 1000;
    private int guardTime = 0;
    private boolean isCountStart = true;
    private Thread mailGuardThread;

    private ThreadMailSendGuard() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public boolean startThread() {
        if (this.mailGuardThread == null) {
            this.mailGuardThread = new Thread(this);
            this.mailGuardThread.start();
            int wait = 0;
            while (!this.mailGuardThread.isAlive()) {
                if (++wait >= 5) break;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            return true;
        }
        return false;
    }

    public void stopReceiving() {
        if (this.mailGuardThread == null) {
            return;
        }
        this.mailGuardThread.interrupt();
        while (this.mailGuardThread != null && this.mailGuardThread.isAlive()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
        logger.info("Thread stop");
        this.mailGuardThread = null;
    }

    public void run() {
        while (this.mailGuardThread != null && this.mailGuardThread.isAlive()) {
            if (this.isCountStart) {
                if (this.guardTime < 0) {
                    MailSendInfo mailData = MailSendInfoList.getInstance().getMailInfo();
                    if (mailData != null) {
                        MailSend mailSender = MailSend.getInstance();
                        mailSender.checkMailSend(mailData.getSubject(), mailData.getMessageBody());
                        SystemResourceFileParse resourceset = SystemResourceConfig.getInstance().getResourceFileParse();
                        this.guardTime = Integer.parseInt(resourceset.getResourceInfo().getMailGuardTime());
                        logger.info("Mail send guard time set : " + this.guardTime);
                    }
                } else {
                    --this.guardTime;
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.info("Stop Mail guard time count " + e.getMessage());
                break;
            }
        }
    }

    public static ThreadMailSendGuard getInstance() {
        return SingletonResource.RESOURCE;
    }

    public Thread getMailGuardThread() {
        return this.mailGuardThread;
    }

    /* synthetic */ ThreadMailSendGuard(ThreadMailSendGuard threadMailSendGuard) {
        this();
    }

    private static class SingletonResource {
        static final ThreadMailSendGuard RESOURCE = new ThreadMailSendGuard(null);

        private SingletonResource() {
        }
    }
}

