/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.model.action;

import java.util.logging.Logger;
import netjfwatcher.common.view.NodeTree;
import netjfwatcher.common.view.NodeTreeGroup;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeView;
import netjfwatcher.engine.view.editorpart.node.EditorNodeConfig;
import netjfwatcher.socketclient.NetworkClientNodeTreeView;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ListenerNodeListTree
implements ISelectionChangedListener {
    private static Logger logger = null;
    private boolean isSocket;

    public ListenerNodeListTree(boolean isSocket) {
        logger = Logger.getLogger(this.getClass().getName());
        this.isSocket = isSocket;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        StructuredSelection ss = (StructuredSelection)event.getSelection();
        logger.info("Tree node  select : " + ss.getFirstElement());
        if (ss.getFirstElement() instanceof NodeTreeGroup) {
            logger.info("NodeTreeGroup ");
            return;
        }
        if (!(ss.getFirstElement() instanceof NodeTree)) {
            logger.info("No NodeTree ");
            return;
        }
        NodeTree entry = (NodeTree)ss.getFirstElement();
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            if (!this.isSocket) {
                activePage.openEditor((IEditorInput)new EditorInputNodeView(String.valueOf(entry.getName()) + " Node View", entry.getNodeInfo(), this.isSocket), EditorNodeConfig.class.getName());
            } else {
                activePage.openEditor((IEditorInput)new EditorInputNodeView(String.valueOf(entry.getName()) + " Node View" + NetworkClientNodeTreeView.getTitleSuffixEngineAddress(), entry.getNodeInfo(), this.isSocket), EditorNodeConfig.class.getName());
            }
        }
        catch (PartInitException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }
    }
}

