/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.nodemaneger.map;

import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Logger;
import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.engine.model.action.ActionBuilderAlarmList;
import netjfwatcher.engine.model.action.ActionBuilderEditorsPartClose;
import netjfwatcher.engine.model.action.ActionBuilderNodeList;
import netjfwatcher.engine.nodemaneger.map.NodeMapViewMouseListener;
import netjfwatcher.engine.socket.info.NodeMapLinkInformation;
import netjfwatcher.engine.view.canvas.CanvasViewConfigFileParse;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;
import org.osgi.framework.Bundle;

public class NodeMapView
extends ViewPart {
    private static Logger logger;
    protected int[] nodeMapViewSize = new int[2];
    protected Color whiteColor = new Color(null, 255, 255, 255);
    protected Color blackColor = new Color(null, 0, 0, 0);
    protected Color redColor = new Color(null, 255, 0, 0);
    protected Display display;
    protected NodeMapViewMouseListener mouseListener;
    protected Canvas canvas;
    protected GC gc;
    protected SubStatusLineManager statusLineManager;
    protected ArrayList nodeMapNodeInfoList = new ArrayList();
    protected NodeMapLinkInformation nodMapLinkInformationList;
    protected Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();
    protected NodeListAction nodeListAction = new NodeListAction();
    protected ActionBuilderEditorsPartClose actionBuilderEditorPart = new ActionBuilderEditorsPartClose();
    protected ActionBuilderAlarmList actionBuilderAlarm = new ActionBuilderAlarmList();

    public NodeMapView() {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    }

    public void createPartControl(Composite parent) {
        this.setCanvasSize();
        if (this.whiteColor == null || this.whiteColor.isDisposed()) {
            this.whiteColor = new Color(null, 255, 255, 255);
        }
        if (this.blackColor == null || this.blackColor.isDisposed()) {
            this.blackColor = new Color(null, 0, 0, 0);
        }
        if (this.redColor == null || this.redColor.isDisposed()) {
            this.redColor = new Color(null, 255, 0, 0);
        }
        this.display = parent.getDisplay();
        ScrolledComposite scrollComposite = new ScrolledComposite(parent, 768);
        GridLayout layout = new GridLayout(1, true);
        scrollComposite.setLayout((Layout)layout);
        this.canvas = new Canvas((Composite)scrollComposite, 0);
        this.gc = new GC((Drawable)this.canvas);
        scrollComposite.setBackground(this.whiteColor);
        this.gc.setBackground(scrollComposite.getBackground());
        scrollComposite.setContent((Control)this.canvas);
        scrollComposite.setMinSize(this.nodeMapViewSize[0], this.nodeMapViewSize[1]);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.setExpandVertical(true);
        this.statusLineManager = (SubStatusLineManager)this.getViewSite().getActionBars().getStatusLineManager();
        this.mouseListener = new NodeMapViewMouseListener(scrollComposite, this.display, parent, this.canvas, this.gc, this.statusLineManager, false);
        this.mouseListener.getPopMenu().setPopUpMenu(parent);
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                NodeMapView.this.mouseListener.redraw();
            }
        });
        scrollComposite.addMouseListener((MouseListener)this.mouseListener);
        this.canvas.addMouseListener((MouseListener)this.mouseListener);
        this.canvas.addMouseMoveListener((MouseMoveListener)this.mouseListener);
        this.setToolBarActions();
    }

    protected void setCanvasSize() {
        this.nodeMapViewSize[0] = CanvasViewConfigFileParse.getInstance().getNodeMapWidth();
        this.nodeMapViewSize[1] = CanvasViewConfigFileParse.getInstance().getNodeMapHeight();
    }

    protected void setToolBarActions() {
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolBarManager.add((IAction)new ActionLoadNodeMapView());
        toolBarManager.add(this.nodeListAction.getActionImportNodeListFile());
        toolBarManager.add(this.nodeListAction.getActionExportNodeListFile());
        toolBarManager.add(this.actionBuilderAlarm.getActionShowAllNodeAlarmListTable());
        toolBarManager.add(this.actionBuilderEditorPart.actionCloseAllEditors());
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.whiteColor != null) {
            this.whiteColor.dispose();
        }
        if (this.blackColor != null) {
            this.blackColor.dispose();
        }
        if (this.redColor != null) {
            this.redColor.dispose();
        }
        if (this.gc != null) {
            this.gc.dispose();
        }
    }

    public void setFocus() {
    }

    protected class NodeListAction
    extends ActionBuilderNodeList {
        protected NodeListAction() {
        }
    }

    public abstract class AbstractNodeMapAction
    extends Action {
        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)NodeMapView.this.bundle.getEntry("icons/reload.gif"));
        }

        public String getText() {
            return "Node Map Load";
        }

        public String getToolTipText() {
            return "Node Map Load";
        }

        public final void run() {
            this.doTask();
        }

        protected abstract void doTask();
    }

    public class ActionLoadNodeMapView
    extends AbstractNodeMapAction {
        protected void doTask() {
            NodeMapView.this.mouseListener.getPopMenu().loadNodeMap();
        }
    }
}

