/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.preferance;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import netjfwatcher.common.view.TableListViewColor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ViewColorPreferancePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String COLOR_PREFERENCE_FILE = "view_color.pref";
    public static final String ALARM_ERROR_LEVEL_COLOR_NAME = "alarm_error";
    public static final String ALARM_WARNING_LEVEL_COLOR_NAME = "alarm_warning";
    public static final String ALARM_INFO_LEVEL_COLOR_NAME = "alarm_info";
    public static final String NODE_LIST_ODD_FORGROUND_COLOR_NAME = "node_list_odd_number_foreground";
    public static final String NODE_LIST_ODD_BACKGROUND_COLOR_NAME = "node_list_odd_number_background";
    public static final String NODE_LIST_EVEN_FORGROUND_COLOR_NAME = "node_list_even_number_foreground";
    public static final String NODE_LIST_EVEN_BACKGROUND_COLOR_NAME = "node_list_even_number_background";
    public static final String NODE_LIST_STATUS_COLOR_NAME = "node_list_status_forground";
    public static final String DEFAULT_ALARM_ERROR_LEVEL_COLOR = "255,0,0";
    public static final String DEFAULT_ALARM_WARNING_LEVEL_COLOR = "0,255,0";
    public static final String DEFAULT_ALARM_INFO_LEVEL_COLOR = "0,0,0";
    public static final String DEFAULT_NODE_LIST_ODD_FORGROUND_COLOR = "0,0,0";
    public static final String DEFAULT_NODE_LIST_ODD_BACKGROUND_COLOR = "255,255,255";
    public static final String DEFAULT_NODE_LIST_EVEN_FORGROUND_COLOR = "0,0,0";
    public static final String DEFAULT_NODE_LIST_EVEN_BACKGROUND_COLOR = "128,255,255";
    public static final String DEFAULT_NODE_LIST_STATUS_COLOR = "255,128,64";
    private static Logger logger;
    private PreferenceStore prefStore;
    private final List editorsList = new ArrayList();

    public ViewColorPreferancePage() {
        super(0);
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    }

    public void init(IWorkbench workbench) {
        try {
            this.prefStore = this.initPreferenceStore(COLOR_PREFERENCE_FILE);
        }
        catch (IOException e) {
            logger.warning(e.getMessage());
        }
    }

    private PreferenceStore initPreferenceStore(String filename) throws IOException {
        PreferenceStore localstore = new PreferenceStore(filename);
        localstore.setDefault(ALARM_ERROR_LEVEL_COLOR_NAME, DEFAULT_ALARM_ERROR_LEVEL_COLOR);
        localstore.setDefault(ALARM_WARNING_LEVEL_COLOR_NAME, DEFAULT_ALARM_WARNING_LEVEL_COLOR);
        localstore.setDefault(ALARM_INFO_LEVEL_COLOR_NAME, "0,0,0");
        localstore.setDefault(NODE_LIST_EVEN_FORGROUND_COLOR_NAME, "0,0,0");
        localstore.setDefault(NODE_LIST_EVEN_BACKGROUND_COLOR_NAME, DEFAULT_NODE_LIST_EVEN_BACKGROUND_COLOR);
        localstore.setDefault(NODE_LIST_ODD_FORGROUND_COLOR_NAME, "0,0,0");
        localstore.setDefault(NODE_LIST_ODD_BACKGROUND_COLOR_NAME, DEFAULT_NODE_LIST_ODD_BACKGROUND_COLOR);
        localstore.setDefault(NODE_LIST_STATUS_COLOR_NAME, DEFAULT_NODE_LIST_STATUS_COLOR);
        File file = new File(filename);
        if (file.exists()) {
            localstore.load();
        }
        return localstore;
    }

    protected void createFieldEditors() {
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(768));
        Group alarmListGroup = new Group(composite, 0);
        alarmListGroup.setText("Alarm List Color");
        alarmListGroup.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        alarmListGroup.setLayoutData((Object)gridData);
        this.registerEditor((FieldEditor)new ColorFieldEditor(ALARM_ERROR_LEVEL_COLOR_NAME, "Alarm list error level select &Color", (Composite)alarmListGroup));
        this.registerEditor((FieldEditor)new ColorFieldEditor(ALARM_WARNING_LEVEL_COLOR_NAME, "Alarm list warning level select &Color", (Composite)alarmListGroup));
        this.registerEditor((FieldEditor)new ColorFieldEditor(ALARM_INFO_LEVEL_COLOR_NAME, "Alarm list infomation level select &Color", (Composite)alarmListGroup));
        Label label = new Label(composite, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        Group nodeListGroup = new Group(composite, 0);
        nodeListGroup.setText("Node List Color");
        nodeListGroup.setLayout((Layout)new GridLayout(2, false));
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        nodeListGroup.setLayoutData((Object)gridData);
        this.registerEditor((FieldEditor)new ColorFieldEditor(NODE_LIST_ODD_FORGROUND_COLOR_NAME, "Node list odd number foreground select &Color", (Composite)nodeListGroup));
        this.registerEditor((FieldEditor)new ColorFieldEditor(NODE_LIST_ODD_BACKGROUND_COLOR_NAME, "Node list odd number background select &Color", (Composite)nodeListGroup));
        this.registerEditor((FieldEditor)new ColorFieldEditor(NODE_LIST_EVEN_FORGROUND_COLOR_NAME, "Node list even number foreground select &Color", (Composite)nodeListGroup));
        this.registerEditor((FieldEditor)new ColorFieldEditor(NODE_LIST_EVEN_BACKGROUND_COLOR_NAME, "Node list even number background select &Color", (Composite)nodeListGroup));
        this.registerEditor((FieldEditor)new ColorFieldEditor(NODE_LIST_STATUS_COLOR_NAME, "Node list status forground select &Color", (Composite)nodeListGroup));
        composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FillLayout(256));
        composite.setLayoutData((Object)new GridData(768));
        return parent;
    }

    protected void performDefaults() {
        int i = 0;
        int n = this.editorsList.size();
        while (i < n) {
            FieldEditor ed = (FieldEditor)this.editorsList.get(i);
            if (ed.isValid()) {
                ed.loadDefault();
            }
            ++i;
        }
        super.performDefaults();
    }

    public boolean performOk() {
        this.storeAll();
        try {
            this.prefStore.save();
            TableListViewColor.getInstance().updateAlarmListColor();
            TableListViewColor.getInstance().updateNodeListColor();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return true;
    }

    protected void registerEditor(FieldEditor ed) {
        this.editorsList.add(ed);
        ed.setPreferencePage((PreferencePage)this);
        ed.setPreferenceStore((IPreferenceStore)this.prefStore);
        ed.load();
    }

    private void storeAll() {
        int i = 0;
        int n = this.editorsList.size();
        while (i < n) {
            FieldEditor ed = (FieldEditor)this.editorsList.get(i);
            if (ed.isValid()) {
                ed.store();
            }
            ++i;
        }
    }
}

