/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.resource;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.security.MessageDigest;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKeyFactory;
import netjfwatcher.engine.resource.SnmpAgentConfigInfo;
import netjfwatcher.engine.resource.SnmpV3AgentConfigInfo;
import netjfwatcher.engine.resource.SystemResourceFileParse;
import netjfwatcher.engine.resource.XMLOutputterFormat;
import netjfwatcher.snmp.snmpv3.SnmpEngineID;
import netjfwatcher.snmp.snmpv3.SnmpV3ConfigurationException;
import netjfwatcher.snmp.snmpv3.UsmUserAgentManager;
import org.jdom.Attribute;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class SnmpV3AgentConfigFileParse {
    public static final String CONF = "conf";
    public static final String ALLOW_HOST = "allow-host";
    public static final String READ_COMMUNITY = "read-Community";
    public static final String WRITE_COMMUNITY = "write-Community";
    public static final String SNMPV3 = "snmpV3";
    public static final String SNMP_ENGINE_ID = "snmpEngineID";
    public static final String SNMP_ENGINE_BOOTS = "snmpEngineBoots";
    public static final String USER_NAME = "userName";
    public static final String AUTH_PRIV = "authPriv";
    public static final String AUTH_PROTOCOL = "authProtocol";
    public static final String AUTH_PASSPHRSE = "authPassPhrase";
    public static final String PRIV_PROTOCOL = "privProtocol";
    public static final String PRIV_PASSPHRSE = "privPassPhrase";
    public static final String CONTEXT_NAME = "contextName";
    public static final String XML_FILE_VALUE = "value";
    private static Logger logger = null;
    private SnmpV3AgentConfigInfo snmpV3AgentConfigInfo;
    private SnmpAgentConfigInfo snmpAgentInfo;

    public SnmpV3AgentConfigFileParse() throws Exception {
        logger = Logger.getLogger(this.getClass().getName());
        logger.info("SNMPV3 Agent Config File Parse : resources/snmpV3Agent.xml");
        Document doc = null;
        doc = this.getResourceFileDocumentPath("resources/snmpV3Agent.xml");
        if (doc == null) {
            logger.severe("Resource File Doc null ");
            return;
        }
        this.snmpV3AgentConfigInfo = new SnmpV3AgentConfigInfo();
        this.snmpAgentInfo = new SnmpAgentConfigInfo();
        try {
            Element root = doc.getRootElement();
            String allowHost = root.getChild(ALLOW_HOST).getAttributeValue(XML_FILE_VALUE);
            this.snmpAgentInfo.setAllowHost(allowHost);
            String readCommunity = root.getChild(READ_COMMUNITY).getAttributeValue(XML_FILE_VALUE);
            this.snmpAgentInfo.setReadCommunity(readCommunity);
            String writeCommunity = root.getChild(WRITE_COMMUNITY).getAttributeValue(XML_FILE_VALUE);
            this.snmpAgentInfo.setWriteCommunity(writeCommunity);
            Element snmpV3 = root.getChild(SNMPV3);
            String snmpEngineID = snmpV3.getChild(SNMP_ENGINE_ID).getAttributeValue(XML_FILE_VALUE);
            this.snmpV3AgentConfigInfo.setSnmpEngineID(snmpEngineID);
            String snmpEngineBoots = snmpV3.getChild(SNMP_ENGINE_BOOTS).getAttributeValue(XML_FILE_VALUE);
            this.snmpV3AgentConfigInfo.setSnmpEngineBoots(snmpEngineBoots);
            String userName = snmpV3.getChild(USER_NAME).getAttributeValue(XML_FILE_VALUE);
            this.snmpV3AgentConfigInfo.setUserName(userName);
            String authPriv = snmpV3.getChild(AUTH_PRIV).getAttributeValue(XML_FILE_VALUE);
            this.snmpV3AgentConfigInfo.setAuthPriv(authPriv);
            String authProtocol = snmpV3.getChild(AUTH_PROTOCOL).getAttributeValue(XML_FILE_VALUE);
            this.snmpV3AgentConfigInfo.setAuthProtocol(authProtocol);
            String authPassPhrase = snmpV3.getChild(AUTH_PASSPHRSE).getAttributeValue(XML_FILE_VALUE);
            this.snmpV3AgentConfigInfo.setAuthPassPhrase(authPassPhrase);
            String privProtocol = snmpV3.getChild(PRIV_PROTOCOL).getAttributeValue(XML_FILE_VALUE);
            this.snmpV3AgentConfigInfo.setPrivProtocol(privProtocol);
            String privPassPhrase = snmpV3.getChild(PRIV_PASSPHRSE).getAttributeValue(XML_FILE_VALUE);
            this.snmpV3AgentConfigInfo.setPrivPassPhrase(privPassPhrase);
            String contextName = snmpV3.getChild(CONTEXT_NAME).getAttributeValue(XML_FILE_VALUE);
            this.snmpV3AgentConfigInfo.setContextName(contextName);
            try {
                this.setSnmpV3AgentConfig(this.snmpV3AgentConfigInfo);
            }
            catch (SnmpV3ConfigurationException e) {
                e.printStackTrace();
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    private void setSnmpV3AgentConfig(SnmpV3AgentConfigInfo info) throws SnmpV3ConfigurationException {
        SnmpEngineID snmpEngineID = new SnmpEngineID(info.getSnmpEngineID());
        UsmUserAgentManager.getInstance().registAgentList(snmpEngineID, info);
        try {
            MessageDigest.getInstance("MD5");
            MessageDigest.getInstance("SHA-1");
            Mac.getInstance("HmacMD5");
            Mac.getInstance("HmacSHA1");
            Cipher.getInstance("DES");
            SecretKeyFactory.getInstance("DES");
        }
        catch (Throwable e) {
            throw new SnmpV3ConfigurationException(e.toString());
        }
    }

    public SnmpAgentConfigInfo getSnmpAgentResourceInfo() {
        return this.snmpAgentInfo;
    }

    public SnmpV3AgentConfigInfo getSnmpV3AgentResourceInfo() {
        return this.snmpV3AgentConfigInfo;
    }

    public URL getResourceFileURL(String file) {
        ClassLoader loader = SystemResourceFileParse.class.getClassLoader();
        URL url = loader.getResource(file);
        if (url == null) {
            logger.info("Resource XML file url : " + url);
        }
        return url;
    }

    public BufferedWriter getResourceFileWriter() {
        File file = new File("resources/snmpV3Agent.xml");
        logger.info("Path : " + file.getAbsolutePath());
        if (file == null) {
            return null;
        }
        BufferedWriter bufferedWriter = null;
        try {
            FileWriter fileWriter = new FileWriter("resources/snmpV3Agent.xml");
            bufferedWriter = new BufferedWriter(fileWriter);
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return null;
        }
        return bufferedWriter;
    }

    public Document getResourceFileDocumentPath(String file) {
        Document doc = null;
        File f = new File(file);
        if (f == null) {
            return null;
        }
        BufferedReader buffReader = null;
        try {
            FileReader fileReader = new FileReader(file);
            buffReader = new BufferedReader(fileReader);
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
            return null;
        }
        try {
            SAXBuilder builder = new SAXBuilder();
            doc = builder.build((Reader)buffReader);
        }
        catch (JDOMException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }
        catch (IOException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }
        return doc;
    }

    public Document updateDocument(SnmpAgentConfigInfo snmpAgentInfo, SnmpV3AgentConfigInfo snmpV3AgentInfo) {
        Element confElement = new Element(CONF);
        Document doc = new Document(confElement);
        Element allowHost = new Element(ALLOW_HOST);
        Element readCommunity = new Element(READ_COMMUNITY);
        Element writeCommunity = new Element(WRITE_COMMUNITY);
        Element snmpV3El = new Element(SNMPV3);
        Element snmpEngineIDEl = new Element(SNMP_ENGINE_ID);
        Element snmpEngineBootsEl = new Element(SNMP_ENGINE_BOOTS);
        Element userNameEl = new Element(USER_NAME);
        Element authPrivEl = new Element(AUTH_PRIV);
        Element authProtocolEl = new Element(AUTH_PROTOCOL);
        Element authPassphrseEl = new Element(AUTH_PASSPHRSE);
        Element privProtocolEl = new Element(PRIV_PROTOCOL);
        Element privPassphrseEl = new Element(PRIV_PASSPHRSE);
        Element contextNameEl = new Element(CONTEXT_NAME);
        confElement.addContent((Content)allowHost);
        confElement.addContent((Content)readCommunity);
        confElement.addContent((Content)writeCommunity);
        allowHost.setAttribute(new Attribute(XML_FILE_VALUE, snmpAgentInfo.getAllowHost()));
        readCommunity.setAttribute(new Attribute(XML_FILE_VALUE, snmpAgentInfo.getReadCommunity()));
        writeCommunity.setAttribute(new Attribute(XML_FILE_VALUE, snmpAgentInfo.getWriteCommunity()));
        confElement.addContent((Content)snmpV3El);
        snmpV3El.addContent((Content)snmpEngineIDEl);
        snmpV3El.addContent((Content)snmpEngineBootsEl);
        snmpV3El.addContent((Content)userNameEl);
        snmpV3El.addContent((Content)authPrivEl);
        snmpV3El.addContent((Content)authProtocolEl);
        snmpV3El.addContent((Content)authPassphrseEl);
        snmpV3El.addContent((Content)privProtocolEl);
        snmpV3El.addContent((Content)privPassphrseEl);
        snmpV3El.addContent((Content)contextNameEl);
        snmpEngineIDEl.setAttribute(new Attribute(XML_FILE_VALUE, snmpV3AgentInfo.getSnmpEngineID()));
        snmpEngineBootsEl.setAttribute(new Attribute(XML_FILE_VALUE, snmpV3AgentInfo.getSnmpEngineBoots()));
        userNameEl.setAttribute(new Attribute(XML_FILE_VALUE, snmpV3AgentInfo.getUserName()));
        authPrivEl.setAttribute(new Attribute(XML_FILE_VALUE, snmpV3AgentInfo.getAuthPriv()));
        authProtocolEl.setAttribute(new Attribute(XML_FILE_VALUE, snmpV3AgentInfo.getAuthProtocol()));
        authPassphrseEl.setAttribute(new Attribute(XML_FILE_VALUE, snmpV3AgentInfo.getAuthPassPhrase()));
        privProtocolEl.setAttribute(new Attribute(XML_FILE_VALUE, snmpV3AgentInfo.getPrivProtocol()));
        privPassphrseEl.setAttribute(new Attribute(XML_FILE_VALUE, snmpV3AgentInfo.getPrivPassPhrase()));
        contextNameEl.setAttribute(new Attribute(XML_FILE_VALUE, snmpV3AgentInfo.getContextName()));
        snmpV3El.addContent((Content)new Comment("AuthPriv NOAUTH/AUTH/PRIV"));
        snmpV3El.addContent((Content)new Comment("AuthProtocol MD5/SHA"));
        return doc;
    }

    public void outputXMLFile(BufferedWriter bufWriter, Document dom) {
        XMLOutputter outputter = XMLOutputterFormat.getInstance().getXMLOutputterFormat();
        OutputStreamWriter writer = null;
        try {
            try {
                outputter.output(dom, (Writer)bufWriter);
            }
            catch (IOException e1) {
                logger.warning(e1.getMessage());
                e1.printStackTrace();
            }
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e2) {
                    logger.warning(e2.getMessage());
                    e2.printStackTrace();
                }
            }
        }
    }
}

