/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.server.protocol.control;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import netjfwatcher.engine.nodewatchinfo.BaseNodeWatchInfoList;
import netjfwatcher.engine.nodewatchinfo.NodeWatchInfo;
import netjfwatcher.engine.nodewatchinfo.OidGetInfo;
import netjfwatcher.engine.nodewatchinfo.StatisticsMibInfo;
import netjfwatcher.engine.server.protocol.control.ListQueueStatisticsMibControl;
import netjfwatcher.engine.server.protocol.control.QueueForStatisticsMib;

public class ThreadListReadQueuePushStatisticMibControl
implements Runnable {
    private static final int WAIT_SLEEP_TIME = 1000;
    private static Logger logger = null;

    public ThreadListReadQueuePushStatisticMibControl() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public void run() {
        int count = 0;
        Iterator it = null;
        while (true) {
            Map list = ListQueueStatisticsMibControl.getInstance().getStatisticsMibHashMap();
            for (Map.Entry ent : list.entrySet()) {
                StatisticsMibInfo info;
                String keyIpAddress = (String)ent.getKey();
                NodeWatchInfo nodeInfo = BaseNodeWatchInfoList.getInstance().getNodeWatchInfo(keyIpAddress);
                if (nodeInfo == null || !nodeInfo.getStatisticsMIBStatus().equals("OK") || (info = (StatisticsMibInfo)list.get(keyIpAddress)) == null) continue;
                Iterator it2 = null;
                HashMap oidInfoMap = info.getOidList();
                if (oidInfoMap == null) continue;
                for (Map.Entry ent2 : oidInfoMap.entrySet()) {
                    String keyOid = (String)ent2.getKey();
                    OidGetInfo oidGetInfo = (OidGetInfo)oidInfoMap.get(keyOid);
                    count = Integer.parseInt(oidGetInfo.getCountGetMibPeriod());
                    if (count == 0) continue;
                    oidGetInfo.setCountGetMibPeriod(Integer.toString(--count));
                    info.updateOid(keyOid, oidGetInfo);
                    ListQueueStatisticsMibControl.getInstance().updateStatisticsMibGetNode(keyIpAddress, info);
                    if (count != 0) continue;
                    QueueForStatisticsMib.getInstance().pushQue(oidGetInfo);
                    oidGetInfo.setCountGetMibPeriod(oidGetInfo.getGetMibPeriod());
                    info.updateOid(keyOid, oidGetInfo);
                    ListQueueStatisticsMibControl.getInstance().updateStatisticsMibGetNode(keyIpAddress, info);
                }
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

