/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.server.protocol.snmp;

import java.net.SocketException;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableStatisticsMIBControl;
import netjfwatcher.database.access.model.LastCheckTimeUpDate;
import netjfwatcher.database.access.model.StatisticsInfo;
import netjfwatcher.engine.alarm.AlarmMessageMake;
import netjfwatcher.engine.snmpmanager.process.MibGetNextInfo;
import netjfwatcher.engine.snmpmanager.process.MibGetNextInfoQueue;
import netjfwatcher.engine.snmpmanager.process.MibValue;
import netjfwatcher.snmp.messageformat.SnmpMIBGetException;

public class ExecuteStatisticsMibGet {
    public static final String THRESHOLD_TYPE_NONE = "none";
    public static final String THRESHOLD_TYPE_DIFFERENCE = "difference";
    public static final String THRESHOLD_TYPE_INTEGRAL = "integrale";
    private static Logger logger = null;
    private DBTableStatisticsMIBControl statisticsDatabaseTable = DBTableStatisticsMIBControl.getInstance();
    private LastCheckTimeUpDate updateLastCheckTime = LastCheckTimeUpDate.getInstance();
    private MibGetNextInfo mibget;

    public ExecuteStatisticsMibGet() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public void execute(String targetip, int version, String community, String oid, String threshHoldString, String type) {
        if (threshHoldString == null || threshHoldString.equals("")) {
            threshHoldString = "0";
        }
        String ipAddressUunderbarConv = "IP" + targetip.replace('.', '_');
        String tableNameIpAddress = ipAddressUunderbarConv = ipAddressUunderbarConv.replace('-', '_');
        ArrayList statisList = null;
        if (tableNameIpAddress == null) {
            return;
        }
        try {
            try {
                int checkCount = 0;
                this.mibget = null;
                while (this.mibget == null) {
                    this.mibget = MibGetNextInfoQueue.getInstance().popMibGetInstanceQueue(targetip, Thread.currentThread().getName());
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e1) {
                        logger.warning(e1.getMessage());
                        e1.printStackTrace();
                    }
                    MibGetNextInfoQueue.getInstance().checkTimeout(targetip, oid, ++checkCount, version);
                }
                logger.info("Mib get IP Address=" + targetip + " Version=" + version + " OID=" + oid);
                this.mibget.setMibGetNext(targetip, version, community);
                statisList = this.mibget.getNextMibValueList(oid);
            }
            catch (SocketException e1) {
                logger.warning(String.valueOf(e1.getMessage()) + " : " + targetip + " : " + oid + " : " + community);
                e1.printStackTrace();
            }
            catch (UnknownHostException e1) {
                logger.warning(String.valueOf(e1.getMessage()) + " : IP=" + targetip + " Version=" + version + " : OID=" + oid + " : Community=" + community);
                e1.printStackTrace();
            }
            catch (SnmpMIBGetException e1) {
                logger.warning(String.valueOf(e1.getMessage()) + " : IP=" + targetip + " Version=" + version + " : OID=" + oid + " : Community=" + community);
                e1.printStackTrace();
            }
        }
        finally {
            if (this.mibget != null) {
                MibGetNextInfoQueue.getInstance().releaseMibGetInstance(targetip, Thread.currentThread().getName());
            }
        }
        if (statisList == null || statisList.size() == 0) {
            return;
        }
        try {
            double value = 0.0;
            double threshold = 0.0;
            threshold = Double.parseDouble(threshHoldString);
            ArrayList databaseList = this.statisticsDatabaseTable.get(tableNameIpAddress, oid, statisList);
            int j = 0;
            while (j < statisList.size()) {
                StatisticsInfo info;
                double diffData;
                String valueString = ((MibValue)statisList.get(j)).getMibValue();
                String instanceName = ((MibValue)statisList.get(j)).getMibName();
                value = Double.parseDouble(valueString);
                if (type == null) break;
                if (type.equals(THRESHOLD_TYPE_INTEGRAL)) {
                    if (value > threshold) {
                        AlarmMessageMake message = AlarmMessageMake.getInstance();
                        message.setStatisticsMIBOver(targetip, oid, instanceName, "Integrale", value, threshold);
                    }
                } else if (type.equals(THRESHOLD_TYPE_DIFFERENCE) && (diffData = this.checkDifference(value, info = (StatisticsInfo)databaseList.get(j))) > threshold) {
                    AlarmMessageMake message = AlarmMessageMake.getInstance();
                    message.setStatisticsMIBOver(targetip, oid, instanceName, "Difference", diffData, threshold);
                }
                ++j;
            }
            this.statisticsDatabaseTable.put(tableNameIpAddress, oid, statisList);
        }
        catch (DatabaseConnectionException e) {
            logger.warning(String.valueOf(e.getMessage()) + " : IP=" + targetip + " Version=" + version + " : OID=" + oid + " : Community=" + community);
            e.printStackTrace();
        }
        catch (SQLException e) {
            logger.warning(String.valueOf(e.getMessage()) + " : IP=" + targetip + " Version=" + version + " : OID=" + oid + " : Community=" + community);
            e.printStackTrace();
        }
        try {
            this.updateLastCheckTime.updateCheckTime(targetip);
        }
        catch (DatabaseConnectionException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }
        catch (SQLException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }
    }

    private double checkDifference(double value, StatisticsInfo info) {
        String preValueString = info.getInstance();
        long preValue = 0L;
        try {
            preValue = Long.parseLong(preValueString);
        }
        catch (NumberFormatException e) {
            logger.warning("NumberFormatException " + e.getMessage() + " " + preValueString);
        }
        Date nowDate = Calendar.getInstance().getTime();
        long nowTime = nowDate.getTime();
        long preTime = info.getDate().getTime();
        double diffData = (value - (double)preValue) / (double)((nowTime - preTime) / 1000L);
        return diffData;
    }
}

