/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.view.editorpart.ping;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;
import netjfwatcher.common.view.AbstractTableView;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTablePingResponse;
import netjfwatcher.engine.calendar.DataFilterInfo;
import netjfwatcher.engine.model.action.ActionBuilderChart;
import netjfwatcher.engine.model.action.ActionBuilderDataExport;
import netjfwatcher.engine.resourceconfig.ClientEngineInfo;
import netjfwatcher.engine.socket.ConnectionPing;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.socket.info.PingInfo;
import netjfwatcher.engine.socket.info.PingProperty;
import netjfwatcher.engine.socket.info.PingResponseInfo;
import netjfwatcher.engine.view.editorpart.common.AbstractEditorNodeView;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeView;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class EditorNodePingResponseData
extends AbstractEditorNodeView {
    public static final String TITLE_SUFFIX = " Ping Data View";
    public static final int TEXT_WIDTH = 100;
    public static final int COUNT_TEXT_WIDTH = 70;
    public static final int DATE_TEXT_WIDTH = 150;
    private static final int[] SCROLL_COMPOSITE_SIZE = new int[]{900, 800};
    private static Logger logger;
    private static final float COLUMN0_DATE_RATIO = 0.15f;
    private static final float COLUMN1_DATA_RATIO = 0.15f;
    private ActionBuilderDataExport exportDataAction = new ActionBuilderDataExport();
    private ActionBuilderChart nodeChartAction = new ActionBuilderChart();
    private NodeInformation targetNodeInfo;
    private PingResponseInfo responseInfo = new PingResponseInfo();
    private Text dataTotalCountText;
    private Text periodText;
    private Text maxDataText;
    private Text thresholdDataText;
    private Text startDateText;
    private Text endDateText;
    private Button refreshButton;
    private TableViewer viewer;
    private ArrayList dateList = new ArrayList();
    private ArrayList dataList = new ArrayList();
    private String[] maxData = new String[1];
    private String[] minData = new String[1];

    public EditorNodePingResponseData() {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    }

    public void createPartControl(Composite parent) {
        EditorInputNodeView nodeViewEditorInput = (EditorInputNodeView)this.getEditorInput();
        this.targetNodeInfo = nodeViewEditorInput.getNodeInfo();
        this.isSocket = nodeViewEditorInput.isSocket();
        if (this.targetNodeInfo == null) {
            logger.warning("NodeInfo null");
        }
        ScrolledComposite scrollComposite = new ScrolledComposite(parent, 768);
        GridLayout layout = new GridLayout(1, false);
        scrollComposite.setLayout((Layout)layout);
        GridLayout gridLayout0 = new GridLayout(1, false);
        Composite baseComposite = new Composite((Composite)scrollComposite, 16384);
        baseComposite.setLayout((Layout)gridLayout0);
        baseComposite.setLayoutData((Object)new GridData(2));
        GridData gridData = null;
        GridLayout gridLayout = new GridLayout(10, false);
        Composite composite = new Composite(baseComposite, 16384);
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(256));
        gridData = new GridData();
        this.refreshButton = new Button(composite, 0);
        this.refreshButton.setText("Refresh");
        this.refreshButton.setLayoutData((Object)new GridData());
        Label label = new Label(composite, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("Total Data=");
        label.setLayoutData((Object)new GridData());
        this.dataTotalCountText = new Text(composite, 16392);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 70;
        this.dataTotalCountText.setEnabled(false);
        this.dataTotalCountText.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("Period(sec)=");
        label.setLayoutData((Object)new GridData());
        this.periodText = new Text(composite, 16392);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 70;
        this.periodText.setEnabled(false);
        this.periodText.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("Max Data(msec)=");
        label.setLayoutData((Object)new GridData());
        this.maxDataText = new Text(composite, 16392);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 70;
        this.maxDataText.setEnabled(false);
        this.maxDataText.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("Threshold(msec)=");
        label.setLayoutData((Object)new GridData());
        this.thresholdDataText = new Text(composite, 16392);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 70;
        this.thresholdDataText.setEnabled(false);
        this.thresholdDataText.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("Start date=");
        label.setLayoutData((Object)new GridData());
        this.startDateText = new Text(composite, 16392);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 150;
        this.startDateText.setEnabled(false);
        this.startDateText.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("End date=");
        label.setLayoutData((Object)new GridData());
        this.endDateText = new Text(composite, 16392);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 150;
        this.endDateText.setEnabled(false);
        this.endDateText.setLayoutData((Object)gridData);
        PingTable statisticsTable = new PingTable();
        this.table = statisticsTable.createTable(baseComposite);
        this.viewer = new TableViewer(this.table);
        this.viewer.setUseHashlookup(true);
        scrollComposite.setContent((Control)baseComposite);
        scrollComposite.setMinSize(SCROLL_COMPOSITE_SIZE[0], SCROLL_COMPOSITE_SIZE[1]);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.setExpandVertical(true);
        this.createContextMenu();
        try {
            this.getPingData();
        }
        catch (DatabaseConnectionException e1) {
            logger.warning(e1.getMessage());
        }
        catch (SQLException e1) {
            logger.warning(e1.getMessage());
        }
        this.setTablePingData();
        this.setRefreshButtonListener();
    }

    private void setRefreshButtonListener() {
        this.refreshButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                EditorNodePingResponseData.this.refreshButton.setEnabled(false);
                try {
                    try {
                        EditorNodePingResponseData.this.getPingData();
                        EditorNodePingResponseData.this.setTablePingData();
                    }
                    catch (DatabaseConnectionException ex) {
                        logger.warning(ex.getMessage());
                        Shell shell = new Shell();
                        MessageDialog.openError((Shell)shell, (String)"Abort Ping response data get", (String)ex.getMessage());
                        shell.dispose();
                    }
                    catch (SQLException ex) {
                        logger.warning(ex.getMessage());
                        Shell shell = new Shell();
                        MessageDialog.openError((Shell)shell, (String)"Abort Ping response data get", (String)ex.getMessage());
                        shell.dispose();
                    }
                }
                finally {
                    EditorNodePingResponseData.this.refreshButton.setEnabled(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
    }

    private void createContextMenu() {
        MenuManager mm = new MenuManager();
        mm.setRemoveAllWhenShown(true);
        mm.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                EditorNodePingResponseData.this.fillContextMenu(manager);
            }
        });
        Menu menu = mm.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(mm, (ISelectionProvider)this.viewer);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new GroupMarker("additions"));
        if (this.table.getSelectionIndex() >= 0 && this.table.getSelection() != null) {
            ((ActionBuilderDataExport.ActionExportPingResponse)this.exportDataAction.getActionExportPing()).setTable(this.table);
            manager.add(this.exportDataAction.getActionExportPing());
        }
        String title = String.valueOf(this.targetNodeInfo.getNodename()) + "(" + this.targetNodeInfo.getIpaddress() + ") " + "Ping " + " Chart";
        ArrayList<String> nameList = new ArrayList<String>();
        nameList.add(String.valueOf(this.targetNodeInfo.getNodename()) + "(" + this.targetNodeInfo.getIpaddress() + ")");
        if (!this.isSocket) {
            ((ActionBuilderChart.ActionNodePingChartView)this.nodeChartAction.getActionNodePingChartView()).setTitle(title);
            ((ActionBuilderChart.ActionNodePingChartView)this.nodeChartAction.getActionNodePingChartView()).setNodeInfo(this.targetNodeInfo);
            ((ActionBuilderChart.ActionNodePingChartView)this.nodeChartAction.getActionNodePingChartView()).setMaxData(this.maxData);
            ((ActionBuilderChart.ActionNodePingChartView)this.nodeChartAction.getActionNodePingChartView()).setMinData(this.minData);
            ((ActionBuilderChart.ActionNodePingChartView)this.nodeChartAction.getActionNodePingChartView()).setDateList(this.dateList);
            ArrayList<ArrayList> list = new ArrayList<ArrayList>();
            list.add(this.dataList);
            ((ActionBuilderChart.ActionNodePingChartView)this.nodeChartAction.getActionNodePingChartView()).setDataList(list);
            ((ActionBuilderChart.ActionNodePingChartView)this.nodeChartAction.getActionNodePingChartView()).setNameList(nameList);
            manager.add(this.nodeChartAction.getActionNodePingChartView());
        } else {
            ((ActionBuilderChart.ActionNodePingChartViewSocket)this.nodeChartAction.getActionNodePingChartViewSocket()).setTitle(title);
            ((ActionBuilderChart.ActionNodePingChartViewSocket)this.nodeChartAction.getActionNodePingChartViewSocket()).setNodeInfo(this.targetNodeInfo);
            ((ActionBuilderChart.ActionNodePingChartViewSocket)this.nodeChartAction.getActionNodePingChartViewSocket()).setMaxData(this.maxData);
            ((ActionBuilderChart.ActionNodePingChartViewSocket)this.nodeChartAction.getActionNodePingChartViewSocket()).setMinData(this.minData);
            ((ActionBuilderChart.ActionNodePingChartViewSocket)this.nodeChartAction.getActionNodePingChartViewSocket()).setDateList(this.dateList);
            ArrayList<ArrayList> list = new ArrayList<ArrayList>();
            list.add(this.dataList);
            ((ActionBuilderChart.ActionNodePingChartViewSocket)this.nodeChartAction.getActionNodePingChartViewSocket()).setDataList(list);
            ((ActionBuilderChart.ActionNodePingChartViewSocket)this.nodeChartAction.getActionNodePingChartViewSocket()).setNameList(nameList);
            manager.add(this.nodeChartAction.getActionNodePingChartViewSocket());
        }
    }

    private void getPingData() throws DatabaseConnectionException, SQLException {
        this.periodText.setText(this.targetNodeInfo.getPingPeriod());
        this.thresholdDataText.setText(this.targetNodeInfo.getPingThreshold());
        ArrayList list = null;
        PingProperty property = null;
        String filterCheckStart = DataFilterInfo.getInstance().getStartDate();
        String filterCheckEnd = DataFilterInfo.getInstance().getEndDate();
        String filterStart = filterCheckStart == null || filterCheckStart.equals("") ? null : filterCheckStart;
        String filterEnd = filterCheckEnd == null || filterCheckEnd.equals("") ? null : filterCheckEnd;
        if (!this.isSocket) {
            DBTablePingResponse pingDBTable = DBTablePingResponse.getInstance();
            list = pingDBTable.findAll(this.targetNodeInfo.getIpaddress(), filterStart, filterEnd);
            property = pingDBTable.getDataCount(this.targetNodeInfo.getIpaddress());
            if (list != null && property != null) {
                System.out.println("List size : " + list.size());
                System.out.println("getStartDate : " + property.getStartDate());
                System.out.println("getEndDat : " + property.getEndDate());
                System.out.println("getMaxData : " + property.getMaxData());
                System.out.println("getTotalDataCount : " + property.getTotalDataCount());
                if (list.size() > 0) {
                    this.dataTotalCountText.setText(Integer.toString(list.size()));
                    this.maxDataText.setText(property.getMaxData());
                    this.startDateText.setText(property.getStartDate().toString());
                    this.endDateText.setText(property.getEndDate().toString());
                    this.maxData[0] = property.getMaxData();
                    this.minData[0] = property.getMinData();
                }
            }
        } else {
            String engineAddress = ClientEngineInfo.getClientEngineInfoInstance().getEngineAddress();
            try {
                ConnectionPing connectionPing = new ConnectionPing(engineAddress);
                PingResponseInfo pingResponseInfo = connectionPing.getPingInfo(this.targetNodeInfo.getIpaddress(), filterStart, filterEnd);
                list = pingResponseInfo.getPingDataList();
                property = pingResponseInfo.getPingProperty();
                if (list != null && property != null && list.size() > 0) {
                    this.dataTotalCountText.setText(Integer.toString(list.size()));
                    this.maxDataText.setText(property.getMaxData());
                    this.startDateText.setText(property.getStartDate().toString());
                    this.endDateText.setText(property.getEndDate().toString());
                    this.maxData[0] = property.getMaxData();
                    this.minData[0] = property.getMinData();
                }
            }
            catch (EngineConnectException ex) {
                Shell shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Engine connect error", (String)("Engine connect error " + ex.getMessage() + " Engine=" + engineAddress));
                logger.warning("Engine connect error " + ex.getMessage());
                shell.dispose();
                ex.printStackTrace();
            }
            catch (IOException e) {
                Shell shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Engine connect error", (String)("Engine connect error " + e.getMessage() + " Engine=" + engineAddress));
                logger.warning("Engine connect error " + e.getMessage());
                shell.dispose();
                e.printStackTrace();
            }
        }
        this.responseInfo.setPingDataList(list);
        this.responseInfo.setPingProperty(property);
    }

    private void setTablePingData() {
        this.table.removeAll();
        this.viewer.refresh();
        this.dateList.clear();
        this.dataList.clear();
        if (this.responseInfo == null) {
            return;
        }
        int limit = DataFilterInfo.getInstance().getLimit();
        ArrayList pingDataList = this.responseInfo.getPingDataList();
        if (pingDataList == null) {
            return;
        }
        int i = 0;
        while (i < pingDataList.size()) {
            PingInfo pingInfo = (PingInfo)pingDataList.get(i);
            String[] pingResponseTableCellArray = new String[]{pingInfo.getPingCheckDate().toString(), Long.toString(pingInfo.getPingDiffTime())};
            this.dateList.add(pingInfo.getPingCheckDate().toString());
            this.dataList.add(Long.toString(pingInfo.getPingDiffTime()));
            TableItem item = new TableItem(this.table, 0);
            item.setText(pingResponseTableCellArray);
            item.setData((Object)pingResponseTableCellArray);
            if (limit != 0 && i >= limit) break;
            ++i;
        }
    }

    private int computeCol0Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.15f);
    }

    private int computeCol1Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.15f);
    }

    protected void setStatusLine() {
        this.statusLineManager = (SubStatusLineManager)this.getEditorSite().getActionBars().getStatusLineManager();
        this.statusLineManager.setVisible(true);
    }

    private final class PingTable
    extends AbstractTableView {
        private boolean[] isColDirection;

        private PingTable() {
        }

        private Table createTable(Composite parent) {
            GridData data2 = new GridData();
            data2.horizontalAlignment = 4;
            data2.verticalAlignment = 4;
            data2.grabExcessHorizontalSpace = true;
            data2.grabExcessVerticalSpace = true;
            this.table = new Table(parent, 66304);
            this.table.setLinesVisible(true);
            this.table.setHeaderVisible(true);
            this.table.setLayoutData((Object)data2);
            this.isColDirection = new boolean[2];
            TableColumn[] col = new TableColumn[2];
            col[0] = new TableColumn(this.table, 0x1000000);
            col[0].setText("Response Date");
            col[0].setWidth(EditorNodePingResponseData.this.computeCol0Width());
            this.isColDirection[0] = true;
            col[0].addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    ((PingTable)PingTable.this).isColDirection[0] = PingTable.this.sortTable(PingTable.this.table, 0, PingTable.this.isColDirection[0]);
                }
            });
            col[1] = new TableColumn(this.table, 0x1000000);
            col[1].setText("Data");
            col[1].setWidth(EditorNodePingResponseData.this.computeCol1Width());
            this.isColDirection[1] = true;
            col[1].addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    ((PingTable)PingTable.this).isColDirection[1] = PingTable.this.sortIntegerTable(PingTable.this.table, 1, PingTable.this.isColDirection[1]);
                }
            });
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().addControlListener(new ControlListener(){

                public void controlMoved(ControlEvent event) {
                }

                public void controlResized(ControlEvent event) {
                    PingTable.this.setResizedTableColumnWidth();
                }
            });
            return this.table;
        }

        protected void setResizedTableColumnWidth() {
            if (EditorNodePingResponseData.this.getEditorSite().getPage().isPartVisible(EditorNodePingResponseData.this.getEditorSite().getPart()) && EditorNodePingResponseData.this.getEditorSite().getShell() != null) {
                EditorNodePingResponseData.this.getEditorSite().getShell().getSize();
            }
        }
    }
}

