/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.view.editorpart.snmp;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableStatisticsMIBControl;
import netjfwatcher.engine.nodewatchinfo.StatisticsMibInfo;
import netjfwatcher.engine.resource.StatisticsMibFileLoad;
import netjfwatcher.engine.resourceconfig.ClientEngineInfo;
import netjfwatcher.engine.server.protocol.control.ListQueueStatisticsMibControl;
import netjfwatcher.engine.snmpmanager.statistics.StatisticsMibDBRegister;
import netjfwatcher.engine.snmpmanager.statistics.ThreadStatisticsMibGetControl;
import netjfwatcher.engine.socket.ConnectionStatisticsMibGet;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.socket.info.StatisticsMibControl;
import netjfwatcher.engine.socket.info.StatisticsMibProperty;
import netjfwatcher.engine.socket.info.StatisticsMibSetStatus;
import netjfwatcher.engine.view.editorpart.common.AbstractEditorNodeView;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeView;
import netjfwatcher.snmp.mibtree.ManagerMibTree;
import netjfwatcher.snmp.mibtree.MibInfo;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EditorNodeSnmpStatisricsSet
extends AbstractEditorNodeView {
    public static final String TITLE_SUFFIX = " Snmp Statistics set";
    private static final int[] SCROLL_COMPOSITE_SIZE = new int[]{800, 600};
    public static final int STATISTICS_MIB_COLLECT_LIST_WIDTH = 250;
    public static final int STATISTICS_MIB_COLLECT_LIST_VERTICALSPAN = 11;
    public static final int SNMP_STATISTICS_MIB_LIST_WIDTH = 200;
    public static final int SNMP_STATISTICS_MIB_LIST_VERTICALSPAN = 11;
    public static final int TEXT_WIDTH1 = 120;
    private static Logger logger;
    private NodeInformation targetNodeInfo;
    private List collectSnmpStatisticsList;
    private ArrayList oidList = new ArrayList();
    private List baseSnmpStatisticsList;
    private ArrayList statisticsMibList;
    private Text statisticsNodeNameText;
    private Text statisticsNodeIPAddressText;
    private Text statisticsOidText;
    private Text statisticsCommunityText;
    private Text statisticsPeriodText;
    private Text statisticsThresholdText;
    private Combo statisticsTypeCombo;
    private Button loadOidListButton;
    private Button addButton;
    private Button editButton;
    private Button deleteButton;

    public EditorNodeSnmpStatisricsSet() {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    }

    public void createPartControl(Composite parent) {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        EditorInputNodeView nodeViewEditorInput = (EditorInputNodeView)this.getEditorInput();
        this.targetNodeInfo = nodeViewEditorInput.getNodeInfo();
        this.isSocket = nodeViewEditorInput.isSocket();
        if (this.targetNodeInfo == null) {
            logger.warning("NodeInfo null");
        }
        ScrolledComposite scrollComposite = new ScrolledComposite(parent, 768);
        GridLayout layout = new GridLayout(1, false);
        scrollComposite.setLayout((Layout)layout);
        GridData gridData = null;
        GridLayout gridLayout0 = new GridLayout(1, true);
        Composite composite0 = new Composite((Composite)scrollComposite, 0);
        composite0.setLayout((Layout)gridLayout0);
        composite0.setLayoutData((Object)new GridData());
        GridLayout gridLayout = new GridLayout(4, false);
        Composite composite1 = new Composite(composite0, 16384);
        composite1.setLayout((Layout)gridLayout);
        composite1.setLayoutData((Object)new GridData());
        gridData = new GridData();
        Label label = new Label(composite1, 0);
        label.setText("Collect Statistics OID list");
        label.setLayoutData((Object)new GridData());
        label = new Label(composite1, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite1, 0);
        label.setText("Select Statistics OID list");
        label.setLayoutData((Object)new GridData());
        this.collectSnmpStatisticsList = new List(composite1, 2564);
        GridData data = new GridData(1808);
        data.horizontalSpan = 1;
        data.verticalSpan = 11;
        data.widthHint = 250;
        data.heightHint = this.collectSnmpStatisticsList.getItemHeight() * 8;
        this.collectSnmpStatisticsList.select(0);
        this.collectSnmpStatisticsList.setLayoutData((Object)data);
        this.loadOidListButton = new Button(composite1, 0);
        this.loadOidListButton.setText("OID list load");
        data = new GridData();
        data.horizontalSpan = 2;
        data.verticalSpan = 1;
        this.loadOidListButton.setLayoutData((Object)data);
        this.baseSnmpStatisticsList = new List(composite1, 2564);
        data = new GridData(1808);
        data.horizontalSpan = 1;
        data.verticalSpan = 11;
        data.widthHint = 200;
        data.heightHint = this.baseSnmpStatisticsList.getItemHeight() * 20;
        this.baseSnmpStatisticsList.select(0);
        this.baseSnmpStatisticsList.setLayoutData((Object)data);
        this.statisticsMibList = StatisticsMibFileLoad.getInstance().getFileParse().getStatisticsMibSelectList();
        int i = 0;
        while (i < this.statisticsMibList.size()) {
            String[] statisMib = (String[])this.statisticsMibList.get(i);
            this.baseSnmpStatisticsList.add(statisMib[0]);
            ++i;
        }
        label = new Label(composite1, 0);
        label.setText("Node Name");
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.statisticsNodeNameText = new Text(composite1, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.statisticsNodeNameText.setLayoutData((Object)gridData);
        label = new Label(composite1, 0);
        label.setText("IP Address");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.statisticsNodeIPAddressText = new Text(composite1, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.statisticsNodeIPAddressText.setLayoutData((Object)gridData);
        label = new Label(composite1, 0);
        label.setText("Community");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.statisticsCommunityText = new Text(composite1, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.statisticsCommunityText.setLayoutData((Object)gridData);
        label = new Label(composite1, 0);
        label.setText("OID");
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.statisticsOidText = new Text(composite1, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.statisticsOidText.setLayoutData((Object)gridData);
        label = new Label(composite1, 0);
        label.setText("Period");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.statisticsPeriodText = new Text(composite1, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.statisticsPeriodText.setLayoutData((Object)gridData);
        label = new Label(composite1, 0);
        label.setText("Threshold");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.statisticsThresholdText = new Text(composite1, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.statisticsThresholdText.setLayoutData((Object)gridData);
        label = new Label(composite1, 0);
        label.setText("Type");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.statisticsTypeCombo = new Combo(composite1, 12);
        this.statisticsTypeCombo.add("none");
        this.statisticsTypeCombo.add("difference");
        this.statisticsTypeCombo.add("integrale");
        this.statisticsTypeCombo.select(0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.statisticsTypeCombo.setLayoutData((Object)gridData);
        this.addButton = new Button(composite1, 0);
        this.addButton.setText("Add");
        data = new GridData();
        data.horizontalSpan = 2;
        data.verticalSpan = 1;
        this.addButton.setLayoutData((Object)data);
        this.editButton = new Button(composite1, 0);
        this.editButton.setText("Edit");
        data = new GridData();
        data.horizontalSpan = 2;
        data.verticalSpan = 1;
        this.editButton.setLayoutData((Object)data);
        this.deleteButton = new Button(composite1, 0);
        this.deleteButton.setText("Delete");
        data = new GridData();
        data.horizontalSpan = 2;
        data.verticalSpan = 1;
        this.deleteButton.setLayoutData((Object)data);
        GridLayout gridLayout2 = new GridLayout(1, false);
        Composite composite2 = new Composite(composite0, 16384);
        composite2.setLayoutData((Object)new GridData());
        composite2.setLayout((Layout)gridLayout2);
        scrollComposite.setContent((Control)composite0);
        scrollComposite.setMinSize(SCROLL_COMPOSITE_SIZE[0], SCROLL_COMPOSITE_SIZE[1]);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.setExpandVertical(true);
        try {
            this.getStatisticsList(this.targetNodeInfo.getIpaddress());
        }
        catch (DatabaseConnectionException e2) {
            logger.warning(e2.getMessage());
        }
        catch (SQLException e2) {
            logger.warning(e2.getMessage());
        }
        catch (IOException e1) {
            logger.warning(e1.getMessage());
        }
        catch (EngineConnectException e1) {
            logger.warning(e1.getMessage());
        }
        this.setTextDefaultNodeInfo(this.targetNodeInfo);
        this.loadOidListButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                EditorNodeSnmpStatisricsSet.this.loadOidListButton.setEnabled(false);
                EditorNodeSnmpStatisricsSet.this.addButton.setEnabled(false);
                EditorNodeSnmpStatisricsSet.this.editButton.setEnabled(false);
                EditorNodeSnmpStatisricsSet.this.deleteButton.setEnabled(false);
                try {
                    try {
                        EditorNodeSnmpStatisricsSet.this.getStatisticsList(EditorNodeSnmpStatisricsSet.this.targetNodeInfo.getIpaddress());
                    }
                    catch (SQLException e1) {
                        logger.warning(e1.getMessage());
                        Shell shell = new Shell();
                        MessageDialog.openError((Shell)shell, (String)"Error", (String)e1.getMessage());
                        shell.dispose();
                    }
                    catch (DatabaseConnectionException e1) {
                        logger.warning(e1.getMessage());
                        Shell shell = new Shell();
                        MessageDialog.openError((Shell)shell, (String)"Error", (String)e1.getMessage());
                        shell.dispose();
                    }
                    catch (IOException e1) {
                        logger.warning(e1.getMessage());
                        Shell shell = new Shell();
                        MessageDialog.openError((Shell)shell, (String)"Error", (String)e1.getMessage());
                        shell.dispose();
                    }
                    catch (EngineConnectException e1) {
                        logger.warning(e1.getMessage());
                        Shell shell = new Shell();
                        MessageDialog.openError((Shell)shell, (String)"Error", (String)e1.getMessage());
                        shell.dispose();
                    }
                }
                finally {
                    EditorNodeSnmpStatisricsSet.this.addButton.setEnabled(true);
                    EditorNodeSnmpStatisricsSet.this.editButton.setEnabled(true);
                    EditorNodeSnmpStatisricsSet.this.deleteButton.setEnabled(true);
                    EditorNodeSnmpStatisricsSet.this.loadOidListButton.setEnabled(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.baseSnmpStatisticsList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int index = EditorNodeSnmpStatisricsSet.this.baseSnmpStatisticsList.getSelectionIndex();
                String[] oidInfo = (String[])EditorNodeSnmpStatisricsSet.this.statisticsMibList.get(index);
                String oid = oidInfo[1];
                EditorNodeSnmpStatisricsSet.this.statisticsOidText.setText(oid);
            }
        });
        this.collectSnmpStatisticsList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int index = EditorNodeSnmpStatisricsSet.this.collectSnmpStatisticsList.getSelectionIndex();
                String oid = (String)EditorNodeSnmpStatisricsSet.this.oidList.get(index);
                EditorNodeSnmpStatisricsSet.this.statisticsOidText.setText(oid);
                try {
                    EditorNodeSnmpStatisricsSet.this.setPropertyText(EditorNodeSnmpStatisricsSet.this.targetNodeInfo.getIpaddress(), oid);
                }
                catch (DatabaseConnectionException e1) {
                    logger.warning(e1.getMessage());
                    Shell shell = new Shell();
                    MessageDialog.openError((Shell)shell, (String)"Error", (String)e1.getMessage());
                    shell.dispose();
                }
                catch (SQLException e1) {
                    logger.warning(e1.getMessage());
                    Shell shell = new Shell();
                    MessageDialog.openError((Shell)shell, (String)"Error", (String)e1.getMessage());
                    shell.dispose();
                }
                catch (IOException e1) {
                    logger.warning(e1.getMessage());
                    Shell shell = new Shell();
                    MessageDialog.openError((Shell)shell, (String)"Error", (String)e1.getMessage());
                    shell.dispose();
                }
                catch (EngineConnectException e1) {
                    logger.warning(e1.getMessage());
                    Shell shell = new Shell();
                    MessageDialog.openError((Shell)shell, (String)"Error", (String)e1.getMessage());
                    shell.dispose();
                }
            }
        });
        this.addButton.addSelectionListener(new SelectionListener(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void widgetSelected(SelectionEvent event) {
                EditorNodeSnmpStatisricsSet.this.addButton.setEnabled(false);
                EditorNodeSnmpStatisricsSet.this.editButton.setEnabled(false);
                EditorNodeSnmpStatisricsSet.this.deleteButton.setEnabled(false);
                EditorNodeSnmpStatisricsSet.this.loadOidListButton.setEnabled(false);
                String setNodeName = EditorNodeSnmpStatisricsSet.this.statisticsNodeNameText.getText();
                String setIPaddress = EditorNodeSnmpStatisricsSet.this.statisticsNodeIPAddressText.getText();
                String setOid = EditorNodeSnmpStatisricsSet.this.statisticsOidText.getText();
                try {
                    if (setOid.equals("")) {
                        Shell shell = new Shell();
                        MessageDialog.openError((Shell)shell, (String)"Error", (String)("Error OID = " + setOid));
                        shell.dispose();
                        return;
                    }
                    int i = 0;
                    while (i < EditorNodeSnmpStatisricsSet.this.oidList.size()) {
                        if (setOid.equals(EditorNodeSnmpStatisricsSet.this.oidList.get(i))) {
                            Shell shell = new Shell();
                            MessageDialog.openError((Shell)shell, (String)"Error", (String)("Already OID = " + setOid));
                            shell.dispose();
                            return;
                        }
                        ++i;
                    }
                    String setCommunity = EditorNodeSnmpStatisricsSet.this.statisticsCommunityText.getText();
                    if (!EditorNodeSnmpStatisricsSet.this.checkTextData()) {
                        return;
                    }
                    String setPeriod = EditorNodeSnmpStatisricsSet.this.statisticsPeriodText.getText();
                    String setThreshold = EditorNodeSnmpStatisricsSet.this.statisticsThresholdText.getText();
                    int selectType = EditorNodeSnmpStatisricsSet.this.statisticsTypeCombo.getSelectionIndex();
                    String setThresholdType = EditorNodeSnmpStatisricsSet.this.statisticsTypeCombo.getItem(selectType);
                    int snmpVersion = 0;
                    ThreadStatisticsMibGetControl ifoctet = new ThreadStatisticsMibGetControl();
                    ifoctet.setStatistics(setIPaddress, snmpVersion, setCommunity, setPeriod, setOid, setThreshold, setThresholdType);
                    StatisticsMibInfo mibInfo = StatisticsMibInfo.getInstance(setIPaddress);
                    mibInfo.setNodeName(setNodeName);
                    mibInfo.setCommunity(setCommunity);
                    mibInfo.setVersion(snmpVersion);
                    mibInfo.setOidList(setOid, setPeriod, setThreshold, setThresholdType);
                    ListQueueStatisticsMibControl.getInstance().setStatisticsMibGetNode(setIPaddress, mibInfo);
                    return;
                }
                finally {
                    try {
                        EditorNodeSnmpStatisricsSet.this.getStatisticsList(setIPaddress);
                    }
                    catch (DatabaseConnectionException e1) {
                        logger.warning(e1.getMessage());
                        Shell shell = new Shell();
                        MessageDialog.openError((Shell)shell, (String)"Error", (String)e1.getMessage());
                        shell.dispose();
                    }
                    catch (SQLException e1) {
                        logger.warning(e1.getMessage());
                        Shell shell = new Shell();
                        MessageDialog.openError((Shell)shell, (String)"Error", (String)e1.getMessage());
                        shell.dispose();
                    }
                    catch (IOException e1) {
                        logger.warning(e1.getMessage());
                        Shell shell = new Shell();
                        MessageDialog.openError((Shell)shell, (String)"Error", (String)e1.getMessage());
                        shell.dispose();
                    }
                    catch (EngineConnectException e1) {
                        logger.warning(e1.getMessage());
                        Shell shell = new Shell();
                        MessageDialog.openError((Shell)shell, (String)"Error", (String)e1.getMessage());
                        shell.dispose();
                    }
                    EditorNodeSnmpStatisricsSet.this.addButton.setEnabled(true);
                    EditorNodeSnmpStatisricsSet.this.editButton.setEnabled(true);
                    EditorNodeSnmpStatisricsSet.this.deleteButton.setEnabled(true);
                    EditorNodeSnmpStatisricsSet.this.loadOidListButton.setEnabled(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.editButton.addSelectionListener(new SelectionListener(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void widgetSelected(SelectionEvent event) {
                EditorNodeSnmpStatisricsSet.this.addButton.setEnabled(false);
                EditorNodeSnmpStatisricsSet.this.editButton.setEnabled(false);
                EditorNodeSnmpStatisricsSet.this.deleteButton.setEnabled(false);
                EditorNodeSnmpStatisricsSet.this.loadOidListButton.setEnabled(false);
                String setNodeName = EditorNodeSnmpStatisricsSet.this.statisticsNodeNameText.getText();
                String setIPaddress = EditorNodeSnmpStatisricsSet.this.statisticsNodeIPAddressText.getText();
                String setOid = EditorNodeSnmpStatisricsSet.this.statisticsOidText.getText();
                try {
                    if (setOid.equals("")) {
                        Shell shell = new Shell();
                        MessageDialog.openError((Shell)shell, (String)"Error", (String)("Error OID = " + setOid));
                        shell.dispose();
                        return;
                    }
                    boolean isFoundOid = false;
                    int i = 0;
                    while (i < EditorNodeSnmpStatisricsSet.this.oidList.size()) {
                        if (setOid.equals(EditorNodeSnmpStatisricsSet.this.oidList.get(i))) {
                            isFoundOid = true;
                        }
                        ++i;
                    }
                    if (!isFoundOid) {
                        Shell shell = new Shell();
                        MessageDialog.openError((Shell)shell, (String)"Error", (String)("NotFound OID = " + setOid));
                        return;
                    }
                    String setCommunity = EditorNodeSnmpStatisricsSet.this.statisticsCommunityText.getText();
                    if (!EditorNodeSnmpStatisricsSet.this.checkTextData()) {
                        return;
                    }
                    String setPeriod = EditorNodeSnmpStatisricsSet.this.statisticsPeriodText.getText();
                    String setThreshold = EditorNodeSnmpStatisricsSet.this.statisticsThresholdText.getText();
                    int selectType = EditorNodeSnmpStatisricsSet.this.statisticsTypeCombo.getSelectionIndex();
                    String setThresholdType = EditorNodeSnmpStatisricsSet.this.statisticsTypeCombo.getItem(selectType);
                    int snmpVersion = 0;
                    StatisticsMibInfo mibInfo = StatisticsMibInfo.getInstance(setIPaddress);
                    StatisticsMibDBRegister mibStatisGet = new StatisticsMibDBRegister(setIPaddress, snmpVersion, setCommunity);
                    mibStatisGet.updateMibStatisticsSetDatabase(setOid, setPeriod, setThreshold, setThresholdType);
                    ListQueueStatisticsMibControl.getInstance().removeStatisticsMibGetNode(setIPaddress);
                    mibInfo.setNodeName(setNodeName);
                    mibInfo.setVersion(snmpVersion);
                    mibInfo.setCommunity(setCommunity);
                    mibInfo.updateOidList(setOid, setPeriod, setThreshold, setThresholdType);
                    ListQueueStatisticsMibControl.getInstance().setStatisticsMibGetNode(setIPaddress, mibInfo);
                    return;
                }
                finally {
                    try {
                        EditorNodeSnmpStatisricsSet.this.getStatisticsList(setIPaddress);
                    }
                    catch (DatabaseConnectionException e1) {
                        logger.warning(e1.getMessage());
                        Shell shell = new Shell();
                        MessageDialog.openError((Shell)shell, (String)"Error", (String)e1.getMessage());
                        shell.dispose();
                    }
                    catch (SQLException e1) {
                        logger.warning(e1.getMessage());
                        Shell shell = new Shell();
                        MessageDialog.openError((Shell)shell, (String)"Error", (String)e1.getMessage());
                        shell.dispose();
                    }
                    catch (IOException e1) {
                        logger.warning(e1.getMessage());
                        Shell shell = new Shell();
                        MessageDialog.openError((Shell)shell, (String)"Error", (String)e1.getMessage());
                        shell.dispose();
                    }
                    catch (EngineConnectException e1) {
                        logger.warning(e1.getMessage());
                        Shell shell = new Shell();
                        MessageDialog.openError((Shell)shell, (String)"Error", (String)e1.getMessage());
                        shell.dispose();
                    }
                    EditorNodeSnmpStatisricsSet.this.addButton.setEnabled(true);
                    EditorNodeSnmpStatisricsSet.this.editButton.setEnabled(true);
                    EditorNodeSnmpStatisricsSet.this.deleteButton.setEnabled(true);
                    EditorNodeSnmpStatisricsSet.this.loadOidListButton.setEnabled(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.deleteButton.addSelectionListener(new SelectionListener(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void widgetSelected(SelectionEvent event) {
                EditorNodeSnmpStatisricsSet.this.addButton.setEnabled(false);
                EditorNodeSnmpStatisricsSet.this.editButton.setEnabled(false);
                EditorNodeSnmpStatisricsSet.this.deleteButton.setEnabled(false);
                EditorNodeSnmpStatisricsSet.this.loadOidListButton.setEnabled(false);
                String setIPaddress = EditorNodeSnmpStatisricsSet.this.statisticsNodeIPAddressText.getText();
                String setOid = EditorNodeSnmpStatisricsSet.this.statisticsOidText.getText();
                try {
                    if (setOid.equals("")) {
                        Shell shell = new Shell();
                        MessageDialog.openError((Shell)shell, (String)"Error", (String)("Error OID = " + setOid));
                        shell.dispose();
                        return;
                    }
                    boolean isFoundOid = false;
                    int i = 0;
                    while (i < EditorNodeSnmpStatisricsSet.this.oidList.size()) {
                        if (setOid.equals(EditorNodeSnmpStatisricsSet.this.oidList.get(i))) {
                            isFoundOid = true;
                        }
                        ++i;
                    }
                    if (!isFoundOid) {
                        Shell shell = new Shell();
                        MessageDialog.openError((Shell)shell, (String)"Error", (String)("NotFound OID = " + setOid));
                        shell.dispose();
                        return;
                    }
                    String setCommunity = EditorNodeSnmpStatisricsSet.this.statisticsCommunityText.getText();
                    int snmpVersion = 0;
                    StatisticsMibInfo mibInfo = StatisticsMibInfo.getInstance(setIPaddress);
                    StatisticsMibDBRegister mibStatisGet = new StatisticsMibDBRegister(setIPaddress, snmpVersion, setCommunity);
                    mibStatisGet.updateMibStatisticsSetDatabase(setOid, "--", "--", "--");
                    ListQueueStatisticsMibControl.getInstance().removeStatisticsMibGetNode(setIPaddress);
                    mibInfo.removeOid(setOid);
                    HashMap list = mibInfo.getOidList();
                    for (String key : list.keySet()) {
                        System.out.println("key : " + key);
                    }
                    ListQueueStatisticsMibControl.getInstance().setStatisticsMibGetNode(setIPaddress, mibInfo);
                    return;
                }
                finally {
                    try {
                        EditorNodeSnmpStatisricsSet.this.getStatisticsList(setIPaddress);
                    }
                    catch (DatabaseConnectionException e1) {
                        logger.warning(e1.getMessage());
                        Shell shell = new Shell();
                        MessageDialog.openError((Shell)shell, (String)"Error", (String)e1.getMessage());
                        shell.dispose();
                    }
                    catch (SQLException e1) {
                        logger.warning(e1.getMessage());
                        Shell shell = new Shell();
                        MessageDialog.openError((Shell)shell, (String)"Error", (String)e1.getMessage());
                        shell.dispose();
                    }
                    catch (IOException e1) {
                        logger.warning(e1.getMessage());
                        Shell shell = new Shell();
                        MessageDialog.openError((Shell)shell, (String)"Error", (String)e1.getMessage());
                        shell.dispose();
                    }
                    catch (EngineConnectException e1) {
                        logger.warning(e1.getMessage());
                        Shell shell = new Shell();
                        MessageDialog.openError((Shell)shell, (String)"Error", (String)e1.getMessage());
                        shell.dispose();
                    }
                    EditorNodeSnmpStatisricsSet.this.addButton.setEnabled(true);
                    EditorNodeSnmpStatisricsSet.this.editButton.setEnabled(true);
                    EditorNodeSnmpStatisricsSet.this.deleteButton.setEnabled(true);
                    EditorNodeSnmpStatisricsSet.this.loadOidListButton.setEnabled(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
    }

    private void setTextDefaultNodeInfo(NodeInformation nodeInfo) {
        this.statisticsTypeCombo.select(0);
        this.statisticsNodeNameText.setText(nodeInfo.getNodename());
        this.statisticsNodeIPAddressText.setText(nodeInfo.getIpaddress());
        this.statisticsCommunityText.setText(nodeInfo.getRoCommunity());
    }

    private boolean checkTextData() {
        String setPeriod = this.statisticsPeriodText.getText();
        try {
            Integer.parseInt(setPeriod);
        }
        catch (NumberFormatException numberFormatException) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Error", (String)"Format error");
            this.statisticsPeriodText.setFocus();
            return false;
        }
        String setThreshold = this.statisticsThresholdText.getText();
        try {
            Integer.parseInt(setThreshold);
        }
        catch (NumberFormatException numberFormatException) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Error", (String)"Format error");
            this.statisticsThresholdText.setFocus();
            return false;
        }
        return true;
    }

    private void getStatisticsList(String ipAddress) throws DatabaseConnectionException, SQLException, IOException, EngineConnectException {
        ArrayList statisticsMibSetStatusList = null;
        if (!this.isSocket) {
            DBTableStatisticsMIBControl mibDBTable = DBTableStatisticsMIBControl.getInstance();
            statisticsMibSetStatusList = mibDBTable.getList(ipAddress);
        } else {
            String engineAddress = ClientEngineInfo.getClientEngineInfoInstance().getEngineAddress();
            StatisticsMibControl control = new StatisticsMibControl();
            control.setSubCommand("Statistics_Set_Status_Get");
            control.setIpaddress(ipAddress);
            ConnectionStatisticsMibGet statisticsMibGet = new ConnectionStatisticsMibGet(engineAddress);
            StatisticsMibProperty mibproperty = statisticsMibGet.getStatisticsMib(control);
            if (mibproperty != null) {
                statisticsMibSetStatusList = mibproperty.getStatisticsMibSetList();
            }
        }
        this.collectSnmpStatisticsList.removeAll();
        this.oidList.clear();
        int i = 0;
        while (i < statisticsMibSetStatusList.size()) {
            StatisticsMibSetStatus test = (StatisticsMibSetStatus)statisticsMibSetStatusList.get(i);
            String oid = test.getReadOid();
            String oidDescription = "";
            this.oidList.add(oid);
            if (ManagerMibTree.getInstance().getOidHashMap().containsKey(oid)) {
                MibInfo miboid = (MibInfo)ManagerMibTree.getInstance().getOidHashMap().get(oid);
                oidDescription = miboid.getDescrip();
            }
            this.collectSnmpStatisticsList.add(String.valueOf(test.getReadOid()) + " : " + oidDescription + " (period=" + test.getReadPeriod() + ")");
            ++i;
        }
    }

    private void setPropertyText(String ipAddress, String oid) throws DatabaseConnectionException, SQLException, IOException, EngineConnectException {
        ArrayList statisticsMibSetStatusList = null;
        if (!this.isSocket) {
            DBTableStatisticsMIBControl mibDBTable = DBTableStatisticsMIBControl.getInstance();
            statisticsMibSetStatusList = mibDBTable.getList(ipAddress);
        } else {
            String engineAddress = ClientEngineInfo.getClientEngineInfoInstance().getEngineAddress();
            StatisticsMibControl control = new StatisticsMibControl();
            control.setSubCommand("Statistics_Set_Status_Get");
            control.setIpaddress(ipAddress);
            ConnectionStatisticsMibGet statisticsMibGet = new ConnectionStatisticsMibGet(engineAddress);
            StatisticsMibProperty mibproperty = statisticsMibGet.getStatisticsMib(control);
            if (mibproperty != null) {
                statisticsMibSetStatusList = mibproperty.getStatisticsMibSetList();
            }
        }
        int i = 0;
        while (i < statisticsMibSetStatusList.size()) {
            StatisticsMibSetStatus statisMibSetStatus = (StatisticsMibSetStatus)statisticsMibSetStatusList.get(i);
            if (oid.equals(statisMibSetStatus.getReadOid())) {
                this.statisticsPeriodText.setText(statisMibSetStatus.getReadPeriod());
                this.statisticsThresholdText.setText(statisMibSetStatus.getReadThreshold());
                if (statisMibSetStatus.getReadThresholdType().equals("difference")) {
                    this.statisticsTypeCombo.select(1);
                } else if (statisMibSetStatus.getReadThresholdType().equals("integrale")) {
                    this.statisticsTypeCombo.select(2);
                } else {
                    this.statisticsTypeCombo.select(0);
                }
            }
            ++i;
        }
    }

    protected void setStatusLine() {
        this.statusLineManager = (SubStatusLineManager)this.getEditorSite().getActionBars().getStatusLineManager();
        this.statusLineManager.setVisible(true);
    }
}

