/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmpmanager.preferences;

import java.io.BufferedWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.logging.Logger;
import netjfwatcher.application.NetJFWatcherApplication;
import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.engine.resource.SnmpV3ManagerConfig;
import netjfwatcher.engine.resource.SnmpV3ManagerConfigInfo;
import netjfwatcher.engine.resource.SnmpV3ManagerUserConfigInfo;
import netjfwatcher.snmpmanager.preferences.AbstractSnmpPreferencePage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.jdom.Document;

public class SnmpV3PreferencePage
extends AbstractSnmpPreferencePage {
    private static final int TEXT_WIDTH = 200;
    private static final int DISCOVERY_TEXT_WIDTH = 120;
    private static final int COMBO_WIDTH = 120;
    private static final int AGENT_LIST_VERTICAL_SPAN = 11;
    private static final int AGENT_LIST_HEIGHT_HINT = 5;
    private static final String DISCOVERY = "Discovery";
    private static final String UNDISCOVERY = "Undiscovery";
    private static Logger logger;
    private List snmpV3AgentAddressList = null;
    private Text selectV3AgentAddressText;
    private Text engineIDText;
    private Text engineBootText;
    private Text engineSysUpTimeText;
    private Text userNameText;
    private Combo authPrivCombo;
    private Combo authProtocolCombo;
    private Text authPassPhrasaText;
    private Text privProtocolText;
    private Text privPassPhrasaText;
    private Text agentLearnedText;
    private Text addAgentAddressText;
    private Text removeAgentAddressText;
    private Button discoveryResetButton;
    private Button addAgentButton;
    private Button removeAgentButton;

    public void init(IWorkbench workbench) {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        this.setPreferenceStore(NetJFWatcherPlugin.getInstance().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        this.textBackColor = Display.getCurrent().getSystemColor(1);
        GridLayout layout = new GridLayout(1, false);
        parent.setLayout((Layout)layout);
        GridData gridData = null;
        Composite compositeSnmpV3AgentProperty = new Composite(parent, 0);
        GridLayout gridLayoutV3AgentProp = new GridLayout(3, false);
        compositeSnmpV3AgentProperty.setLayout((Layout)gridLayoutV3AgentProp);
        compositeSnmpV3AgentProperty.setLayoutData((Object)new GridData(256));
        this.snmpV3AgentAddressList = new List(compositeSnmpV3AgentProperty, 2050);
        GridData data = new GridData(1808);
        data.horizontalSpan = 1;
        data.verticalSpan = 11;
        data.widthHint = 200;
        data.heightHint = this.snmpV3AgentAddressList.getItemHeight() * 5;
        this.snmpV3AgentAddressList.setLayoutData((Object)data);
        Iterator iterator = null;
        for (String ipAddress : SnmpV3ManagerConfig.getInstance().getResourceFileParse().getSnmpV3ConfigAddresssMapList().keySet()) {
            SnmpV3ManagerConfigInfo info = SnmpV3ManagerConfig.getInstance().getResourceFileParse().getSnmpV3AgentInfo(ipAddress);
            this.snmpV3AgentAddressList.add(info.getIpAddress());
        }
        this.snmpV3AgentAddressList.setLayoutData((Object)data);
        Label label = new Label(compositeSnmpV3AgentProperty, 0);
        label.setText("Select Agent Address");
        label.setLayoutData((Object)new GridData());
        this.selectV3AgentAddressText = new Text(compositeSnmpV3AgentProperty, 2048);
        this.selectV3AgentAddressText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.selectV3AgentAddressText.setLayoutData((Object)gridData);
        label = new Label(compositeSnmpV3AgentProperty, 0);
        label.setText("EngineID");
        label.setLayoutData((Object)new GridData());
        this.engineIDText = new Text(compositeSnmpV3AgentProperty, 2056);
        this.engineIDText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.engineIDText.setLayoutData((Object)gridData);
        this.engineIDText.setEditable(false);
        this.engineIDText.setEnabled(false);
        this.engineIDText.setBackground(this.textBackColor);
        label = new Label(compositeSnmpV3AgentProperty, 0);
        label.setText("EngineBoots");
        label.setLayoutData((Object)new GridData());
        this.engineBootText = new Text(compositeSnmpV3AgentProperty, 2056);
        this.engineBootText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.engineBootText.setLayoutData((Object)gridData);
        this.engineBootText.setEditable(false);
        this.engineBootText.setEnabled(false);
        this.engineBootText.setBackground(this.textBackColor);
        label = new Label(compositeSnmpV3AgentProperty, 0);
        label.setText("EngineSysUpTime");
        label.setLayoutData((Object)new GridData());
        this.engineSysUpTimeText = new Text(compositeSnmpV3AgentProperty, 2056);
        this.engineSysUpTimeText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.engineSysUpTimeText.setLayoutData((Object)gridData);
        this.engineSysUpTimeText.setEditable(false);
        this.engineSysUpTimeText.setEnabled(false);
        this.engineSysUpTimeText.setBackground(this.textBackColor);
        this.agentLearnedText = new Text(compositeSnmpV3AgentProperty, 2056);
        this.agentLearnedText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.agentLearnedText.setLayoutData((Object)gridData);
        this.agentLearnedText.setEnabled(false);
        this.agentLearnedText.setBackground(this.textBackColor);
        this.discoveryResetButton = new Button(compositeSnmpV3AgentProperty, 0);
        this.discoveryResetButton.setText("Discovery Reset");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.discoveryResetButton.setLayoutData((Object)gridData);
        label = new Label(compositeSnmpV3AgentProperty, 0);
        label.setText("User Name");
        label.setLayoutData((Object)new GridData());
        this.userNameText = new Text(compositeSnmpV3AgentProperty, 2048);
        this.userNameText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.userNameText.setLayoutData((Object)gridData);
        label = new Label(compositeSnmpV3AgentProperty, 0);
        label.setText("AuthPriv");
        label.setLayoutData((Object)new GridData());
        this.authPrivCombo = new Combo(compositeSnmpV3AgentProperty, 12);
        this.authPrivCombo.add("NOAUTH");
        this.authPrivCombo.add("AUTH");
        this.authPrivCombo.add("PRIV");
        this.authPrivCombo.select(0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.authPrivCombo.setLayoutData((Object)gridData);
        label = new Label(compositeSnmpV3AgentProperty, 0);
        label.setText("AuthProtocol");
        label.setLayoutData((Object)new GridData());
        this.authProtocolCombo = new Combo(compositeSnmpV3AgentProperty, 12);
        this.authProtocolCombo.add("MD5");
        this.authProtocolCombo.add("SHA");
        this.authProtocolCombo.select(0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.authProtocolCombo.setLayoutData((Object)gridData);
        label = new Label(compositeSnmpV3AgentProperty, 0);
        label.setText("AuthPassPhrase");
        label.setLayoutData((Object)new GridData());
        this.authPassPhrasaText = new Text(compositeSnmpV3AgentProperty, 2048);
        this.authPassPhrasaText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.authPassPhrasaText.setLayoutData((Object)gridData);
        label = new Label(compositeSnmpV3AgentProperty, 0);
        label.setText("PrivProtocol");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.privProtocolText = new Text(compositeSnmpV3AgentProperty, 2048);
        this.privProtocolText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.privProtocolText.setLayoutData((Object)gridData);
        label = new Label(compositeSnmpV3AgentProperty, 0);
        label.setText("PrivPassPhrase");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.privPassPhrasaText = new Text(compositeSnmpV3AgentProperty, 2048);
        this.privPassPhrasaText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.privPassPhrasaText.setLayoutData((Object)gridData);
        this.addAgentAddressText = new Text(compositeSnmpV3AgentProperty, 2048);
        this.addAgentAddressText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.addAgentAddressText.setLayoutData((Object)gridData);
        this.addAgentButton = new Button(compositeSnmpV3AgentProperty, 0);
        this.addAgentButton.setText("Add Agent");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.addAgentButton.setLayoutData((Object)gridData);
        this.removeAgentAddressText = new Text(compositeSnmpV3AgentProperty, 2048);
        this.removeAgentAddressText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.removeAgentAddressText.setLayoutData((Object)gridData);
        this.removeAgentButton = new Button(compositeSnmpV3AgentProperty, 0);
        this.removeAgentButton.setText("Remove Agent");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.removeAgentButton.setLayoutData((Object)gridData);
        this.addAgentButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                SnmpV3PreferencePage.this.addAgent();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.removeAgentButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                SnmpV3PreferencePage.this.removeAgent();
            }

            public void widgetDefaultSelected(SelectionEvent ev) {
            }
        });
        this.snmpV3AgentAddressList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SnmpV3PreferencePage.this.selectSnmpV3AgentAddressList();
            }
        });
        this.discoveryResetButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                SnmpV3PreferencePage.logger = Logger.getLogger(this.getClass().getName());
                int index = SnmpV3PreferencePage.this.snmpV3AgentAddressList.getSelectionIndex();
                String addAgentAddress = SnmpV3PreferencePage.this.snmpV3AgentAddressList.getItem(index);
                SnmpV3ManagerConfigInfo info = SnmpV3ManagerConfig.getInstance().getResourceFileParse().getSnmpV3AgentInfo(addAgentAddress);
                if (addAgentAddress.equals("")) {
                    return;
                }
                SnmpV3PreferencePage.this.engineIDText.setText("");
                SnmpV3PreferencePage.this.engineBootText.setText("");
                SnmpV3PreferencePage.this.engineSysUpTimeText.setText("");
                SnmpV3PreferencePage.this.agentLearnedText.setText(SnmpV3PreferencePage.UNDISCOVERY);
                info.setLearned(false);
                SnmpV3ManagerConfig.getInstance().getResourceFileParse().updateSnmpV3ManagerConfigInfo(addAgentAddress, info);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        Composite entryTable = new Composite(parent, 0);
        entryTable.setLayoutData((Object)new GridData(768));
        return entryTable;
    }

    private void addAgent() {
        String addAgentAddress = this.addAgentAddressText.getText();
        if (addAgentAddress.equals("")) {
            return;
        }
        try {
            InetAddress host = InetAddress.getByName(addAgentAddress);
            addAgentAddress = host.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            MessageDialog.openError((Shell)this.getShell().getShell(), (String)"Error", (String)("UnknownHostException IP Address = " + addAgentAddress));
            this.addAgentAddressText.setFocus();
            return;
        }
        if (SnmpV3ManagerConfig.getInstance().getResourceFileParse().getSnmpV3AgentInfo(addAgentAddress) != null) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)("Already Agent IP = " + addAgentAddress + " !"));
            return;
        }
        this.snmpV3AgentAddressList.add(addAgentAddress);
        this.addAgentAddressText.setText("");
        SnmpV3ManagerConfigInfo info = new SnmpV3ManagerConfigInfo();
        SnmpV3ManagerUserConfigInfo userInfo = new SnmpV3ManagerUserConfigInfo();
        userInfo.setUsername(this.userNameText.getText());
        userInfo.setAuthPriv(this.authPrivCombo.getText());
        userInfo.setAuthProtocol(this.authProtocolCombo.getText());
        userInfo.setAuthPassPhrase(this.authPassPhrasaText.getText());
        userInfo.setPrivProtocol(this.privProtocolText.getText());
        userInfo.setPrivPassPhrase(this.privPassPhrasaText.getText());
        info.addUserList(userInfo);
        info.setIpAddress(addAgentAddress);
        info.setLearned(false);
        SnmpV3ManagerConfig.getInstance().getResourceFileParse().updateSnmpV3ManagerConfigInfo(addAgentAddress, info);
    }

    private void removeAgent() {
        String removeAgentAddress = this.removeAgentAddressText.getText();
        if (removeAgentAddress.equals("")) {
            return;
        }
        if (MessageDialog.openQuestion((Shell)this.getShell(), (String)"Confirm", (String)("Remove " + removeAgentAddress + " ?"))) {
            if (SnmpV3ManagerConfig.getInstance().getResourceFileParse().getSnmpV3AgentInfo(removeAgentAddress) == null) {
                MessageDialog.openError((Shell)this.getShell().getShell(), (String)"Error", (String)("Not Found  IP Address = " + removeAgentAddress));
                this.removeAgentAddressText.setFocus();
                return;
            }
            this.removeAgentAddressText.setText("");
            this.snmpV3AgentAddressList.remove(removeAgentAddress);
            this.snmpV3AgentAddressList.redraw();
            SnmpV3ManagerConfig.getInstance().getResourceFileParse().getSnmpV3ConfigAddresssMapList().remove(removeAgentAddress);
        }
    }

    private void selectSnmpV3AgentAddressList() {
        int index = this.snmpV3AgentAddressList.getSelectionIndex();
        SnmpV3ManagerConfigInfo info = SnmpV3ManagerConfig.getInstance().getResourceFileParse().getSnmpV3AgentInfo(this.snmpV3AgentAddressList.getItem(index));
        if (info != null) {
            this.selectV3AgentAddressText.setText(info.getIpAddress());
            this.removeAgentAddressText.setText(info.getIpAddress());
            if (info.getSnmpEngineID() != null && !info.getSnmpEngineID().equals("")) {
                this.engineIDText.setText("0x" + info.getSnmpEngineID());
            } else {
                this.engineIDText.setText("");
            }
            if (info.getSnmpEngineBoots() != null) {
                this.engineBootText.setText(info.getSnmpEngineBoots());
            } else {
                this.engineBootText.setText("");
            }
            if (info.isLearned()) {
                this.agentLearnedText.setText(DISCOVERY);
            } else {
                this.agentLearnedText.setText(UNDISCOVERY);
            }
            long agentSnmpEngineTime = 0L;
            try {
                agentSnmpEngineTime = Long.parseLong(info.getSnmpEngineTime());
            }
            catch (NumberFormatException numberFormatException) {
                logger.warning("NumberFormatException SNMP Agent SnmpEngineTime " + info.getSnmpEngineTime());
            }
            if (agentSnmpEngineTime != 0L) {
                Date agentDate = Calendar.getInstance().getTime();
                agentDate.setTime(agentSnmpEngineTime);
                SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                this.engineSysUpTimeText.setText(dateformat.format(agentDate));
            } else {
                this.engineSysUpTimeText.setText("");
            }
            SnmpV3ManagerUserConfigInfo userInfo = (SnmpV3ManagerUserConfigInfo)info.getUserList().get(0);
            if (userInfo != null) {
                this.userNameText.setText(userInfo.getUsername());
                this.authPrivCombo.setText(userInfo.getAuthPriv());
                this.authProtocolCombo.setText(userInfo.getAuthProtocol());
                this.authPassPhrasaText.setText(userInfo.getAuthPassPhrase());
                this.privProtocolText.setText(userInfo.getPrivProtocol());
                this.privPassPhrasaText.setText(userInfo.getPrivPassPhrase());
            }
        }
    }

    protected void performDefaults() {
        this.snmpV3AgentAddressList.removeAll();
        ArrayList snmpV3InfoList = SnmpV3ManagerConfig.getInstance().getResourceFileParse().getResourceSnmpV3ConfigList();
        String[] snmpV3TargetAddress = new String[snmpV3InfoList.size()];
        int i = 0;
        while (i < snmpV3InfoList.size()) {
            SnmpV3ManagerConfigInfo info = (SnmpV3ManagerConfigInfo)snmpV3InfoList.get(i);
            System.out.println("Address : " + info.getIpAddress());
            snmpV3TargetAddress[i] = info.getIpAddress();
            this.snmpV3AgentAddressList.add(info.getIpAddress());
            ++i;
        }
        this.selectV3AgentAddressText.setText("");
        this.addAgentAddressText.setText("");
        this.removeAgentAddressText.setText("");
        this.engineIDText.setText("");
        this.engineBootText.setText("");
        this.agentLearnedText.setText("");
        this.engineSysUpTimeText.setText("");
        this.userNameText.setText("");
        this.authPrivCombo.select(0);
        this.authProtocolCombo.select(0);
        this.authPassPhrasaText.setText("");
        this.privProtocolText.setText("");
        this.privPassPhrasaText.setText("");
    }

    public boolean performOk() {
        String targetIPAddress = "";
        if (this.selectV3AgentAddressText.getText().equals("")) {
            return false;
        }
        targetIPAddress = this.selectV3AgentAddressText.getText();
        SnmpV3ManagerConfigInfo info = SnmpV3ManagerConfig.getInstance().getResourceFileParse().getSnmpV3AgentInfo(targetIPAddress);
        if (info != null) {
            SnmpV3ManagerUserConfigInfo userInfo = (SnmpV3ManagerUserConfigInfo)info.getUserList().get(0);
            if (userInfo != null) {
                userInfo.setUsername(this.userNameText.getText());
                userInfo.setAuthPriv(this.authPrivCombo.getText());
                userInfo.setAuthProtocol(this.authProtocolCombo.getText());
                userInfo.setAuthPassPhrase(this.authPassPhrasaText.getText());
                userInfo.setPrivProtocol(this.privProtocolText.getText());
                userInfo.setPrivPassPhrase(this.privPassPhrasaText.getText());
            }
            info.addUserList(userInfo);
            info.setIpAddress(targetIPAddress);
            if (this.agentLearnedText.getText().equals(DISCOVERY)) {
                info.setLearned(true);
            } else {
                info.setLearned(false);
            }
        }
        ArrayList<SnmpV3ManagerConfigInfo> saveAgentList = new ArrayList<SnmpV3ManagerConfigInfo>();
        String[] agentListAddress = new String[this.snmpV3AgentAddressList.getItemCount()];
        int i = 0;
        while (this.snmpV3AgentAddressList.getItemCount() > i) {
            agentListAddress[i] = this.snmpV3AgentAddressList.getItem(i);
            if (agentListAddress[i].equals(targetIPAddress)) {
                saveAgentList.add(info);
            } else {
                SnmpV3ManagerConfigInfo workInfo = SnmpV3ManagerConfig.getInstance().getResourceFileParse().getSnmpV3AgentInfo(agentListAddress[i]);
                saveAgentList.add(workInfo);
            }
            ++i;
        }
        this.saveSnmpV3XMLInfo(saveAgentList);
        if (NetJFWatcherApplication.getSnmpV3OperationView() != null) {
            NetJFWatcherApplication.getSnmpV3OperationView().updateSnmpV3AgentList();
        }
        return super.performOk();
    }

    private void saveSnmpV3XMLInfo(ArrayList snmpV3List) {
        Document dom = null;
        BufferedWriter bufWriter = null;
        dom = this.updateSNMPV3Resource(snmpV3List);
        if (dom == null) {
            Shell shell = new Shell();
            MessageDialog.openError((Shell)shell, (String)"Error", (String)"Abort save SNMP V3 config");
            shell.dispose();
            return;
        }
        bufWriter = SnmpV3ManagerConfig.getInstance().getResourceFileParse().getResourceFileWriter();
        this.outputXMLFile(bufWriter, dom);
        if (bufWriter != null) {
            try {
                bufWriter.close();
            }
            catch (IOException e) {
                logger.warning("Abort close BufferedWriter for snmp V3 resource : " + e.getMessage());
                e.printStackTrace();
            }
        }
        SnmpV3ManagerConfig.getInstance().updateResourceset();
    }

    private Document updateSNMPV3Resource(ArrayList snmpV3List) {
        Document dom = SnmpV3ManagerConfig.getInstance().getResourceFileParse().updateDocument(snmpV3List);
        return dom;
    }
}

