/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmpmanager.trap;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.security.GeneralSecurityException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import netjfwatcher.engine.common.model.DataStringDisplay;
import netjfwatcher.snmp.messageformat.SNMPTLV;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.snmpobject.message.SnmpMessage;
import netjfwatcher.snmp.snmpv3.SnmpV3ConfigurationException;
import netjfwatcher.snmp.snmpv3.SnmpV3DecryptAbortException;
import netjfwatcher.snmpmanager.SnmpManagerQueue;
import netjfwatcher.snmpmanager.trap.TrapV1ReceiveMP;
import netjfwatcher.snmpmanager.trap.TrapV2ReceiveMP;
import netjfwatcher.snmpmanager.trap.TrapV3ReceiveMP;

public class TrapDispatcher
extends DataStringDisplay {
    private static Logger logger;

    public TrapDispatcher() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public void disptcher(DatagramSocket dSocket, List listenerList) throws SnmpV3ConfigurationException, GeneralSecurityException, SnmpBadValueException, SnmpV3DecryptAbortException, IOException {
        DatagramPacket inDatagramPacket = new DatagramPacket(new byte[512], 512);
        dSocket.receive(inDatagramPacket);
        byte[] encodedMessage = inDatagramPacket.getData();
        Date date = Calendar.getInstance().getTime();
        SimpleDateFormat dateformat = new SimpleDateFormat("HH:mm:ss");
        logger.info("Receive Trap date : " + dateformat.format(date) + " : Data length : " + inDatagramPacket.getLength() + "Byte");
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue("Receive Trap date : " + dateformat.format(date) + " : Data length : " + inDatagramPacket.getLength() + "Byte");
        logger.info(this.hexBytetoString(encodedMessage, inDatagramPacket.getLength()));
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue(this.hexBytetoString(encodedMessage, inDatagramPacket.getLength()));
        SnmpMessage receivedMessage = new SnmpMessage();
        SNMPTLV nextTLV = receivedMessage.extractNextTLV(encodedMessage, 0);
        receivedMessage.setTLV(nextTLV);
        byte[] versionData = receivedMessage.getVersion();
        byte trapSnmpVersion = versionData[0];
        logger.info("Trap Version : " + this.getVesionDiscrip(trapSnmpVersion));
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue("Trap Version : " + this.hexByte(versionData[0]) + "(" + this.getVesionDiscrip(trapSnmpVersion) + ")");
        byte snmpCommandCode = receivedMessage.getCommand();
        String agentAddress = inDatagramPacket.getAddress().getHostName();
        switch (versionData[0]) {
            case 0: {
                if (snmpCommandCode == -92) {
                    logger.info("SNMP Ver.1 Trap(0xA4) Receive : " + this.hexByte(snmpCommandCode) + "(" + this.getCommandDescription(snmpCommandCode) + ")" + " from " + agentAddress);
                } else if (snmpCommandCode == -89) {
                    logger.warning("SNMP Ver.1 TarpV2(0xA7) Receive : " + this.hexByte(snmpCommandCode) + "(" + this.getCommandDescription(snmpCommandCode) + ")" + " from " + agentAddress);
                }
                TrapV1ReceiveMP mp = new TrapV1ReceiveMP();
                mp.process(agentAddress, encodedMessage, listenerList);
                break;
            }
            case 1: {
                if (snmpCommandCode == -92) {
                    logger.info("SNMP Ver.2 Trap(0xA4) Receive : " + this.hexByte(snmpCommandCode) + "(" + this.getCommandDescription(snmpCommandCode) + ")" + " from " + agentAddress);
                } else if (snmpCommandCode == -89) {
                    logger.warning("SNMP Ver.2 TarpV2(0xA7) Receive : " + this.hexByte(snmpCommandCode) + "(" + this.getCommandDescription(snmpCommandCode) + ")" + " from " + agentAddress);
                }
                TrapV2ReceiveMP mp2 = new TrapV2ReceiveMP();
                mp2.process(agentAddress, encodedMessage, listenerList);
                break;
            }
            case 3: {
                if (snmpCommandCode == -92) {
                    logger.info("SNMP Ver.3 Trap(0xA4) Receive : " + this.hexByte(snmpCommandCode) + "(" + this.getCommandDescription(snmpCommandCode) + ")" + " from " + agentAddress);
                } else if (snmpCommandCode == -89) {
                    logger.warning("SNMP Ver.3 TarpV2(0xA7) Receive : " + this.hexByte(snmpCommandCode) + "(" + this.getCommandDescription(snmpCommandCode) + ")" + " from " + agentAddress);
                }
                TrapV3ReceiveMP mp3 = new TrapV3ReceiveMP();
                mp3.process(agentAddress, encodedMessage, listenerList);
                break;
            }
            default: {
                logger.warning("Unknown SNMP Trap version : " + versionData[0]);
            }
        }
    }

    private String getVesionDiscrip(int version) {
        String snmpVersion = "";
        switch (version) {
            case 0: {
                snmpVersion = "SnmpV1";
                break;
            }
            case 1: {
                snmpVersion = "SnmpV2c";
                break;
            }
            case 3: {
                snmpVersion = "SnmpV3";
                break;
            }
            default: {
                logger.warning("Bad Snmp version: " + version);
            }
        }
        return snmpVersion;
    }

    private String getCommandDescription(byte code) {
        String snmpCode = "";
        switch (code) {
            case -92: {
                snmpCode = "Trap-PDU";
                break;
            }
            case -89: {
                snmpCode = "Trap2-PDU";
                break;
            }
            case -90: {
                snmpCode = "Inform-PDU";
                break;
            }
            case -96: {
                snmpCode = "GetRequest";
                break;
            }
            case -95: {
                snmpCode = "GetNextRequest";
                break;
            }
            case -93: {
                snmpCode = "SetRequest";
                break;
            }
            case -94: {
                snmpCode = "GetResponse";
                break;
            }
            default: {
                snmpCode = "Unknown";
                logger.warning("Undefined SNMP Command code : " + code);
            }
        }
        return snmpCode;
    }
}

