/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.socketclient;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import netjfwatcher.engine.resourceconfig.EngineResourceConfig;
import netjfwatcher.engine.resourceconfig.EngineResourceInfo;
import netjfwatcher.engine.view.editorpart.common.AbstractEditorNodeView;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeView;
import netjfwatcher.socketclient.XMLSocketConnectThread;
import netjfwatcher.socketclient.XMLSocketConnectTimerProcessor;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;

public class XMLSocketEditorView
extends AbstractEditorNodeView {
    public static final String TITLE_SUFFIX = "XML Socket Connection";
    private static final int[] SCROLL_COMPOSITE_SIZE = new int[]{400, 300};
    private static final int LIST_WIDTHHINT = 200;
    private static final int LIST_VERTIALSPAN = 7;
    private static final int LIST_ITEMHEIGHT = 10;
    private List detinationEngineAddressList;
    private List messageList;
    private ArrayList engineList;
    private HashMap engineMap;
    private Display display;
    private static Logger logger;
    private XMLSocketConnectTimerProcessor timerProcessor;
    private Button connectButton;
    private Button disconnectButton;
    private Button messageResetButton;
    private Color textBackColor;

    public XMLSocketEditorView() {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        this.engineMap = new HashMap();
        this.textBackColor = Display.getCurrent().getSystemColor(1);
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        this.display = parent.getDisplay();
        EditorInputNodeView cfr_ignored_0 = (EditorInputNodeView)this.getEditorInput();
        ScrolledComposite scrollComposite = new ScrolledComposite(parent, 768);
        GridLayout layout = new GridLayout(1, false);
        scrollComposite.setLayout((Layout)layout);
        GridData gridData = null;
        GridLayout gridLayout0 = new GridLayout(1, true);
        Composite composite0 = new Composite((Composite)scrollComposite, 0);
        composite0.setLayout((Layout)gridLayout0);
        composite0.setLayoutData((Object)new GridData(272));
        GridLayout gridLayout = new GridLayout(4, false);
        Composite composite1 = new Composite(composite0, 0);
        composite1.setLayout((Layout)gridLayout);
        composite1.setLayoutData((Object)new GridData(256));
        gridData = new GridData();
        this.connectButton = new Button(composite1, 0);
        this.connectButton.setText("Connect");
        this.disconnectButton = new Button(composite1, 0);
        this.disconnectButton.setText("Disconnect");
        GridLayout gridLayout2 = new GridLayout(6, false);
        Composite composite2 = new Composite(composite0, 0);
        composite2.setLayoutData((Object)new GridData(256));
        composite2.setLayout((Layout)gridLayout2);
        Label label = new Label(composite2, 0);
        label.setText("Engine List");
        label.setLayoutData((Object)new GridData());
        label = new Label(composite2, 0);
        label.setText("     ");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Message List");
        label.setLayoutData((Object)new GridData());
        label = new Label(composite2, 0);
        label.setText("     ");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.detinationEngineAddressList = new List(composite2, 2820);
        GridData data = new GridData(1808);
        data.horizontalSpan = 1;
        data.verticalSpan = 7;
        data.widthHint = 200;
        data.heightHint = this.detinationEngineAddressList.getItemHeight() * 10;
        this.detinationEngineAddressList.setLayoutData((Object)data);
        label = new Label(composite2, 0);
        label.setText("    ");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 7;
        label.setLayoutData((Object)gridData);
        this.messageResetButton = new Button(composite2, 0);
        this.messageResetButton.setText("Message Reset");
        gridData = new GridData(2);
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 7;
        this.messageResetButton.setLayoutData((Object)gridData);
        GridData data2 = new GridData(1808);
        this.messageList = new List(composite2, 2820);
        data2.horizontalSpan = 1;
        data2.verticalSpan = 7;
        data2.widthHint = 400;
        data2.heightHint = this.messageList.getItemHeight() * 10;
        this.messageList.setLayoutData((Object)data2);
        scrollComposite.setContent((Control)composite0);
        scrollComposite.setMinSize(SCROLL_COMPOSITE_SIZE[0], SCROLL_COMPOSITE_SIZE[1]);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.setExpandVertical(true);
        this.disconnectButton.setEnabled(false);
        this.connectButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                XMLSocketEditorView.this.startXMLSocket();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.disconnectButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                XMLSocketEditorView.this.disconnectButton.setEnabled(false);
                XMLSocketEditorView.this.connectButton.setEnabled(true);
                try {
                    XMLSocketEditorView.this.startTimer();
                    XMLSocketConnectThread.getInstance().stopXMLSocketConnectThread();
                }
                catch (Exception e) {
                    XMLSocketEditorView.this.disconnectButton.setEnabled(true);
                    e.printStackTrace();
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.messageResetButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                XMLSocketEditorView.this.messageResetButton.setEnabled(false);
                try {
                    XMLSocketEditorView.this.messageList.removeAll();
                }
                finally {
                    XMLSocketEditorView.this.messageResetButton.setEnabled(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.startXMLSocket();
        this.setList();
    }

    private void startXMLSocket() {
        this.engineList = EngineResourceConfig.getInstance().getEngineInfo().getEngineInfoList();
        try {
            this.connectButton.setEnabled(false);
            this.disconnectButton.setEnabled(true);
            this.startTimer();
            XMLSocketConnectThread.getInstance().startXMLSocketConnectThread(this.engineList);
        }
        catch (Exception e) {
            this.connectButton.setEnabled(true);
            e.printStackTrace();
        }
    }

    private void setList() {
        this.engineList = EngineResourceConfig.getInstance().getEngineInfo().getEngineInfoList();
        if (XMLSocketConnectThread.getInstance().checkThread()) {
            this.disconnectButton.setEnabled(true);
            this.connectButton.setEnabled(false);
            return;
        }
        this.detinationEngineAddressList.removeAll();
        String engineAddress = "";
        this.engineMap.clear();
        int i = 0;
        while (i < this.engineList.size()) {
            engineAddress = ((EngineResourceInfo)this.engineList.get(i)).getEngineIPaddress();
            ((EngineResourceInfo)this.engineList.get(i)).getEnginePort();
            this.detinationEngineAddressList.add(String.valueOf(engineAddress) + " Unconnect");
            this.engineMap.put(((EngineResourceInfo)this.engineList.get(i)).getEngineIPaddress(), this.engineList.get(i));
            ++i;
        }
    }

    protected void setStatusLine() {
        this.statusLineManager = (SubStatusLineManager)this.getEditorSite().getActionBars().getStatusLineManager();
        this.statusLineManager.setVisible(true);
    }

    private void startTimer() {
        XMLSocketConnectTimerProcessor.getInstance().setDisplay(this.display);
        this.timerProcessor = XMLSocketConnectTimerProcessor.getInstance();
        this.timerProcessor.setEditorSite(this.getEditorSite());
        this.timerProcessor.setList(this.detinationEngineAddressList, this.messageList);
        this.display.timerExec(1000, (Runnable)this.timerProcessor);
    }

    private void stopTimer() {
        this.display.timerExec(-1, (Runnable)this.timerProcessor);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.textBackColor != null) {
            this.textBackColor.dispose();
        }
    }
}

