/*
 * Created on 2004/04/27
 *
 *
 *@Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.database.access.model;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;

import netjfwatcher.database.access.control.AbstractDataAccessObject;
import netjfwatcher.database.access.control.DatabaseAccess;
import netjfwatcher.database.access.control.DatabaseAccessControlKind;
import netjfwatcher.database.access.control.DatabaseAccessPool;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.engine.socket.info.AlarmInformation;
import netjfwatcher.engine.socket.info.DatabaseWatcherInfo;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.view.editorpart.node.EditorNodeOperationInitialData;


/**
 * m[hĎe[u𑀍삷郁\bh܂B
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class DBTableNodeRegister extends DBTableBase {
    /** m[hĎe[u */
    public static final String NODE_REGISTER_TABLE = "noderegister";

    /** m[hJ */
    public static final String NODENAME = "nodename";

    /** m[hIPAhX J */
    public static final String IPADDRESS = "ipaddress";

    /** m[hO[v J */
    public static final String NODEGROUP = "nodegroup";

    /** m[hIcon XW J */
    public static final String NODEX = "nodeX";

    /** m[hIcon YW J */
    public static final String NODEY = "nodeY";

    /** m[h J */
    public static final String NODEKIND = "nodeKind";

    /** PingĎ J */
    public static final String PING_PERIOD = "ping_period";

    /** Ping臒l J */
    public static final String PING_THRESHOLD = "ping_threshold";

    /** SNMPĎo[W J */
    public static final String SNMP_VERSION = "snmpVersion";

    /** SNMPĎ J */
    public static final String SNMP_PERIOD = "snmp_period";

    /** SNMPĎ^CAEg J */
    public static final String SNMPTIMEOUT = "snmp_timeout";

    /** SNMPĎx J */
    public static final String SNMP_LEVEL = "snmp_level";

    /** SNMP ReadR~jeB J */
    public static final String SNMP_ROCOMMUNITY = "community";

    /** SNMP Read?writeR~jeB J */
    public static final String SNMP_RWCOMMUNITY = "RWCommunity";

    /** HTTPT[oĎURL J */
    public static final String HTTP_URL = "http_url";

    /** HTTPT[oĎ J */
    public static final String HTTP_PERIOD = "http_period";

    /** HTTPT[oĎ|[g J */
    public static final String HTTP_PORT = "http_port";

    /**  J */
    public static final String HTTP_TIMEOUT = "http_timeout";

    /** Pop3T[oĎ J */
    public static final String POP3_PERIOD = "pop3_period";

    /** Pop3T[o[U J */
    public static final String POP3_USER = "pop3_user";

    /** Pop3T[opX[h J */
    public static final String POP3_PASSWORD = "pop3_password";

    /** Pop3T[oĎ|[g J */
    public static final String POP3_PORT = "pop3_port";

    /** Pop3T[oĎ^CAEg J */
    public static final String POP3_TIMEOUT = "pop3_timeout";

    /** SMTPT[oĎ J */
    public static final String SMTP_PERIOD = "smtp_period";

    /** SMTPT[o|[g J */
    public static final String SMTP_PORT = "smtp_port";

    /** SMTPT[oĎ^CAEg J */
    public static final String SMTP_TIMEOUT = "smtp_timeout";

    /**  J */
    public static final String SMTP_TEST_ADDRESS = "smtp_test_address";

    /** SMTPM`FbNPopT[ozXg J */
    public static final String SMTP_CHECK_POP_HOST = "smtp_check_pop_host";

    /** SMTPM`FbNPopT[o[U J */
    public static final String SMTP_CHECK_POP_USER = "smtp_check_pop_user";

    /** SMTPM`FbNPopT[opX[h J */
    public static final String SMTP_CHECK_POP_PASSWORD =
        "smtp_check_pop_password";

    /** SMTPM`FbNPopT[o|[g J */
    public static final String SMTP_CHECK_POP_PORT = "smtp_check_pop_port";

    /** SMTPM`FbNPopT[oĎ^CAEg J */
    public static final String SMTP_CHECK_POP_TIMEOUT =
        "smtp_check_pop_timeout";

    /** m[ho^GWAhX J */
    public static final String ENGINE_ADDRESS = "engine_Address";

    /** m[hĎŐV J */
    public static final String LAST_CHECK = "last_check";

    /** m[ho^ J */
    public static final String REGISTER_DATE = "register_date";

    /* MO */
    private static Logger logger = null;

    /* tH[}bg */
    private final DateFormat simpleDateformat =
        new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    /**
     * m[hĎe[u𑀍삷VOgNX
     * CX^X𐶐܂B
     *
     */
    private DBTableNodeRegister() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * m[hĎe[u𑀍삷VOgNX
     * CX^XԂ܂B
     *
     * @return VOgNXCX^X
     */
    public static DBTableNodeRegister getInstance() {
        return SingletonResource.RESOURCE;
    }

    /**
     * m[hĎe[u𐶐܂B
     *
     * @throws DatabaseConnectionException f[^x[XRlNV
     * 擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public synchronized void createTable()
        throws DatabaseConnectionException, SQLException {
        DatabaseAccess databaseAccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        try {
            // UÃe[u폜
            AbstractDataAccessObject dataaccessobject =
                DatabaseAccessControlKind.getInstance().getDataAccessObject();
            this.deleteTable(databaseAccess, NODE_REGISTER_TABLE);

            // m[hĎf[^x[XEe[u쐬
            databaseAccess.executeUpdate(
                dataaccessobject.getCreateNoderegisterTable());
        } finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                    databaseAccess);
            }
        }
    }

    /**
     * m[hĎe[u폜܂B
     *
     * @throws DatabaseConnectionException f[^x[XRlNV
     * 擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public synchronized void dropTable()
        throws DatabaseConnectionException, SQLException {
        // DatabaseAccess databaseAccess = new DatabaseAccess();
        DatabaseAccess databaseAccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        try {
            // ̃e[u폜
            this.deleteTable(databaseAccess, NODE_REGISTER_TABLE);
        } finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                    databaseAccess);
            }
        }
    }

    /**
     * m[hĎǉ܂B
     *
     * @param registerNodeInfo m[hĎ
     * @return isSuccess XV
     * @throws DatabaseConnectionException f[^x[XRlNV
     * 擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public synchronized boolean registerNode(
        final NodeInformation registerNodeInfo)
        throws SQLException, DatabaseConnectionException {
        NodeInformation nodeInfo = checkNodeInfo(registerNodeInfo);
        boolean isSuccess = false;

        // DatabaseAccess dataaccess = new DatabaseAccess();
        DatabaseAccess dataaccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        try {
            /*
             * Timestamp format for HSQLDB
             */
            Date date = Calendar.getInstance().getTime();

            //sql̍쐬
            String sql =
                "INSERT INTO " + NODE_REGISTER_TABLE + "( "
                + DBTableNodeRegister.NODENAME + ", "
                + DBTableNodeRegister.IPADDRESS + ", "
                + DBTableNodeRegister.NODEGROUP + ", "
                + DBTableNodeRegister.NODEX + ", " + DBTableNodeRegister.NODEY
                + ", " + DBTableNodeRegister.NODEKIND + ", "
                /* ping(icmp) */
                + DBTableNodeRegister.PING_PERIOD + ", "
                + DBTableNodeRegister.PING_THRESHOLD + ", "
                /* snmp */
                + DBTableNodeRegister.SNMP_VERSION + ", "
                + DBTableNodeRegister.SNMP_PERIOD + ", "
                + DBTableNodeRegister.SNMP_LEVEL + ", "
                + DBTableNodeRegister.SNMP_ROCOMMUNITY + ", "
                + DBTableNodeRegister.SNMP_RWCOMMUNITY + ", "
                /* http */
                + DBTableNodeRegister.HTTP_URL + ", "
                + DBTableNodeRegister.HTTP_PERIOD + ", "
                + DBTableNodeRegister.HTTP_PORT + ", "
                + DBTableNodeRegister.HTTP_TIMEOUT + ", "
                /* pop */
                + DBTableNodeRegister.POP3_PERIOD + ", "
                + DBTableNodeRegister.POP3_USER + ", "
                + DBTableNodeRegister.POP3_PASSWORD + ", "
                + DBTableNodeRegister.POP3_PORT + ", "
                + DBTableNodeRegister.POP3_TIMEOUT + ", "
                /* smtp */
                + DBTableNodeRegister.SMTP_PERIOD + ", "
                + DBTableNodeRegister.SMTP_PORT + ", "
                + DBTableNodeRegister.SMTP_TIMEOUT + ", "
                + DBTableNodeRegister.SMTP_TEST_ADDRESS + ", "
                + DBTableNodeRegister.SMTP_CHECK_POP_HOST + ", "
                + DBTableNodeRegister.SMTP_CHECK_POP_USER + ", "
                + DBTableNodeRegister.SMTP_CHECK_POP_PASSWORD + ", "
                + DBTableNodeRegister.SMTP_CHECK_POP_PORT + ", "
                + DBTableNodeRegister.SMTP_CHECK_POP_TIMEOUT + ", "
                /*  */
                + DBTableNodeRegister.ENGINE_ADDRESS + ", "
                + DBTableNodeRegister.REGISTER_DATE + " )" /* Value */
                + "VALUES ( '" + nodeInfo.getNodename() + "','"
                + nodeInfo.getIpaddress() + "','" + nodeInfo.getGroup() + "','"
                + nodeInfo.getNodeX() + "','" + nodeInfo.getNodeY() + "','"
                + nodeInfo.getNodeKind() + "','" + nodeInfo.getPingPeriod()
                + "','" + nodeInfo.getPingThreshold() + "','"
                + nodeInfo.getSnmpVersion() + "','" + nodeInfo.getSnmpPeriod()
                + "','" + nodeInfo.getSnmpLevel() + "','"
                + nodeInfo.getRoCommunity() + "','" + nodeInfo.getRwCommunity()
                + "','" + nodeInfo.getHttpUrl() + "','"
                + nodeInfo.getHttpPeriod() + "','" + nodeInfo.getHttpPort()
                + "','" + nodeInfo.getHttpTimeout() + "','"
                + nodeInfo.getPopPeriod() + "','" + nodeInfo.getPopUser()
                + "','" + nodeInfo.getPopPassword() + "','"
                + nodeInfo.getPopPort() + "','" + nodeInfo.getPopTimeout()
                + "','" + nodeInfo.getSmtpPeriod() + "','"
                + nodeInfo.getSmtpPort() + "','" + nodeInfo.getSmtpTimeout()
                + "','" + nodeInfo.getSmtpSendAddress() + "','"
                + nodeInfo.getSmtpCheckHost() + "','"
                + nodeInfo.getSmtpCheckUser() + "','"
                + nodeInfo.getSmtpCheckPassword() + "','"
                + nodeInfo.getSmtpCheckPort() + "','"
                + nodeInfo.getSmtpCheckTimeout() + "','"
                + nodeInfo.getEngineAddress() + "','"
                + simpleDateformat.format(date) + "' )";

            dataaccess.executeUpdate(sql);

            // dataaccess.executeUpdate(AbstractDataAccessObject.COMMIT);
            isSuccess = true;
        } finally {
            if (dataaccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                    dataaccess);
            }
        }

        return isSuccess;
    }

    /**
     * m[hĎe[uXV܂B
     *
     * @param updateNodeInfo m[hĎ
     * @return isSuccess XV
     * @throws DatabaseConnectionException f[^x[XRlNV擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public synchronized boolean updateNode(NodeInformation updateNodeInfo)
        throws SQLException, DatabaseConnectionException {
        NodeInformation nodeInfo = checkNodeInfo(updateNodeInfo);

        boolean isSuccess = false;

        // DatabaseAccess dataaccess = new DatabaseAccess();
        DatabaseAccess dataaccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        try {
            Date date = Calendar.getInstance().getTime();

            //sql̍쐬
            String sql =
                "UPDATE " + NODE_REGISTER_TABLE + " set "
                + DBTableNodeRegister.NODENAME + "='" + nodeInfo.getNodename()
                + "', " + DBTableNodeRegister.IPADDRESS + "='"
                + nodeInfo.getIpaddress() + "', "
                + DBTableNodeRegister.NODEGROUP + "='" + nodeInfo.getGroup()
                + "', " + DBTableNodeRegister.NODEX + "= " + "'"
                + nodeInfo.getNodeX() + "', " + DBTableNodeRegister.NODEY
                + "= " + "'" + nodeInfo.getNodeY() + "', "
                + DBTableNodeRegister.NODEKIND + "='" + nodeInfo.getNodeKind()
                + "', " + DBTableNodeRegister.PING_PERIOD + "='"
                + nodeInfo.getPingPeriod() + "', "
                + DBTableNodeRegister.PING_THRESHOLD + "='"
                + nodeInfo.getPingThreshold() + "', "
                + DBTableNodeRegister.SNMP_VERSION + "='"
                + nodeInfo.getSnmpVersion() + "', "
                + DBTableNodeRegister.SNMP_PERIOD + "='"
                + nodeInfo.getSnmpPeriod() + "', "
                + DBTableNodeRegister.SNMP_LEVEL + "='"
                + nodeInfo.getSnmpLevel() + "', "
                + DBTableNodeRegister.SNMPTIMEOUT + "= " + "'"
                + nodeInfo.getSnmpTimeout() + "', "
                + DBTableNodeRegister.SNMP_ROCOMMUNITY + "='"
                + nodeInfo.getRoCommunity() + "', "
                + DBTableNodeRegister.SNMP_RWCOMMUNITY + "='"
                + nodeInfo.getRwCommunity() + "', "
                + DBTableNodeRegister.HTTP_URL + "='" + nodeInfo.getHttpUrl()
                + "', " + DBTableNodeRegister.HTTP_PERIOD + "='"
                + nodeInfo.getHttpPeriod() + "', "
                + DBTableNodeRegister.HTTP_PORT + "= " + "'"
                + nodeInfo.getHttpPort() + "', "
                + DBTableNodeRegister.HTTP_TIMEOUT + "= " + "'"
                + nodeInfo.getHttpTimeout() + "', "
                + DBTableNodeRegister.POP3_PERIOD + "='"
                + nodeInfo.getPopPeriod() + "', "
                + DBTableNodeRegister.POP3_USER + "='" + nodeInfo.getPopUser()
                + "', " + DBTableNodeRegister.POP3_PASSWORD + "='"
                + nodeInfo.getPopPassword() + "', "
                + DBTableNodeRegister.POP3_PORT + "='" + nodeInfo.getPopPort()
                + "', " + DBTableNodeRegister.POP3_TIMEOUT + "='"
                + nodeInfo.getPopTimeout() + "', "
                + DBTableNodeRegister.SMTP_PERIOD + "='"
                + nodeInfo.getSmtpPeriod() + "', "
                + DBTableNodeRegister.SMTP_PORT + "='" + nodeInfo.getSmtpPort()
                + "', " + DBTableNodeRegister.SMTP_TIMEOUT + "='"
                + nodeInfo.getSmtpTimeout() + "', "
                + DBTableNodeRegister.SMTP_TEST_ADDRESS + "='"
                + nodeInfo.getSmtpSendAddress() + "', "
                + DBTableNodeRegister.SMTP_CHECK_POP_HOST + "='"
                + nodeInfo.getSmtpCheckHost() + "', "
                + DBTableNodeRegister.SMTP_CHECK_POP_USER + "='"
                + nodeInfo.getSmtpCheckUser() + "', "
                + DBTableNodeRegister.SMTP_CHECK_POP_PASSWORD + "='"
                + nodeInfo.getSmtpCheckPassword() + "', "
                + DBTableNodeRegister.SMTP_CHECK_POP_PORT + "='"
                + nodeInfo.getSmtpCheckPort() + "', "
                + DBTableNodeRegister.SMTP_CHECK_POP_TIMEOUT + "='"
                + nodeInfo.getSmtpCheckTimeout() + "', "
                + DBTableNodeRegister.ENGINE_ADDRESS + "= " + "'"
                + nodeInfo.getEngineAddress() + "', "
                + DBTableNodeRegister.REGISTER_DATE + "='"
                + simpleDateformat.format(date) + "' " + " where "
                + DBTableNodeRegister.IPADDRESS + "='"
                + nodeInfo.getIpaddress() + "'";

            dataaccess.executeUpdate(sql);

            // dataaccess.executeUpdate(AbstractDataAccessObject.COMMIT);
            isSuccess = true;
        } finally {
            if (dataaccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                    dataaccess);
            }
        }

        return isSuccess;
    }

    /**
     * m[hĎ`FbNAُf[^𖳌ɂ܂B
     *
     * @param nodeInfo m[hĎ
     * @return nodeInfo m[hĎ
     */
    public synchronized NodeInformation checkNodeInfo(NodeInformation nodeInfo) {
        if (
            (nodeInfo.getNodename() == null)
                || nodeInfo.getNodename().equals("null")) {
            nodeInfo.setNodename("");
        }

        if (
            (nodeInfo.getIpaddress() == null)
                || nodeInfo.getIpaddress().equals("null")) {
            nodeInfo.setIpaddress("");
        }

        if ((nodeInfo.getGroup() == null) || nodeInfo.getGroup().equals("null")) {
            nodeInfo.setGroup("");
        }

        if ((nodeInfo.getNodeX() == null) || nodeInfo.getNodeX().equals("null")) {
            nodeInfo.setNodeX("");
        }

        if ((nodeInfo.getNodeY() == null) || nodeInfo.getNodeY().equals("null")) {
            nodeInfo.setNodeY("");
        }

        if (
            (nodeInfo.getNodeKind() == null)
                || nodeInfo.getNodeKind().equals("null")) {
            nodeInfo.setNodeKind("");
        }

        if (
            (nodeInfo.getNodeKind() == null)
                || nodeInfo.getNodeKind().equals("null")) {
            nodeInfo.setNodeKind("");
        }

        if (
            (nodeInfo.getPingPeriod() == null)
                || nodeInfo.getPingPeriod().equals("null")) {
            nodeInfo.setPingPeriod("0");
        }

        if (
            (nodeInfo.getPingThreshold() == null)
                || nodeInfo.getPingThreshold().equals("null")) {
            nodeInfo.setPingThreshold("0");
        }

        if (
            (nodeInfo.getSnmpVersion() == null)
                || nodeInfo.getSnmpVersion().equals("null")) {
            nodeInfo.setSnmpVersion("SNMPV1");
        }

        if (
            (nodeInfo.getSnmpPeriod() == null)
                || nodeInfo.getSnmpPeriod().equals("null")) {
            nodeInfo.setSnmpPeriod("0");
        }

        if (
            (nodeInfo.getSnmpLevel() == null)
                || nodeInfo.getSnmpLevel().equals("null")) {
            nodeInfo.setSnmpLevel("0");
        }

        if (
            (nodeInfo.getSnmpTimeout() == null)
                || nodeInfo.getSnmpTimeout().equals("null")) {
            nodeInfo.setSnmpTimeout("");
        }

        if (
            (nodeInfo.getRoCommunity() == null)
                || nodeInfo.getRoCommunity().equals("null")) {
            nodeInfo.setRoCommunity("");
        }

        if (
            (nodeInfo.getRwCommunity() == null)
                || nodeInfo.getRwCommunity().equals("null")) {
            nodeInfo.setRwCommunity("");
        }

        if (
            (nodeInfo.getHttpUrl() == null)
                || nodeInfo.getHttpUrl().equals("null")) {
            nodeInfo.setHttpUrl("");
        }

        if (
            (nodeInfo.getHttpPeriod() == null)
                || nodeInfo.getHttpPeriod().equals("null")) {
            nodeInfo.setHttpPeriod("0");
        }

        if (
            (nodeInfo.getHttpTimeout() == null)
                || nodeInfo.getHttpTimeout().equals("null")) {
            nodeInfo.setHttpTimeout("");
        }

        if (
            (nodeInfo.getHttpPort() == null)
                || nodeInfo.getHttpPort().equals("null")) {
            nodeInfo.setHttpPort("");
        }

        if (
            (nodeInfo.getPopPeriod() == null)
                || nodeInfo.getPopPeriod().equals("null")) {
            nodeInfo.setPopPeriod("0");
        }

        if (
            (nodeInfo.getPopUser() == null)
                || nodeInfo.getPopUser().equals("null")) {
            nodeInfo.setPopUser("");
        }

        if (
            (nodeInfo.getPopPassword() == null)
                || nodeInfo.getPopPassword().equals("null")) {
            nodeInfo.setPopPassword("");
        }

        if (
            (nodeInfo.getPopPort() == null)
                || nodeInfo.getPopPort().equals("null")) {
            nodeInfo.setPopPort("");
        }

        if (
            (nodeInfo.getPopTimeout() == null)
                || nodeInfo.getPopTimeout().equals("null")) {
            nodeInfo.setPopTimeout("");
        }

        if (
            (nodeInfo.getSmtpPeriod() == null)
                || nodeInfo.getSmtpPeriod().equals("null")) {
            nodeInfo.setSmtpPeriod("0");
        }

        if (
            (nodeInfo.getSmtpPort() == null)
                || nodeInfo.getSmtpPort().equals("null")) {
            nodeInfo.setSmtpPort("");
        }

        if (
            (nodeInfo.getSmtpTimeout() == null)
                || nodeInfo.getSmtpTimeout().equals("null")) {
            nodeInfo.setSmtpTimeout("");
        }

        if (
            (nodeInfo.getSmtpSendAddress() == null)
                || nodeInfo.getSmtpSendAddress().equals("null")) {
            nodeInfo.setSmtpSendAddress("");
        }

        if (
            (nodeInfo.getSmtpCheckHost() == null)
                || nodeInfo.getSmtpCheckHost().equals("null")) {
            nodeInfo.setSmtpCheckHost("");
        }

        if (
            (nodeInfo.getSmtpCheckUser() == null)
                || nodeInfo.getSmtpCheckUser().equals("null")) {
            nodeInfo.setSmtpCheckUser("");
        }

        if (
            (nodeInfo.getSmtpCheckPassword() == null)
                || nodeInfo.getSmtpCheckPassword().equals("null")) {
            nodeInfo.setSmtpCheckPassword("");
        }

        if (
            (nodeInfo.getSmtpCheckPort() == null)
                || nodeInfo.getSmtpCheckPort().equals("null")) {
            nodeInfo.setSmtpCheckPort("");
        }

        if (
            (nodeInfo.getSmtpCheckTimeout() == null)
                || nodeInfo.getSmtpCheckTimeout().equals("null")) {
            nodeInfo.setSmtpCheckTimeout("");
        }

        return nodeInfo;
    }

    /**
     * m[hĎsŐVm[hĎe[ũJɃAbvf[g܂B
     *
     * @param ipaddress m[hIPAhX
     * @throws SQLException f[^x[XANZXɎsꍇ
     * @throws DatabaseConnectionException f[^x[XRlNV擾ňُ킪ꍇ
     */
    public synchronized void upDateLastCheck(final String ipaddress)
        throws DatabaseConnectionException, SQLException {
        DatabaseAccess databaseAccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        Date date = Calendar.getInstance().getTime();

        //sql̍쐬
        String sql =
            "UPDATE " + NODE_REGISTER_TABLE + " set " + LAST_CHECK + "= " + "'"
            + simpleDateformat.format(date) + "'" + " where " + IPADDRESS
            + "= " + "'" + ipaddress + "'";

        try {
            // XVSQLs
            databaseAccess.executeUpdate(sql);
        } catch (DatabaseConnectionException e) {
            logger.warning(e.getMessage());
            throw e;
        } catch (SQLException e) {
            logger.warning(e.getMessage());
            throw e;
        } finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                    databaseAccess);
            }
        }
    }

    /**
     * f[^x[Xm[h擾ăXgƂĕԂ܂B
     * Xg̊i[́Aw̃\[gΏۃJƏ/~wɂ܂B
     *
     * @param sortColumn \[gJ
     * @param sortDirection \[g
     * @return m[hĎ񃊃Xg
     * @throws DatabaseConnectionException f[^x[XRlNV擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public synchronized ArrayList getNodeInfoList(
        String sortColumn, String sortDirection)
        throws SQLException, DatabaseConnectionException {
        String sqlext = "";

        if ((sortColumn != null) && (sortDirection != null)) {
            sqlext = " order by " + sortColumn + " " + sortDirection;
        }

        ArrayList nodeList = null;
        nodeList = getNodeList(sqlext);

        return nodeList;
    }

    /**
     * Q̃\[gJyу\[gɂăm[hĎ񃊃Xg
     * 擾܂B
     *
     * @param sortColumn \[gJ1
     * @param sortDirection \[g1
     * @param sortColumn2 \[gJ2
     * @param sortDirection2 \[g2
     * @return m[hĎ񃊃Xg
     * @throws DatabaseConnectionException f[^x[XRlNV
     * 擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public synchronized ArrayList getNodeInfoList(
        String sortColumn, String sortDirection, String sortColumn2,
        String sortDirection2) throws SQLException, DatabaseConnectionException {
        String sqlext = "";

        if ((sortColumn != null) && (sortColumn2 != null)) {
            sqlext =
                " order by " + sortColumn + " " + sortDirection + " , "
                + sortColumn2 + " " + sortDirection2;
        }

        ArrayList nodeList = null;
        nodeList = getNodeList(sqlext);

        return nodeList;
    }

    /*
     * wSQLŃm[hĎ񃊃Xg擾܂B
     *
     * @param sqlext SQL
     * @return m[hĎ񃊃Xg
     * @throws DatabaseConnectionException f[^x[XRlNV擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    private ArrayList getNodeList(String sqlext)
        throws SQLException, DatabaseConnectionException {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        ArrayList nodeList = null;

        // DatabaseAccess dataaccess = new DatabaseAccess();
        DatabaseAccess dataaccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        DBTableAlarm alarmDBTable = DBTableAlarm.getInstance();

        try {
            String sql = "SELECT * from " + NODE_REGISTER_TABLE + sqlext;
            conn = dataaccess.getConnection();

            // SQLXe[ggIuWFNg̍쐬
            stmt = conn.createStatement();

            // select̎s
            rs = stmt.executeQuery(sql);
            nodeList = new ArrayList();

            int nodeCount = 0;

            while (rs.next()) {
                NodeInformation nodeInformation = new NodeInformation();

                /*
                 * m[hXg\ɃgOɐFs߂Ƀm[hɋԍƊԍ
                 * ߍ
                 */
                if ((nodeCount % 2) == 0) {
                    nodeInformation.setNumberEvenOdd("Even");
                } else {
                    nodeInformation.setNumberEvenOdd("Odd");
                }

                /* m[h\ԍ𖄂ߍ */
                nodeInformation.setNodeNumber(Integer.toString(nodeCount));
                nodeCount++;

                String ipAddress = rs.getObject(IPADDRESS).toString();
                nodeInformation.setNodename(rs.getObject(NODENAME).toString());
                nodeInformation.setIpaddress(ipAddress);
                nodeInformation.setGroup(rs.getObject(NODEGROUP).toString());

                String nodeX = (String) rs.getObject(NODEX);

                if (
                    (nodeX == null) || nodeX.equals("null")
                        || nodeX.equals("0") || nodeX.equals("")) {
                    nodeX = Integer.toString(50 + (60 * nodeCount));
                }

                nodeInformation.setNodeX(nodeX);

                String nodeY = (String) rs.getObject(NODEY);

                if (
                    (nodeY == null) || nodeY.equals("null")
                        || nodeY.equals("0") || nodeY.equals("")) {
                    nodeY = Integer.toString(50 + (40 * nodeCount));
                }

                nodeInformation.setNodeY(nodeY);

                String nodeKind = (String) rs.getObject(NODEKIND);

                if ((nodeKind == null) || nodeKind.equals("")) {
                    nodeKind = "unkonown";
                }

                nodeInformation.setNodeKind(nodeKind);

                nodeInformation.setPingThreshold(
                    rs.getObject(PING_THRESHOLD).toString());

                nodeInformation.setSnmpVersion(
                    rs.getObject(SNMP_VERSION).toString());
                nodeInformation.setSnmpLevel(
                    rs.getObject(SNMP_LEVEL).toString());
                nodeInformation.setRoCommunity(
                    rs.getObject(SNMP_ROCOMMUNITY).toString());
                nodeInformation.setRwCommunity(
                    rs.getObject(SNMP_RWCOMMUNITY).toString());

                if (rs.getObject(REGISTER_DATE) == null) {
                    logger.warning("REGISTER_DATE null");
                } else {
                    String optimeString =
                        convRegisterDate(
                            (Date) rs.getObject(
                                DBTableNodeRegister.REGISTER_DATE));

                    nodeInformation.setRegisterDate(
                        rs.getObject(DBTableNodeRegister.REGISTER_DATE)
                          .toString() + optimeString);
                }

                String pingPeriod = (String) rs.getObject(PING_PERIOD);

                if (
                    (pingPeriod == null) || pingPeriod.equals("")
                        || pingPeriod.equals("0")) {
                    pingPeriod = "--";
                }

                nodeInformation.setPingPeriod(pingPeriod);

                String snmpPeriod = (String) rs.getObject(SNMP_PERIOD);

                if (
                    (snmpPeriod == null) || snmpPeriod.equals("")
                        || snmpPeriod.equals("0")) {
                    snmpPeriod = "--";
                }

                nodeInformation.setSnmpPeriod(snmpPeriod);

                /*
                 * http
                 */
                String httpPeriod = (String) rs.getObject(HTTP_PERIOD);

                if (
                    (httpPeriod == null) || httpPeriod.equals("")
                        || httpPeriod.equals("0")) {
                    httpPeriod = "--";
                }

                nodeInformation.setHttpPeriod(httpPeriod);

                String httpUrl = (String) rs.getObject(HTTP_URL);

                if ((httpUrl == null) || httpUrl.equals("")) {
                    httpUrl = "http://";
                }

                nodeInformation.setHttpUrl(httpUrl);

                String httpPort = (String) rs.getObject(HTTP_PORT);
                nodeInformation.setHttpPort(httpPort);

                String httpTimeout = (String) rs.getObject(HTTP_TIMEOUT);

                if ((httpTimeout == null) || httpTimeout.equals("")) {
                    httpTimeout = "0";
                }

                nodeInformation.setHttpTimeout(httpTimeout);

                /*
                 * SMTP
                 */
                String smtpPeriod = (String) rs.getObject(SMTP_PERIOD);

                if (
                    (smtpPeriod == null) || smtpPeriod.equals("")
                        || smtpPeriod.equals("0")) {
                    smtpPeriod = "--";
                }

                nodeInformation.setSmtpPeriod(smtpPeriod);

                String smtpPort = (String) rs.getObject(SMTP_PORT);

                if ((smtpPort == null) || smtpPort.equals("")) {
                    smtpPort = "0";
                }

                nodeInformation.setSmtpPort(smtpPort);

                String smtpTimeout = (String) rs.getObject(SMTP_TIMEOUT);

                if ((smtpTimeout == null) || smtpTimeout.equals("")) {
                    smtpTimeout = "0";
                }

                nodeInformation.setSmtpTimeout(smtpTimeout);

                String smtpTestAddress =
                    (String) rs.getObject(SMTP_TEST_ADDRESS);

                if (smtpTestAddress == null) {
                    smtpTestAddress = "";
                }

                nodeInformation.setSmtpSendAddress(smtpTestAddress);

                String smtpHost = (String) rs.getObject(SMTP_CHECK_POP_HOST);

                if (smtpHost == null) {
                    smtpHost = "";
                }

                nodeInformation.setSmtpCheckHost(smtpHost);

                String smtpUser = (String) rs.getObject(SMTP_CHECK_POP_USER);

                if (smtpUser == null) {
                    smtpUser = "";
                }

                nodeInformation.setSmtpCheckUser(smtpUser);

                String smtpPassword =
                    (String) rs.getObject(SMTP_CHECK_POP_PASSWORD);

                if (smtpPassword == null) {
                    smtpPassword = "";
                }

                nodeInformation.setSmtpCheckPassword(smtpPassword);

                String smtpPopPort = (String) rs.getObject(SMTP_CHECK_POP_PORT);

                if (smtpPopPort == null) {
                    smtpPopPort = "0";
                }

                nodeInformation.setSmtpCheckPort(smtpPopPort);

                String smtpPopTimeout =
                    (String) rs.getObject(SMTP_CHECK_POP_TIMEOUT);

                if (smtpPopTimeout == null) {
                    smtpPopTimeout = "0";
                }

                nodeInformation.setSmtpCheckTimeout(smtpPopTimeout);

                /*
                 * Pop
                 */
                String popPeriod = (String) rs.getObject(POP3_PERIOD);

                if (
                    (popPeriod == null) || popPeriod.equals("")
                        || popPeriod.equals("0")) {
                    popPeriod = "--";
                }

                nodeInformation.setPopPeriod(popPeriod);

                String popUser = (String) rs.getObject(POP3_USER);

                if (popUser == null) {
                    popUser = "";
                }

                nodeInformation.setPopUser(popUser);

                String popPassword = (String) rs.getObject(POP3_PASSWORD);

                if (popPassword == null) {
                    popPassword = "";
                }

                nodeInformation.setPopPassword(popPassword);

                String popPort = (String) rs.getObject(POP3_PORT);

                if ((popPort == null) || popPort.equals("")) {
                    popPort =
                        EditorNodeOperationInitialData.INITIAL_NODE_POP_PORT;
                }

                nodeInformation.setPopPort(popPort);

                String popTimeout = (String) rs.getObject(POP3_TIMEOUT);

                if ((popTimeout == null) || popTimeout.equals("")) {
                    popTimeout = "0";
                }

                nodeInformation.setPopTimeout(popTimeout);

                /*
                 * ŐVĎ`FbN
                 */
                if (rs.getObject(LAST_CHECK) != null) {
                    nodeInformation.setLastCheck(
                        rs.getObject(LAST_CHECK).toString());
                }

                /*
                 * Engine
                 */
                if (rs.getObject(ENGINE_ADDRESS) != null) {
                    nodeInformation.setEngineAddress(
                        rs.getObject(ENGINE_ADDRESS).toString());
                } else {
                    nodeInformation.setEngineAddress("unknown");
                }

                /*
                 * ipaddress [.] --> [_] convert
                 * JavaScript etc for JavaScript control
                 */
                nodeInformation.setConvIPAddress((ipAddress).replace('.', '_'));

                /*
                 * m[h̍ŐVA[擾
                 */
                ArrayList alarmList = null;
                alarmList =
                    alarmDBTable.getNodeAlarm(ipAddress);

                if (alarmList.size() > 0) {
                    AlarmInformation alarmInfo =
                        (AlarmInformation) alarmList.get(0);

                    logger.info(
                        "Alarm message : " + alarmInfo.getAlarmMessage());

                    nodeInformation.setAlarmCode(alarmInfo.getAlarmCode());
                    nodeInformation.setAlarmMessage(
                        alarmInfo.getAlarmMessage());
                    nodeInformation.setAlarmDate(alarmInfo.getAlarmDate());
                    nodeInformation.setAlarmLevel(alarmInfo.getAlarmLevel());
                }

                DatabaseWatcherInfo databaseInfo = DBTableDatabaseWatcher.getInstance().findDatabaseWatcher(ipAddress);
                nodeInformation.setDatabaseWatcherInfo(databaseInfo);

                nodeList.add(nodeInformation);
            }
        } finally {
            if (rs != null) {
                try {
                    rs.close();
                } catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }

                rs = null;
            }

            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }

                stmt = null;
            }

            if (conn != null) {
                if (dataaccess != null) {
                    dataaccess.releaseConnection(conn);
                    conn = null;
                    DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                        dataaccess);
                }
            }

            dataaccess = null;
            alarmDBTable = null;
        }

        return nodeList;
    }

    /**
     * wm[hIPAhX̃m[hĎ擾܂B
     *
     * @param ipaddress m[hIPAhX
     * @return nodeList m[hĎ񃊃Xg
     * @throws DatabaseConnectionException f[^x[XRlNV
     * 擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public synchronized ArrayList findTarget(String ipaddress)
        throws SQLException, DatabaseConnectionException {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;

        DatabaseAccess dataaccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        DBTableAlarm alarmDBTable = DBTableAlarm.getInstance();
        ArrayList nodeList = null;

        try {
            //sql̍쐬
            String sql =
                "SELECT * from " + NODE_REGISTER_TABLE + " where " + IPADDRESS
                + "=" + "'" + ipaddress + "'";
            // System.out.println(sql);

            // SQLXe[ggIuWFNg̍쐬
            // select̎s
            conn = dataaccess.getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            nodeList = new ArrayList();

            while (rs.next()) {
                NodeInformation nodeInformation = new NodeInformation();

                if (rs.getObject(DBTableNodeRegister.NODENAME) != null) {
                    nodeInformation.setNodename(
                        rs.getObject(DBTableNodeRegister.NODENAME).toString());
                }

                if (rs.getObject(DBTableNodeRegister.IPADDRESS) != null) {
                    nodeInformation.setIpaddress(
                        rs.getObject(DBTableNodeRegister.IPADDRESS).toString());
                }

                if (rs.getObject(DBTableNodeRegister.NODEGROUP) != null) {
                    nodeInformation.setGroup(
                        rs.getObject(DBTableNodeRegister.NODEGROUP).toString());
                }

                if (rs.getObject(DBTableNodeRegister.NODEKIND) != null) {
                    nodeInformation.setNodeKind(
                        rs.getObject(DBTableNodeRegister.NODEKIND).toString());
                }
                if (rs.getObject(DBTableNodeRegister.NODEX) != null) {
                    nodeInformation.setNodeX(
                        rs.getObject(DBTableNodeRegister.NODEX).toString());
                }
                if (rs.getObject(DBTableNodeRegister.NODEY) != null) {
                    nodeInformation.setNodeY(
                        rs.getObject(DBTableNodeRegister.NODEY).toString());
                }
                if (rs.getObject(DBTableNodeRegister.PING_PERIOD) != null) {
                    nodeInformation.setPingPeriod(
                        rs.getObject(DBTableNodeRegister.PING_PERIOD).toString());
                }

                if (rs.getObject(DBTableNodeRegister.PING_THRESHOLD) != null) {
                    nodeInformation.setPingThreshold(
                        rs.getObject(DBTableNodeRegister.PING_THRESHOLD)
                          .toString());
                }

                if (rs.getObject(DBTableNodeRegister.SNMP_VERSION) != null) {
                    nodeInformation.setSnmpVersion(
                        rs.getObject(DBTableNodeRegister.SNMP_VERSION).toString());
                }

                if (rs.getObject(DBTableNodeRegister.SNMP_PERIOD) != null) {
                    nodeInformation.setSnmpPeriod(
                        rs.getObject(DBTableNodeRegister.SNMP_PERIOD).toString());
                }

                if (rs.getObject(DBTableNodeRegister.SNMP_LEVEL) != null) {
                    nodeInformation.setSnmpLevel(
                        rs.getObject(DBTableNodeRegister.SNMP_LEVEL).toString());
                }

                if (rs.getObject(DBTableNodeRegister.SNMP_ROCOMMUNITY) != null) {
                    nodeInformation.setRoCommunity(
                        rs.getObject(DBTableNodeRegister.SNMP_ROCOMMUNITY)
                          .toString());
                }

                if (rs.getObject(DBTableNodeRegister.SNMP_RWCOMMUNITY) != null) {
                    nodeInformation.setRwCommunity(
                        rs.getObject(DBTableNodeRegister.SNMP_RWCOMMUNITY)
                          .toString());
                }

                if (rs.getObject(DBTableNodeRegister.HTTP_URL) != null) {
                    nodeInformation.setHttpUrl(
                        rs.getObject(DBTableNodeRegister.HTTP_URL).toString());
                }

                if (rs.getObject(DBTableNodeRegister.HTTP_PERIOD) != null) {
                    nodeInformation.setHttpPeriod(
                        rs.getObject(DBTableNodeRegister.HTTP_PERIOD).toString());
                }

                if (rs.getObject(DBTableNodeRegister.HTTP_PORT) != null) {
                    nodeInformation.setHttpPort(
                        rs.getObject(DBTableNodeRegister.HTTP_PORT).toString());
                }

                if (rs.getObject(DBTableNodeRegister.HTTP_TIMEOUT) != null) {
                    nodeInformation.setHttpTimeout(
                        rs.getObject(DBTableNodeRegister.HTTP_TIMEOUT).toString());
                }

                if (rs.getObject(DBTableNodeRegister.POP3_PERIOD) != null) {
                    nodeInformation.setPopPeriod(
                        rs.getObject(DBTableNodeRegister.POP3_PERIOD).toString());
                }

                if (rs.getObject(DBTableNodeRegister.POP3_USER) != null) {
                    nodeInformation.setPopUser(
                        rs.getObject(DBTableNodeRegister.POP3_USER).toString());
                }

                if (rs.getObject(DBTableNodeRegister.POP3_PASSWORD) != null) {
                    nodeInformation.setPopPassword(
                        rs.getObject(DBTableNodeRegister.POP3_PASSWORD)
                          .toString());
                }

                if (rs.getObject(DBTableNodeRegister.POP3_PORT) != null) {
                    nodeInformation.setPopPort(
                        rs.getObject(DBTableNodeRegister.POP3_PORT).toString());
                }

                if (rs.getObject(DBTableNodeRegister.POP3_TIMEOUT) != null) {
                    nodeInformation.setPopTimeout(
                        rs.getObject(DBTableNodeRegister.POP3_TIMEOUT).toString());
                }

                if (rs.getObject(DBTableNodeRegister.SMTP_PERIOD) != null) {
                    nodeInformation.setSmtpPeriod(
                        rs.getObject(DBTableNodeRegister.SMTP_PERIOD).toString());
                }

                if (rs.getObject(DBTableNodeRegister.SMTP_PORT) != null) {
                    nodeInformation.setSmtpPort(
                        rs.getObject(DBTableNodeRegister.SMTP_PORT).toString());
                }

                if (rs.getObject(DBTableNodeRegister.SMTP_TIMEOUT) != null) {
                    nodeInformation.setSmtpTimeout(
                        rs.getObject(DBTableNodeRegister.SMTP_TIMEOUT).toString());
                }

                if (rs.getObject(DBTableNodeRegister.SMTP_TEST_ADDRESS) != null) {
                    nodeInformation.setSmtpSendAddress(
                        rs.getObject(DBTableNodeRegister.SMTP_TEST_ADDRESS)
                          .toString());
                }

                if (
                    rs.getObject(DBTableNodeRegister.SMTP_CHECK_POP_HOST) != null) {
                    nodeInformation.setSmtpCheckHost(
                        rs.getObject(DBTableNodeRegister.SMTP_CHECK_POP_HOST)
                          .toString());
                }

                if (
                    rs.getObject(DBTableNodeRegister.SMTP_CHECK_POP_USER) != null) {
                    nodeInformation.setSmtpCheckUser(
                        rs.getObject(DBTableNodeRegister.SMTP_CHECK_POP_USER)
                          .toString());
                }

                if (
                    rs.getObject(DBTableNodeRegister.SMTP_CHECK_POP_PASSWORD) != null) {
                    nodeInformation.setSmtpCheckPassword(
                        rs.getObject(
                            DBTableNodeRegister.SMTP_CHECK_POP_PASSWORD)
                          .toString());
                }

                if (
                    rs.getObject(DBTableNodeRegister.SMTP_CHECK_POP_PORT) != null) {
                    nodeInformation.setSmtpCheckPort(
                        rs.getObject(DBTableNodeRegister.SMTP_CHECK_POP_PORT)
                          .toString());
                }

                if (
                    rs.getObject(DBTableNodeRegister.SMTP_CHECK_POP_TIMEOUT) != null) {
                    nodeInformation.setSmtpCheckTimeout(
                        rs.getObject(
                            DBTableNodeRegister.SMTP_CHECK_POP_TIMEOUT)
                          .toString());
                }

                if (rs.getObject(ENGINE_ADDRESS) != null) {
                    nodeInformation.setEngineAddress(
                        rs.getObject(ENGINE_ADDRESS).toString());
                } else {
                    nodeInformation.setEngineAddress("unknown");
                }

                if (rs.getObject(DBTableNodeRegister.REGISTER_DATE) != null) {
                    nodeInformation.setRegisterDate(
                        rs.getObject(DBTableNodeRegister.REGISTER_DATE)
                          .toString());
                }

                if (rs.getObject(DBTableNodeRegister.LAST_CHECK) == null) {
                    nodeInformation.setLastCheck("");
                } else {
                    nodeInformation.setLastCheck(
                        rs.getObject(DBTableNodeRegister.LAST_CHECK).toString());
                }

                if (rs.getObject(DBTableNodeRegister.REGISTER_DATE) != null) {
                    /*
                     * m[ho^ғԂZo
                     */
                    String optimeString =
                        convRegisterDate(
                            (Date) rs.getObject(
                                DBTableNodeRegister.REGISTER_DATE));

                    nodeInformation.setRegisterDate(
                        rs.getObject(DBTableNodeRegister.REGISTER_DATE)
                          .toString() + optimeString);
                }

                nodeInformation.setConvIPAddress(
                    (rs.getObject(DBTableNodeRegister.IPADDRESS).toString())
                    .replace('.', '_'));

                ArrayList alarmList = null;

                alarmList = alarmDBTable.getNodeAlarm(ipaddress);

                if (alarmList.size() > 0) {
                    AlarmInformation alarmInfo =
                        (AlarmInformation) alarmList.get(0);

                    logger.info(
                        "Alarm message : " + alarmInfo.getAlarmMessage());

                    nodeInformation.setAlarmCode(alarmInfo.getAlarmCode());
                    nodeInformation.setAlarmMessage(
                        alarmInfo.getAlarmMessage());
                    nodeInformation.setAlarmDate(alarmInfo.getAlarmDate());
                }
                DatabaseWatcherInfo databaseInfo = DBTableDatabaseWatcher.getInstance().findDatabaseWatcher(ipaddress);
                nodeInformation.setDatabaseWatcherInfo(databaseInfo);

                nodeList.add(nodeInformation);
            }
        } finally {
            if (rs != null) {
                try {
                    rs.close();
                } catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }

                rs = null;
            }

            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }

                stmt = null;
            }

            if (conn != null) {
                if (dataaccess != null) {
                    dataaccess.releaseConnection(conn);
                    conn = null;
                    DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                        dataaccess);
                }
            }

            alarmDBTable = null;
        }

        return nodeList;
    }

    /**
     * m[ho^̌oߎԂZoĕԂ܂B
     *
     * @param registerDate m[ho^
     * @return o^̌oߎԂ\
     */
    private String convRegisterDate(Date registerDate) {
        Date date = Calendar.getInstance().getTime();

        long opTime = date.getTime() - registerDate.getTime();
        String optimeString = "";

        if (opTime != 0) {
            int day = (int) opTime / (1000 * 60 * 60 * 24);
            int hour =
                (int) (opTime - (day * 1000 * 60 * 60 * 24)) / (1000 * 60 * 60);
            int min =
                (int) (opTime - (day * 1000 * 60 * 60 * 24)
                - (hour * 1000 * 60 * 60)) / (1000 * 60);
            int sec =
                (int) (opTime - (day * 1000 * 60 * 60 * 24)
                - (hour * 1000 * 60 * 60) - (min * 1000 * 60)) / 1000;

            String dayString;

            if (day == 0) {
                dayString = "";
            } else {
                dayString = day + "day ";
            }

            String hourString;

            if (hour == 0) {
                hourString = "";
            } else {
                hourString = hour + "hour";
            }

            String minString;

            if (min == 0) {
                minString = "";
            } else {
                minString = min + "min";
            }

            optimeString =
                " (" + dayString + hourString + minString + sec + "sec)";
        }

        return optimeString;
    }

    /**
     * wm[hIPAhXm[hĎe[u폜܂B
     *
     * @param nodeAddress m[hIPAhX
     * @throws DatabaseConnectionException f[^x[XRlNV
     * 擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public synchronized void deleteNode(String nodeAddress)
        throws SQLException, DatabaseConnectionException {
        DatabaseAccess dataaccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        try {
            //sql̍쐬
            String sql =
                "delete from " + NODE_REGISTER_TABLE + " where " + IPADDRESS
                + "=" + "'" + nodeAddress + "'";

            dataaccess.executeUpdate(sql);
        } finally {
            if (dataaccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                    dataaccess);
            }
        }
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final DBTableNodeRegister RESOURCE = new DBTableNodeRegister();
    }
}
