/*
 * Created on 2004/04/28
 *
 *
 *@Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.database.access.model;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;

import netjfwatcher.database.access.control.AbstractDataAccessObject;
import netjfwatcher.database.access.control.DatabaseAccess;
import netjfwatcher.database.access.control.DatabaseAccessControlKind;
import netjfwatcher.database.access.control.DatabaseAccessPool;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.engine.socket.info.PingInfo;
import netjfwatcher.engine.socket.info.PingProperty;


/**
 * Pinge[u𑀍삷郁\bh܂B
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class DBTablePingResponse extends DBTableBase {
    /** Pinge[u */
    public final static String PING_RESPONSE_TABLE_NAME = "_pingresponse";

    /** Pingf[^̎J */
    public static final String CURDATE = AbstractDataAccessObject.CUR_DATE;

    /** Pingf[^J */
    public static final String DIFF_TIME = "difftime";

    /* MO */
    private static Logger logger = null;

    /* Pingf[^̎tH[}bg */
    private DateFormat simpleDateformat =
        new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    /**
     * Pinge[uVOgNXCX^X
     * ܂B
     *
     */
    private DBTablePingResponse() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * Pinge[uVOgNXCX^X
     * Ԃ܂B
     *
     * @return VOgNXCX^X
     */
    public static DBTablePingResponse getInstance() {
        return SingletonResource.RESOURCE;
    }

    /**
     * Pinge[u𐶐܂B
     *
     * @param paraIPAddress m[hIPAhX
     * @throws DatabaseConnectionException f[^x[XRlNV
     * 擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public synchronized void createTable(final String paraIPAddress)
        throws DatabaseConnectionException, SQLException {
        String targetIpAddress =
            DBTableBase.IP + paraIPAddress.replace('.', '_');
        targetIpAddress = targetIpAddress.replace('-', '_');

        DatabaseAccess databaseAccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        try {
            AbstractDataAccessObject dataaccess =
                DatabaseAccessControlKind.getInstance().getDataAccessObject();
            String autoIncrement = dataaccess.getAutoIncrement();
            String pingTableItem =
                " (" + autoIncrement + "," + CURDATE + " "
                + AbstractDataAccessObject.TIMESTAMP + "," + DIFF_TIME + " "
                + AbstractDataAccessObject.BIGINT + ")";

            // ̃e[u폜
            this.deleteTable(
                databaseAccess, targetIpAddress + PING_RESPONSE_TABLE_NAME);

            if (
                DatabaseAccessControlKind.getInstance().getDatabaseName()
                                             .equals(
                        AbstractDataAccessObject.POSTGRESQL)) {
                this.dropSequence(
                    databaseAccess,
                    "DROP SEQUENCE " + targetIpAddress + "_ping_id_seq");
                pingTableItem =
                    " (id INTEGER DEFAULT NEXTVAL('" + targetIpAddress
                    + "_ping_id_seq'" + "), curdate TIMESTAMP," + DIFF_TIME
                    + " BIGINT)";
                databaseAccess.executeUpdate(
                    "CREATE SEQUENCE " + targetIpAddress + "_ping_id_seq");
            }

            // f[^x[XEe[u쐬
            databaseAccess.executeUpdate(
                "CREATE TABLE " + targetIpAddress + PING_RESPONSE_TABLE_NAME
                + pingTableItem);

            DBTableManagement tableManagement = new DBTableManagement();
            tableManagement.put(
                paraIPAddress, targetIpAddress + PING_RESPONSE_TABLE_NAME, DBTableManagement.LIMIT_YES);
        } finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                    databaseAccess);
            }
        }
    }

    /**
     * Pinge[u폜܂B
     *
     * @param paraIPAddress m[hIPAhX
     * @throws DatabaseConnectionException f[^x[XRlNV
     * 擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public synchronized void dropTable(final String paraIPAddress)
        throws DatabaseConnectionException, SQLException {
        String targetIpAddress =
            DBTableBase.IP + paraIPAddress.replace('.', '_');
        targetIpAddress = targetIpAddress.replace('-', '_');

        DatabaseAccess databaseAccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        try {
            // ̃e[u폜
            databaseAccess.executeUpdate(
                "DROP TABLE IF EXISTS " + targetIpAddress
                + PING_RESPONSE_TABLE_NAME);
        } finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                    databaseAccess);
            }
        }
    }

    /**
     * Pingf[^yэ̎e[uɊi[܂B
     *
     * @param paraIPAddress m[hIPAhX
     * @param difftime Ping
     * @throws DatabaseConnectionException f[^x[XRlNV
     * 擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public synchronized void putPingTable(
        final String paraIPAddress, final long difftime)
        throws DatabaseConnectionException, SQLException {
        String targetIpAddress =
            DBTableBase.IP + paraIPAddress.replace('.', '_');
        targetIpAddress = targetIpAddress.replace('-', '_');

        Date date = Calendar.getInstance().getTime();

        DatabaseAccess databaseAccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        try {
            // pingsʃf[^DBɊi[
            databaseAccess.executeUpdate(
                "insert into " + targetIpAddress + PING_RESPONSE_TABLE_NAME
                + "( " + CURDATE + ", " + DIFF_TIME + " )" + " VALUES( '"
                + simpleDateformat.format(date) + "'," + difftime + ")");
        } finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                    databaseAccess);
                databaseAccess = null;
            }
        }
    }

    /**
     * wm[hIPAhXAwԂPingԃf[^̃XgԂ܂B
     *
     *
     * @param ipaddress m[hIPAhX
     * @param startTime Jn
     * @param endTime I
     * @return list Pingf[^Xg
     * @throws DatabaseConnectionException f[^x[XRlNV
     * 擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public synchronized ArrayList findAll(
        final String ipaddress, final String startTime, final String endTime)
        throws SQLException, DatabaseConnectionException {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;

        DatabaseAccess dataaccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        ArrayList list = null;
        list = new ArrayList();

        try {
            String convIPAddress = DBTableBase.IP + ipaddress.replace('.', '_');
            convIPAddress = convIPAddress.replace('-', '_');

            String sql = "";

            //sql̍쐬
            if ((startTime == null) || (endTime == null)) {
                sql = "SELECT * from " + convIPAddress
                    + DBTablePingResponse.PING_RESPONSE_TABLE_NAME
                    + " order by " + CURDATE + " desc";
            } else {
                sql = "SELECT * from " + convIPAddress
                    + DBTablePingResponse.PING_RESPONSE_TABLE_NAME + " where "
                    + CURDATE + " between " + "'" + startTime + "'" + " and "
                    + "'" + endTime + "'" + " order by " + CURDATE + " desc";
            }

            // System.out.println(sql);

            // select̎s
            conn = dataaccess.getConnection();

            // SQLXe[ggIuWFNg̍쐬
            stmt = conn.createStatement();

            // select̎s
            rs = stmt.executeQuery(sql);

            while (rs.next()) {
                PingInfo info = new PingInfo();

                if (rs.getObject(DIFF_TIME) != null) {
                    info.setPingDiffTime(
                        Long.parseLong(rs.getObject(DIFF_TIME).toString()));
                }

                if (rs.getObject(CURDATE) != null) {
                    info.setPingCheckDate((Date) rs.getObject(CURDATE));
                }

                list.add(info);
            }
        } finally {
            if (rs != null) {
                try {
                    rs.close();
                } catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }

                rs = null;
            }

            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }

                stmt = null;
            }

            if (conn != null) {
                if (dataaccess != null) {
                    dataaccess.releaseConnection(conn);
                    conn = null;
                    DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                        dataaccess);
                }
            }

            dataaccess = null;
        }

        return list;
    }

    /**
     * Ping̈ȉ̃f[^擾܂B
     *
     * Ef[^
     * Eőyэŏf[^
     * E̎
     *
     * @param ipaddress m[hIPAhX
     * @return PingvpeB
     * @throws DatabaseConnectionException f[^x[XRlNV
     * 擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public synchronized PingProperty getDataCount(final String ipaddress)
        throws SQLException, DatabaseConnectionException {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;

        DatabaseAccess dataaccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        PingProperty pingProperty = new PingProperty();

        try {
            // SQLXe[ggIuWFNg̍쐬
            String convIPAddress = DBTableBase.IP + ipaddress.replace('.', '_');
            convIPAddress = convIPAddress.replace('-', '_');

            //sql̍쐬
            String sql =
                "select count(*) from " + convIPAddress
                + DBTablePingResponse.PING_RESPONSE_TABLE_NAME;

            // select̎s
            conn = dataaccess.getConnection();

            // SQLXe[ggIuWFNg̍쐬
            stmt = conn.createStatement();

            // select̎s
            rs = stmt.executeQuery(sql);
            rs.next();

            int count = -1;
            count = rs.getInt(1);
            pingProperty.setTotalDataCount(count);

            sql = "select min(" + DIFF_TIME + "), max(" + DIFF_TIME + ") from "
                + convIPAddress + DBTablePingResponse.PING_RESPONSE_TABLE_NAME;
            rs = stmt.executeQuery(sql);
            rs.next();

            long minDiffTime = -1;
            minDiffTime = rs.getLong(1);

            long maxDiffTime = -1;
            maxDiffTime = rs.getLong(2);
            pingProperty.setMinData(Long.toString(minDiffTime));
            pingProperty.setMaxData(Long.toString(maxDiffTime));

            sql = "select min(" + CURDATE + "), max(" + CURDATE + ") from "
                + convIPAddress + DBTablePingResponse.PING_RESPONSE_TABLE_NAME;
            rs = stmt.executeQuery(sql);
            rs.next();
            pingProperty.setStartDate((Date) rs.getObject(1));
            pingProperty.setEndDate((Date) rs.getObject(2));
        } finally {
            if (rs != null) {
                try {
                    rs.close();
                } catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }

                rs = null;
            }

            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }

                stmt = null;
            }

            if (conn != null) {
                if (dataaccess != null) {
                    dataaccess.releaseConnection(conn);
                    conn = null;
                    DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                        dataaccess);
                }
            }

            dataaccess = null;
        }

        return pingProperty;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final DBTablePingResponse RESOURCE = new DBTablePingResponse();
    }
}
