/*
 * Created on 2004/06/05
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.command.model;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.logging.Logger;

import netjfwatcher.database.access.model.DatabaseTest;
import netjfwatcher.engine.command.control.TemplateCommandImpl;
import netjfwatcher.engine.socket.CommandInfo;


/**
 * f[^x[X̉ғeXgs܂B
 *
 * @author Yoshimasa Matsumoto
 *@@version 1.0
 */
public class CommandDatabaseTest extends TemplateCommandImpl {
    /* MO */
    private static Logger logger;

    /**
     * f[^x[XeXgs܂B
     *
     * @param com R}h
     * @param ois ̓Xg[
     * @param oos o̓Xg[
     */
    public void doInvoke(
        CommandInfo com, ObjectInputStream ois, ObjectOutputStream oos) {
        logger = Logger.getLogger(this.getClass().getName());

        String databaseName = com.getResourceInfo().getDatabaseName();
        String databaseDriver = com.getResourceInfo().getDatabaseDriver();
        String databaseUrl = com.getResourceInfo().getDatabaseUrl();
        String databaseUser = com.getResourceInfo().getDatabaseUser();
        String databasePassword = com.getResourceInfo().getDatabasePassword();

        logger.info("Database Test databaseName : " + databaseName);
        logger.info("Database Test databaseDriver : " + databaseDriver);
        logger.info("Database Test databaseUrl : " + databaseUrl);
        logger.info("Database Test databaseUser : " + databaseUser);
        logger.info("Database Test databasePassword : " + databasePassword);

        /* f[^x[XғeXgs */
        DatabaseTest databaseTest = new DatabaseTest(databaseName);
        String[] testResult =
            databaseTest.checkDatabase(
                databaseDriver, databaseUrl, databaseUser, databasePassword);

        for (int i = 0; i < testResult.length; i++) {
            logger.info("Database Test Phase " + i + " : " + testResult[i]);
        }

        sendResponse(testResult, ois, oos);
    }
}
