/*
 * Created on 2004/04/06
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.command.model;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableNodeRegister;
import netjfwatcher.engine.command.control.CommandMappingTableResource;
import netjfwatcher.engine.command.control.TemplateCommandImpl;
import netjfwatcher.engine.nodecontrol.NodeAdd;
import netjfwatcher.engine.resource.SnmpV3ManagerConfig;
import netjfwatcher.engine.socket.CommandInfo;
import netjfwatcher.engine.socket.info.NodeInformation;


/**
 * m[hǉs\bhNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class CommandNodeAdd extends TemplateCommandImpl {
    /* MO */
    private static Logger logger;

    /**
     * m[hǉs܂B
     *
     * @param com R}h
     * @param ois ̓Xg[
     * @param oos o̓Xg[
     */
    public void doInvoke(
        CommandInfo com, ObjectInputStream ois, ObjectOutputStream oos) {
        logger = Logger.getLogger(this.getClass().getName());

        String responseCode = CommandMappingTableResource.ACK_RESPONSE;
        NodeAdd nodeadd = NodeAdd.getInstance();
        try {
            DBTableNodeRegister nodeRegisterDBTable =
                DBTableNodeRegister.getInstance();

            if (com.getNodeInformationList() != null) {
                ArrayList nodeInfoList = com.getNodeInformationList();

                for (int i = 0; i < nodeInfoList.size(); i++) {
                    NodeInformation nodeInfo =
                        (NodeInformation) nodeInfoList.get(i);

                    ArrayList checkNodeList = null;
                    checkNodeList =
                        nodeRegisterDBTable.findTarget(nodeInfo.getIpaddress());
                    if ((checkNodeList != null) && (checkNodeList.size() > 0)) {
                        responseCode =
                            "Duplicate address : " + nodeInfo.getIpaddress();
                        logger.warning(responseCode);
                    } else {
                        if (nodeInfo.getSnmpVersion().equals("SNMPV3")) {
                            /*
                             * m[ho^^[QbgSNMPo[WV3w
                             * ŁAm[hIPAhXSNMP V3o^̏ꍇ
                             * G[ʂʒm
                             */
                            if (
                                SnmpV3ManagerConfig.getInstance()
                                                       .getResourceFileParse()
                                                       .getSnmpV3AgentInfo(
                                        nodeInfo.getIpaddress()) == null) {
                                responseCode =
                                    "Not found SNMP V3 Agent Address = "
                                    + nodeInfo.getIpaddress();
                                logger.warning(responseCode);
                                continue;
                            }
                        }
                        logger.info("Add Node IP=" + nodeInfo.getIpaddress());
                        /* m[he[u𐶐Am[hǉ */
                        nodeadd.addNode(nodeInfo, true);
                    }
                }
            } else {
                ArrayList checkNodeList = null;
                checkNodeList = nodeRegisterDBTable.findTarget(com.getIpaddress());

                if ((checkNodeList != null) && (checkNodeList.size() > 0)) {
                    responseCode = "Duplicate address : " + com.getIpaddress();
                    logger.warning(responseCode);
                } else {
                    NodeInformation nodeInfo = com.getNodeInformation();

                    if (nodeInfo.getSnmpVersion().equals("SNMPV3")) {
                        /*
                         * m[ho^^[QbgSNMPo[WV3w
                         * ŁAm[hIPAhXSNMP V3o^̏ꍇ
                         * G[ʂʒm
                         */
                        if (
                            SnmpV3ManagerConfig.getInstance()
                                                   .getResourceFileParse()
                                                   .getSnmpV3AgentInfo(
                                    com.getIpaddress()) == null) {
                            responseCode =
                                "Not found SNMP V3 Agent Address = "
                                + com.getIpaddress();
                            logger.warning(responseCode);
                            sendResponse(responseCode, ois, oos);

                            return;
                        }
                    }

                    logger.info("Add Node IP=" + com.getIpaddress());
                    nodeadd.addNode(com);
                }
            }
        } catch (SQLException e1) {
            logger.warning("SQLException : " + e1.getMessage());
            responseCode = "SQLException : " + e1.getMessage();
        } catch (DatabaseConnectionException e1) {
            logger.warning("DatabaseConnectionException : " + e1.getMessage());
            responseCode = "DatabaseConnectionException : " + e1.getMessage();
        }

        sendResponse(responseCode, ois, oos);
    }
}
