/*
 * Created on 2003/08/11
 *
 *
 * Copyright(c) 2003 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.mail;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Properties;
import java.util.logging.Logger;

import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

import netjfwatcher.engine.alarm.AlarmMessageMake;
import netjfwatcher.engine.preferance.MailSendPreferencePage;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.resource.SystemResourceFileParse;
import netjfwatcher.engine.socket.info.MailProperty;


/**
 * Mail𑗐M邽߂̃\bhNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class MailSend {
    /* Logging */
    private static Logger logger = null;
    private static final String MAIL_SMTP_HOST = "mail.smtp.host";
    private static final String MAIL_FROM = "mail.from";
    private static final String ENC = "ISO-2022-JP";
    /* Mail Session */
    private Session session;

    /* Mail Properties */
    private Properties prop = new Properties();

    /*
     * MailMCX^X𐶐܂B
     * iVOgNX̂߂privateƂ܂j
     *
     */
    private MailSend() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * \[Xɓo^ĂSMTPzXgyу[MAhX
     * [𑗐M܂B
     *
     * @param mailSubject Mail Subject
     * @param mailMessageBody Mail Body
     */
    public void checkMailSend(String mailSubject, String mailMessageBody) {
        /*
         * \[Xt@Cɐݒ肳ĂMailMXg
         * Mail𑗐M
         */
        SystemResourceFileParse resourceset =
            SystemResourceConfig.getInstance().getResourceFileParse();
        MailProperty[] mailProp =
            resourceset.getResourceInfo().getMailPropertyList();

        /* MailM\[XݒiSMTPzXgj[v */
        for (int i = 0; i < mailProp.length; i++) {
            /*
             * MailMtO`FbN
             * tOONłȂ΃[MsȂ
             */
            if ((mailProp[i].getMailSendFlag()).equals(MailSendPreferencePage.MAIL_SEND_ON)) {
                String from = mailProp[i].getFrom();
                String smtpHost = mailProp[i].getSmtpHost();

                String subject = mailSubject;
                String messageBody = mailMessageBody;

                ArrayList toList = mailProp[i].getToList();

                /*
                 * MailM敪[v
                 */
                try {
                    for (int j = 0; j < toList.size(); j++) {
                        this.sendMail(
                            smtpHost, from, (String) toList.get(j), subject,
                            messageBody);
                    }
                } catch (MailSendException e) {
                    logger.warning(e.getMessage());

                    AlarmMessageMake alarmMessage =
                        AlarmMessageMake.getInstance();
                    alarmMessage.setMailSendError(e.getMessage());
                    e.printStackTrace();
                }
            }
        }
    }

    /**
     * MailSMTPzXgɑM܂B
     * MailMeXgɂ͂̃NXO璼ڌĂ΂܂B
     *
     * @param smtpHost SMTPzXg
     * @param from MAhX
     * @param to MAhX
     * @param subject Mail Subject
     * @param content Mail̓e
     * @throws MailSendException MailMɎsꍇ
     */
    public void sendMail(
        String smtpHost, String from, String to, String subject, String content)
        throws MailSendException {
        try {
            // ZbVm
            try {
                /*
                 * VKSessionASMTP.HOST܂mail.fromύX
                 * Session
                 */
                if (
                    (session == null)
                        || !session.getProperties().getProperty(
                        		MAIL_SMTP_HOST).equals(smtpHost)
                        || !session.getProperties().getProperty(MAIL_FROM)
                                       .equals(from)) {
                    // Mail PropertyZbg
                    prop.setProperty(MAIL_FROM, from);
                    prop.setProperty(MAIL_SMTP_HOST, smtpHost);

                    logger.info("Create session smtp_host : " + smtpHost);
                    logger.info("Create session from : " + from);
                    session = Session.getInstance(prop, null);
                }
            } catch (NoClassDefFoundError e) {
                logger.warning(e.getMessage());
                throw new MailSendException(e.getMessage());
            }

            if (session == null) {
                logger.warning("Session is null at Mail send");
                throw new MailSendException("Session is null at Mail send");
            }

            // MIMEbZ[W
            MimeMessage message = new MimeMessage(session);
            message.setFrom(new InternetAddress(from));
            message.setSentDate(Calendar.getInstance().getTime());

            InternetAddress[] dests =
                new InternetAddress[] { new InternetAddress(to) };
            message.setRecipients(Message.RecipientType.TO, dests);

            logger.info("Mail Send to : " + to + " from : " + from);
            logger.info("Mail Send subject : " + subject);
            logger.info("Mail Send content : " + content);

            message.setSubject(subject, ENC);
            message.setText(content, ENC);
            Transport.send(message);
        } catch (AddressException e) {
            logger.warning(e.getMessage());
            throw new MailSendException(e.getMessage());
        } catch (MessagingException e) {
            logger.warning(e.getMessage());
            throw new MailSendException(e.getMessage());
        }
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static MailSend getInstance() {
        return SingletonResource.RESOURCE;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final MailSend RESOURCE = new MailSend();
    }
}
