/*
 * Created on 2003/08/21
 *
 *
 * Copyright(c) 2003 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.resource;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.engine.filepreference.FilePreference;
import netjfwatcher.engine.socket.info.MailProperty;
import netjfwatcher.engine.socket.info.ResourceInfo;
import netjfwatcher.snmp.preference.SnmpPreference;

import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.osgi.framework.Bundle;

/**
 * \[Xt@C̉͋yэXVsNXłB \[Xt@C̉͂A\[XƂĕԂ\bhȂǂ܂B
 * 
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class SystemResourceFileParse {
	/** \[XXML l^O */
	public static final String XML_FILE_VALUE = "value";

	/** \[XXML conf ^O */
	public static final String CONF = "conf";

	/** \[XXML Engine ^O */
	public static final String ENGINE = "engine";

	/** \[XXML Engine Port ^O */
	public static final String ENGINE_PORT = "port";

	/** \[XXML Engine Port ^O */
	public static final String ENGINE_ALLOW_HOST = "allow-host";

	/** \[XXML f[^x[X ^O */
	public static final String DATABASE = "database";

	/** \[XXML f[^x[X ^O */
	public static final String DATABASE_NAME = "database_name";

	/** \[XXML f[^x[XhCo ^O */
	public static final String DATABASE_DRIVER = "driver";

	/** \[XXML f[^x[XURL ^O */
	public static final String DATABASE_URL = "url";

	/** \[XXML f[^x[X[U ^O */
	public static final String DATABASE_USER = "user";

	/** \[XXML f[^x[XpX[h ^O */
	public static final String DATABASE_PASSWORD = "password";

	/** \[XXML SNMP ^O */
	public static final String SNMP = "snmp";

	/** \[XXML SNMP|[g ^O */
	public static final String SNMP_PORT = "port";

	/** \[XXML Trap|[g ^O */
	public static final String SNMP_TRAP_PORT = "trapPort";

	/** \[XXML SNMP V1^CAEgl ^O */
	public static final String SNMPV1_TIMEOUT = "snmpV1Timeout";

	/** \[XXML SNMP V2^CAEgl ^O */
	public static final String SNMPV2_TIMEOUT = "snmpV2Timeout";

	/** \[XXML SNMP V3^CAEgl ^O */
	public static final String SNMPV3_TIMEOUT = "snmpV3Timeout";

	/** \[XXML SNMP V1gCl ^O */
	public static final String SNMPV1_RETRY = "snmpV1Retry";

	/** \[XXML SNMP V2gCl ^O */
	public static final String SNMPV2_RETRY = "snmpV2Retry";

	/** \[XXML SNMP V3gCl ^O */
	public static final String SNMPV3_RETRY = "snmpV3Retry";

	/** \[XXML Ping ^O */
	public static final String PING = "ping";

	/** \[XXML Ping^CAEgl ^O */
	public static final String PING_TIMEOUT = "timeout";

	/** \[XXML PinggCl ^O */
	public static final String PING_COUNT = "count";

	/** \[XXML XML Socket ^O */
	public static final String XML_SOCKET = "xmlsocket";

	/** \[XXML Alert Sound ^O */
	public static final String ALERT_SOUND = "alert_sound";

	/** \[XXML XML SocketڑzXg ^O */
	public static final String ALLOW_HOST = "allow-host";

	/** \[XXML XML Socketڑ|[g ^O */
	public static final String XML_SOCKET_PORT = "port";

	/** \[XXML XML Socketڑő吔 ^O */
	public static final String XML_SOCKET_MAXCONNECT = "maxconnect";

	/** \[XXML NCAgtbV^C}[l^O */
	public static final String REFRESH_TIME = "refresh_time";

	/** \[XXML MailMtB^[ ^O */
	public static final String MAIL_FILTER = "mail_filter";

	/** \[XXML MailMtB^[ G[x ^O */
	public static final String MAIL_FILTER_ERROR_LEVEL = "error_level";

	/** \[XXML MailMtB^[ tO ^O */
	public static final String MAIL_FILTER_FLAG = "message_filter_flag";

	/** \[XXML MailMtB^[ L ^O */
	public static final String MAIL_FILTER_STRING = "message_filter_string";

	/** \[XXML o^m[hΉ ^O */
	public static final String UNREGISTRATION_NODE = "UnregistrationNode";

	/** \[XXML o^m[h A[ ^O */
	public static final String UNREGISTRATION_NODE_ALARM = "alarm";

	/** \[XXML MailMK[h ^O */
	public static final String GUARD = "guard";

	/** \[XXML Mail ^O */
	public static final String MAIL = "mail";

	/** \[XXML MailMK[h ^O */
	public static final String MAIL_GUARD_TIME = "mail_guard_time";

	/** \[XXML MainM ^O */
	public static final String MAIL_SEND = "send";

	/** \[XXML Mail SMTPzXg ^O */
	public static final String MAIL_SMTP_HOST = "smtp.host";

	/** \[XXML Mail From ^O */
	public static final String MAIL_FROM = "from";

	/** \[XXML Mail To List ^O */
	public static final String MAIL_TO_LIST = "mail_to";

	/** \[XXML l^O */
	public static final String MAIL_TO = "to";

	/** \[XXML A[ ^O */
	public static final String ALARM = "alarm";

	/** \[XXML A[ێ ^O */
	public static final String ALARM_HOLD_PERIOD = "hold_period_day";

	/** \[XXML A[ێs ^O */
	public static final String ALARM_MAX_LINE = "max_line";

	/** \[XXML v ^O */
	public static final String STATISTICS = "statistics";

	/** \[XXML vێ ^O */
	public static final String STATISTICS_HOLD_PERIOD = "hold_period_day";

	/** \[XXML vێs ^O */
	public static final String STATISTICS_MAX_LINE = "max_line";

	/* Logging */
	private static Logger logger = null;

	/* GW|[g */
	private String enginePort;

	/* GWڑzXg */
	private String engineAllowHost;

	/* f[^x[X */
	private String databaseName;

	/* f[^x[XhCo */
	private String databaseDriver;

	/* f[^x[XURL */
	private String databaseUrl;

	/* f[^x[X[U */
	private String databaseUser;

	/* f[^x[XpX[h */
	private String databasePassword;

	/* SNMP V1^CAEgl */
	private String snmpV1Timeout;

	/* SNMP V2^CAEgl */
	private String snmpV2Timeout;

	/* SNMP V3^CAEgl */
	private String snmpV3Timeout;

	/* SNMP V1gCl */
	private String snmpV1Retry;

	/* SNMP V2gCl */
	private String snmpV2Retry;

	/* SNMP V3gCl */
	private String snmpV3Retry;

	/* Ping^CAEgl */
	private String pingTimeout;

	/* PinggC */
	private String pingRetry;

	/* XML Socketڑ|[g */
	private String xmlsocketPort;

	/* Alert Sound */
	private String alertSound;

	/* XML SocketڑzXg */
	private String xmlsocketAllowHost;

	/* XML Socketڑő吔 */
	private String xmlsocketMaxconnect;

	/* NCAgtbV^C}[ */
	private String refreshTime;

	/* MailMK[h^C}[ */
	private String mailGuardTime;

	/* A[ێ */
	private String alarmHoldPeriodDay;

	/* A[ێs */
	private String alarmMax;

	/* vێ */
	private String statisticsHoldPeriodDay;

	/* vێs */
	private String statisticsMax;

	/* \[X */
	private ResourceInfo resourceInfo;

	/**
	 * 
	 * wfBNgt@C͂ă\[Xێ܂B
	 * 
	 * @throws Exception
	 *             \[X͂Ɏsꍇ
	 */
	public SystemResourceFileParse() throws Exception {
		logger = Logger.getLogger(this.getClass().getName());

		logger.info("Resource File Parse : "
				+ FilePreference.SYSTEM_RESOURCE_XML_FILE);

		Document doc = null;

		// jart@C邩fBNgwt@C擾邩
		// doc = getDocument(RESOURCE_XML_FILE);
		doc = getResourceFileDocumentPath(FilePreference.SYSTEM_RESOURCE_XML_FILE);

		if (doc == null) {
			logger.severe("Resource File Doc null ");

			return;
		}

		resourceInfo = new ResourceInfo();

		try {

			// rootvfo
			Element root = doc.getRootElement();

			Element engineEl = root.getChild(ENGINE);
			Element databaseEl = root.getChild(DATABASE);
			Element snmpEl = root.getChild(SNMP);
			Element pingEl = root.getChild(PING);
			Element xmlsocketEl = root.getChild(XML_SOCKET);
			Element guardEl = root.getChild(GUARD);
			Element alarmEl = root.getChild(ALARM);
			Element statisticsEl = root.getChild(STATISTICS);
			Element mailFilterEl = root.getChild(MAIL_FILTER);
			Element unregistrationNodeEl = root.getChild(UNREGISTRATION_NODE);
			// engine port
			if (engineEl.getChild(ENGINE_PORT) != null) {
				enginePort = (engineEl.getChild(ENGINE_PORT))
						.getAttributeValue(XML_FILE_VALUE);
				engineAllowHost = (engineEl.getChild(ENGINE_ALLOW_HOST))
						.getAttributeValue(XML_FILE_VALUE);
				resourceInfo.setEnginePort((engineEl.getChild(ENGINE_PORT))
						.getAttributeValue(XML_FILE_VALUE));
				resourceInfo.setEngineAllowHost((engineEl
						.getChild(ENGINE_ALLOW_HOST))
						.getAttributeValue(XML_FILE_VALUE));
				// logger.info("Engine poot : " + enginePort);
			} else {
				logger.warning("Engine port not found");
			}

			// database
			if (databaseEl.getChild(DATABASE_NAME) != null) {
				databaseName = (databaseEl.getChild(DATABASE_NAME))
						.getAttributeValue(XML_FILE_VALUE);
				resourceInfo.setDatabaseName((databaseEl
						.getChild(DATABASE_NAME))
						.getAttributeValue(XML_FILE_VALUE));
			} else {
				logger.warning("database_name not found");
			}

			if (databaseEl.getChild(DATABASE_DRIVER) != null) {
				databaseDriver = (databaseEl.getChild(DATABASE_DRIVER))
						.getAttributeValue(XML_FILE_VALUE);
				resourceInfo.setDatabaseDriver((databaseEl
						.getChild(DATABASE_DRIVER))
						.getAttributeValue(XML_FILE_VALUE));
			} else {
				logger.warning("Database driver not found");
			}

			if (databaseEl.getChild(DATABASE_URL) != null) {
				databaseUrl = (databaseEl.getChild(DATABASE_URL))
						.getAttributeValue(XML_FILE_VALUE);
				resourceInfo.setDatabaseUrl((databaseEl.getChild(DATABASE_URL))
						.getAttributeValue(XML_FILE_VALUE));
			} else {
				logger.warning("Database url not found");
			}

			if (databaseEl.getChild(DATABASE_USER) != null) {
				databaseUser = (databaseEl.getChild(DATABASE_USER))
						.getAttributeValue(XML_FILE_VALUE);
				resourceInfo.setDatabaseUser((databaseEl
						.getChild(DATABASE_USER))
						.getAttributeValue(XML_FILE_VALUE));
			} else {
				logger.warning("Database user not found");
			}

			if (databaseEl.getChild(DATABASE_PASSWORD) != null) {
				databasePassword = (databaseEl.getChild(DATABASE_PASSWORD))
						.getAttributeValue(XML_FILE_VALUE);
				resourceInfo.setDatabasePassword((databaseEl
						.getChild(DATABASE_PASSWORD))
						.getAttributeValue(XML_FILE_VALUE));
			} else {
				logger.warning("Database password not found");
			}

			/*
			 * logger.info("Database Name : " + databaseName);
			 * logger.info("Database DriverName : " + databaseDriver);
			 * logger.info("Database Url : " + databaseUrl);
			 * logger.info("Database User : " + databaseUser);
			 * logger.info("Database Password : " + databasePassword);
			 */

			if (snmpEl.getChild(SNMP_PORT) != null) {
				resourceInfo.setSnmpPort(Integer
						.parseInt((snmpEl.getChild(SNMP_PORT))
								.getAttributeValue(XML_FILE_VALUE)));
			} else {
				logger.warning("snmpEl.getChild(SNMP_PORT) null");

				try {
					resourceInfo.setSnmpPort(Integer.parseInt(Integer
							.toString(SnmpPreference.SNMP_PORT)));
				} catch (NumberFormatException e1) {
					logger.warning(e1.getMessage());
					e1.printStackTrace();
				}

				logger.warning("snmp Port not found");
			}

			if (snmpEl.getChild(SNMP_TRAP_PORT) != null) {
				resourceInfo.setSnmpTrapPort(Integer.parseInt((snmpEl
						.getChild(SNMP_TRAP_PORT))
						.getAttributeValue(XML_FILE_VALUE)));
			} else {
				try {
					resourceInfo.setSnmpTrapPort(Integer.parseInt(Integer
							.toString(SnmpPreference.SNMP_TRAP_PORT)));
				} catch (NumberFormatException e1) {
					logger.warning(e1.getMessage());
					e1.printStackTrace();
				}

				logger.warning("snmp Trap Port not found");
			}

			// snmp timeout
			if (snmpEl.getChild(SNMPV1_TIMEOUT) != null) {
				snmpV1Timeout = (snmpEl.getChild(SNMPV1_TIMEOUT))
						.getAttributeValue(XML_FILE_VALUE);
				resourceInfo.setSnmpV1Timeout((snmpEl.getChild(SNMPV1_TIMEOUT))
						.getAttributeValue(XML_FILE_VALUE));
			} else {
				logger.warning("snmpV1Timeout not found");
			}

			if (snmpEl.getChild(SNMPV2_TIMEOUT) != null) {
				snmpV2Timeout = (snmpEl.getChild(SNMPV2_TIMEOUT))
						.getAttributeValue(XML_FILE_VALUE);
				resourceInfo.setSnmpV2Timeout((snmpEl.getChild(SNMPV2_TIMEOUT))
						.getAttributeValue(XML_FILE_VALUE));
			} else {
				logger.warning("snmpV2Timeout not found");
			}

			if (snmpEl.getChild(SNMPV3_TIMEOUT) != null) {
				snmpV3Timeout = (snmpEl.getChild(SNMPV3_TIMEOUT))
						.getAttributeValue(XML_FILE_VALUE);
				resourceInfo.setSnmpV3Timeout((snmpEl.getChild(SNMPV3_TIMEOUT))
						.getAttributeValue(XML_FILE_VALUE));
			} else {
				logger.warning("snmpV3Timeout not found");
			}

			// snmp retry
			if (snmpEl.getChild(SNMPV1_RETRY) != null) {
				snmpV1Retry = (snmpEl.getChild(SNMPV1_RETRY))
						.getAttributeValue(XML_FILE_VALUE);
				resourceInfo.setSnmpV1Retry((snmpEl.getChild(SNMPV1_RETRY))
						.getAttributeValue(XML_FILE_VALUE));
			} else {
				logger.warning("snmpV1Retry not found");
			}

			if (snmpEl.getChild(SNMPV2_RETRY) != null) {
				snmpV2Retry = (snmpEl.getChild(SNMPV2_RETRY))
						.getAttributeValue(XML_FILE_VALUE);
				resourceInfo.setSnmpV2Retry((snmpEl.getChild(SNMPV2_RETRY))
						.getAttributeValue(XML_FILE_VALUE));
			} else {
				logger.warning("snmpV2Retry not found");
			}

			if (snmpEl.getChild(SNMPV3_RETRY) != null) {
				snmpV3Retry = (snmpEl.getChild(SNMPV3_RETRY))
						.getAttributeValue(XML_FILE_VALUE);
				resourceInfo.setSnmpV3Retry((snmpEl.getChild(SNMPV3_RETRY))
						.getAttributeValue(XML_FILE_VALUE));
			} else {
				logger.warning("snmpV3Retry not found");
			}

			/*
			 * logger.info("Snmp port : " + resourceInfo.getSnmpPort());
			 * logger.info("Snmp trapPort : " + resourceInfo.getSnmpTrapPort());
			 * logger.info("Snmp V1 Timeout : " + snmpV1Timeout);
			 * logger.info("Snmp V2 Timeout : " + snmpV2Timeout);
			 * logger.info("Snmp V3 Timeout : " + snmpV3Timeout);
			 * logger.info("Snmp V1 Retry : " + snmpV1Retry); logger.info("Snmp
			 * V2 Retry : " + snmpV2Retry); logger.info("Snmp V3 Retry : " +
			 * snmpV3Retry);
			 */

			// ping timeout
			if (pingEl.getChild(PING_TIMEOUT) != null) {
				pingTimeout = (pingEl.getChild(PING_TIMEOUT))
						.getAttributeValue(XML_FILE_VALUE);
				resourceInfo.setPingTimeout((pingEl.getChild(PING_TIMEOUT))
						.getAttributeValue(XML_FILE_VALUE));
			} else {
				logger.warning("Ping timeout not found");
			}

			// ping retry
			if (pingEl.getChild(PING_COUNT) != null) {
				pingRetry = (pingEl.getChild(PING_COUNT))
						.getAttributeValue(XML_FILE_VALUE);
				resourceInfo.setPingRetry((pingEl.getChild(PING_COUNT))
						.getAttributeValue(XML_FILE_VALUE));
			} else {
				logger.warning("Ping retry notfound");
			}

			// Alert Sound Name
			if (xmlsocketEl.getChild(ALERT_SOUND) != null) {
				alertSound = (xmlsocketEl.getChild(ALERT_SOUND))
						.getAttributeValue(XML_FILE_VALUE);
				resourceInfo.setAlertSound((xmlsocketEl.getChild(ALERT_SOUND))
						.getAttributeValue(XML_FILE_VALUE));
			} else {
				logger.warning("Alert sound notfound");
			}

			// xmlsocket connect allow host
			if (xmlsocketEl.getChild(ALLOW_HOST) != null) {
				xmlsocketAllowHost = (xmlsocketEl.getChild(ALLOW_HOST))
						.getAttributeValue(XML_FILE_VALUE);
				resourceInfo.setXmlsocketAllowHost((xmlsocketEl
						.getChild(ALLOW_HOST))
						.getAttributeValue(XML_FILE_VALUE));
			} else {
				logger.warning("xmlsocket allow host notfound");
			}

			// xmlsocket port
			if (xmlsocketEl.getChild(XML_SOCKET_PORT) != null) {
				xmlsocketPort = (xmlsocketEl.getChild(XML_SOCKET_PORT))
						.getAttributeValue(XML_FILE_VALUE);
				resourceInfo.setXmlSocketPort((xmlsocketEl
						.getChild(XML_SOCKET_PORT))
						.getAttributeValue(XML_FILE_VALUE));
			} else {
				logger.warning("xmlsocket port notfound");
			}

			// xmlsocket maxconnect
			if (xmlsocketEl.getChild(XML_SOCKET_MAXCONNECT) != null) {
				xmlsocketMaxconnect = (xmlsocketEl
						.getChild(XML_SOCKET_MAXCONNECT))
						.getAttributeValue(XML_FILE_VALUE);
				resourceInfo.setXmlSocketMaxConnect((xmlsocketEl
						.getChild(XML_SOCKET_MAXCONNECT))
						.getAttributeValue(XML_FILE_VALUE));
			} else {
				logger.warning("maxconnect notfound");
			}

			// refresh time
			if (xmlsocketEl.getChild(REFRESH_TIME) != null) {
				refreshTime = (xmlsocketEl.getChild(REFRESH_TIME))
						.getAttributeValue(XML_FILE_VALUE);
				resourceInfo
						.setRefreshTime((xmlsocketEl.getChild(REFRESH_TIME))
								.getAttributeValue(XML_FILE_VALUE));
			} else {
				logger.warning("refresh_time notfound");
			}

			/* MailMtB^[ */
			if (mailFilterEl != null) {
				if (mailFilterEl.getChild(MAIL_FILTER_ERROR_LEVEL) != null) {
					resourceInfo.setMailFilterErrorLevel((mailFilterEl
							.getChild(MAIL_FILTER_ERROR_LEVEL))
							.getAttributeValue(XML_FILE_VALUE));
				}
				if (mailFilterEl.getChild(MAIL_FILTER_FLAG) != null) {
					if (((mailFilterEl.getChild(MAIL_FILTER_FLAG))
							.getAttributeValue(XML_FILE_VALUE)).equals("on")) {
						resourceInfo.setMailFilterStringFlag(true);
					} else {
						resourceInfo.setMailFilterStringFlag(false);
					}
				}
				if (mailFilterEl.getChild(MAIL_FILTER_STRING) != null) {
					resourceInfo.setMailFilterString((mailFilterEl
							.getChild(MAIL_FILTER_STRING))
							.getAttributeValue(XML_FILE_VALUE));
				}

			}
			if (unregistrationNodeEl != null) {
				if (unregistrationNodeEl.getChild(UNREGISTRATION_NODE_ALARM) != null) {
					resourceInfo
							.setUnregistrationNodeAlarm((unregistrationNodeEl
									.getChild(UNREGISTRATION_NODE_ALARM))
									.getAttributeValue(XML_FILE_VALUE));
				}
			}
			// mail guard time
			mailGuardTime = (guardEl.getChild(MAIL_GUARD_TIME))
					.getAttributeValue(XML_FILE_VALUE);
			resourceInfo.setMailGuardTime((guardEl.getChild(MAIL_GUARD_TIME))
					.getAttributeValue(XML_FILE_VALUE));

			// alarm
			alarmHoldPeriodDay = (alarmEl.getChild(ALARM_HOLD_PERIOD))
					.getAttributeValue(XML_FILE_VALUE);
			resourceInfo.setAlarmHoldPeriodDay((alarmEl
					.getChild(ALARM_HOLD_PERIOD))
					.getAttributeValue(XML_FILE_VALUE));
			alarmMax = (alarmEl.getChild(ALARM_MAX_LINE))
					.getAttributeValue(XML_FILE_VALUE);
			resourceInfo.setAlarmMax((alarmEl.getChild(ALARM_MAX_LINE))
					.getAttributeValue(XML_FILE_VALUE));

			// statistics
			statisticsHoldPeriodDay = (statisticsEl
					.getChild(STATISTICS_HOLD_PERIOD))
					.getAttributeValue(XML_FILE_VALUE);
			resourceInfo.setStatisticsHoldPeriodDay((statisticsEl
					.getChild(STATISTICS_HOLD_PERIOD))
					.getAttributeValue(XML_FILE_VALUE));
			statisticsMax = (statisticsEl.getChild(STATISTICS_MAX_LINE))
					.getAttributeValue(XML_FILE_VALUE);
			resourceInfo.setStatisticsMax((statisticsEl
					.getChild(STATISTICS_MAX_LINE))
					.getAttributeValue(XML_FILE_VALUE));

			/*
			 * logger.info("Mail send guard time : " + mailGuardTime);
			 * logger.info("Alarm hold period day : " + alarmHoldPeriodDay);
			 * logger.info("Alarm max : " + alarmMax); logger.info( "Statistics
			 * hold period day : " + statisticsHoldPeriodDay);
			 * logger.info("Statistics max : " + statisticsMax);
			 */

			List mailList = root.getChildren(MAIL);

			Iterator iterator = mailList.iterator();

			while (iterator.hasNext()) {
				MailProperty mailProperty = new MailProperty();
				Element mailListEl = (Element) iterator.next();

				mailProperty.setMailSendFlag(mailListEl.getChild(MAIL_SEND)
						.getAttributeValue(XML_FILE_VALUE));
				mailProperty.setSmtpHost(mailListEl.getChild(MAIL_SMTP_HOST)
						.getAttributeValue(XML_FILE_VALUE));
				mailProperty.setFrom(mailListEl.getChild(MAIL_FROM)
						.getAttributeValue(XML_FILE_VALUE));

				// mail to
				List toList = mailListEl.getChildren(MAIL_TO_LIST);
				Iterator iteratorSub = toList.iterator();

				while (iteratorSub.hasNext()) {
					Element mailToEl = (Element) iteratorSub.next();
					mailProperty.setTo(mailToEl.getChild(MAIL_TO)
							.getAttributeValue(XML_FILE_VALUE));
				}

				resourceInfo.setMailPropertyList(mailProperty);
			}
		} catch (NullPointerException e) {
			e.printStackTrace();
		}
	}

	/**
	 * \[XԂ܂B
	 * 
	 * @return resourceInfo \[X
	 */
	public ResourceInfo getResourceInfo() {
		return resourceInfo;
	}

	/**
	 * \[XBufferedWriterԂ܂B
	 * 
	 * @return bufferedWriter \[XBufferedWriter
	 */
	public BufferedWriter getResourceFileWriter() {
		File f = new File(FilePreference.SYSTEM_RESOURCE_XML_FILE);
		// logger.info("Path : " + f.getAbsolutePath());

		if (f == null) {
			return null;
		}

		BufferedWriter bufferedWriter = null;

		try {
			FileWriter fi = new FileWriter(
					FilePreference.SYSTEM_RESOURCE_XML_FILE);
			bufferedWriter = new BufferedWriter(fi);
		} catch (IOException e1) {
			e1.printStackTrace();

			return null;
		}

		return bufferedWriter;
	}

	/**
	 * wfBNgXMLt@C͂DocumentԂ܂B ijart@ČȂj
	 * 
	 * @param file
	 *            XMLt@C
	 * @return doc Document
	 */
	public Document getResourceFileDocumentPath(String file) {
		Document doc = null;

		File f = new File(file);
		// logger.info("Path : " + f.getAbsolutePath());

		if (f == null) {
			logger.warning("Abort create File : " + f.getAbsolutePath());

			return null;
		}

		BufferedReader d = null;

		try {
			FileReader fi = new FileReader(file);
			d = new BufferedReader(fi);
		} catch (FileNotFoundException e1) {
			logger.warning("FileNotFoundException : " + f.getPath() + " : "
					+ e1.getMessage());
			logger.warning("FileNotFoundException : " + f.getAbsolutePath()
					+ " : " + e1.getMessage());
			e1.printStackTrace();

			return null;
		}

		try {
			// FileInputStream stream = new FileInputStream(f);
			SAXBuilder builder = new SAXBuilder();
			doc = builder.build(d);
		} catch (JDOMException e) {
			logger.warning("JDOMException : " + e.getMessage());
			e.printStackTrace();
		} catch (NullPointerException e) {
			logger.warning("NullPointerException : " + e.getMessage());
			e.printStackTrace();
		} catch (IOException e) {
			logger.warning("IOException : " + e.getMessage());
			e.printStackTrace();
		}

		return doc;
	}

	/**
	 * jart@CXMLt@CE͂DocumentԂ܂B
	 * 
	 * @param file
	 *            XMLt@C
	 * @return doc Document
	 */
	protected Document getDocument(String file) {
		Document doc = null;

		URL url = null;

		try {
			logger.severe("Parse start : " + file);

			/* 摜肷邽߂PluginResource bundle */
			Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();
			url = bundle.getEntry(file);

			// logger.info("getLocation : " + bundle.getLocation());
			// logger.info("getResourcen : " + bundle.getResource(file));

			if (url == null) {
				/* bZ[W\[Xt@CȂꍇMO̎ */
				logger.severe("Resource XML file url : " + url);

				return null;
			}

			SAXBuilder builder = new SAXBuilder();
			doc = builder.build(url.openStream());
		} catch (JDOMException e) {
			logger.severe("Alert/Confirm Dialog Window Message XML file url : "
					+ url);
			e.printStackTrace();
		} catch (NullPointerException e) {
			logger.severe("Alert/Confirm Dialog Window Message XML file url : "
					+ url);
			e.printStackTrace();
		} catch (IOException e) {
			logger.severe("Alert/Confirm Dialog Window Message XML file url : "
					+ url);
			e.printStackTrace();
		}

		return doc;
	}

	/**
	 * \[X񂩂Document𐶐AԂ܂B
	 * 
	 * @param updateResourceInfo
	 *            \[X
	 * @return Document
	 */
	public Document updateDocument(ResourceInfo updateResourceInfo) {
		logger = Logger.getLogger(this.getClass().getName());

		Element confElement = new Element(CONF);
		Document doc = new Document(confElement);

		Element engine = new Element(ENGINE);
		Element port = new Element(ENGINE_PORT);
		Element allowHost = new Element(ENGINE_ALLOW_HOST);

		Element database = new Element(DATABASE);
		Element databaseName = new Element(DATABASE_NAME);
		Element driver = new Element(DATABASE_DRIVER);
		Element url = new Element(DATABASE_URL);
		Element user = new Element(DATABASE_USER);
		Element password = new Element(DATABASE_PASSWORD);

		Element snmp = new Element(SNMP);
		Element snmpPort = new Element(SNMP_PORT);
		Element snmpTrapPort = new Element(SNMP_TRAP_PORT);
		Element snmpV1Timeout = new Element(SNMPV1_TIMEOUT);
		Element snmpV1Retry = new Element(SNMPV1_RETRY);
		Element snmpV2Timeout = new Element(SNMPV2_TIMEOUT);
		Element snmpV2Retry = new Element(SNMPV2_RETRY);
		Element snmpV3Timeout = new Element(SNMPV3_TIMEOUT);
		Element snmpV3Retry = new Element(SNMPV3_RETRY);

		Element ping = new Element(PING);
		Element pingTimeout = new Element(PING_TIMEOUT);
		Element pingRetry = new Element(PING_COUNT);

		Element xmlsocket = new Element(XML_SOCKET);
		Element alertSound = new Element(ALERT_SOUND);
		Element xmlsocketAllowHost = new Element(ALLOW_HOST);
		Element xmlsocketPort = new Element(XML_SOCKET_PORT);
		Element xmlsocketMaxconnect = new Element(XML_SOCKET_MAXCONNECT);
		Element refreshTime = new Element(REFRESH_TIME);

		Element mailFilterEl = new Element(MAIL_FILTER);
		Element mailFilterErrorLevel = new Element(MAIL_FILTER_ERROR_LEVEL);
		Element mailFilterFlag = new Element(MAIL_FILTER_FLAG);
		Element mailFilterString = new Element(MAIL_FILTER_STRING);

		Element unregistrationNodeEl = new Element(UNREGISTRATION_NODE);
		Element unregistrationNodeAlarm = new Element(UNREGISTRATION_NODE_ALARM);

		Element guard = new Element(GUARD);
		Element mailGuardTime = new Element(MAIL_GUARD_TIME);

		Element alarm = new Element(ALARM);
		Element alarmMaxLine = new Element(ALARM_MAX_LINE);
		Element alarmHoldPeriod = new Element(ALARM_HOLD_PERIOD);

		Element statistics = new Element(STATISTICS);
		Element statisticsMaxLine = new Element(STATISTICS_MAX_LINE);
		Element statisticsHoldPeriod = new Element(STATISTICS_HOLD_PERIOD);

		confElement.addContent(engine);
		engine.addContent(port);

		if (updateResourceInfo.getEnginePort() != null) {
			port.setAttribute(new Attribute(XML_FILE_VALUE, updateResourceInfo
					.getEnginePort()));
		} else {
			port.setAttribute(new Attribute(XML_FILE_VALUE, enginePort));
		}

		engine.addContent(allowHost);

		if (updateResourceInfo.getEngineAllowHost() != null) {
			allowHost.setAttribute(new Attribute(XML_FILE_VALUE,
					updateResourceInfo.getEngineAllowHost()));
		} else {
			allowHost.setAttribute(new Attribute(XML_FILE_VALUE,
					engineAllowHost));
		}

		confElement.addContent(database);
		database.addContent(databaseName);
		database.addContent(driver);
		database.addContent(url);
		database.addContent(user);
		database.addContent(password);
		databaseName.setAttribute(new Attribute(XML_FILE_VALUE,
				updateResourceInfo.getDatabaseName()));
		driver.setAttribute(new Attribute(XML_FILE_VALUE, updateResourceInfo
				.getDatabaseDriver()));
		url.setAttribute(new Attribute(XML_FILE_VALUE, updateResourceInfo
				.getDatabaseUrl()));
		user.setAttribute(new Attribute(XML_FILE_VALUE, updateResourceInfo
				.getDatabaseUser()));
		password.setAttribute(new Attribute(XML_FILE_VALUE, updateResourceInfo
				.getDatabasePassword()));

		confElement.addContent(snmp);

		String snmpPortString = "";
		String snmpTrapPortString = "";

		try {
			snmpPortString = Integer.toString(updateResourceInfo.getSnmpPort());
			snmpTrapPortString = Integer.toString(updateResourceInfo
					.getSnmpTrapPort());
		} catch (NumberFormatException e) {
			snmpPortString = Integer.toString(SnmpPreference.SNMP_PORT);
			snmpTrapPortString = Integer
					.toString(SnmpPreference.SNMP_TRAP_PORT);
		}

		snmp.addContent(snmpPort);
		snmp.addContent(snmpTrapPort);
		snmpPort.setAttribute(new Attribute(XML_FILE_VALUE, snmpPortString));
		snmpTrapPort.setAttribute(new Attribute(XML_FILE_VALUE,
				snmpTrapPortString));

		// snmpV1
		snmp.addContent(snmpV1Timeout);
		snmp.addContent(snmpV1Retry);
		snmpV1Timeout.setAttribute(new Attribute(XML_FILE_VALUE,
				updateResourceInfo.getSnmpV1Timeout()));
		snmpV1Retry.setAttribute(new Attribute(XML_FILE_VALUE,
				updateResourceInfo.getSnmpV1Retry()));

		// snmpV2
		snmp.addContent(snmpV2Timeout);
		snmp.addContent(snmpV2Retry);
		snmpV2Timeout.setAttribute(new Attribute(XML_FILE_VALUE,
				updateResourceInfo.getSnmpV2Timeout()));
		snmpV2Retry.setAttribute(new Attribute(XML_FILE_VALUE,
				updateResourceInfo.getSnmpV2Retry()));

		// snmpV3
		snmp.addContent(snmpV3Timeout);
		snmp.addContent(snmpV3Retry);
		snmpV3Timeout.setAttribute(new Attribute(XML_FILE_VALUE,
				updateResourceInfo.getSnmpV3Timeout()));
		snmpV3Retry.setAttribute(new Attribute(XML_FILE_VALUE,
				updateResourceInfo.getSnmpV3Retry()));

		confElement.addContent(ping);
		ping.addContent(pingTimeout);
		ping.addContent(pingRetry);
		pingTimeout.setAttribute(new Attribute(XML_FILE_VALUE,
				updateResourceInfo.getPingTimeout()));
		pingRetry.setAttribute(new Attribute(XML_FILE_VALUE, updateResourceInfo
				.getPingRetry()));

		confElement.addContent(xmlsocket);
		xmlsocket.addContent(alertSound);
		xmlsocket.addContent(refreshTime);
		xmlsocket.addContent(xmlsocketAllowHost);
		xmlsocket.addContent(xmlsocketPort);
		xmlsocket.addContent(xmlsocketMaxconnect);
		alertSound.setAttribute(new Attribute(XML_FILE_VALUE,
				updateResourceInfo.getAlertSound()));
		refreshTime.setAttribute(new Attribute(XML_FILE_VALUE,
				updateResourceInfo.getRefreshTime()));
		xmlsocketAllowHost.setAttribute(new Attribute(XML_FILE_VALUE,
				updateResourceInfo.getXmlsocketAllowHost()));
		xmlsocketPort.setAttribute(new Attribute(XML_FILE_VALUE,
				updateResourceInfo.getXmlSocketPort()));
		xmlsocketMaxconnect.setAttribute(new Attribute(XML_FILE_VALUE,
				updateResourceInfo.getXmlSocketMaxConnect()));

		confElement.addContent(mailFilterEl);
		mailFilterEl.addContent(mailFilterErrorLevel);
		mailFilterEl.addContent(mailFilterFlag);
		mailFilterEl.addContent(mailFilterString);

		if (updateResourceInfo.getMailFilterErrorLevel() != null) {
			mailFilterErrorLevel.setAttribute(new Attribute(XML_FILE_VALUE,
					updateResourceInfo.getMailFilterErrorLevel()));
		} else {
			mailFilterErrorLevel.setAttribute(new Attribute(XML_FILE_VALUE,
					resourceInfo.getMailFilterErrorLevel()));
		}
		if (updateResourceInfo.getMailFilterErrorLevel() != null) {
			if (updateResourceInfo.isMailFilterStringFlag()) {
				mailFilterFlag
						.setAttribute(new Attribute(XML_FILE_VALUE, "on"));
			} else {
				mailFilterFlag
						.setAttribute(new Attribute(XML_FILE_VALUE, "off"));
			}
		} else {
			if (resourceInfo.isMailFilterStringFlag()) {
				mailFilterFlag
						.setAttribute(new Attribute(XML_FILE_VALUE, "on"));
			} else {
				mailFilterFlag
						.setAttribute(new Attribute(XML_FILE_VALUE, "off"));
			}
		}
		if (updateResourceInfo.getMailFilterString() != null) {
			mailFilterString.setAttribute(new Attribute(XML_FILE_VALUE,
					updateResourceInfo.getMailFilterString()));

		} else {
			mailFilterString.setAttribute(new Attribute(XML_FILE_VALUE,
					resourceInfo.getMailFilterString()));
		}

		confElement.addContent(unregistrationNodeEl);
		unregistrationNodeEl.addContent(unregistrationNodeAlarm);

		if (updateResourceInfo.getUnregistrationNodeAlarm() != null) {
			unregistrationNodeAlarm.setAttribute(new Attribute(XML_FILE_VALUE,
					updateResourceInfo.getUnregistrationNodeAlarm()));
		} else {
			unregistrationNodeAlarm.setAttribute(new Attribute(XML_FILE_VALUE,
					resourceInfo.getUnregistrationNodeAlarm()));
		}

		confElement.addContent(guard);
		guard.addContent(mailGuardTime);
		mailGuardTime.setAttribute(new Attribute(XML_FILE_VALUE,
				updateResourceInfo.getMailGuardTime()));

		confElement.addContent(alarm);
		alarm.addContent(alarmHoldPeriod);
		alarm.addContent(alarmMaxLine);
		alarmHoldPeriod.setAttribute(new Attribute(XML_FILE_VALUE,
				updateResourceInfo.getAlarmHoldPeriodDay()));
		alarmMaxLine.setAttribute(new Attribute(XML_FILE_VALUE,
				updateResourceInfo.getAlarmMax()));

		confElement.addContent(statistics);
		statistics.addContent(statisticsHoldPeriod);
		statistics.addContent(statisticsMaxLine);
		statisticsHoldPeriod.setAttribute(new Attribute(XML_FILE_VALUE,
				updateResourceInfo.getStatisticsHoldPeriodDay()));
		statisticsMaxLine.setAttribute(new Attribute(XML_FILE_VALUE,
				updateResourceInfo.getStatisticsMax()));

		MailProperty[] mailProp = updateResourceInfo.getMailPropertyList();

		Element[] mail = new Element[mailProp.length];
		Element[] mailSend = new Element[mailProp.length];
		Element[] smtpHost = new Element[mailProp.length];
		Element[] mailFrom = new Element[mailProp.length];

		for (int i = 0; i < mailProp.length; i++) {
			mail[i] = new Element(MAIL);
			mailSend[i] = new Element(MAIL_SEND);
			smtpHost[i] = new Element(MAIL_SMTP_HOST);
			mailFrom[i] = new Element(MAIL_FROM);

			confElement.addContent(mail[i]);
			mail[i].addContent(smtpHost[i]);
			mail[i].addContent(mailSend[i]);
			mail[i].addContent(mailFrom[i]);

			smtpHost[i].setAttribute(new Attribute(XML_FILE_VALUE, mailProp[i]
					.getSmtpHost()));
			mailSend[i].setAttribute(new Attribute(XML_FILE_VALUE, mailProp[i]
					.getMailSendFlag()));
			mailFrom[i].setAttribute(new Attribute(XML_FILE_VALUE, mailProp[i]
					.getFrom()));

			String[] toArray = mailProp[i].getTo();
			Element[] mailTo = new Element[toArray.length];
			Element[] to = new Element[toArray.length];

			for (int j = 0; j < toArray.length; j++) {
				mailTo[j] = new Element(MAIL_TO_LIST);
				mail[i].addContent(mailTo[j]);
				to[j] = new Element(MAIL_TO);
				mailTo[j].addContent(to[j]);
				to[j].setAttribute(new Attribute(XML_FILE_VALUE, toArray[j]));
			}
		}

		return doc;
	}
}
