/*
 * Created on 2004/05/08
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.server.protocol.control;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

import netjfwatcher.engine.nodewatchinfo.NodeWatchInfo;



/**
 * SNMP MibWThread𐧌䂷邽߂̃XgێNXłB
 * ʃXbhł̃Xg̃JE^PbŃJEg_E0([)
 * ȂƎsL[Push܂B
 *
 *            ThreadListReadQ
 *           iĎJEgAĎŃL[Pushj
 *        Read         Push
 * |  | ---------+   +---------------+   Queue
 * |--|                            |  |
 * |--|                            |   |
 * |--|                            |   |
 * |--|                            |   |    ThreadQueueCheck
 * +--+                            |   |   iL[Ƀf[^
 *                                 |   |      `FbNsj
 * ListQueue                                    
 * im[ho^/폜                    +----------+  +----- Exec
 *  ŃXgZbgj
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class ListQueueDefaultSnmpMibControl {
    /*
     * IPAhXL[Ƃm[hێHashMap
     */
    private Map<String, NodeWatchInfo> defaultSnmpMibHashMap;

    /*
     * IPAhXL[Ƃm[hێHashMap𐶐܂B
     *
     */
    private ListQueueDefaultSnmpMibControl() {
        defaultSnmpMibHashMap =
            Collections.synchronizedMap(new LinkedHashMap<String, NodeWatchInfo>());
    }

    /**
     * w肳ꂽIPAhXL[ƂāAm[hĎMapɊi[܂B
     * ̎AMIB̎JE^ɃZbg܂B
     *
     * @param ip m[hIPAhX
     * @param nodeInfo m[hĎ
     */
    public void setDefaultSnmpNode(String ip, NodeWatchInfo nodeInfo) {
        nodeInfo.setCountSnmpPeriod(nodeInfo.getSnmpPeriod());

        // Xgɒǉ
        defaultSnmpMibHashMap.put(ip, nodeInfo);
    }

    /**
     * w肳ꂽIPAhXɑΉm[hĎԂ܂B
     *
     * @param ip m[hIPAhX
     * @return m[hĎ
     */
    public NodeWatchInfo getDefaultSnmpNode(String ip) {
        return (NodeWatchInfo) defaultSnmpMibHashMap.get(ip);
    }

    /**
     * w肳ꂽIPAhXɑΉm[hSNMPĎ폜܂B
     *
     * @param ip m[hIPAhX
     */
    public void removeDefaultSnmpNode(String ip) {
        defaultSnmpMibHashMap.remove(ip);
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static ListQueueDefaultSnmpMibControl getInstance() {
        return SingletonAboutMessage.INSTANCE;
    }

    /**
     * m[hSNMPĎێMapԂ܂B
     *
     * @return defaultSnmpMibHashMap m[hSNMPĎێMap
     */
    public Map getDefaultSnmpMibHashMap() {
        return defaultSnmpMibHashMap;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonAboutMessage {
        static final ListQueueDefaultSnmpMibControl INSTANCE =
            new ListQueueDefaultSnmpMibControl();
    }
}
